/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.editor.properties.Acceptors;
import org.netbeans.modules.css.editor.properties.CssPropertyValueAcceptor;
import org.netbeans.modules.css.editor.properties.KeywordUtil;
import org.netbeans.modules.css.editor.properties.parser.GrammarElement;
import org.netbeans.modules.css.editor.properties.parser.GroupGrammarElement;
import org.netbeans.modules.css.editor.properties.parser.ResolvedToken;
import org.netbeans.modules.css.editor.properties.parser.Tokenizer;
import org.netbeans.modules.css.editor.properties.parser.ValueGrammarElement;
import org.netbeans.modules.web.common.api.Pair;

public class GrammarResolver {
    static final Map<Log, AtomicBoolean> LOGGERS = new EnumMap<Log, AtomicBoolean>(Log.class);
    private static boolean LOG;
    private static final Logger LOGGER;
    private List<ResolvedToken> resolvedTokens = new ArrayList<ResolvedToken>();
    private Stack<String> tokensLeft = new Stack();
    private Stack<String> tokens = new Stack();
    private GroupGrammarElement grammar;
    private String input;
    private boolean inputResolved;
    private Map<GrammarElement, Pair<InputState, Collection<ValueGrammarElement>>> resolvedSomething = new LinkedHashMap<GrammarElement, Pair<InputState, Collection<ValueGrammarElement>>>();
    private GrammarElement lastResolved;

    public static void setLogging(Log log, boolean enable) {
        LOGGERS.get((Object)log).set(enable);
        LOG = false;
        for (Log l : Log.values()) {
            if (!GrammarResolver.isLoggingEnabled(l)) continue;
            LOG = true;
        }
    }

    private static boolean isLoggingEnabled(Log log) {
        return LOGGERS.get((Object)log).get();
    }

    public static GrammarResolver resolve(GroupGrammarElement grammar, String input) {
        return new GrammarResolver(grammar, input).initialize();
    }

    public GrammarResolver(GroupGrammarElement grammar, String input) {
        this.grammar = grammar;
        this.input = input;
    }

    public List<String> tokens() {
        return this.tokens;
    }

    public List<String> left() {
        return this.tokensLeft;
    }

    public List<ResolvedToken> resolved() {
        return this.resolvedTokens;
    }

    public boolean success() {
        return this.inputResolved;
    }

    private GrammarResolver initialize() {
        this.tokens = Tokenizer.tokenize(this.input);
        this.tokensLeft = (Stack)this.tokens.clone();
        this.groupMemberResolved(this.grammar, this.grammar, this.createInputState(), true);
        this.inputResolved = this.resolve(this.grammar);
        if (!this.tokensLeft.isEmpty()) {
            this.inputResolved = false;
        }
        this.resolvingFinished();
        return this;
    }

    private void resolvingFinished() {
        if (GrammarResolver.isLoggingEnabled(Log.DEFAULT)) {
            if (LOG) {
                this.log("\nResolved tokens:");
            }
            for (ResolvedToken rt : this.resolvedTokens) {
                if (!LOG) continue;
                this.log(rt.toString());
            }
        }
        if (GrammarResolver.isLoggingEnabled(Log.ALTERNATIVES)) {
            if (LOG) {
                this.log(Log.ALTERNATIVES, "\nAlternatives:");
            }
            for (ValueGrammarElement e : this.getAlternatives()) {
                if (!LOG) continue;
                this.log(Log.ALTERNATIVES, e.path());
            }
        }
    }

    private InputState createInputState() {
        return new InputState(this.tokensLeft, this.resolvedTokens);
    }

    private boolean equalsToCurrentState(InputState state) {
        return this.tokensLeft.equals(state.input) && ((Object)this.resolvedTokens).equals(state.consumed);
    }

    private void backupInputState(InputState state) {
        if (this.equalsToCurrentState(state)) {
            return;
        }
        this.tokensLeft = (Stack)state.input.clone();
        this.resolvedTokens = new ArrayList<ResolvedToken>(state.consumed);
        if (LOG) {
            this.log(String.format("  state backup to: %s", state));
        }
    }

    private boolean resolve(GrammarElement e) {
        boolean resolves;
        if (LOG) {
            this.log(String.format("+ entering %s, %s", e.path(), this.createInputState()));
        }
        switch (e.getKind()) {
            case GROUP: {
                resolves = this.processGroup((GroupGrammarElement)e);
                break;
            }
            case VALUE: {
                resolves = this.processValue((ValueGrammarElement)e);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (LOG) {
            this.log(String.format("- leaving %s, resolved: %s, %s", e.path(), resolves, this.createInputState()));
        }
        return resolves;
    }

    private void valueNotAccepted(ValueGrammarElement valueGrammarElement) {
        if (this.resolvedTokens.size() < this.tokens.size()) {
            return;
        }
        if (LOG) {
            this.log(Log.ALTERNATIVES, String.format("value not accepted %s, %s", valueGrammarElement.path(), this.createInputState()));
        }
        Pair<InputState, Collection<ValueGrammarElement>> pair = this.resolvedSomething.get(this.lastResolved);
        ((Collection)pair.getB()).add(valueGrammarElement);
    }

    private void groupMemberResolved(GrammarElement member, GroupGrammarElement group, InputState state, boolean root) {
        if (!root && state.consumed.size() < this.tokens.size()) {
            return;
        }
        if (LOG) {
            this.log(Log.ALTERNATIVES, String.format("input matched %s, %s", member.path(), state));
        }
        this.resolvedSomething.put(group, (Pair<InputState, Collection<ValueGrammarElement>>)new Pair((Object)state, new LinkedList()));
        this.lastResolved = group;
    }

    public Set<ValueGrammarElement> getAlternatives() {
        HashSet<ValueGrammarElement> alternatives = new HashSet<ValueGrammarElement>();
        for (Pair<InputState, Collection<ValueGrammarElement>> tri : this.resolvedSomething.values()) {
            for (ValueGrammarElement value : (Collection)tri.getB()) {
                alternatives.add(value);
            }
        }
        return alternatives;
    }

    private boolean processGroup(GroupGrammarElement group) {
        InputState successState = null;
        InputState enteringGroupState = this.createInputState();
        block23: for (int i = 0; i < group.getMaximumOccurances(); ++i) {
            InputState atMultiplicityLoopStartState = this.createInputState();
            if (LOG && i > 0) {
                this.log(String.format("  multiplicity loop %s, %s", i, atMultiplicityLoopStartState));
            }
            ArrayList<GrammarElement> grammarElementsToProcess = new ArrayList<GrammarElement>(group.elements());
            ArrayList<GrammarElement> branchAlternativesGrammarElementsToProcess = null;
            HashSet<GrammarElement> alreadyTriedAlternativeBranches = new HashSet<GrammarElement>();
            HashMap<GrammarElement, InputState> branchesResults = new HashMap<GrammarElement, InputState>();
            block24: while (true) {
                InputState atCollectionLoopStartState = this.createInputState();
                Iterator membersIterator = grammarElementsToProcess.iterator();
                while (membersIterator.hasNext()) {
                    InputState state;
                    GrammarElement member = (GrammarElement)membersIterator.next();
                    boolean resolved = this.resolve(member);
                    if (LOG) {
                        this.log(String.format("  back in %s", group.path()));
                    }
                    if (!resolved && member instanceof ValueGrammarElement) {
                        this.valueNotAccepted((ValueGrammarElement)member);
                    }
                    if (resolved) {
                        state = this.createInputState();
                        this.groupMemberResolved(member, group, state, false);
                        switch (group.getType()) {
                            case SET: 
                            case COLLECTION: 
                            case ALL: {
                                if (LOG) {
                                    this.log(String.format("  added %s branch result: %s, %s", group.getType().name(), member.path(), state));
                                }
                                branchesResults.put(member, state);
                                this.backupInputState(enteringGroupState);
                                break;
                            }
                            case LIST: {
                                if (!membersIterator.hasNext()) {
                                    successState = state;
                                    break block24;
                                } else {
                                    break;
                                }
                            }
                        }
                        continue;
                    }
                    if (member.isOptional()) {
                        state = this.createInputState();
                        if (LOG) {
                            this.log(String.format("  arbitrary member %s skipped", member.path()));
                        }
                        switch (group.getType()) {
                            case SET: 
                            case COLLECTION: 
                            case ALL: {
                                if (LOG) {
                                    this.log(String.format(" added %s branch result: %s, %s", group.getType().name(), member, state));
                                }
                                branchesResults.put(member, state);
                                this.backupInputState(enteringGroupState);
                                break;
                            }
                            case LIST: {
                                if (!membersIterator.hasNext()) {
                                    successState = state;
                                    break block24;
                                } else {
                                    break;
                                }
                            }
                        }
                        continue;
                    }
                    switch (group.getType()) {
                        case LIST: {
                            break block23;
                        }
                    }
                }
                switch (group.getType()) {
                    case SET: 
                    case COLLECTION: 
                    case ALL: {
                        int inputLenBeforeEnteringGroupElement;
                        if (branchesResults.isEmpty()) break;
                        int bestMatchConsumed = inputLenBeforeEnteringGroupElement = enteringGroupState.consumed.size();
                        for (InputState state : branchesResults.values()) {
                            if (bestMatchConsumed >= state.consumed.size()) continue;
                            bestMatchConsumed = state.consumed.size();
                        }
                        if (LOG) {
                            this.log(String.format("  resolving best branch (consumed %s tokens)", bestMatchConsumed - inputLenBeforeEnteringGroupElement));
                        }
                        if (bestMatchConsumed == inputLenBeforeEnteringGroupElement) {
                            Map.Entry entry = branchesResults.entrySet().iterator().next();
                            successState = (InputState)entry.getValue();
                            this.backupInputState(successState);
                            if (!LOG) break;
                            this.log(String.format("  zero tokens consumed, but decided to use arbitraty branch %s, %s", ((GrammarElement)entry.getKey()).path(), successState));
                            break;
                        }
                        LinkedHashMap<GrammarElement, InputState> bestBranches = new LinkedHashMap<GrammarElement, InputState>();
                        for (GrammarElement member : group.elements()) {
                            InputState state = (InputState)branchesResults.get(member);
                            if (state == null || state.consumed.size() != bestMatchConsumed) continue;
                            bestBranches.put(member, state);
                        }
                        for (int j = inputLenBeforeEnteringGroupElement; j < bestMatchConsumed; ++j) {
                            LinkedList consumedUnit = new LinkedList();
                            for (Map.Entry entry : bestBranches.entrySet()) {
                                ResolvedToken token = (ResolvedToken)((InputState)entry.getValue()).consumed.get(j);
                                if (!token.getGrammarElement().isUnit()) continue;
                                consumedUnit.add(entry.getKey());
                            }
                            if (consumedUnit.size() == bestBranches.size()) continue;
                            for (GrammarElement ge : consumedUnit) {
                                bestBranches.remove(ge);
                            }
                        }
                        assert (!bestBranches.isEmpty());
                        if (bestBranches.size() > 1) {
                            this.log(String.format("! more branches (%s) which consumed same input lenght found!", bestBranches.size()));
                            for (Map.Entry entry : bestBranches.entrySet()) {
                                if (LOG) {
                                    this.log(String.format("\t%s, %s %s", entry.getKey(), entry.getValue(), alreadyTriedAlternativeBranches.contains(entry.getKey()) ? "(tried)" : ""));
                                }
                                if (branchAlternativesGrammarElementsToProcess != null) continue;
                                if (LOG) {
                                    StringBuilder b = new StringBuilder();
                                    b.append("  saving grammar elements to process: ");
                                    for (GrammarElement e : grammarElementsToProcess) {
                                        b.append(e);
                                        b.append(',');
                                    }
                                    this.log(b.toString());
                                }
                                branchAlternativesGrammarElementsToProcess = new ArrayList<GrammarElement>(grammarElementsToProcess);
                            }
                        }
                        GrammarElement bestMatchElement = null;
                        for (GrammarElement alternative : bestBranches.keySet()) {
                            if (alreadyTriedAlternativeBranches.contains(alternative)) continue;
                            bestMatchElement = alternative;
                            break;
                        }
                        if (bestBranches.size() == 1) {
                            bestMatchElement = (GrammarElement)bestBranches.keySet().iterator().next();
                        }
                        if (bestMatchElement == null) {
                            this.log(String.format("! all %s alternative branches tried", bestBranches.size()));
                            break;
                        }
                        if (bestBranches.size() > 1 && branchAlternativesGrammarElementsToProcess != null) {
                            StringBuilder b = new StringBuilder();
                            b.append("  restoring grammar elements to process: ");
                            for (GrammarElement e : branchAlternativesGrammarElementsToProcess) {
                                b.append(e);
                                b.append(',');
                            }
                            this.log(b.toString());
                            grammarElementsToProcess = new ArrayList<GrammarElement>(branchAlternativesGrammarElementsToProcess);
                        }
                        alreadyTriedAlternativeBranches.add(bestMatchElement);
                        successState = (InputState)branchesResults.get(bestMatchElement);
                        this.log(String.format("  decided to use best match %s, %s", bestMatchElement.path(), successState));
                        this.backupInputState(successState);
                        switch (group.getType()) {
                            case COLLECTION: 
                            case ALL: {
                                grammarElementsToProcess.remove(bestMatchElement);
                            }
                        }
                    }
                }
                if (successState == null || successState.equals(atCollectionLoopStartState)) break;
                switch (group.getType()) {
                    case SET: 
                    case LIST: {
                        break block24;
                    }
                    default: {
                        continue block24;
                    }
                }
                break;
            }
            switch (group.getType()) {
                case ALL: {
                    for (GrammarElement e : grammarElementsToProcess) {
                        if (e.isOptional()) continue;
                        if (LOG) {
                            StringBuilder sb = new StringBuilder();
                            Iterator itr = grammarElementsToProcess.iterator();
                            while (itr.hasNext()) {
                                sb.append(((GrammarElement)itr.next()).path());
                                if (!itr.hasNext()) continue;
                                sb.append(", ");
                            }
                            this.log(String.format("  all group: exited collection_loop but there are some grammar element to process left: %s", sb.toString()));
                        }
                        this.backupInputState(atMultiplicityLoopStartState);
                        return false;
                    }
                    break;
                }
            }
            if (successState == null || successState.equals(atMultiplicityLoopStartState)) break;
        }
        if (successState == null) {
            this.backupInputState(enteringGroupState);
            return false;
        }
        this.backupInputState(successState);
        return true;
    }

    private boolean processValue(ValueGrammarElement ve) {
        if (this.tokensLeft.isEmpty()) {
            return false;
        }
        String token = this.tokensLeft.peek();
        if (ve.isUnit() && !KeywordUtil.isKeyword(token)) {
            String unitName = ve.value();
            CssPropertyValueAcceptor acceptor = Acceptors.instance().getAcceptor(unitName);
            if (acceptor != null) {
                if (acceptor.accepts(token)) {
                    this.consumeValueGrammarElement(token, ve);
                    if (LOG) {
                        this.log(Log.VALUES, String.format("eaten unit %s", token));
                    }
                    return true;
                }
            } else {
                LOGGER.log(Level.WARNING, String.format("Cannot find unit acceptor '%s'!", ve.value()));
            }
        } else if (token.equalsIgnoreCase(ve.value())) {
            this.consumeValueGrammarElement(token, ve);
            if (LOG) {
                this.log(Log.VALUES, String.format("eaten value %s", token));
            }
            return true;
        }
        return false;
    }

    private void consumeValueGrammarElement(String tokenImage, ValueGrammarElement element) {
        this.tokensLeft.pop();
        this.resolvedTokens.add(new ResolvedToken(tokenImage, element));
    }

    private void log(String text) {
        this.log(Log.DEFAULT, text);
    }

    private void log(Log log, String text) {
        if (GrammarResolver.isLoggingEnabled(log)) {
            System.out.println(text);
        }
    }

    static {
        for (Log log : Log.values()) {
            LOGGERS.put(log, new AtomicBoolean(false));
        }
        LOG = false;
        LOGGER = Logger.getLogger(GrammarResolver.class.getName());
    }

    private static class InputState {
        private final Stack<String> input;
        private List<ResolvedToken> consumed;

        public InputState(Stack<String> input, List<ResolvedToken> consumed) {
            this.input = (Stack)input.clone();
            this.consumed = new ArrayList<ResolvedToken>(consumed);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<ResolvedToken> i = this.consumed.iterator();
            while (i.hasNext()) {
                ResolvedToken rt = i.next();
                sb.append(rt.token());
                if (!i.hasNext()) continue;
                sb.append(' ');
            }
            sb.append(']');
            sb.append(' ');
            for (int i2 = this.input.size() - 1; i2 >= 0; --i2) {
                sb.append((String)this.input.get(i2));
                if (i2 <= 0) continue;
                sb.append(' ');
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InputState other = (InputState)obj;
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            return this.consumed == other.consumed || this.consumed != null && ((Object)this.consumed).equals(other.consumed);
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 79 * hash + (this.consumed != null ? ((Object)this.consumed).hashCode() : 0);
            return hash;
        }
    }

    public static enum Log {
        DEFAULT,
        VALUES,
        ALTERNATIVES;

    }
}

