/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties.parser;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.css.editor.module.CssModuleSupport;
import org.netbeans.modules.css.editor.module.spi.Property;
import org.netbeans.modules.css.editor.properties.Acceptors;
import org.netbeans.modules.css.editor.properties.CssPropertyValueAcceptor;
import org.netbeans.modules.css.editor.properties.parser.GrammarElement;
import org.netbeans.modules.css.editor.properties.parser.GroupGrammarElement;
import org.netbeans.modules.css.editor.properties.parser.PropertyModel;
import org.netbeans.modules.css.editor.properties.parser.ValueGrammarElement;

public class GrammarParser {
    public static final char INVISIBLE_PROPERTY_PREFIX = '@';
    private String propertyName;
    private String expression;

    public static boolean isArtificialElementName(CharSequence name) {
        if (name.length() == 0) {
            return false;
        }
        return name.charAt(0) == '@';
    }

    public static GroupGrammarElement parse(String expresssion) {
        return GrammarParser.parse(expresssion, null);
    }

    public static GroupGrammarElement parse(String expression, String propertyName) {
        return new GrammarParser(expression, propertyName).parse();
    }

    public GrammarParser(String expression, String propertyName) {
        this.expression = expression;
        this.propertyName = propertyName;
    }

    private GroupGrammarElement parse() {
        AtomicInteger group_index = new AtomicInteger(0);
        int openedParenthesis = 0;
        GroupGrammarElement root = new GroupGrammarElement(null, group_index.getAndIncrement(), this.propertyName);
        ParserInput input = new ParserInput(this.expression);
        this.parseElements(input, root, false, group_index, openedParenthesis);
        if (openedParenthesis != 0) {
            throw new IllegalStateException(String.format("Property '%s' parsing error - bracket pairs doesn't match: ", this.propertyName, openedParenthesis));
        }
        return root;
    }

    private void parseElements(ParserInput input, GroupGrammarElement parent, boolean ignoreInherits, AtomicInteger group_index, int openedParenthesis) {
        GrammarElement last = null;
        char c;
        block13: while ((c = input.read()) != '\uffff') {
            StringBuilder buf;
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block13;
                }
                case '&': {
                    char next = input.read();
                    if (next == '&') {
                        parent.setType(GroupGrammarElement.Type.ALL);
                        continue block13;
                    }
                    input.backup(1);
                    continue block13;
                }
                case '[': {
                    last = new GroupGrammarElement(parent, group_index.getAndIncrement());
                    this.parseElements(input, (GroupGrammarElement)last, false, group_index, ++openedParenthesis);
                    parent.addElement(last);
                    continue block13;
                }
                case '|': {
                    char next = input.read();
                    if (next == '|') {
                        parent.setType(GroupGrammarElement.Type.COLLECTION);
                        continue block13;
                    }
                    input.backup(1);
                    parent.setType(GroupGrammarElement.Type.SET);
                    continue block13;
                }
                case ']': {
                    --openedParenthesis;
                    return;
                }
                case '<': {
                    buf = new StringBuilder();
                    while ((c = input.read()) != '>') {
                        buf.append(c);
                    }
                    String referredElementName = buf.toString();
                    Collection<Property> properties = CssModuleSupport.getProperties(referredElementName, true);
                    if (properties == null) {
                        throw new IllegalStateException(String.format("Property '%s' parsing error: No referred element '%s' found. Read input: %s", this.propertyName, referredElementName, input.readText()));
                    }
                    PropertyModel model = new PropertyModel(referredElementName, properties);
                    ParserInput pinput = new ParserInput(model.getGrammar());
                    String propName = model.getProperty().getName();
                    last = new GroupGrammarElement(parent, group_index.getAndIncrement(), propName);
                    this.parseElements(pinput, (GroupGrammarElement)last, true, group_index, openedParenthesis);
                    parent.addElement(last);
                    continue block13;
                }
                case '!': {
                    buf = new StringBuilder();
                    while ((c = input.read()) != '\uffff') {
                        if (GrammarParser.isEndOfValueChar(c)) {
                            input.backup(1);
                            break;
                        }
                        buf.append(c);
                    }
                    String unitName = buf.toString();
                    CssPropertyValueAcceptor acceptor = Acceptors.instance().getAcceptor(unitName);
                    if (acceptor == null) {
                        throw new IllegalStateException(String.format("Property '%s' parsing error - No unit property value acceptor for '%s'. Read input: '%s'", this.propertyName, unitName, input.readText()));
                    }
                    last = new ValueGrammarElement(parent, unitName, true);
                    parent.addElement(last);
                    continue block13;
                }
                case '{': {
                    StringBuilder text = new StringBuilder();
                    while ((c = input.read()) != '}') {
                        text.append(c);
                    }
                    StringTokenizer st = new StringTokenizer(text.toString(), ",");
                    int min = Integer.parseInt(st.nextToken());
                    int max = Integer.parseInt(st.nextToken());
                    last.setMinimumOccurances(min);
                    last.setMaximumOccurances(max);
                    continue block13;
                }
                case '+': {
                    last.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block13;
                }
                case '*': {
                    last.setMinimumOccurances(0);
                    last.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block13;
                }
                case '?': {
                    last.setMinimumOccurances(0);
                    last.setMaximumOccurances(1);
                    continue block13;
                }
            }
            buf = new StringBuilder();
            boolean quotes = GrammarParser.isQuoteChar(c);
            if (quotes) {
                c = input.read();
            }
            while (c != '\uffff') {
                if (GrammarParser.isEndOfValueChar(c)) {
                    input.backup(1);
                    break;
                }
                if (quotes && GrammarParser.isQuoteChar(c)) break;
                buf.append(c);
                c = input.read();
            }
            String image = buf.toString();
            if (ignoreInherits && "inherit".equalsIgnoreCase(image)) continue;
            last = new ValueGrammarElement(parent, image, false);
            parent.addElement(last);
        }
        return;
    }

    private static boolean isEndOfValueChar(char c) {
        return c == ' ' || c == '+' || c == '?' || c == '{' || c == '[' || c == ']' || c == '|';
    }

    private static boolean isQuoteChar(char c) {
        return c == '\'' || c == '\"';
    }

    private static class ParserInput {
        CharSequence text;
        private int pos = 0;

        private ParserInput(CharSequence text) {
            this.text = text;
        }

        public char read() {
            if (this.pos == this.text.length()) {
                return '\uffff';
            }
            return this.text.charAt(this.pos++);
        }

        public void backup(int chars) {
            this.pos -= chars;
        }

        public CharSequence readText() {
            return this.text.subSequence(0, this.pos);
        }
    }
}

