/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.csl.CssElement;
import org.netbeans.modules.css.editor.csl.CssPropertyElement;
import org.netbeans.modules.css.editor.module.spi.CssCompletionItem;
import org.netbeans.modules.css.editor.module.spi.CssModule;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.editor.module.spi.Property;
import org.netbeans.modules.css.editor.properties.parser.GrammarParser;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.NbBundle;

public class Utilities {
    private Utilities() {
    }

    public static <T extends Set<OffsetRange>> NodeVisitor<T> createMarkOccurrencesNodeVisitor(EditorFeatureContext context, T result, NodeType ... nodeTypesToMatch) {
        final Snapshot snapshot = context.getSnapshot();
        int astCaretOffset = snapshot.getEmbeddedOffset(context.getCaretOffset());
        if (astCaretOffset == -1) {
            return null;
        }
        final Node current = NodeUtil.findNonTokenNodeAtOffset((Node)context.getParseTreeRoot(), (int)astCaretOffset);
        if (current == null) {
            return null;
        }
        EnumSet<NodeType> types = EnumSet.copyOf(Arrays.asList(nodeTypesToMatch));
        if (!types.contains(current.type())) {
            return null;
        }
        final CharSequence selectedNamespacePrefixImage = current.image();
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                if (node.type() == current.type() && CharSequenceUtilities.textEquals((CharSequence)selectedNamespacePrefixImage, (CharSequence)node.image())) {
                    OffsetRange documentNodeRange = Css3Utils.getDocumentOffsetRange(node, snapshot);
                    ((Set)this.getResult()).add(Css3Utils.getValidOrNONEOffsetRange(documentNodeRange));
                }
                return false;
            }
        };
    }

    public static List<CompletionProposal> createRAWCompletionProposals(Collection<String> props, ElementKind kind, int anchor) {
        return Utilities.createRAWCompletionProposals(props, kind, anchor, null);
    }

    public static List<CompletionProposal> createRAWCompletionProposals(Collection<String> props, ElementKind kind, int anchor, String addPrefix) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(props.size());
        for (String value : props) {
            if (addPrefix != null) {
                value = addPrefix + value;
            }
            CssElement handle = new CssElement(value);
            CssCompletionItem proposal = CssCompletionItem.createRAWCompletionItem(handle, value, kind, anchor, false);
            proposals.add(proposal);
        }
        return proposals;
    }

    public static List<CompletionProposal> wrapProperties(Collection<Property> props, int anchor) {
        return Utilities.wrapProperties(props, anchor, 0);
    }

    public static List<CompletionProposal> wrapProperties(Collection<Property> props, int anchor, int stripLen) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(props.size());
        for (Property p : props) {
            if (GrammarParser.isArtificialElementName(p.getName())) continue;
            CssPropertyElement handle = new CssPropertyElement(p);
            String insertPrefix = stripLen == 0 ? p.getName() : p.getName().substring(stripLen);
            CssCompletionItem proposal = CssCompletionItem.createPropertyNameCompletionItem(handle, p.getName(), insertPrefix, anchor, false);
            proposals.add(proposal);
        }
        return proposals;
    }

    public static Collection<Property> parsePropertyDefinitionFile(String sourcePath, CssModule module) {
        ArrayList<Property> properties = new ArrayList<Property>();
        ResourceBundle bundle = NbBundle.getBundle((String)sourcePath);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String name = keys.nextElement();
            String value = bundle.getString(name);
            StringTokenizer nameTokenizer = new StringTokenizer(name, ";");
            while (nameTokenizer.hasMoreTokens()) {
                String parsed_name = nameTokenizer.nextToken().trim();
                Property prop = new Property(parsed_name, value, module);
                properties.add(prop);
            }
        }
        return properties;
    }
}

