/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.css.editor.csl.CssNodeElement;
import org.netbeans.modules.css.editor.module.main.NamespacesModule;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.openide.util.NbBundle;

public class NamespaceStructureItem
implements StructureItem {
    private CssNodeElement handle;
    private CharSequence prefix;
    private CharSequence resource;

    public NamespaceStructureItem(Node namespaceNode) {
        this.handle = CssNodeElement.createElement(namespaceNode);
        Node prefixNode = NodeUtil.query((Node)namespaceNode, (String)"namespace_prefix");
        this.prefix = prefixNode != null ? prefixNode.image() : NbBundle.getMessage(NamespaceStructureItem.class, (String)"default_namespace");
        Node resourceNode = NodeUtil.query((Node)namespaceNode, (String)"resourceIdentifier");
        this.resource = resourceNode != null ? resourceNode.image() : "";
    }

    public String getName() {
        return "" + this.prefix + ':' + this.resource;
    }

    public String getSortText() {
        return this.getName();
    }

    public String getHtml(HtmlFormatter formatter) {
        return "<b>" + this.prefix + "</b>" + ' ' + this.resource;
    }

    public ElementHandle getElementHandle() {
        return this.handle;
    }

    public ElementKind getKind() {
        return NamespacesModule.NAMESPACE_ELEMENT_KIND;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean isLeaf() {
        return true;
    }

    public List<? extends StructureItem> getNestedItems() {
        return Collections.emptyList();
    }

    public long getPosition() {
        return this.handle.from();
    }

    public long getEndPosition() {
        return this.handle.to();
    }

    public ImageIcon getCustomIcon() {
        return null;
    }
}

