/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.module.BrowserSpecificDefinitionParser;
import org.netbeans.modules.css.editor.module.CssModuleSupport;
import org.netbeans.modules.css.editor.module.main.StandardPropertiesHelpResolver;
import org.netbeans.modules.css.editor.module.spi.Browser;
import org.netbeans.modules.css.editor.module.spi.CssEditorModule;
import org.netbeans.modules.css.editor.module.spi.CssModule;
import org.netbeans.modules.css.editor.module.spi.HelpResolver;
import org.netbeans.modules.css.editor.module.spi.Property;
import org.netbeans.modules.css.editor.module.spi.PropertySupportResolver;
import org.netbeans.modules.css.editor.properties.parser.PropertyModel;
import org.openide.util.NbBundle;

public class BrowserSupportModule
extends CssEditorModule
implements CssModule {
    private Browser browser;
    private BrowserSpecificDefinitionParser parser;
    private final String DEFINITION_FILES_BASE = "org/netbeans/modules/css/editor/module/main/browsers/";

    public BrowserSupportModule(Browser browser, String propertiesDefinitionFileName) {
        this.browser = browser;
        this.parser = new BrowserSpecificDefinitionParser("org/netbeans/modules/css/editor/module/main/browsers/" + propertiesDefinitionFileName, browser, this);
    }

    protected Browser getBrowser() {
        return this.browser;
    }

    @Override
    public Collection<Browser> getExtraBrowsers() {
        return Collections.singleton(this.browser);
    }

    @Override
    public Collection<Property> getProperties() {
        return this.parser.getVendorSpecificProperties();
    }

    @Override
    public PropertySupportResolver.Factory getPropertySupportResolverFactory() {
        return new PropertySupportResolver.Factory(){

            @Override
            public PropertySupportResolver createPropertySupportResolver(Browser browser) {
                return browser == BrowserSupportModule.this.getBrowser() ? BrowserSupportModule.this.parser : null;
            }
        };
    }

    @Override
    public Collection<HelpResolver> getHelpResolvers() {
        return Collections.singleton(new HelpResolver(){

            @Override
            public String getHelp(Property property) {
                if (property.getName().startsWith(BrowserSupportModule.this.getBrowser().getVendorSpecificPropertyPrefix())) {
                    StandardPropertiesHelpResolver resolver;
                    String help;
                    String standardPropertyName = property.getName().substring(BrowserSupportModule.this.getBrowser().getVendorSpecificPropertyPrefix().length());
                    PropertyModel standardPropertyModel = CssModuleSupport.getPropertyModel(standardPropertyName);
                    if (standardPropertyModel != null && (help = (resolver = new StandardPropertiesHelpResolver()).getHelp(standardPropertyModel.getProperty())) != null) {
                        return help;
                    }
                    return NbBundle.getMessage(this.getClass(), (String)"completion-help-no-documentation-found");
                }
                return null;
            }

            @Override
            public URL resolveLink(Property property, String link) {
                return null;
            }

            @Override
            public int getPriority() {
                return 10000;
            }
        });
    }

    @Override
    public String getName() {
        return this.browser.getName();
    }

    @Override
    public String getDisplayName() {
        return String.format("%s CSS Extensions", this.browser.getName());
    }

    @Override
    public String getSpecificationURL() {
        return null;
    }

    protected class SupportAll
    extends PropertySupportResolver {
        private Browser browser;

        public SupportAll(Browser browser) {
            this.browser = browser;
        }

        @Override
        public boolean isPropertySupported(String propertyName) {
            if (Css3Utils.isVendorSpecificProperty(propertyName)) {
                return propertyName.startsWith(this.browser.getVendorSpecificPropertyPrefix());
            }
            return true;
        }
    }

    protected class SupportAllFactory
    implements PropertySupportResolver.Factory {
        protected SupportAllFactory() {
        }

        @Override
        public PropertySupportResolver createPropertySupportResolver(Browser browser) {
            return BrowserSupportModule.this.getBrowser().equals(browser) ? new SupportAll(browser) : null;
        }
    }
}

