/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.css.editor.module.spi.Browser;
import org.netbeans.modules.css.editor.module.spi.CompletionContext;
import org.netbeans.modules.css.editor.module.spi.CssEditorModule;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.editor.module.spi.FeatureCancel;
import org.netbeans.modules.css.editor.module.spi.FeatureContext;
import org.netbeans.modules.css.editor.module.spi.FutureParamTask;
import org.netbeans.modules.css.editor.module.spi.HelpResolver;
import org.netbeans.modules.css.editor.module.spi.Property;
import org.netbeans.modules.css.editor.module.spi.PropertySupportResolver;
import org.netbeans.modules.css.editor.properties.parser.GrammarParser;
import org.netbeans.modules.css.editor.properties.parser.PropertyModel;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.web.common.api.Pair;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class CssModuleSupport {
    private static final Logger LOGGER = Logger.getLogger(CssModuleSupport.class.getSimpleName());
    private static final AtomicReference<Map<String, Collection<Property>>> PROPERTIES_MAP = new AtomicReference();
    private static final AtomicReference<Collection<Property>> PROPERTIES = new AtomicReference();
    private static final Map<String, PropertyModel> PROPERTY_MODELS = new HashMap<String, PropertyModel>();
    private static final String JAVA_FX_CSS_EDITOR_MODULE_NAME = "javafx2_css";
    private static Collection<Property> NON_JAVA_FX_PROPERTIES;

    public static Collection<? extends CssEditorModule> getModules() {
        return Lookup.getDefault().lookupAll(CssEditorModule.class);
    }

    public static Map<OffsetRange, Set<ColoringAttributes>> getSemanticHighlights(FeatureContext context, FeatureCancel cancel) {
        HashMap<OffsetRange, Set<ColoringAttributes>> all = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getSemanticHighlightingNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptyMap();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static Set<OffsetRange> getMarkOccurrences(EditorFeatureContext context, FeatureCancel cancel) {
        HashSet<OffsetRange> all = new HashSet<OffsetRange>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getMarkOccurrencesNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptySet();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static Map<String, List<OffsetRange>> getFolds(FeatureContext context, FeatureCancel cancel) {
        HashMap<String, List<OffsetRange>> all = new HashMap<String, List<OffsetRange>>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getFoldsNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptyMap();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static Pair<OffsetRange, FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext>> getDeclarationLocation(final Document document, final int caretOffset, final FeatureCancel cancel) {
        final AtomicReference result = new AtomicReference();
        document.render(new Runnable(){

            @Override
            public void run() {
                for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
                    if (cancel.isCancelled()) {
                        return;
                    }
                    Pair<OffsetRange, FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext>> declarationLocation = cssEditorModule.getDeclaration(document, caretOffset);
                    if (declarationLocation == null) continue;
                    result.set(declarationLocation);
                    return;
                }
            }
        });
        return (Pair)result.get();
    }

    public static List<StructureItem> getStructureItems(FeatureContext context, FeatureCancel cancel) {
        ArrayList<StructureItem> all = new ArrayList<StructureItem>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getStructureItemsNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptyList();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static boolean isJavaFxCssFile(FileObject file) {
        if (file == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return false;
        }
        return CssModuleSupport.isJavaFxProject(project);
    }

    private static boolean isJavaFxProject(Project project) {
        Preferences prefs = ProjectUtils.getPreferences((Project)project, Project.class, (boolean)false);
        String isFX = prefs.get("issue214819_fx_enabled", "false");
        return isFX != null && isFX.equals("true");
    }

    public static synchronized Collection<Property> getProperties(boolean filter_out_java_fx) {
        if (!filter_out_java_fx) {
            return CssModuleSupport.getProperties();
        }
        if (NON_JAVA_FX_PROPERTIES == null) {
            NON_JAVA_FX_PROPERTIES = new ArrayList<Property>();
            for (Property p : CssModuleSupport.getProperties()) {
                if (JAVA_FX_CSS_EDITOR_MODULE_NAME.equals(p.getCssModule().getName())) continue;
                NON_JAVA_FX_PROPERTIES.add(p);
            }
        }
        return NON_JAVA_FX_PROPERTIES;
    }

    public static Collection<Property> getProperties(FileObject file) {
        return CssModuleSupport.getProperties(!CssModuleSupport.isJavaFxCssFile(file));
    }

    public static Collection<Property> getProperties(FeatureContext featureContext) {
        return CssModuleSupport.getProperties(featureContext.getSource().getFileObject());
    }

    public static PropertyModel getPropertyModel(String name, FileObject file) {
        PropertyModel pm = CssModuleSupport.getPropertyModel(name);
        if (pm == null) {
            return null;
        }
        Property p = pm.getProperty();
        return CssModuleSupport.getProperties(file).contains(p) ? pm : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Property> getProperties() {
        AtomicReference<Collection<Property>> atomicReference = PROPERTIES;
        synchronized (atomicReference) {
            if (PROPERTIES.get() == null) {
                PROPERTIES.set(CssModuleSupport.createAllPropertiesCollection());
            }
            return PROPERTIES.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Collection<Property>> getPropertiesMap() {
        AtomicReference<Map<String, Collection<Property>>> atomicReference = PROPERTIES_MAP;
        synchronized (atomicReference) {
            if (PROPERTIES_MAP.get() == null) {
                PROPERTIES_MAP.set(CssModuleSupport.loadProperties());
            }
            return PROPERTIES_MAP.get();
        }
    }

    private static Collection<Property> createAllPropertiesCollection() {
        LinkedList<Property> all = new LinkedList<Property>();
        for (Collection<Property> props : CssModuleSupport.getPropertiesMap().values()) {
            all.addAll(props);
        }
        return all;
    }

    private static Map<String, Collection<Property>> loadProperties() {
        HashMap<String, Collection<Property>> all = new HashMap<String, Collection<Property>>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            for (Property pd : cssEditorModule.getProperties()) {
                String propertyName = pd.getName();
                LinkedList<Property> props = (LinkedList<Property>)all.get(propertyName);
                if (props == null) {
                    props = new LinkedList<Property>();
                    all.put(propertyName, props);
                }
                if (!GrammarParser.isArtificialElementName(propertyName) && !props.isEmpty()) {
                    LOGGER.warning(String.format("Duplicate property %s found, offending css module: %s", pd.getName(), pd.getCssModule()));
                    for (Property p : props) {
                        LOGGER.warning(String.format("Existing property found in css module: %s", p.getCssModule()));
                    }
                }
                props.add(pd);
            }
        }
        return all;
    }

    public static Collection<Property> getProperties(String propertyName) {
        return CssModuleSupport.getProperties(propertyName, false);
    }

    public static Collection<Property> getProperties(String propertyName, boolean allowToGetInvisibleProperties) {
        StringBuilder sb = new StringBuilder().append('@').append(propertyName);
        Collection<Property> invisibleProperty = CssModuleSupport.getPropertiesMap().get(sb.toString());
        return allowToGetInvisibleProperties && invisibleProperty != null ? invisibleProperty : PROPERTIES_MAP.get().get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyModel getPropertyModel(String name) {
        Map<String, PropertyModel> map = PROPERTY_MODELS;
        synchronized (map) {
            PropertyModel model = PROPERTY_MODELS.get(name);
            if (model == null) {
                Collection<Property> properties = CssModuleSupport.getProperties(name);
                model = properties != null ? new PropertyModel(name, properties) : null;
                PROPERTY_MODELS.put(name, model);
            }
            return model;
        }
    }

    public static List<CompletionProposal> getCompletionProposals(CompletionContext context) {
        ArrayList<CompletionProposal> all = new ArrayList<CompletionProposal>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            all.addAll(cssEditorModule.getCompletionProposals(context));
        }
        return all;
    }

    public static Collection<String> getPseudoClasses() {
        HashSet<String> all = new HashSet<String>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<String> vals = cssEditorModule.getPseudoClasses();
            if (vals == null) continue;
            all.addAll(vals);
        }
        return all;
    }

    public static Collection<String> getPseudoElements() {
        HashSet<String> all = new HashSet<String>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<String> vals = cssEditorModule.getPseudoElements();
            if (vals == null) continue;
            all.addAll(vals);
        }
        return all;
    }

    public static SortedSet<Browser> getBrowsers() {
        TreeSet<Browser> all = new TreeSet<Browser>(new Comparator<Browser>(){

            @Override
            public int compare(Browser t, Browser t1) {
                return t.getName().compareTo(t1.getName());
            }
        });
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<Browser> extraBrowsers = cssEditorModule.getExtraBrowsers();
            if (extraBrowsers == null) continue;
            all.addAll(extraBrowsers);
        }
        return all;
    }

    public static boolean isPropertySupported(String propertyName, Browser browser) {
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            PropertySupportResolver resolver;
            PropertySupportResolver.Factory factory = cssEditorModule.getPropertySupportResolverFactory();
            if (factory == null || (resolver = factory.createPropertySupportResolver(browser)) == null || !resolver.isPropertySupported(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static HelpResolver getHelpResolver() {
        return new HelpResolver(){

            @Override
            public String getHelp(Property property) {
                StringBuilder sb = new StringBuilder();
                for (HelpResolver resolver : CssModuleSupport.getSortedHelpResolvers()) {
                    String help = resolver.getHelp(property);
                    if (help == null) continue;
                    sb.append(help);
                }
                return sb.toString();
            }

            @Override
            public URL resolveLink(Property property, String link) {
                for (HelpResolver resolver : CssModuleSupport.getSortedHelpResolvers()) {
                    URL url = resolver.resolveLink(property, link);
                    if (url == null) continue;
                    return url;
                }
                return null;
            }

            @Override
            public int getPriority() {
                return 0;
            }
        };
    }

    private static Collection<HelpResolver> getSortedHelpResolvers() {
        ArrayList<HelpResolver> list = new ArrayList<HelpResolver>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<HelpResolver> resolvers = cssEditorModule.getHelpResolvers();
            if (resolvers == null) continue;
            list.addAll(resolvers);
        }
        Collections.sort(list, new Comparator<HelpResolver>(){

            @Override
            public int compare(HelpResolver t1, HelpResolver t2) {
                int i1 = t1.getPriority();
                int i2 = t2.getPriority();
                return new Integer(i1).compareTo(new Integer(i2));
            }
        });
        return list;
    }
}

