/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.csl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.csl.CssErrorFactory;
import org.netbeans.modules.css.editor.module.CssModuleSupport;
import org.netbeans.modules.css.editor.properties.CustomErrorMessageProvider;
import org.netbeans.modules.css.editor.properties.parser.PropertyModel;
import org.netbeans.modules.css.editor.properties.parser.PropertyValue;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CssAnalyser {
    private static final String UNKNOWN_PROPERTY_BUNDLE_KEY = "unknown_property";
    private static final String UNKNOWN_PROPERTY_ERROR_KEY_DELIMITER = "/";
    private static final String UNKNOWN_PROPERTY_ERROR_KEY = "unknown_property/";
    private static final String INVALID_PROPERTY_VALUE = "invalid_property_value";
    private static final Collection<String> NON_CSS21_DECLARATION_PROPERTY_NAMES = Arrays.asList("opacity", "resize", "text-overflow", "text-shadow", "filter");
    private static final Collection<String> NON_CSS21_DECLARATION_PROPERTY_VALUES = Arrays.asList("expression");

    public static List<Error> checkForErrors(final Snapshot snapshot, Node node) {
        final FileObject file = snapshot.getSource().getFileObject();
        ArrayList<Error> errors = new ArrayList<Error>();
        NodeVisitor<List<Error>> visitor = new NodeVisitor<List<Error>>(errors){

            public boolean visit(Node node) {
                if (node.type() == NodeType.declaration) {
                    Node parent = node.parent();
                    if (parent.type() == NodeType.declarations) {
                        switch (parent.parent().type()) {
                            case fontFace: 
                            case counterStyle: {
                                return false;
                            }
                        }
                    }
                    Node propertyNode = NodeUtil.getChildByType((Node)node, (NodeType)NodeType.property);
                    Node valueNode = NodeUtil.getChildByType((Node)node, (NodeType)NodeType.expr);
                    if (propertyNode != null) {
                        PropertyValue pv;
                        String valueImage;
                        String propertyName = ((Object)propertyNode.image()).toString().trim();
                        if (CssAnalyser.isNonCss21CompatibleDeclarationPropertyName(propertyName)) {
                            return false;
                        }
                        PropertyModel property = CssModuleSupport.getPropertyModel(propertyName, file);
                        if (!Css3Utils.containsGeneratedCode(propertyName) && !Css3Utils.isVendorSpecificProperty(propertyName) && property == null) {
                            String msg = NbBundle.getMessage(CssAnalyser.class, (String)CssAnalyser.UNKNOWN_PROPERTY_BUNDLE_KEY, (Object)propertyName);
                            Error error = CssAnalyser.makeError(propertyNode.from(), propertyNode.to(), snapshot, CssAnalyser.UNKNOWN_PROPERTY_ERROR_KEY + propertyName, msg, msg, false, Severity.WARNING);
                            if (error != null) {
                                ((List)this.getResult()).add(error);
                            }
                        }
                        if (valueNode != null && property != null && !Css3Utils.containsGeneratedCode(valueImage = ((Object)valueNode.image()).toString().trim()) && !(pv = new PropertyValue(property, valueImage)).isResolved()) {
                            Error error;
                            String unexpectedToken;
                            String errorMsg = null;
                            if (pv instanceof CustomErrorMessageProvider) {
                                errorMsg = ((CustomErrorMessageProvider)((Object)pv)).customErrorMessage();
                            }
                            if (CssAnalyser.isNonCss21CompatiblePropertyValue(unexpectedToken = pv.getUnresolvedTokens().get(pv.getUnresolvedTokens().size() - 1))) {
                                return false;
                            }
                            if (errorMsg == null) {
                                errorMsg = NbBundle.getMessage(CssAnalyser.class, (String)CssAnalyser.INVALID_PROPERTY_VALUE, (Object)unexpectedToken);
                            }
                            if ((error = CssAnalyser.makeError(valueNode.from(), valueNode.to(), snapshot, CssAnalyser.INVALID_PROPERTY_VALUE, errorMsg, errorMsg, false, Severity.WARNING)) != null) {
                                ((List)this.getResult()).add(error);
                            }
                        }
                    }
                }
                return false;
            }
        };
        visitor.visitChildren(node);
        return errors;
    }

    private static Error makeError(int astFrom, int astTo, Snapshot snapshot, String key, String displayName, String description, boolean lineError, Severity severity) {
        assert (astFrom <= astTo);
        return CssErrorFactory.createError(key, displayName, description, snapshot.getSource().getFileObject(), astFrom, astTo, lineError, severity);
    }

    public static boolean isConfigurableError(String errorKey) {
        return CssAnalyser.isUnknownPropertyError(errorKey);
    }

    public static boolean isUnknownPropertyError(String errorKey) {
        return errorKey.startsWith(UNKNOWN_PROPERTY_ERROR_KEY);
    }

    public static String getUnknownPropertyName(String unknownPropertyErrorKey) {
        assert (unknownPropertyErrorKey.startsWith(UNKNOWN_PROPERTY_ERROR_KEY));
        int index = unknownPropertyErrorKey.indexOf(UNKNOWN_PROPERTY_ERROR_KEY_DELIMITER);
        return unknownPropertyErrorKey.substring(index + 1);
    }

    private static boolean isNonCss21CompatibleDeclarationPropertyName(String propertyName) {
        return NON_CSS21_DECLARATION_PROPERTY_NAMES.contains(propertyName);
    }

    private static boolean isNonCss21CompatiblePropertyValue(String propertyValue) {
        return NON_CSS21_DECLARATION_PROPERTY_VALUES.contains(propertyValue);
    }
}

