/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.RuleViolation;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDResult;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.BugGroupNode;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.RuleViolationNode;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.SessionNode;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;

class RuleViolationRenderer
extends DefaultTreeCellRenderer {
    private static final Color HIGH_PRIORITY_COLOR = new Color(0xFF0000);
    private static final Color NORMAL_PRIORITY_COLOR = new Color(0x9F0000);
    private static final Color LOW_PRIORITY_COLOR = Color.BLACK;
    private static final Color EXP_PRIORITY_COLOR = Color.BLACK;
    private static final RuleViolationRenderer theInstance = new RuleViolationRenderer();
    private static final long serialVersionUID = 1L;
    private ImageIcon bugGroupIcon;
    private ImageIcon packageIcon;
    private ImageIcon bugIcon;
    private ImageIcon classIcon;
    private Object value;

    private RuleViolationRenderer() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.bugGroupIcon = new ImageIcon(classLoader.getResource("org/nbheaven/sqe/tools/pmd/codedefects/core/resources/pmd.png"));
        this.packageIcon = new ImageIcon(classLoader.getResource("org/nbheaven/sqe/tools/pmd/codedefects/core/resources/package.gif"));
        this.bugIcon = new ImageIcon(classLoader.getResource("org/nbheaven/sqe/tools/pmd/codedefects/core/resources/pmd.png"));
        this.classIcon = new ImageIcon(classLoader.getResource("org/nbheaven/sqe/tools/pmd/codedefects/core/resources/class.gif"));
    }

    public static RuleViolationRenderer instance() {
        return theInstance;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof RuleViolationNode) {
            RuleViolationNode node = (RuleViolationNode)value;
            IRuleViolation ruleViolation = node.getRuleViolation();
            this.setIcon(this.bugIcon);
            String packagePrefix = ruleViolation.getPackageName().length() > 0 ? ruleViolation.getPackageName() + "." : "";
            String classDescription = packagePrefix + (null == ruleViolation.getClassName() || ruleViolation.getClassName().length() == 0 ? ruleViolation.getFilename() : ruleViolation.getClassName());
            this.setText(classDescription + ":" + ruleViolation.getBeginLine());
        } else if (value instanceof SessionNode) {
            SessionNode sessionNode = (SessionNode)value;
            ProjectInformation information = ProjectUtils.getInformation((Project)sessionNode.getSession().getProject());
            this.setIcon(information.getIcon());
            this.setText(information.getDisplayName() + " (" + sessionNode.getBugCount() + ")");
        } else if (value instanceof BugGroupNode) {
            BugGroupNode bugGroupNode = (BugGroupNode)value;
            Object groupObject = bugGroupNode.getGroupObject();
            if (groupObject instanceof PMDResult.CategoryKey) {
                this.setIcon(this.bugGroupIcon);
                this.setText(((PMDResult.CategoryKey)groupObject).getDisplayName());
            } else if (groupObject instanceof PMDResult.ClassKey) {
                this.setIcon(this.classIcon);
                this.setText(((PMDResult.ClassKey)groupObject).getDisplayName());
            } else if (groupObject instanceof PMDResult.PackageKey) {
                this.setIcon(this.packageIcon);
                this.setText(((PMDResult.PackageKey)groupObject).getDisplayName());
            } else {
                this.setIcon(null);
            }
            this.setText(this.getText() + " (" + bugGroupNode.getSize() + ")");
        } else {
            this.setIcon(null);
        }
        return this;
    }

    public Color getTextNonSelectionColor() {
        return this.getCellTextColor();
    }

    private Color getCellTextColor() {
        Color color = Color.BLACK;
        if (this.value instanceof RuleViolation) {
            RuleViolation ruleViolation = (RuleViolation)this.value;
            switch (ruleViolation.getRule().getPriority()) {
                case 5: {
                    color = LOW_PRIORITY_COLOR;
                    break;
                }
                default: {
                    color = NORMAL_PRIORITY_COLOR;
                }
            }
        }
        return color;
    }
}

