/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.pmd.RuleViolation;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDResult;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDSession;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.BugTree;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.CollapseAllAction;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.ExpandAllAction;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.RefreshAction;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.ShowHideDescriptionAction;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.SortAction;

public final class ResultPanel
extends JPanel {
    private BugTree bugTree = null;
    private JScrollPane treeScrollPane = null;
    private JScrollPane htmlScrollPane = null;
    private JSplitPane splitPane;
    private JTextPane textPane;
    private ButtonGroup buttonGroup;
    private int dividerLocation = 400;
    private JToggleButton showHideDescriptionButton;

    public ResultPanel(PMDSession session) {
        this.initialize(session);
        this.bugTree.refresh();
    }

    private void initialize(PMDSession session) {
        this.setFocusCycleRoot(true);
        this.setLayout(new BorderLayout());
        this.bugTree = new BugTree(session);
        this.treeScrollPane = new JScrollPane(this.bugTree);
        this.treeScrollPane.setBorder(null);
        this.textPane = new JTextPane();
        this.textPane.setSize(200, 100);
        this.textPane.setEditorKit(new HTMLEditorKit());
        this.htmlScrollPane = new JScrollPane(this.textPane);
        this.htmlScrollPane.setBorder(null);
        this.splitPane = new JSplitPane(1, this.treeScrollPane, this.htmlScrollPane);
        this.splitPane.setBorder(null);
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.add(new RefreshAction(this.bugTree));
        toolBar.addSeparator();
        toolBar.add(new ExpandAllAction(this.bugTree));
        toolBar.add(new CollapseAllAction(this.bugTree));
        toolBar.addSeparator();
        this.showHideDescriptionButton = new JToggleButton(new ShowHideDescriptionAction(this));
        this.showHideDescriptionButton.setText(null);
        this.showHideDescriptionButton.setSelected(true);
        toolBar.add(this.showHideDescriptionButton);
        toolBar.addSeparator();
        this.buttonGroup = new ButtonGroup();
        for (PMDResult.Mode mode : PMDResult.Mode.values()) {
            JToggleButton button = new JToggleButton(new SortAction(this.bugTree, mode));
            this.buttonGroup.add(button);
            button.setFocusable(false);
            button.setText(null);
            if (this.bugTree.isActiveMode(mode)) {
                button.setSelected(true);
            }
            toolBar.add(button);
        }
        this.add((Component)toolBar, "West");
        this.add((Component)this.splitPane, "Center");
        this.validate();
        this.splitPane.setDividerLocation(this.dividerLocation);
        this.updateDescription();
        this.bugTree.addTreeSelectionListener(new DescriptionUpdateListener(this));
    }

    private void setDescriptionVisible(boolean visible) {
        if (visible ^ this.htmlScrollPane.isVisible()) {
            if (visible) {
                this.splitPane.setDividerLocation(this.dividerLocation);
                this.htmlScrollPane.setVisible(true);
            } else {
                if (this.htmlScrollPane.isVisible()) {
                    this.dividerLocation = this.splitPane.getDividerLocation();
                }
                this.splitPane.setDividerLocation(1.0);
                this.htmlScrollPane.setVisible(false);
            }
        }
    }

    void updateDescription() {
        String description = null;
        TreePath treePath = this.bugTree.getSelectionPath();
        if (null != treePath) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object obj = selectedNode.getUserObject();
            if (obj instanceof PMDResult.CategoryKey) {
                PMDResult.CategoryKey categoryKey = (PMDResult.CategoryKey)obj;
                description = categoryKey.getDescription();
            }
            if (obj instanceof RuleViolation) {
                RuleViolation ruleViolation = (RuleViolation)obj;
                description = ruleViolation.getDescription();
            }
        }
        String string = description = null == description ? "" : description.trim();
        if (description.length() == 0 || !this.showHideDescriptionButton.isSelected()) {
            this.textPane.setText("");
            this.setDescriptionVisible(false);
        } else {
            this.setDescriptionVisible(true);
            this.textPane.setText(description);
        }
    }

    private static class DescriptionUpdateListener
    implements TreeSelectionListener {
        private final ResultPanel resultPanel;

        private DescriptionUpdateListener(ResultPanel resultPanel) {
            this.resultPanel = resultPanel;
        }

        public void valueChanged(TreeSelectionEvent e) {
            this.resultPanel.updateDescription();
        }
    }
}

