/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result;

import java.awt.EventQueue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.Rule;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDResult;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDSession;
import org.nbheaven.sqe.tools.pmd.codedefects.core.annotations.RuleViolationAnnotationProcessor;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.BugGroupNode;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.DisableRuleAction;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.RuleViolationNode;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.RuleViolationRenderer;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.SessionNode;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class BugTree
extends JTree {
    public static final String PROPERTY_ACTIVE_MODE = "ActiveMode";
    public static final String PROPERTY_CORE_FILTER_ENABLED = "CoreFilterEnabled";
    private final RequestProcessor requestProcessor;
    private final PMDSession session;
    private PMDResult.Mode resultMode = PMDResult.Mode.TYPE;
    private boolean isCollapsed = true;
    private boolean coreFilterEnabled = true;

    BugTree(PMDSession session) {
        this.session = session;
        this.requestProcessor = new RequestProcessor("BugTree-" + session.getDisplayName(), 1);
        this.session.addPropertyChangeListener(new SessionListener(this));
        this.setCellRenderer(RuleViolationRenderer.instance());
        this.addMouseListener(new JumpToSourceMouseListener());
        this.addKeyListener(new JumpToSourceKeyListener());
    }

    public PMDSession getSession() {
        return this.session;
    }

    public boolean isActiveMode(PMDResult.Mode mode) {
        return this.resultMode == mode;
    }

    public void setActiveMode(PMDResult.Mode mode) {
        PMDResult.Mode oldMode = this.resultMode;
        this.resultMode = mode;
        this.refresh();
        this.firePropertyChange(PROPERTY_ACTIVE_MODE, (Object)oldMode, (Object)this.resultMode);
    }

    public boolean isCoreFilterEnabled() {
        return this.coreFilterEnabled;
    }

    public void setCoreFilterEnabled(boolean coreFilterEnabled) {
        boolean oldCoreFilterEnabled = this.coreFilterEnabled;
        this.coreFilterEnabled = coreFilterEnabled;
        this.refresh();
        this.firePropertyChange(PROPERTY_CORE_FILTER_ENABLED, oldCoreFilterEnabled, this.coreFilterEnabled);
    }

    public void refresh() {
        this.requestProcessor.post(new Runnable(){

            public void run() {
                final TreeNode rootNode = BugTree.createRootTreeNode(BugTree.this.session, BugTree.this.coreFilterEnabled, BugTree.this.resultMode);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        BugTree.this.setModel(new DefaultTreeModel(rootNode));
                        if (BugTree.this.isCollapsed) {
                            BugTree.this.collapseAll();
                        } else {
                            BugTree.this.expandAll();
                        }
                    }
                });
            }
        });
    }

    public void collapseAll() {
        for (int row = this.getRowCount() - 1; row > 0; --row) {
            this.collapseRow(row);
        }
    }

    public void expandAll() {
        for (int row = this.getRowCount() - 1; row > 0; --row) {
            this.expandRow(row);
        }
    }

    private static TreeNode createRootTreeNode(PMDSession session, boolean coreFilterEnabled, PMDResult.Mode resultMode) {
        if (null == session || null == session.getResult()) {
            return new DefaultMutableTreeNode("No result available");
        }
        SessionNode rootNode = new SessionNode(session, session.getResult().getBugCount());
        rootNode.setUserObject((Object)session);
        Map<Object, Collection<IRuleViolation>> instances = resultMode.getInstanceList(session.getResult());
        int typeIndex = 0;
        for (Map.Entry<Object, Collection<IRuleViolation>> entry : instances.entrySet()) {
            BugGroupNode typeNode = new BugGroupNode(entry.getKey(), entry.getValue().size());
            int index = 0;
            for (IRuleViolation ruleViolation : entry.getValue()) {
                RuleViolationNode ruleViolationNode = new RuleViolationNode(ruleViolation, false);
                typeNode.insert(ruleViolationNode, index);
                ++index;
            }
            rootNode.insert(typeNode, typeIndex);
            ++typeIndex;
        }
        return rootNode;
    }

    public JPopupMenu getComponentPopupMenu() {
        DefaultMutableTreeNode selectedNode;
        Object obj;
        TreePath treePath = this.getSelectionModel().getSelectionPath();
        if (null != treePath && treePath.getPathCount() > 0 && (obj = (selectedNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof Rule) {
            DisableRuleAction disableDetector = new DisableRuleAction((Rule)obj, this.session.getProject());
            return Utilities.actionsToPopup((Action[])new Action[]{disableDetector}, (Lookup)Utilities.actionsGlobalContext());
        }
        return null;
    }

    private static void jumpToSource(final TreePath treePath) {
        if (null == treePath || treePath.getPathCount() == 0) {
            return;
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BugTree.jumpToSource(treePath);
                }
            });
            return;
        }
        PMDSession session = (PMDSession)((Object)((DefaultMutableTreeNode)treePath.getPathComponent(0)).getUserObject());
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object obj = selectedNode.getUserObject();
        if (obj instanceof IRuleViolation) {
            IRuleViolation ruleViolation = (IRuleViolation)obj;
            RuleViolationAnnotationProcessor.openSourceFile(ruleViolation, session.getProject());
        }
    }

    private static class JumpToSourceKeyListener
    extends KeyAdapter {
        private JumpToSourceKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                JTree jTree = (JTree)keyEvent.getSource();
                BugTree.jumpToSource(jTree.getSelectionPath());
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                JTree jTree = (JTree)keyEvent.getSource();
                BugTree.jumpToSource(jTree.getSelectionPath());
            }
        }
    }

    private static class JumpToSourceMouseListener
    extends MouseAdapter {
        private JumpToSourceMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (2 == evt.getClickCount()) {
                JTree jTree = (JTree)evt.getSource();
                BugTree.jumpToSource(jTree.getSelectionPath());
            }
        }
    }

    private static class SessionListener
    implements PropertyChangeListener {
        private final BugTree bugTreePanel;

        public SessionListener(BugTree bugTreePanel) {
            this.bugTreePanel = bugTreePanel;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.bugTreePanel.refresh();
        }
    }
}

