/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.core.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.nbheaven.sqe.core.api.SQEManager;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDSession;
import org.nbheaven.sqe.tools.pmd.codedefects.core.ui.result.ResultPanel;
import org.netbeans.api.project.Project;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class PMDTopComponent
extends TopComponent {
    private static PMDTopComponent instance;
    static final String ICON_PATH = "org/nbheaven/sqe/tools/pmd/codedefects/core/resources/pmd.png";
    private static final String PREFERRED_ID = "PMDTopComponent";
    private SQEManagerListener sqeManagerListener = new SQEManagerListener(this);
    private PMDSession activeSession = null;
    private final JComponent emptyComponent;
    private JToolBar actionsToolbar;
    private JPanel resultPanel;

    private PMDTopComponent() {
        this.initComponents();
        this.emptyComponent = new JLabel("<No Results available>");
        this.emptyComponent.setBackground(Color.WHITE);
        this.setName(NbBundle.getMessage(PMDTopComponent.class, (String)"CTL_PMDTopComponent"));
        this.setToolTipText(NbBundle.getMessage(PMDTopComponent.class, (String)"HINT_PMDTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    private void initComponents() {
        this.resultPanel = new JPanel();
        this.actionsToolbar = new JToolBar();
        this.addAncestorListener(new AncestorListener(){

            public void ancestorMoved(AncestorEvent evt) {
            }

            public void ancestorAdded(AncestorEvent evt) {
                PMDTopComponent.this.formAncestorAdded(evt);
            }

            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.setLayout(new BorderLayout());
        this.resultPanel.setLayout(new BorderLayout());
        this.add(this.resultPanel, "Center");
        this.actionsToolbar.setFloatable(false);
        this.actionsToolbar.setOrientation(1);
        this.actionsToolbar.setRollover(true);
        this.add(this.actionsToolbar, "West");
    }

    private void formAncestorAdded(AncestorEvent evt) {
    }

    public static synchronized PMDTopComponent getDefault() {
        if (instance == null) {
            instance = new PMDTopComponent();
        }
        return instance;
    }

    public static synchronized PMDTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(PMDTopComponent.class.getName()).warning("Cannot find PMDTopComponent component. It will not be located properly in the window system.");
            return PMDTopComponent.getDefault();
        }
        if (win instanceof PMDTopComponent) {
            return (PMDTopComponent)win;
        }
        Logger.getLogger(PMDTopComponent.class.getName()).warning("There seem to be multiple components with the 'PMDTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return PMDTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        SQEManager.getDefault().addPropertyChangeListener("PropActiveProject", (PropertyChangeListener)this.sqeManagerListener);
        this.setActiveSessionByProject(SQEManager.getDefault().getActiveProject());
    }

    public void componentClosed() {
        SQEManager.getDefault().removePropertyChangeListener("PropActiveProject", (PropertyChangeListener)this.sqeManagerListener);
        this.setActiveSession(null);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void setActiveSessionByProject(final Project project) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    PMDTopComponent.this.setActiveSessionByProject(project);
                }
            });
            return;
        }
        if (null != project) {
            this.setActiveSession((PMDSession)((Object)project.getLookup().lookup(PMDSession.class)));
            AbstractNode node = new AbstractNode(Children.LEAF, Lookups.singleton((Object)project));
            this.setActivatedNodes(new Node[]{node});
        } else {
            this.setActiveSession(null);
            this.setActivatedNodes(new Node[0]);
        }
    }

    private void setActiveSession(PMDSession session) {
        assert (EventQueue.isDispatchThread()) : "setActiveSession has to be called on EventQueue";
        if (this.activeSession != session) {
            this.activeSession = session;
            JComponent component = null != this.activeSession ? new ResultPanel(this.activeSession) : this.emptyComponent;
            this.resultPanel.removeAll();
            this.resultPanel.add((Component)component, "Center");
            this.resultPanel.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return PMDTopComponent.getDefault();
        }
    }

    private static class SQEManagerListener
    implements PropertyChangeListener {
        private final PMDTopComponent component;

        private SQEManagerListener(PMDTopComponent component) {
            this.component = component;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("PropActiveProject".equals(evt.getPropertyName())) {
                this.component.setActiveSessionByProject((Project)evt.getNewValue());
            }
        }
    }
}

