/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.core.settings.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import org.nbheaven.sqe.tools.pmd.codedefects.core.settings.PMDSettings;
import org.openide.util.Exceptions;

public final class PMDSettingsImpl
implements PMDSettings {
    private static String SETTINGS_DIR = System.getProperty("netbeans.user") + File.separatorChar + "config" + File.separatorChar + "pmd";
    private static String SETTINGS_FILE = "pmd.settings";
    private Map<String, Boolean> ruleMap;
    File settingsFile;

    public static PMDSettings globalSettings() {
        return new PMDSettingsImpl(new File(SETTINGS_DIR + File.separatorChar + SETTINGS_FILE));
    }

    public PMDSettingsImpl(File file) {
        this.settingsFile = file;
        this.readFile();
    }

    public void activateRule(Rule rule) {
        this.ruleMap.remove(rule.getName());
        this.updateFile();
    }

    public void deactivateRule(Rule rule) {
        this.ruleMap.put(rule.getName(), Boolean.FALSE);
        this.updateFile();
    }

    public boolean isRuleActive(Rule rule) {
        Boolean b = this.ruleMap.get(rule.getName());
        return null == b ? true : b;
    }

    public RuleSet getActiveRules() {
        RuleSet activeRuleSet = new RuleSet();
        RuleSet ruleSet = new RuleSet();
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        try {
            Iterator iterator = ruleSetFactory.getRegisteredRuleSets();
            while (iterator.hasNext()) {
                ruleSet = (RuleSet)iterator.next();
                for (Rule rule : ruleSet.getRules()) {
                    if (!this.isRuleActive(rule)) continue;
                    activeRuleSet.addRule(rule);
                }
            }
        }
        catch (RuleSetNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return activeRuleSet;
    }

    private void updateFile() {
        this.settingsFile.getParentFile().mkdirs();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.settingsFile, false));
            for (Map.Entry<String, Boolean> entry : this.ruleMap.entrySet()) {
                if (entry.getValue().booleanValue()) continue;
                writer.append(entry.getKey());
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void readFile() {
        this.ruleMap = new HashMap<String, Boolean>();
        if (this.settingsFile.exists()) {
            try {
                String line;
                BufferedReader fileReader = new BufferedReader(new FileReader(this.settingsFile));
                while (null != (line = fileReader.readLine())) {
                    this.ruleMap.put(line, Boolean.FALSE);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

