/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.core.option;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import org.jdesktop.layout.GroupLayout;
import org.nbheaven.sqe.tools.pmd.codedefects.core.option.RuleCellRenderer;
import org.nbheaven.sqe.tools.pmd.codedefects.core.option.SortedRuleTableModel;
import org.nbheaven.sqe.tools.pmd.codedefects.core.settings.PMDSettings;
import org.openide.util.NbBundle;

public class ConfigureRulesPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(ConfigureRulesPanel.class.getPackage().getName());
    private PMDSettings pmdSettings;
    private JEditorPane exampleEditor;
    private JTextArea informationArea;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTable rulesTable;

    public ConfigureRulesPanel() {
        this.initComponents();
    }

    public void setSettings(PMDSettings pmdSettings) {
        this.pmdSettings = pmdSettings;
        this.fillTable();
    }

    private void fillTable() {
        if (null == this.pmdSettings) {
            return;
        }
        DefaultTableModel model = new DefaultTableModel(new Object[0][], new String[]{"Rule", "Enabled"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Boolean.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
        ArrayList rules = new ArrayList();
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        try {
            Iterator iterator = ruleSetFactory.getRegisteredRuleSets();
            while (iterator.hasNext()) {
                RuleSet ruleSet = (RuleSet)iterator.next();
                rules.addAll(ruleSet.getRules());
            }
            for (Rule rule : rules) {
                model.addRow(new Object[]{rule, this.pmdSettings.isRuleActive(rule)});
            }
            SortedRuleTableModel sorter = new SortedRuleTableModel(model, this.rulesTable.getTableHeader());
            this.rulesTable.setModel(sorter);
            this.rulesTable.getColumnModel().getColumn(0).setCellRenderer(new RuleCellRenderer());
            this.rulesTable.getSelectionModel().addListSelectionListener(new RulesListListener());
        }
        catch (RuleSetNotFoundException ex) {
            logger.log(Level.SEVERE, "exception", ex);
        }
    }

    public void saveSettingsToPreferences() {
        Rule rule = null;
        Boolean enabled = true;
        SortedRuleTableModel model = (SortedRuleTableModel)this.rulesTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            rule = (Rule)model.getValueAt(i, 0);
            enabled = (Boolean)model.getValueAt(i, 1);
            if (enabled.booleanValue()) {
                this.pmdSettings.activateRule(rule);
                continue;
            }
            this.pmdSettings.deactivateRule(rule);
        }
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.informationArea = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.exampleEditor = new JEditorPane();
        this.jScrollPane1 = new JScrollPane();
        this.rulesTable = new JTable();
        this.informationArea.setColumns(20);
        this.informationArea.setRows(5);
        this.jScrollPane2.setViewportView(this.informationArea);
        this.exampleEditor.setContentType(NbBundle.getMessage(ConfigureRulesPanel.class, (String)"ConfigureRulesPanel.exampleEditor.contentType"));
        this.jScrollPane3.setViewportView(this.exampleEditor);
        this.rulesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Rule", "Enabled"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Boolean.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.fillTable();
        this.jScrollPane1.setViewportView(this.rulesTable);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jScrollPane3, -1, 549, Short.MAX_VALUE).add(1, (Component)this.jScrollPane1, -1, 549, Short.MAX_VALUE).add(1, (Component)this.jScrollPane2, -1, 549, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, 151, -2).add(26, 26, 26).add((Component)this.jScrollPane2, -2, 60, -2).addPreferredGap(0).add((Component)this.jScrollPane3, -2, 204, -2).addContainerGap()));
    }

    private class RulesListListener
    implements ListSelectionListener {
        private RulesListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int selectedRow = lsm.getMinSelectionIndex();
            if (selectedRow >= 0) {
                SortedRuleTableModel model = (SortedRuleTableModel)ConfigureRulesPanel.this.rulesTable.getModel();
                Rule rule = (Rule)model.getValueAt(selectedRow, 0);
                ConfigureRulesPanel.this.informationArea.setText(rule.getMessage());
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : rule.getExamples()) {
                    stringBuilder.append(string);
                }
                ConfigureRulesPanel.this.exampleEditor.setText(stringBuilder.toString());
            }
        }
    }
}

