/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.core.annotations;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import net.sourceforge.pmd.IRuleViolation;
import org.nbheaven.sqe.codedefects.core.api.QualityResult;
import org.nbheaven.sqe.codedefects.core.api.SQEAnnotationProcessor;
import org.nbheaven.sqe.core.java.search.SearchUtilities;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDResult;
import org.nbheaven.sqe.tools.pmd.codedefects.core.annotations.PMDAnnotation;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Line;

public final class RuleViolationAnnotationProcessor
implements SQEAnnotationProcessor {
    public static final SQEAnnotationProcessor INSTANCE = new RuleViolationAnnotationProcessor();

    private RuleViolationAnnotationProcessor() {
    }

    private static void openSourceFileAndAnnotate(IRuleViolation ruleViolation, Line line, Project project) {
        RuleViolationAnnotationProcessor.annotate(ruleViolation, line, project);
        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, ruleViolation.getBeginColumn());
    }

    public static Line getLineForRuleViolation(FileObject fo, IRuleViolation ruleViolation) {
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            LineCookie cookie = (LineCookie)dao.getCookie(LineCookie.class);
            Line.Set lineset = cookie.getLineSet();
            int lineNum = ruleViolation.getBeginLine();
            return lineset.getOriginal(lineNum - 1);
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            throw new RuntimeException("Failure accesing DataObject fot FileObject " + fo);
        }
    }

    private static void annotate(IRuleViolation ruleViolation, Line line, Project project) {
        PMDAnnotation annotation = PMDAnnotation.getNewInstance(project);
        annotation.setErrorMessage(ruleViolation.getDescription() + " [" + ruleViolation.getRule().getName() + "]");
        Line.Part linePart = line.createPart(ruleViolation.getBeginColumn(), ruleViolation.getEndColumn());
        annotation.attach((Annotatable)linePart);
        line.addPropertyChangeListener((PropertyChangeListener)annotation);
    }

    public static void openSourceFile(IRuleViolation ruleViolation, Project project) {
        String packagePrefix = ruleViolation.getPackageName().length() > 0 ? ruleViolation.getPackageName() + "." : "";
        String fileName = packagePrefix + ("".equals(ruleViolation.getFilename()) ? ruleViolation.getClassName() : ruleViolation.getFilename());
        FileObject fo = RuleViolationAnnotationProcessor.findFileObjectForAnnotatedClass(fileName);
        if (fo != null) {
            Line line = RuleViolationAnnotationProcessor.getLineForRuleViolation(fo, ruleViolation);
            RuleViolationAnnotationProcessor.openSourceFileAndAnnotate(ruleViolation, line, project);
        }
    }

    public static FileObject findFileObjectForAnnotatedClass(String className) {
        String javaFileName = className;
        if (-1 != javaFileName.indexOf(36)) {
            javaFileName = javaFileName.substring(0, javaFileName.indexOf(36));
        }
        javaFileName = javaFileName.replaceAll("\\.", "/") + ".java";
        return GlobalPathRegistry.getDefault().findResource(javaFileName);
    }

    public void annotateSourceFile(JavaSource javaSource, Project project, QualityResult qualityResult) {
        if (null == qualityResult) {
            return;
        }
        assert (qualityResult instanceof PMDResult) : "Illegal session passed to AnnotationProcessor";
        PMDResult result = (PMDResult)qualityResult;
        FileObject fileObject = (FileObject)javaSource.getFileObjects().iterator().next();
        Collection fqnClassNames = SearchUtilities.getFQNClassNames((FileObject)fileObject);
        for (String fqnClassName : fqnClassNames) {
            this.annotateClass(fqnClassName, fileObject, project, result);
        }
    }

    public void clearAllAnnotations(Project project) {
        PMDAnnotation.clearAll(project);
    }

    private void annotateClass(String className, FileObject fileObject, Project project, PMDResult result) {
        PMDResult.ClassKey classKey;
        Map<Object, Collection<IRuleViolation>> instanceMap = result.getInstanceByClass();
        Collection<IRuleViolation> ruleViolations = instanceMap.get(classKey = new PMDResult.ClassKey(className));
        if (null != ruleViolations) {
            for (IRuleViolation ruleViolation : ruleViolations) {
                try {
                    Line line = RuleViolationAnnotationProcessor.getLineForRuleViolation(fileObject, ruleViolation);
                    RuleViolationAnnotationProcessor.annotate(ruleViolation, line, project);
                }
                catch (RuntimeException rex) {
                    ErrorManager.getDefault().notify((Throwable)rex);
                }
            }
        }
    }
}

