/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.core.annotations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.openide.text.Annotation;
import org.openide.text.Line;

public class PMDAnnotation
extends Annotation
implements PropertyChangeListener {
    private static Map<Project, List<Annotation>> annotationMap = new HashMap<Project, List<Annotation>>();
    private String errormessage = null;

    private PMDAnnotation() {
    }

    public static final PMDAnnotation getNewInstance(Project project) {
        PMDAnnotation pmd = new PMDAnnotation();
        List<Annotation> annotations = annotationMap.get(project);
        if (null == annotations) {
            annotations = new ArrayList<Annotation>();
            annotationMap.put(project, annotations);
        }
        annotations.add(pmd);
        return pmd;
    }

    public static final void clearAll(Project project) {
        List<Annotation> annotations = annotationMap.get(project);
        if (null != annotations) {
            for (Annotation annotation : annotations) {
                annotation.detach();
            }
            annotations.clear();
        }
    }

    public String getAnnotationType() {
        return "pmd-annotation";
    }

    public void setErrorMessage(String message) {
        this.errormessage = message;
    }

    public String getShortDescription() {
        return this.errormessage;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("annotationCount")) {
            return;
        }
        Line line = (Line)propertyChangeEvent.getSource();
        line.removePropertyChangeListener((PropertyChangeListener)this);
        this.detach();
    }
}

