/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.core;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.spi.AbstractQualitySession;
import org.nbheaven.sqe.codedefects.core.spi.SQECodedefectScanner;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDFileScannerJob;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDProjectScannerJob;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDQualityProvider;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDResult;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;

public class PMDSession
extends AbstractQualitySession {
    private PMDResult pmdResult;
    private AtomicBoolean isRunning;
    private Lock waitResultLock = new ReentrantLock();
    private Condition waitForResult = this.waitResultLock.newCondition();

    public PMDSession(Project project) {
        super((QualityProvider)PMDQualityProvider.getDefault(), project);
        this.isRunning = new AtomicBoolean(false);
    }

    public PMDQualityProvider getProvider() {
        return (PMDQualityProvider)super.getProvider();
    }

    public PMDResult getResult() {
        return this.pmdResult;
    }

    public PMDResult computeResultAndWait(FileObject ... fileObjects) {
        PMDFileScannerJob job = new PMDFileScannerJob(this.getProject(), fileObjects);
        SQECodedefectScanner.postAndWait((SQECodedefectScanner.Job)job);
        return job.getPMDResult();
    }

    public PMDResult computeResultAndWait() {
        this.waitResultLock.lock();
        this.computeResult();
        this.waitForResult.awaitUninterruptibly();
        this.waitResultLock.unlock();
        return this.pmdResult;
    }

    public void computeResult() {
        if (!this.isRunning.getAndSet(true)) {
            PMDProjectScannerJob job = new PMDProjectScannerJob(this);
            SQECodedefectScanner.post((SQECodedefectScanner.Job)job);
        }
    }

    void scanningDone() {
        this.waitResultLock.lock();
        this.isRunning.set(false);
        this.waitForResult.signalAll();
        this.waitResultLock.unlock();
    }

    void setResult(PMDResult pmdResult) {
        PMDResult oldResult = this.pmdResult;
        this.pmdResult = pmdResult;
        this.fireResultChanged(oldResult, this.pmdResult);
    }
}

