/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.core;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.SourceType;
import org.nbheaven.sqe.codedefects.core.spi.SQECodedefectScanner;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDResult;
import org.nbheaven.sqe.tools.pmd.codedefects.core.settings.PMDSettings;
import org.nbheaven.sqe.tools.pmd.codedefects.core.settings.PMDSettingsProvider;
import org.nbheaven.sqe.tools.pmd.codedefects.core.settings.impl.PMDSettingsImpl;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PMDScannerJob
extends SQECodedefectScanner.Job {
    private static final Logger LOGGER = Logger.getLogger(PMDScannerJob.class.getName());
    private final Project project;
    private PMDResult pmdResult;
    private PMD pmd;
    private RuleSet rules;
    private RuleContext ruleContext;
    private Report report;
    private PMDSettings settings;

    PMDScannerJob(Project project) {
        this.project = project;
    }

    protected final String getDisplayName() {
        return "PMD scanning " + ProjectUtils.getInformation((Project)this.getProject()).getName();
    }

    protected final Project getProject() {
        return this.project;
    }

    protected final PMDResult getPMDResult() {
        return this.pmdResult;
    }

    protected final PMDSettings getPMDSettings() {
        return this.settings;
    }

    private void init() {
        this.pmd = new PMD();
        this.ruleContext = new RuleContext();
        this.report = new Report();
        this.ruleContext.setReport(this.report);
        PMDSettingsProvider settingsProvider = (PMDSettingsProvider)this.getProject().getLookup().lookup(PMDSettingsProvider.class);
        if (settingsProvider != null) {
            this.settings = settingsProvider.getPMDSettings();
        }
        if (this.settings == null) {
            this.settings = PMDSettingsImpl.globalSettings();
        }
        this.rules = this.settings.getActiveRules();
    }

    private SourceType getSourceType(FileObject fo) {
        String sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)fo);
        if ("1.3".equals(sourceLevel)) {
            return SourceType.JAVA_13;
        }
        if ("1.4".equals(sourceLevel)) {
            return SourceType.JAVA_14;
        }
        if ("1.5".equals(sourceLevel)) {
            return SourceType.JAVA_15;
        }
        if ("1.6".equals(sourceLevel)) {
            return SourceType.JAVA_15;
        }
        return SourceType.JAVA_15;
    }

    protected void scan() {
        this.getProgressHandle().progress("Setting up PMD");
        this.init();
        this.executePMD();
        this.pmdResult = new PMDResult(this.report);
    }

    protected abstract void executePMD();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executePMD(Collection<FileObject> fullList) {
        this.getProgressHandle().switchToDeterminate(fullList.size());
        int i = 0;
        for (FileObject fo : fullList) {
            Reader reader = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(fo.getInputStream(), FileEncodingQuery.getEncoding((FileObject)fo)));
                    this.ruleContext.setSourceCodeFilename(fo.getName());
                    this.pmd.setJavaVersion(this.getSourceType(fo));
                    this.getProgressHandle().progress(i++);
                    this.getProgressHandle().progress("Scanning " + fo.getName());
                    this.pmd.processFile(reader, this.rules, this.ruleContext);
                    this.getProgressHandle().progress("Looking for next file");
                }
                catch (PMDException ex) {
                    LOGGER.warning("Failure running PMD on " + fo.getName() + " caused by " + ex.getCause().getMessage());
                }
                catch (FileNotFoundException ex) {
                    LOGGER.warning("File foe FileObject could not be found: " + fo.getName());
                }
            }
            finally {
                if (null == reader) continue;
                try {
                    reader.close();
                }
                catch (IOException ioex) {}
            }
        }
    }
}

