/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import org.nbheaven.sqe.codedefects.core.api.CodeDefectSeverity;
import org.nbheaven.sqe.codedefects.core.api.QualityResult;
import org.nbheaven.sqe.codedefects.core.api.QualityResultStatistic;
import org.nbheaven.sqe.tools.pmd.codedefects.core.annotations.RuleViolationAnnotationProcessor;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMDResult
implements QualityResult,
Lookup.Provider,
QualityResultStatistic {
    private Map<Object, Collection<IRuleViolation>> instanceByClass;
    private Map<Object, Collection<IRuleViolation>> instanceByPackage;
    private Map<Object, Collection<IRuleViolation>> instanceByType;
    private Report report;
    private Lookup lookup;

    public PMDResult(Report report) {
        this.report = report;
        this.lookup = Lookups.fixed((Object[])new Object[]{this});
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private void removeAllRuleViolationsForRule(Rule rule, Map<? extends Object, Collection<IRuleViolation>> mapToClear) {
        for (Map.Entry<? extends Object, Collection<IRuleViolation>> entry : new HashMap<Object, Collection<IRuleViolation>>(mapToClear).entrySet()) {
            for (IRuleViolation ruleViolation : new ArrayList<IRuleViolation>(entry.getValue())) {
                if (!ruleViolation.getRule().equals(rule)) continue;
                entry.getValue().remove(ruleViolation);
            }
            if (!entry.getValue().isEmpty()) continue;
            mapToClear.remove(entry.getKey());
        }
    }

    public void removeAllRuleViolationsForRule(Rule rule) {
        if (null != this.instanceByType) {
            this.removeAllRuleViolationsForRule(rule, this.instanceByType);
        }
        if (null != this.instanceByClass) {
            this.removeAllRuleViolationsForRule(rule, this.instanceByClass);
        }
    }

    public Map<Object, Collection<IRuleViolation>> getInstanceByType() {
        if (null == this.instanceByType) {
            TreeMap<Object, Collection<IRuleViolation>> tempInstanceByType = new TreeMap<Object, Collection<IRuleViolation>>();
            for (IRuleViolation ruleViolation : this.report) {
                CategoryKey categoryKey = new CategoryKey(ruleViolation);
                ArrayList<IRuleViolation> ruleViolations = (ArrayList<IRuleViolation>)tempInstanceByType.get(categoryKey);
                if (null == ruleViolations) {
                    ruleViolations = new ArrayList<IRuleViolation>();
                    tempInstanceByType.put(categoryKey, ruleViolations);
                }
                ruleViolations.add(ruleViolation);
            }
            this.instanceByType = tempInstanceByType;
        }
        return this.instanceByType;
    }

    public Map<Object, Collection<IRuleViolation>> getInstanceByClass() {
        if (null == this.instanceByClass) {
            this.instanceByClass = new TreeMap<Object, Collection<IRuleViolation>>();
            for (IRuleViolation ruleViolation : this.report) {
                ClassKey classKey = new ClassKey(ruleViolation);
                Collection<IRuleViolation> ruleViolations = this.instanceByClass.get(classKey);
                if (null == ruleViolations) {
                    ruleViolations = new ArrayList<IRuleViolation>();
                    this.instanceByClass.put(classKey, ruleViolations);
                }
                ruleViolations.add(ruleViolation);
            }
        }
        return this.instanceByClass;
    }

    public Map<Object, Collection<IRuleViolation>> getInstanceByPackage() {
        if (null == this.instanceByPackage) {
            this.instanceByPackage = new TreeMap<Object, Collection<IRuleViolation>>();
            for (IRuleViolation ruleViolation : this.report) {
                PackageKey packageKey = new PackageKey(ruleViolation);
                Collection<IRuleViolation> ruleViolations = this.instanceByPackage.get(packageKey);
                if (null == ruleViolations) {
                    ruleViolations = new ArrayList<IRuleViolation>();
                    this.instanceByPackage.put(packageKey, ruleViolations);
                }
                ruleViolations.add(ruleViolation);
            }
        }
        return this.instanceByPackage;
    }

    public long getBugCount() {
        return this.report.size();
    }

    public long getCodeDefectCountSum() {
        return this.getBugCount();
    }

    public long getCodeDefectCount(CodeDefectSeverity severity) {
        if (CodeDefectSeverity.INFO == severity) {
            return this.getBugCount();
        }
        if (CodeDefectSeverity.WARNING == severity) {
            return 0L;
        }
        if (CodeDefectSeverity.ERROR == severity) {
            return 0L;
        }
        return 0L;
    }

    public static class CategoryKey
    extends DisplayableKey {
        private final IRuleViolation bugPattern;

        public CategoryKey(IRuleViolation bugPattern) {
            this.bugPattern = bugPattern;
        }

        public String getDisplayName() {
            return this.bugPattern.getRule().getName();
        }

        public String getDescription() {
            return this.bugPattern.getDescription();
        }
    }

    public static class ClassKey
    extends DisplayableKey {
        private final String className;
        private final FileObject fileObject;

        public ClassKey(IRuleViolation ruleViolation) {
            this.className = (0 == ruleViolation.getPackageName().length() ? "" : ruleViolation.getPackageName() + ".") + (null == ruleViolation.getClassName() || ruleViolation.getClassName().length() == 0 ? ruleViolation.getFilename() : ruleViolation.getClassName());
            this.fileObject = RuleViolationAnnotationProcessor.findFileObjectForAnnotatedClass(this.className);
        }

        public ClassKey(String className) {
            this.className = className;
            this.fileObject = RuleViolationAnnotationProcessor.findFileObjectForAnnotatedClass(className);
        }

        public String getDisplayName() {
            return this.className;
        }

        public String getClassName() {
            return this.className;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }
    }

    public static abstract class DisplayableKey
    implements Comparable {
        public abstract String getDisplayName();

        public final boolean equals(Object object) {
            if (object instanceof DisplayableKey) {
                return ((DisplayableKey)object).getDisplayName().equals(this.getDisplayName());
            }
            return false;
        }

        public final int hashCode() {
            return this.getDisplayName().hashCode();
        }

        public final int compareTo(Object object) {
            if (object instanceof DisplayableKey) {
                return this.getDisplayName().compareTo(((DisplayableKey)object).getDisplayName());
            }
            throw new IllegalArgumentException("Can't be compared to " + object.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        CLASS("HINT_VIEW_BY_CLASS", "org/nbheaven/sqe/tools/pmd/codedefects/core/resources/class.gif"){

            @Override
            public Map<Object, Collection<IRuleViolation>> getInstanceList(PMDResult result) {
                return result.getInstanceByClass();
            }
        }
        ,
        PACKAGE("HINT_VIEW_BY_PACKAGE", "org/nbheaven/sqe/tools/pmd/codedefects/core/resources/package.gif"){

            @Override
            public Map<Object, Collection<IRuleViolation>> getInstanceList(PMDResult result) {
                return result.getInstanceByPackage();
            }
        }
        ,
        TYPE("HINT_VIEW_BY_CATEGORY", "org/nbheaven/sqe/tools/pmd/codedefects/core/resources/pmd.png"){

            @Override
            public Map<Object, Collection<IRuleViolation>> getInstanceList(PMDResult result) {
                return result.getInstanceByType();
            }
        };

        private final String hint;
        private final Icon icon;

        private Mode(String hint, String iconPath) {
            this.hint = hint;
            this.icon = new ImageIcon(ImageUtilities.loadImage((String)iconPath));
        }

        public String getHint() {
            return this.hint;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public abstract Map<Object, Collection<IRuleViolation>> getInstanceList(PMDResult var1);
    }

    public static class PackageKey
    extends DisplayableKey {
        private final String packageName;

        public PackageKey(IRuleViolation ruleViolation) {
            this.packageName = 0 == ruleViolation.getPackageName().length() ? "<Default Package>" : ruleViolation.getPackageName();
        }

        public String getDisplayName() {
            return this.packageName;
        }
    }
}

