/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutowiredAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements MergedBeanDefinitionPostProcessor,
PriorityOrdered,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(AutowiredAnnotationBeanPostProcessor.class);
    private Class<? extends Annotation> autowiredAnnotationType = Autowired.class;
    private String requiredParameterName = "required";
    private boolean requiredParameterValue = true;
    private int order = 0x7FFFFFFD;
    private ConfigurableListableBeanFactory beanFactory;
    private final Map<Class<?>, Constructor[]> candidateConstructorsCache = new ConcurrentHashMap();
    private final Map<Class<?>, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap();

    public void setAutowiredAnnotationType(Class<? extends Annotation> autowiredAnnotationType) {
        Assert.notNull(autowiredAnnotationType, "'autowiredAnnotationType' must not be null");
        this.autowiredAnnotationType = autowiredAnnotationType;
    }

    protected Class<? extends Annotation> getAutowiredAnnotationType() {
        return this.autowiredAnnotationType;
    }

    public void setRequiredParameterName(String requiredParameterName) {
        this.requiredParameterName = requiredParameterName;
    }

    public void setRequiredParameterValue(boolean requiredParameterValue) {
        this.requiredParameterValue = requiredParameterValue;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("AutowiredAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class beanType, String beanName) {
        if (beanType != null) {
            InjectionMetadata metadata = this.findAutowiringMetadata(beanType);
            metadata.checkConfigMembers(beanDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constructor[] determineCandidateConstructors(Class beanClass, String beanName) throws BeansException {
        Constructor[] candidateConstructors = this.candidateConstructorsCache.get(beanClass);
        if (candidateConstructors == null) {
            Map<Class<?>, Constructor[]> map = this.candidateConstructorsCache;
            synchronized (map) {
                candidateConstructors = this.candidateConstructorsCache.get(beanClass);
                if (candidateConstructors == null) {
                    Constructor<?>[] rawCandidates = beanClass.getDeclaredConstructors();
                    ArrayList candidates = new ArrayList(rawCandidates.length);
                    Constructor<?> requiredConstructor = null;
                    Constructor<?> defaultConstructor = null;
                    for (int i = 0; i < rawCandidates.length; ++i) {
                        Constructor<?> candidate = rawCandidates[i];
                        Annotation annotation = candidate.getAnnotation(this.getAutowiredAnnotationType());
                        if (annotation != null) {
                            if (requiredConstructor != null) {
                                throw new BeanCreationException("Invalid autowire-marked constructor: " + candidate + ". Found another constructor with 'required' Autowired annotation: " + requiredConstructor);
                            }
                            if (candidate.getParameterTypes().length == 0) {
                                throw new IllegalStateException("Autowired annotation requires at least one argument: " + candidate);
                            }
                            boolean required = this.determineRequiredStatus(annotation);
                            if (required) {
                                if (!candidates.isEmpty()) {
                                    throw new BeanCreationException("Invalid autowire-marked constructors: " + candidates + ". Found another constructor with 'required' Autowired annotation: " + requiredConstructor);
                                }
                                requiredConstructor = candidate;
                            }
                            candidates.add(candidate);
                            continue;
                        }
                        if (candidate.getParameterTypes().length != 0) continue;
                        defaultConstructor = candidate;
                    }
                    if (!candidates.isEmpty()) {
                        if (requiredConstructor == null && defaultConstructor != null) {
                            candidates.add(defaultConstructor);
                        }
                        candidateConstructors = candidates.toArray(new Constructor[candidates.size()]);
                    } else {
                        candidateConstructors = new Constructor[]{};
                    }
                    this.candidateConstructorsCache.put(beanClass, candidateConstructors);
                }
            }
        }
        return candidateConstructors.length > 0 ? candidateConstructors : null;
    }

    @Override
    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findAutowiringMetadata(bean.getClass());
        try {
            metadata.injectFields(bean, beanName);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Autowiring of fields failed", ex);
        }
        return true;
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findAutowiringMetadata(bean.getClass());
        try {
            metadata.injectMethods(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Autowiring of methods failed", ex);
        }
        return pvs;
    }

    public void processInjection(Object bean) throws BeansException {
        InjectionMetadata metadata = this.findAutowiringMetadata(bean.getClass());
        try {
            metadata.injectFields(bean, null);
            metadata.injectMethods(bean, null, null);
        }
        catch (Throwable ex) {
            throw new BeanCreationException("Autowiring of fields/methods failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findAutowiringMetadata(final Class clazz) {
        InjectionMetadata metadata = this.injectionMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(clazz);
                if (metadata == null) {
                    final InjectionMetadata newMetadata = new InjectionMetadata(clazz);
                    ReflectionUtils.doWithFields(clazz, new ReflectionUtils.FieldCallback(){

                        public void doWith(Field field) {
                            Annotation annotation = field.getAnnotation(AutowiredAnnotationBeanPostProcessor.this.getAutowiredAnnotationType());
                            if (annotation != null) {
                                if (Modifier.isStatic(field.getModifiers())) {
                                    throw new IllegalStateException("Autowired annotation is not supported on static fields");
                                }
                                boolean required = AutowiredAnnotationBeanPostProcessor.this.determineRequiredStatus(annotation);
                                newMetadata.addInjectedField(new AutowiredFieldElement(field, required));
                            }
                        }
                    });
                    ReflectionUtils.doWithMethods(clazz, new ReflectionUtils.MethodCallback(){

                        public void doWith(Method method) {
                            Annotation annotation = method.getAnnotation(AutowiredAnnotationBeanPostProcessor.this.getAutowiredAnnotationType());
                            if (annotation != null && method.equals(ClassUtils.getMostSpecificMethod(method, clazz))) {
                                if (Modifier.isStatic(method.getModifiers())) {
                                    throw new IllegalStateException("Autowired annotation is not supported on static methods");
                                }
                                if (method.getParameterTypes().length == 0) {
                                    throw new IllegalStateException("Autowired annotation requires at least one argument: " + method);
                                }
                                boolean required = AutowiredAnnotationBeanPostProcessor.this.determineRequiredStatus(annotation);
                                PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
                                newMetadata.addInjectedMethod(new AutowiredMethodElement(method, required, pd));
                            }
                        }
                    });
                    metadata = newMetadata;
                    this.injectionMetadataCache.put(clazz, metadata);
                }
            }
        }
        return metadata;
    }

    protected Map findAutowireCandidates(Class type) throws BeansException {
        if (this.beanFactory == null) {
            throw new IllegalStateException("No BeanFactory configured - override the getBeanOfType method or specify the 'beanFactory' property");
        }
        return BeanFactoryUtils.beansOfTypeIncludingAncestors(this.beanFactory, type);
    }

    protected boolean determineRequiredStatus(Annotation annotation) {
        try {
            Method method = ReflectionUtils.findMethod(annotation.annotationType(), this.requiredParameterName);
            return this.requiredParameterValue == (Boolean)ReflectionUtils.invokeMethod(method, annotation);
        }
        catch (Exception ex) {
            return true;
        }
    }

    private void registerDependentBeans(String beanName, Set<String> autowiredBeanNames) {
        if (beanName != null) {
            for (String autowiredBeanName : autowiredBeanNames) {
                this.beanFactory.registerDependentBean(autowiredBeanName, beanName);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' to bean named '" + autowiredBeanName + "'"));
            }
        }
    }

    private class AutowiredFieldElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;
        private volatile boolean cached;
        private volatile Object cachedFieldValue;

        public AutowiredFieldElement(Field field, boolean required) {
            super(field, null);
            this.cached = false;
            this.required = required;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Field field = (Field)this.member;
            try {
                Object value = null;
                if (this.cached) {
                    if (this.cachedFieldValue instanceof DependencyDescriptor) {
                        DependencyDescriptor descriptor = (DependencyDescriptor)this.cachedFieldValue;
                        TypeConverter typeConverter = AutowiredAnnotationBeanPostProcessor.this.beanFactory.getTypeConverter();
                        value = AutowiredAnnotationBeanPostProcessor.this.beanFactory.resolveDependency(descriptor, beanName, null, typeConverter);
                    } else {
                        value = this.cachedFieldValue instanceof RuntimeBeanReference ? AutowiredAnnotationBeanPostProcessor.this.beanFactory.getBean(((RuntimeBeanReference)this.cachedFieldValue).getBeanName()) : this.cachedFieldValue;
                    }
                } else {
                    LinkedHashSet autowiredBeanNames = new LinkedHashSet(1);
                    TypeConverter typeConverter = AutowiredAnnotationBeanPostProcessor.this.beanFactory.getTypeConverter();
                    DependencyDescriptor descriptor = new DependencyDescriptor(field, this.required);
                    this.cachedFieldValue = descriptor;
                    value = AutowiredAnnotationBeanPostProcessor.this.beanFactory.resolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
                    if (value != null) {
                        AutowiredAnnotationBeanPostProcessor.this.registerDependentBeans(beanName, autowiredBeanNames);
                        if (autowiredBeanNames.size() == 1) {
                            String autowiredBeanName = (String)autowiredBeanNames.iterator().next();
                            if (AutowiredAnnotationBeanPostProcessor.this.beanFactory.containsBean(autowiredBeanName) && AutowiredAnnotationBeanPostProcessor.this.beanFactory.isTypeMatch(autowiredBeanName, field.getType())) {
                                this.cachedFieldValue = new RuntimeBeanReference(autowiredBeanName);
                            }
                        }
                    } else {
                        this.cachedFieldValue = null;
                    }
                    this.cached = true;
                }
                if (value != null) {
                    ReflectionUtils.makeAccessible(field);
                    field.set(bean, value);
                }
            }
            catch (Throwable ex) {
                throw new BeanCreationException("Could not autowire field: " + field, ex);
            }
        }
    }

    private class AutowiredMethodElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;
        private volatile boolean cached;
        private volatile Object[] cachedMethodArguments;

        public AutowiredMethodElement(Method method, boolean required, PropertyDescriptor pd) {
            super(method, pd);
            this.cached = false;
            this.required = required;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            if (this.skip == null && this.pd != null && pvs != null && pvs.contains(this.pd.getName())) {
                this.skip = Boolean.TRUE;
            }
            if (this.skip != null && this.skip.booleanValue()) {
                return;
            }
            Method method = (Method)this.member;
            try {
                Object[] arguments = null;
                if (this.cached) {
                    if (this.cachedMethodArguments != null) {
                        arguments = new Object[this.cachedMethodArguments.length];
                        for (int i = 0; i < arguments.length; ++i) {
                            Object cachedArg = this.cachedMethodArguments[i];
                            if (cachedArg instanceof DependencyDescriptor) {
                                DependencyDescriptor descriptor = (DependencyDescriptor)cachedArg;
                                TypeConverter typeConverter = AutowiredAnnotationBeanPostProcessor.this.beanFactory.getTypeConverter();
                                arguments[i] = AutowiredAnnotationBeanPostProcessor.this.beanFactory.resolveDependency(descriptor, beanName, null, typeConverter);
                                continue;
                            }
                            arguments[i] = cachedArg instanceof RuntimeBeanReference ? AutowiredAnnotationBeanPostProcessor.this.beanFactory.getBean(((RuntimeBeanReference)cachedArg).getBeanName()) : cachedArg;
                        }
                    }
                } else {
                    Class<?>[] paramTypes = method.getParameterTypes();
                    arguments = new Object[paramTypes.length];
                    LinkedHashSet autowiredBeanNames = new LinkedHashSet(arguments.length);
                    TypeConverter typeConverter = AutowiredAnnotationBeanPostProcessor.this.beanFactory.getTypeConverter();
                    this.cachedMethodArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        MethodParameter methodParam = new MethodParameter(method, i);
                        GenericTypeResolver.resolveParameterType(methodParam, bean.getClass());
                        DependencyDescriptor descriptor = new DependencyDescriptor(methodParam, this.required);
                        this.cachedMethodArguments[i] = descriptor;
                        arguments[i] = AutowiredAnnotationBeanPostProcessor.this.beanFactory.resolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
                        if (arguments[i] != null) continue;
                        arguments = null;
                        break;
                    }
                    if (arguments != null) {
                        AutowiredAnnotationBeanPostProcessor.this.registerDependentBeans(beanName, autowiredBeanNames);
                        if (autowiredBeanNames.size() == paramTypes.length) {
                            Iterator it = autowiredBeanNames.iterator();
                            for (int i = 0; i < paramTypes.length; ++i) {
                                String autowiredBeanName = (String)it.next();
                                if (AutowiredAnnotationBeanPostProcessor.this.beanFactory.containsBean(autowiredBeanName)) {
                                    if (!AutowiredAnnotationBeanPostProcessor.this.beanFactory.isTypeMatch(autowiredBeanName, paramTypes[i])) continue;
                                    this.cachedMethodArguments[i] = new RuntimeBeanReference(autowiredBeanName);
                                    continue;
                                }
                                this.cachedMethodArguments[i] = arguments[i];
                            }
                        }
                    } else {
                        this.cachedMethodArguments = null;
                    }
                    this.cached = true;
                }
                if (this.skip == null) {
                    if (this.pd != null && pvs instanceof MutablePropertyValues) {
                        ((MutablePropertyValues)pvs).registerProcessedProperty(this.pd.getName());
                    }
                    this.skip = Boolean.FALSE;
                }
                if (arguments != null) {
                    ReflectionUtils.makeAccessible(method);
                    method.invoke(bean, arguments);
                }
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            catch (Throwable ex) {
                throw new BeanCreationException("Could not autowire method: " + method, ex);
            }
        }
    }
}

