/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jersey.api.core.ResourceContext;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LeafResource {
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected Habitat habitat;
    protected LeafContent entity;
    protected Dom parent;
    protected String tagName;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LeafResource.class);

    public void setEntity(LeafContent p) {
        this.entity = p;
    }

    public LeafContent getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        this.entity = new LeafContent();
        this.entity.name = tagName;
        this.entity.value = parent.leafElement(tagName);
    }

    @GET
    @Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult get(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        if (this.getEntity() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return this.buildActionReportResult();
    }

    @POST
    @Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult create(HashMap<String, String> data) {
        if (data.containsKey("operation") && data.get("operation").equals("__deleteoperation")) {
            data.remove("operation");
            return this.delete(data);
        }
        return null;
    }

    @DELETE
    @Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult delete(HashMap<String, String> data) {
        ResourceUtil.addQueryString((MultivaluedMap<String, String>)this.uriInfo.getQueryParameters(), data);
        return null;
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html;qs=2", "application/xml"})
    public ActionReportResult options() {
        return this.buildActionReportResult();
    }

    protected ActionReportResult buildActionReportResult() {
        RestActionReporter ar = new RestActionReporter();
        String typeKey = Util.decode(this.getName());
        ar.setActionDescription(typeKey);
        ar.getExtraProperties().put("entityLeaf", this.getEntity());
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        Map<String, MethodMetaData> mmd = this.getMethodMetaData();
        optionsResult.putMethodMetaData("GET", mmd.get("GET"));
        optionsResult.putMethodMetaData("POST", mmd.get("POST"));
        ResourceUtil.addMethodMetaData((ActionReport)ar, mmd);
        ActionReportResult r = new ActionReportResult(ar, optionsResult);
        r.setLeafContent(this.entity);
        return r;
    }

    protected Map<String, MethodMetaData> getMethodMetaData() {
        TreeMap<String, MethodMetaData> mmd = new TreeMap<String, MethodMetaData>();
        mmd.put("GET", new MethodMetaData());
        return mmd;
    }

    protected String getName() {
        return Util.getResourceName(this.uriInfo);
    }

    public static class LeafContent {
        public String name;
        public String value;
    }
}

