/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.admin.util.AuthenticationInfo;
import com.sun.enterprise.admin.util.HttpConnectorAddress;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecureAdminInternalUser;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.common.ActionReporter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.security.common.MasterPassword;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Util.class);
    private static Client client;

    private Util() {
    }

    public static String getResourceName(UriInfo uriInfo) {
        return Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uriInfo.getPath(), '/')));
    }

    public static String getParentName(UriInfo uriInfo) {
        if (uriInfo == null) {
            return null;
        }
        return Util.getParentName(uriInfo.getPath());
    }

    public static String getGrandparentName(UriInfo uriInfo) {
        if (uriInfo == null) {
            return null;
        }
        return Util.getGrandparentName(uriInfo.getPath());
    }

    public static String getName(String typeName) {
        return Util.getName(typeName, '.');
    }

    public static String getName(String typeName, char delimiter) {
        int index;
        if (typeName == null || "".equals(typeName)) {
            return typeName;
        }
        if (typeName.length() - 1 == typeName.lastIndexOf(delimiter)) {
            typeName = typeName.substring(0, typeName.length() - 1);
        }
        if (typeName != null && typeName.length() > 0 && (index = typeName.lastIndexOf(delimiter)) != -1) {
            return typeName.substring(index + 1);
        }
        return typeName;
    }

    public static String getParentName(String url) {
        if (url == null || "".equals(url)) {
            return url;
        }
        String name = Util.getName(url, '/');
        int nameIndex = url.indexOf(name, url.indexOf(":") + 1);
        return Util.getName(url.substring(0, nameIndex - 1), '/');
    }

    public static String getGrandparentName(String url) {
        if (url == null || "".equals(url)) {
            return url;
        }
        String name = Util.getParentName(url);
        int nameIndex = url.indexOf(name, url.indexOf(":") + 1);
        return Util.getName(url.substring(0, nameIndex - 1), '/');
    }

    public static String eleminateHypen(String string) {
        if (string != null && string.length() > 0) {
            int index = string.indexOf(45);
            while (index != -1) {
                string = index == 0 ? string.substring(1) : (index == string.length() - 1 ? string.substring(0, string.length() - 1) : string.substring(0, index) + Util.upperCaseFirstLetter(string.substring(index + 1)));
                index = string.indexOf(45);
            }
        }
        return string;
    }

    public static String decode(String string) {
        String ret = string;
        try {
            ret = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static String upperCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(Locale.US) + string.substring(1);
    }

    protected static String getHtml(String message, UriInfo uriInfo, boolean delete) {
        String result = ProviderUtil.getHtmlHeader(uriInfo.getBaseUri().toASCIIString());
        String uri = uriInfo.getAbsolutePath().toString();
        if (delete) {
            uri = uri + "/..";
        }
        String name = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uri, '/')));
        String parentName = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getParentName(uri)));
        result = result + "<h1>" + name + "</h1>";
        result = result + message;
        result = result + "<a href=\"" + uri + "\">Back</a>";
        result = result + "</body></html>";
        return result;
    }

    public static String methodNameFromDtdName(String elementName, String prefix) {
        return Util.methodNameFromBeanName(Util.eleminateHypen(elementName), prefix);
    }

    public static String methodNameFromBeanName(String elementName, String prefix) {
        if (null == elementName || null == prefix || prefix.length() <= 0) {
            return elementName;
        }
        String methodName = Util.upperCaseFirstLetter(elementName);
        methodName = prefix + methodName;
        return methodName;
    }

    public static Client getJerseyClient(Habitat habitat) {
        if (client == null) {
            ConnectionFactory urlConnectionFactory = new ConnectionFactory(habitat);
            client = new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)urlConnectionFactory));
        }
        return client;
    }

    public static ActionReporter applyChanges(Map<String, String> data, UriInfo uriInfo, Habitat habitat) {
        List pathSegments = uriInfo.getPathSegments();
        PathSegment lastSegment = (PathSegment)pathSegments.get(pathSegments.size() - 1);
        if (lastSegment.getPath().isEmpty()) {
            pathSegments = pathSegments.subList(0, pathSegments.size() - 1);
        }
        List candidatePathSegment = null;
        candidatePathSegment = pathSegments.size() != 1 ? pathSegments.subList(1, pathSegments.size()) : pathSegments;
        StringBuilder sb = new StringBuilder();
        for (PathSegment pathSegment : candidatePathSegment) {
            sb.append(pathSegment.getPath());
            sb.append('.');
        }
        String setBasePath = sb.toString();
        ParameterMap parameters = new ParameterMap();
        Map<String, String> currentValues = Util.getCurrentValues(setBasePath, habitat);
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String currentValue = currentValues.get(setBasePath + entry.getKey());
            if (currentValue != null && !entry.getValue().equals("") && currentValue.equals(entry.getValue())) continue;
            parameters.add((Object)"DEFAULT", (Object)(setBasePath + entry.getKey() + "=" + entry.getValue()));
        }
        if (!parameters.entrySet().isEmpty()) {
            return ResourceUtil.runCommand("set", parameters, habitat, "");
        }
        return new RestActionReporter();
    }

    private static Map<String, String> getCurrentValues(String basePath, Habitat habitat) {
        HashMap<String, String> values = new HashMap<String, String>();
        final String path = basePath.endsWith(".") ? basePath.substring(0, basePath.length() - 1) : basePath;
        RestActionReporter gr = ResourceUtil.runCommand("get", new ParameterMap(){
            {
                this.add("DEFAULT", path);
            }
        }, habitat, "");
        ActionReport.MessagePart top = gr.getTopMessagePart();
        for (ActionReport.MessagePart child : top.getChildren()) {
            String message = child.getMessage();
            if (!message.contains("=")) continue;
            String[] parts = message.split("=");
            values.put(parts[0], parts.length > 1 ? parts[1] : "");
        }
        return values;
    }

    public static void deleteFile(String fileName, String mimeType, InputStream fileStream) {
        System.out.println("Deleting file....");
        if (fileName.contains(".")) {
            File f = new File(new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name")), fileName);
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveFile(String fileName, String mimeType, InputStream fileStream) {
        FilterOutputStream out = null;
        File f = null;
        try {
            if (fileName.contains(".")) {
                File tmpFile = new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name"));
                if (!tmpFile.exists()) {
                    tmpFile.mkdir();
                }
                f = new File(tmpFile, fileName);
            }
            out = new BufferedOutputStream(new FileOutputStream(f));
            byte[] buffer = new byte[32768];
            int bytesRead = 0;
            while ((bytesRead = fileStream.read(buffer)) != -1) {
                ((BufferedOutputStream)out).write(buffer, 0, bytesRead);
            }
            File file = f;
            return file;
        }
        catch (IOException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    private static class ConnectionFactory
    implements HttpURLConnectionFactory {
        Habitat habitat;

        private ConnectionFactory(Habitat habitat) {
            this.habitat = habitat;
        }

        public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
            Domain domain = (Domain)this.habitat.getComponent(Domain.class);
            SecureAdmin secureAdmin = domain.getSecureAdmin();
            String certAlias = SecureAdmin.Util.isUsingUsernamePasswordAuth((SecureAdmin)secureAdmin) ? null : SecureAdmin.Util.DASAlias((SecureAdmin)secureAdmin);
            HttpConnectorAddress httpConnectorAddress = new HttpConnectorAddress(((SSLUtils)this.habitat.getComponent(SSLUtils.class)).getAdminSocketFactory(certAlias, "TLS"));
            AuthenticationInfo authenticationInfo = this.authenticationInfo(this.habitat, secureAdmin);
            if (authenticationInfo != null) {
                httpConnectorAddress.setAuthenticationInfo(authenticationInfo);
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)httpConnectorAddress.openConnection(url);
            String indicatorValue = SecureAdmin.Util.configuredAdminIndicator((SecureAdmin)secureAdmin);
            if (indicatorValue != null) {
                httpURLConnection.setRequestProperty("X-GlassFish-admin", indicatorValue);
            }
            httpURLConnection.setRequestProperty("Content-type", "application/json");
            return httpURLConnection;
        }

        private AuthenticationInfo authenticationInfo(Habitat habitat, SecureAdmin secureAdmin) {
            SecureAdminInternalUser secureAdminInternalUser;
            AuthenticationInfo result = null;
            if (SecureAdmin.Util.isUsingUsernamePasswordAuth((SecureAdmin)secureAdmin) && (secureAdminInternalUser = SecureAdmin.Util.secureAdminInternalUser((SecureAdmin)secureAdmin)) != null) {
                try {
                    String pw = ((MasterPassword)habitat.getComponent(MasterPassword.class)).getMasterPasswordAdapter().getPasswordForAlias(secureAdminInternalUser.getPasswordAlias());
                    result = new AuthenticationInfo(secureAdminInternalUser.getUsername(), pw);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            return result;
        }
    }
}

