/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.tomcat;

import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.netbeans.modules.profiler.j2ee.tomcat.AbstractTomcatIntegrationProvider;
import org.netbeans.modules.profiler.j2ee.tomcat.TomcatIntegrationPanelUI;
import org.openide.util.HelpCtx;

public class TomcatIntegrationPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "TomcatIntegrationPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("TomcatIntegrationPanel.HelpCtx");
    private Model model = new Model();
    private TomcatIntegrationPanelUI panel = null;

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return this.model.isTomcatValid() && this.model.isCatalinaValid() && this.model.getSelectedPlatform() != null;
    }

    public boolean canBack(AttachWizardContext context) {
        return true;
    }

    public boolean canFinish(AttachWizardContext context) {
        return false;
    }

    public boolean canNext(AttachWizardContext context) {
        return this.isValid();
    }

    public boolean onCancel(AttachWizardContext context) {
        return true;
    }

    public void onEnter(AttachWizardContext context) {
        this.model.setCatalinaBase(((AbstractTomcatIntegrationProvider)context.getIntegrationProvider()).getCatalinaBase());
        this.model.setTomcatInstall(((AbstractTomcatIntegrationProvider)context.getIntegrationProvider()).getInstallationPath());
        String selectedJavaHome = ((AbstractTomcatIntegrationProvider)context.getIntegrationProvider()).getTargetJava();
        List platformList = TargetPlatform.getPlatformList((boolean)false);
        for (TargetPlatform platform : platformList) {
            if (!platform.getHomePath().equals(selectedJavaHome)) continue;
            this.model.setSelectedPlatform(platform);
        }
        this.panel.loadModel();
    }

    public void onExit(AttachWizardContext context) {
        AbstractTomcatIntegrationProvider provider = (AbstractTomcatIntegrationProvider)context.getIntegrationProvider();
        boolean isModified = false;
        if (provider.getTargetJavaHome() != null && this.model.getSelectedPlatform() != null && !provider.getTargetJavaHome().equals(this.model.getSelectedPlatform().getHomePath())) {
            isModified = true;
        } else if (!provider.getCatalinaBase().equals(this.model.getCatalinaBase())) {
            isModified = true;
        } else if (!provider.getInstallationPath().equals(this.model.getTomcatInstall())) {
            isModified = true;
        }
        if (isModified) {
            context.setConfigChanged();
        }
        provider.setTargetPlatform(this.model.getSelectedPlatform());
        provider.setCatalinaBase(this.model.getCatalinaBase());
        provider.setInstallationPath(this.model.getTomcatInstall());
    }

    public void onFinish(AttachWizardContext context) {
    }

    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new TomcatIntegrationPanelUI(this.model);
        }
        return this.panel;
    }

    protected void onPanelShow() {
        this.panel.refreshJvmList(this.model.getSelectedPlatform());
    }

    class Model {
        private TargetPlatform.TargetPlatformFilter platformFilter = new TargetPlatform.TargetPlatformFilter(){

            public boolean isSupported(TargetPlatform javaPlatform) {
                AttachSettings settings = TomcatIntegrationPanel.this.getContext().getAttachSettings();
                TargetPlatformEnum jvm = javaPlatform.getAsEnum();
                if (!settings.isDirect()) {
                    if (settings.isDynamic16()) {
                        if (!(jvm.equals((Object)TargetPlatformEnum.JDK6) || jvm.equals((Object)TargetPlatformEnum.JDK7) || jvm.equals((Object)TargetPlatformEnum.JDK8))) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                return TomcatIntegrationPanel.this.getContext().getIntegrationProvider().supportsJVM(javaPlatform.getAsEnum(), settings);
            }
        };
        private String catalinaBase = "";
        private String catalinaHint = "";
        private String tomcatHint = "";
        private String tomcatInstall = "";
        private TargetPlatform selectedPlatform = null;
        private boolean catalinaValid = true;
        private boolean tomcatValid = false;

        Model() {
        }

        public void setCatalinaBase(String path) {
            if (TomcatIntegrationPanel.this.getContext() == null) {
                return;
            }
            ValidationResult result = ((AbstractTomcatIntegrationProvider)TomcatIntegrationPanel.this.getContext().getIntegrationProvider()).validateCatalinaBase(path);
            if (result.isValid()) {
                this.catalinaValid = true;
                this.catalinaHint = "";
            } else {
                this.catalinaValid = false;
                this.catalinaHint = result.getMessage();
            }
            this.catalinaBase = path;
            TomcatIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public String getCatalinaBase() {
            return this.catalinaBase;
        }

        public String getCatalinaBaseHint() {
            return this.catalinaHint;
        }

        public boolean isCatalinaValid() {
            return this.catalinaValid;
        }

        public TargetPlatform.TargetPlatformFilter getPlatformFilter() {
            return this.platformFilter;
        }

        public TargetPlatformEnum getSelectedJVM() {
            return this.selectedPlatform.getAsEnum();
        }

        public void setSelectedPlatform(TargetPlatform platform) {
            this.selectedPlatform = platform;
            TomcatIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public TargetPlatform getSelectedPlatform() {
            return this.selectedPlatform;
        }

        public void setTomcatInstall(String path) {
            if (TomcatIntegrationPanel.this.getContext() == null) {
                return;
            }
            String targetOS = TomcatIntegrationPanel.this.getContext().getAttachSettings().getHostOS();
            ValidationResult result = ((AbstractTomcatIntegrationProvider)TomcatIntegrationPanel.this.getContext().getIntegrationProvider()).validateInstallation(targetOS, path);
            if (result.isValid()) {
                this.tomcatValid = true;
                this.tomcatHint = "";
            } else {
                this.tomcatValid = false;
                this.tomcatHint = result.getMessage();
            }
            this.tomcatInstall = path;
            TomcatIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public String getTomcatInstall() {
            return this.tomcatInstall;
        }

        public String getTomcatInstallHint() {
            return this.tomcatHint;
        }

        public boolean isTomcatValid() {
            return this.tomcatValid;
        }
    }
}

