/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.tomcat;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.IDESettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.SettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.providers.scripted.AbstractScriptIntegrationProvider;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.TextScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.SimpleWizardStep;
import org.netbeans.modules.profiler.j2ee.tomcat.Bundle;
import org.netbeans.modules.profiler.j2ee.tomcat.TomcatIntegrationPanel;

public abstract class AbstractTomcatIntegrationProvider
extends AbstractScriptIntegrationProvider {
    private static final String INSERTION_POINT_NOWIN_0_STRING = "#!/bin/sh";
    private static final String INSERTION_POINT_WIN_1_STRING = "rem Guess CATALINA_HOME";
    private static final String INSERTION_POINT_NOWIN_1_STRING = "# OS specific support.";
    private static final String INSERTION_POINT_2_STRING = "Get remaining unshifted";
    private static final String CATALINA_MOD_EXT_STRING = "_nbprofiler";
    private static final String CATALINA_HOME_VAR_STRING = "CATALINA_HOME";
    private static final String CATALINA_BASE_VAR_STRING = "CATALINA_BASE";
    private SettingsPersistor persistor;
    private String catalinaBase = "";

    public AbstractTomcatIntegrationProvider() {
        this.attachedWizard = new SimpleWizardStep(Bundle.AttachWizard_LocateRequiredFilesString(), (WizardScreen)new TomcatIntegrationPanel());
        this.persistor = new IDESettingsPersistor(){

            protected String getSettingsFileName() {
                return "TomcatIntegrationProvider.properties";
            }

            protected void parsePersistableSettings(Properties settings) {
                String javaPlatform = settings.getProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", "");
                if (javaPlatform != null && javaPlatform.length() > 0) {
                    AbstractTomcatIntegrationProvider.this.setTargetJava(javaPlatform);
                } else {
                    AbstractTomcatIntegrationProvider.this.setTargetJava(TargetPlatformEnum.JDK5.toString());
                }
                AbstractTomcatIntegrationProvider.this.setInstallationPath(settings.getProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_InstallDir", ""));
                AbstractTomcatIntegrationProvider.this.setCatalinaBase(settings.getProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_BaseDir", ""));
                if (AbstractTomcatIntegrationProvider.this.getInstallationPath() == null || AbstractTomcatIntegrationProvider.this.getInstallationPath().length() == 0) {
                    AbstractTomcatIntegrationProvider.this.setInstallationPath(AbstractTomcatIntegrationProvider.this.getDefaultInstallationPath());
                }
                if (AbstractTomcatIntegrationProvider.this.getCatalinaBase() == null || AbstractTomcatIntegrationProvider.this.getCatalinaBase().length() == 0) {
                    AbstractTomcatIntegrationProvider.this.setCatalinaBase(AbstractTomcatIntegrationProvider.this.getDefaultCatalinaBase());
                }
            }

            protected Properties preparePersistableSettings() {
                Properties settings = new Properties();
                settings.setProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", AbstractTomcatIntegrationProvider.this.getTargetJava());
                settings.setProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_InstallDir", AbstractTomcatIntegrationProvider.this.getInstallationPath());
                settings.setProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_BaseDir", AbstractTomcatIntegrationProvider.this.getCatalinaBase());
                return settings;
            }
        };
    }

    public IntegrationProvider.IntegrationHints getAfterInstallationHints(AttachSettings attachSettings, boolean automation) {
        IntegrationProvider.IntegrationHints hints = new IntegrationProvider.IntegrationHints();
        String targetOS = attachSettings.getHostOS();
        if (attachSettings.isDirect()) {
            hints.addStep(Bundle.TomcatIntegrationProvider_AdditionalStepsStep1DirectMsg(this.getModifiedScriptPath(targetOS, true)));
        } else {
            hints.addStep(Bundle.TomcatIntegrationProvider_AdditionalStepsStep1DynamicMsg(this.getModifiedScriptPath(targetOS, true)));
        }
        hints.addStep(Bundle.TomcatIntegrationProvider_AdditionalStepsStep2Msg());
        if (attachSettings.isDirect()) {
            hints.addStep(Bundle.TomcatIntegrationProvider_AdditionalStepsStep3DirectMsg());
        } else {
            hints.addStep(Bundle.TomcatIntegrationProvider_AdditionalStepsStep3DynamicPidMsg());
            hints.addWarning(Bundle.TomcatIntegrationProvider_DynamicWarningMessage(IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())));
        }
        hints.addHint(Bundle.TomcatIntegrationProvider_AdditionalStepsAutoStartMsg());
        return hints;
    }

    public void setCatalinaBase(String path) {
        this.catalinaBase = path;
    }

    public String getCatalinaBase() {
        return this.catalinaBase;
    }

    public IntegrationProvider.IntegrationHints getIntegrationReview(AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints hints = new IntegrationProvider.IntegrationHints();
        String targetOS = attachSettings.getHostOS();
        hints.addStep(Bundle.TomcatIntegrationProvider_IntegrReviewStep1Msg(this.getScriptPath(targetOS, true), this.getModifiedScriptPath(targetOS, true)));
        hints.addStep(Bundle.TomcatIntegrationProvider_IntegrReviewStep2Msg(IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + "<br>" + IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_HOME_VAR_STRING, (String)this.getInstallationPath()) + "<br>" + (this.catalinaBase != null && this.catalinaBase.length() > 0 ? IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_BASE_VAR_STRING, (String)this.catalinaBase) + "<br>" : "") + (attachSettings.isDirect() ? IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"CATALINA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)false, (int)attachSettings.getPort())) + "<br>" : "")));
        this.addLinkWarning(hints, "CATALINA_OPTS", attachSettings);
        return hints;
    }

    public IntegrationProvider.IntegrationHints getModificationHints(AttachSettings attachSettings) {
        String targetOS = attachSettings.getHostOS();
        IntegrationProvider.IntegrationHints h = attachSettings.isRemote() ? this.getManualRemoteIntegrationStepsInstructions(targetOS, attachSettings) : (attachSettings.isDirect() ? this.getManualLocalDirectIntegrationStepsInstructions(targetOS, attachSettings) : this.getManualLocalDynamicIntegrationStepsInstructions(targetOS, attachSettings));
        this.addLinkWarning(h, "CATALINA_OPTS", attachSettings);
        return h;
    }

    public SettingsPersistor getSettingsPersistor() {
        return this.persistor;
    }

    public ValidationResult validateCatalinaBase(String path) {
        if (path == null || path.length() == 0) {
            return new ValidationResult(true);
        }
        if (!new File(path).exists()) {
            return new ValidationResult(false, Bundle.TomcatIntegrationProvider_PathNotExistsMsg());
        }
        if (!this.validateCatalinaBasePath(path)) {
            return new ValidationResult(false, Bundle.TomcatIntegrationProvider_InvalidCatalinaBaseMsg());
        }
        return new ValidationResult(true);
    }

    public ValidationResult validateInstallation(String targetOS, String path) {
        String separator = System.getProperty("file.separator");
        String ext = IntegrationUtils.getBatchExtensionString((String)targetOS);
        if (!new File(path).exists()) {
            return new ValidationResult(false, Bundle.TomcatIntegrationProvider_PathNotExistsMsg());
        }
        if (!new File(path + separator + "bin" + separator + this.getCatalinaScriptName() + ext).exists()) {
            return new ValidationResult(false, Bundle.TomcatIntegrationProvider_InvalidCatalinaHomeMsg());
        }
        return new ValidationResult(true);
    }

    protected boolean isBackupRequired() {
        return false;
    }

    protected abstract String getCatalinaScriptName();

    protected ScriptHeaderModifier getHeaderModifier(String targetOS) {
        return new TextScriptHeaderModifier(IntegrationUtils.getSilentScriptCommentSign((String)targetOS));
    }

    protected abstract int getMagicNumber();

    protected IntegrationProvider.IntegrationHints getManualLocalDirectIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints hints = new IntegrationProvider.IntegrationHints();
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualDirectDynamicStep1Msg(IntegrationUtils.getEnvVariableReference((String)CATALINA_HOME_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), "catalina", IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualDirectStep2Msg(this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)Bundle.TomcatIntegrationProvider_PathToJvmDirText(IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))) + "<br>" + IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"CATALINA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort()))));
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualDirectDynamicStep3Msg(this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualDirectStep4Msg());
        hints.addHint(this.REDUCE_OVERHEAD_MSG);
        return hints;
    }

    protected IntegrationProvider.IntegrationHints getManualLocalDynamicIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints hints = new IntegrationProvider.IntegrationHints();
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualDirectDynamicStep1Msg(IntegrationUtils.getEnvVariableReference((String)CATALINA_HOME_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualDynamicStep2Msg(this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)Bundle.TomcatIntegrationProvider_PathToJvmDirText(IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())))));
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualDirectDynamicStep3Msg(this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualDynamicStep4Msg());
        hints.addHint(this.REDUCE_OVERHEAD_MSG);
        hints.addWarning(Bundle.TomcatIntegrationProvider_DynamicWarningMessage(IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())));
        return hints;
    }

    protected IntegrationProvider.IntegrationHints getManualRemoteIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints hints = new IntegrationProvider.IntegrationHints();
        hints.addStep(this.getManualRemoteStep1(targetOS));
        hints.addStep(this.getManualRemoteStep2(targetOS));
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualRemoteStep3Msg(IntegrationUtils.getEnvVariableReference((String)"REMOTE_CATALINA_HOME", (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualRemoteStep4Msg(this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)Bundle.TomcatIntegrationProvider_PathToJvmDirText(IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))) + "<br>" + IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"CATALINA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort(), (boolean)false)), this.REMOTE_ABSOLUTE_PATH_HINT));
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualRemoteStep5Msg(this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(Bundle.TomcatIntegrationProvider_ManualRemoteStep6Msg());
        hints.addHint(this.REDUCE_OVERHEAD_MSG);
        return hints;
    }

    protected String getModifiedScriptPath(String targetOS, boolean useQuotas) {
        return this.getCatalinaScriptPath(targetOS, CATALINA_MOD_EXT_STRING, useQuotas);
    }

    protected String getScriptPath(String targetOS, boolean useQuotas) {
        return this.getCatalinaScriptPath(targetOS, "", useQuotas);
    }

    protected String getWinConsoleString() {
        return Bundle.TomcatIntegrationProvider_ProfiledTomcatConsoleString();
    }

    protected void generateCommands(String targetOS, Collection commandsArray) {
        commandsArray.add(this.getModifiedScriptPath(targetOS, false));
        commandsArray.add("run");
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS) && !IntegrationUtils.PLATFORM_MAC_OS.equals(targetOS)) {
            commandsArray.add(">&1");
        }
    }

    protected void modifyScriptFileForDirectAttach(String targetOS, int commPort, boolean isReplaceFile, StringBuffer buffer) {
        String lineBreak = IntegrationUtils.getLineBreak((String)targetOS);
        int insertionPoint1 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? buffer.indexOf(INSERTION_POINT_WIN_1_STRING) : buffer.indexOf(INSERTION_POINT_NOWIN_1_STRING);
        int insertionPoint2 = buffer.indexOf(IntegrationUtils.getScriptCommentSign((String)targetOS) + " " + INSERTION_POINT_2_STRING);
        String exportJavaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + lineBreak;
        String exportCatalinaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_HOME_VAR_STRING, (String)this.getInstallationPath()) + lineBreak;
        String exportCatalinaBase = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_BASE_VAR_STRING, (String)this.catalinaBase) + lineBreak;
        String exportNativeLibraries = IntegrationUtils.getAddProfilerLibrariesToPathString((String)targetOS, (String)this.getTargetJava(), (boolean)false, (boolean)false) + lineBreak;
        String exportCatalinaOpts = this.getJavaOptions(targetOS, this.getTargetJava(), commPort, ' ');
        int currentOffset = 0;
        buffer.insert(insertionPoint1 + currentOffset, exportJavaHome);
        buffer.insert(insertionPoint1 + (currentOffset += exportJavaHome.length()), exportCatalinaHome);
        currentOffset += exportCatalinaHome.length();
        if (this.catalinaBase != null && !"".equals(this.catalinaBase.trim())) {
            buffer.insert(insertionPoint1 + currentOffset, exportCatalinaBase);
            currentOffset += exportCatalinaBase.length();
        }
        int catalinaOptsInsertionPoint = IntegrationUtils.isWindowsPlatform((String)targetOS) ? insertionPoint2 : insertionPoint1;
        buffer.insert(catalinaOptsInsertionPoint + currentOffset, exportCatalinaOpts);
    }

    protected void modifyScriptFileForDynamicAttach(String targetOS, int commPort, boolean isReplaceFile, StringBuffer buffer) {
        String lineBreak = IntegrationUtils.getLineBreak((String)targetOS);
        int insertionPoint0 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? 0 : buffer.indexOf(INSERTION_POINT_NOWIN_0_STRING) + INSERTION_POINT_NOWIN_0_STRING.length() + 1;
        int insertionPoint1 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? buffer.indexOf(INSERTION_POINT_WIN_1_STRING) : buffer.indexOf(INSERTION_POINT_NOWIN_1_STRING);
        String header = IntegrationUtils.getProfilerModifiedFileHeader((String)targetOS) + lineBreak;
        String exportJavaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + lineBreak;
        String exportCatalinaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_HOME_VAR_STRING, (String)this.getInstallationPath()) + lineBreak;
        String exportCatalinaBase = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_BASE_VAR_STRING, (String)this.catalinaBase) + lineBreak;
        int currentOffset = 0;
        buffer.insert(insertionPoint0 + currentOffset, header);
        buffer.insert(insertionPoint1 + (currentOffset += header.length()), exportJavaHome);
        buffer.insert(insertionPoint1 + (currentOffset += exportJavaHome.length()), exportCatalinaHome);
        currentOffset += exportCatalinaHome.length();
        if (this.catalinaBase != null && !"".equals(this.catalinaBase.trim())) {
            buffer.insert(insertionPoint1 + currentOffset, exportCatalinaBase);
        }
    }

    private String getCatalinaScriptPath(String targetOS, String scriptPostfix, boolean useQuotas) {
        String separator = System.getProperty("file.separator");
        String ext = IntegrationUtils.getBatchExtensionString((String)targetOS);
        String quotas = "";
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            quotas = "\"";
        }
        StringBuilder path = new StringBuilder();
        path.append(this.getInstallationPath());
        if (!this.getInstallationPath().endsWith(separator)) {
            path.append(separator);
        }
        path.append("bin").append(separator).append(this.getCatalinaScriptName()).append(scriptPostfix).append(ext);
        if (useQuotas && path.indexOf(" ") > -1) {
            path.insert(0, quotas);
            path.append(quotas);
        }
        return path.toString();
    }

    private String getDefaultCatalinaBase() {
        String catalinaBase = "";
        try {
            File catalinaBaseDir;
            String catalinaBaseEnv = System.getenv(CATALINA_BASE_VAR_STRING);
            if (catalinaBaseEnv != null && catalinaBaseEnv.length() > 1 && (catalinaBaseDir = new File(catalinaBaseEnv)).exists() && catalinaBaseDir.isDirectory()) {
                catalinaBase = catalinaBaseEnv;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return catalinaBase;
    }

    private String getDefaultInstallationPath() {
        String catalinaHome = "";
        try {
            File catalinaHomeDir;
            String catalinaHomeEnv = System.getenv(CATALINA_HOME_VAR_STRING);
            if (catalinaHomeEnv != null && catalinaHomeEnv.length() > 1 && (catalinaHomeDir = new File(catalinaHomeEnv)).exists() && catalinaHomeDir.isDirectory()) {
                catalinaHome = catalinaHomeEnv;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return catalinaHome;
    }

    private String getJavaOptions(String targetOS, String targetJVM, int commPort, char delimiter) {
        StringBuilder javaOpts = new StringBuilder();
        boolean nonEmptyOpts = false;
        if (System.getProperty("org.netbeans.lib.profiler.wireprotocol.WireIO.agent") != null) {
            nonEmptyOpts = true;
            javaOpts.append("-Dorg.netbeans.lib.profiler.wireprotocol.WireIO=true");
        }
        if (System.getProperty("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook") != null) {
            if (nonEmptyOpts) {
                javaOpts.append(delimiter);
            }
            nonEmptyOpts = true;
            javaOpts.append("-Dorg.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook=true");
        }
        String profilerOpts = IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)targetJVM, (boolean)false, (int)commPort);
        profilerOpts = profilerOpts.replace("\\s-", delimiter + "-");
        if (nonEmptyOpts) {
            javaOpts.append(delimiter);
        }
        javaOpts.append(profilerOpts);
        return IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"CATALINA_OPTS", (String)javaOpts.toString()) + IntegrationUtils.getLineBreak((String)targetOS);
    }

    private boolean validateCatalinaBasePath(String path) {
        String dirSeparator = System.getProperty("file.separator");
        return new File(path + dirSeparator + "conf" + dirSeparator + "server.xml").exists();
    }
}

