/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.icefaces;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.JsfComponentUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.icefaces.Icefaces2Customizer;
import org.netbeans.modules.web.jsf.icefaces.ui.Icefaces2CustomizerPanelVisual;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentImplementation;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class Icefaces2Implementation
implements JsfComponentImplementation {
    private static final Logger LOGGER = Logger.getLogger(Icefaces2Implementation.class.getName());
    public static final String PREFERENCES_NODE = "icefaces";
    public static final String ICEFACES_NAME = "ICEfaces";
    public static final String ICEFACES_CORE_CLASS = "org.icefaces.impl.facelets.tag.icefaces.core.ConfigHandler";
    public static final String PREF_LIBRARY_NAME = "preffered-library";
    private Icefaces2Customizer customizer;
    private static final String FACES_SAVING_METHOD = "javax.faces.STATE_SAVING_METHOD";
    private static final String FACES_SKIP_COMMENTS = "javax.faces.FACELETS_SKIP_COMMENTS";
    private static final String icefacesPom = "http://anonsvn.icesoft.org//repo/maven2/releases/org/icefaces/icefaces/3.0.0/icefaces-3.0.0.pom";

    public String getName() {
        return ICEFACES_NAME;
    }

    public String getDescription() {
        return NbBundle.getMessage(Icefaces2Implementation.class, (String)"DESC_IcefacesImplementation");
    }

    public Set<FileObject> extend(WebModule webModule, JsfComponentCustomizer jsfComponentCustomizer) {
        InitParam initParam;
        Library library;
        WebApp webApp;
        block15: {
            try {
                String string;
                webApp = new ArrayList(1);
                library = null;
                if (jsfComponentCustomizer != null) {
                    initParam = (Icefaces2CustomizerPanelVisual)jsfComponentCustomizer.getComponent();
                    string = initParam.getIcefacesLibrary();
                    library = LibraryManager.getDefault().getLibrary(string);
                }
                if (library == null) {
                    initParam = Icefaces2Implementation.getIcefacesPreferences();
                    library = LibraryManager.getDefault().getLibrary(initParam.get(PREF_LIBRARY_NAME, ""));
                }
                if (library == null) {
                    library = Icefaces2Customizer.getIcefacesLibraries().get(0);
                }
                if (library != null) {
                    initParam = webModule.getJavaSources();
                    string = FileOwnerQuery.getOwner((FileObject)webModule.getDocumentBase());
                    AntArtifactProvider antArtifactProvider = (AntArtifactProvider)string.getLookup().lookup(AntArtifactProvider.class);
                    if (antArtifactProvider == null) {
                        try {
                            List<URI> list = Arrays.asList(new URI(icefacesPom));
                            library = JsfComponentUtils.enhanceLibraryWithPomContent((Library)library, list);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            LOGGER.log(Level.SEVERE, null, uRISyntaxException);
                        }
                    }
                    webApp.add(library);
                    ProjectClassPathModifier.addLibraries((Library[])webApp.toArray(new Library[1]), (FileObject)initParam[0], (String)"classpath/compile");
                    break block15;
                }
                LOGGER.log(Level.SEVERE, "No ICEfaces library was found.");
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Exception during extending an web project", iOException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOGGER.log(Level.WARNING, "Exception during extending an web project", unsupportedOperationException);
            }
        }
        try {
            webApp = DDProvider.getDefault().getDDRoot(webModule.getDeploymentDescriptor());
            library = (InitParam)webApp.createBean("InitParam");
            library.setParamName(FACES_SAVING_METHOD);
            library.setParamValue("server");
            webApp.addContextParam((InitParam)library);
            initParam = (InitParam)webApp.createBean("InitParam");
            initParam.setParamName(FACES_SKIP_COMMENTS);
            initParam.setParamValue("true");
            webApp.addContextParam(initParam);
            webApp.write(webModule.getDeploymentDescriptor());
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.log(Level.WARNING, "Exception during updating web.xml DD", classNotFoundException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception during updating web.xml DD", iOException);
        }
        try {
            webApp = Icefaces2Implementation.generateWelcomePage(webModule);
            Collections.singleton(webApp);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception during welcome page creation", iOException);
        }
        return Collections.emptySet();
    }

    private static FileObject generateWelcomePage(WebModule webModule) throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)"Templates/Other/welcomeIcefaces.xhtml");
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        DataObject dataObject2 = dataObject.createFromTemplate(DataFolder.findFolder((FileObject)webModule.getDocumentBase()), "welcomeIcefaces");
        JsfComponentUtils.reformat((DataObject)dataObject2);
        Icefaces2Implementation.updateIndexPage(webModule);
        return dataObject2.getPrimaryFile();
    }

    private static void updateIndexPage(WebModule webModule) throws DataObjectNotFoundException {
        FileObject fileObject = webModule.getDocumentBase().getFileObject("index.xhtml");
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        JsfComponentUtils.enhanceFileBody((DataObject)dataObject, (String)"</h:body>", (String)"<br />\n<h:link outcome=\"welcomeIcefaces\" value=\"ICEfaces welcome page\" />");
        if (fileObject.isValid() && fileObject.canWrite()) {
            JsfComponentUtils.reformat((DataObject)dataObject);
        }
    }

    public Set<JSFVersion> getJsfVersion() {
        return EnumSet.of(JSFVersion.JSF_2_0, JSFVersion.JSF_2_1);
    }

    public boolean isInWebModule(WebModule webModule) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        return classPath.findResource(ICEFACES_CORE_CLASS.replace('.', '/') + ".class") != null;
    }

    public JsfComponentCustomizer createJsfComponentCustomizer(WebModule webModule) {
        if (this.customizer == null) {
            this.customizer = new Icefaces2Customizer();
        }
        return this.customizer;
    }

    public void remove(WebModule webModule) {
        try {
            List<Library> list = Icefaces2Customizer.getIcefacesLibraries();
            ProjectClassPathModifier.removeLibraries((Library[])list.toArray(new Library[list.size()]), (FileObject)webModule.getJavaSources()[0], (String)"classpath/compile");
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", iOException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", unsupportedOperationException);
        }
    }

    public static Preferences getIcefacesPreferences() {
        return NbPreferences.forModule(Icefaces2Customizer.class).node(PREFERENCES_NODE);
    }
}

