/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.connectors.admin.cli.ConnectionPoolUtil;
import org.glassfish.resource.common.PoolInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="ping-connection-pool")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@I18n(value="ping.connection.pool")
public class PingConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PingConnectionPool.class);
    @Param(name="pool_name", primary=true)
    private String poolName;
    @Inject
    private ConnectorRuntime connRuntime;
    @Inject
    private Domain domain;
    @Param(name="appname", optional=true)
    private String applicationName;
    @Param(name="modulename", optional=true)
    private String moduleName;
    @Inject
    private ConnectionPoolUtil poolUtil;
    @Inject
    private Applications applications;
    @Param(optional=true, alias="targetName", obsolete=true)
    private String target = "server";

    public void execute(AdminCommandContext context) {
        Application application;
        ActionReport report = context.getActionReport();
        boolean status = false;
        Resources resources = this.domain.getResources();
        String scope = "";
        if (this.moduleName != null) {
            if (!this.poolUtil.isValidModule(this.applicationName, this.moduleName, this.poolName, report)) {
                return;
            }
            application = this.applications.getApplication(this.applicationName);
            Module module = application.getModule(this.moduleName);
            resources = module.getResources();
            scope = "java:module/";
        } else if (this.applicationName != null) {
            if (!this.poolUtil.isValidApplication(this.applicationName, this.poolName, report)) {
                return;
            }
            application = this.applications.getApplication(this.applicationName);
            resources = application.getResources();
            scope = "java:app/";
        }
        if (!this.poolUtil.isValidPool(resources, this.poolName, scope, report)) {
            return;
        }
        PoolInfo poolInfo = new PoolInfo(this.poolName, this.applicationName, this.moduleName);
        try {
            status = this.connRuntime.pingConnectionPool(poolInfo);
            if (status) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(localStrings.getLocalString("ping.connection.pool.fail", "Ping Connection Pool for {0} Failed", new Object[]{poolInfo}));
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("ping.connection.pool.fail", "Ping Connection Pool for {0} Failed", new Object[]{poolInfo}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

