/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

abstract class RegexBuiltins {
    static HashMap patternLookup = new HashMap();
    static LinkedList patterns = new LinkedList();
    static final int PATTERN_CACHE_SIZE = 100;

    RegexBuiltins() {
    }

    static Pattern getPattern(String patternString, String flagString) throws TemplateModelException {
        int flags = 0;
        String patternKey = patternString + '\u0000' + flagString;
        Pattern result = (Pattern)patternLookup.get(patternKey);
        if (result != null) {
            return result;
        }
        if (flagString == null || flagString.length() == 0) {
            try {
                result = Pattern.compile(patternString);
            }
            catch (PatternSyntaxException e) {
                throw new TemplateModelException(e);
            }
        }
        if (flagString.indexOf(105) >= 0) {
            flags |= 2;
        }
        if (flagString.indexOf(109) >= 0) {
            flags |= 8;
        }
        if (flagString.indexOf(99) >= 0) {
            flags |= 4;
        }
        if (flagString.indexOf(115) >= 0) {
            flags |= 0x20;
        }
        try {
            result = Pattern.compile(patternString, flags);
        }
        catch (PatternSyntaxException e) {
            throw new TemplateModelException(e);
        }
        patterns.add(patternKey);
        patternLookup.put(patternKey, result);
        if (patterns.size() > 100) {
            Object first = patterns.removeFirst();
            patterns.remove(first);
        }
        return result;
    }

    static class MatcherBuilder
    implements TemplateMethodModel {
        String matchString;

        MatcherBuilder(TemplateScalarModel match) throws TemplateModelException {
            this.matchString = match.getAsString();
        }

        public Object exec(List args) throws TemplateModelException {
            int numArgs = args.size();
            if (numArgs == 0) {
                throw new TemplateModelException("Expecting at least one argument");
            }
            if (numArgs > 2) {
                throw new TemplateModelException("Expecting at most two argumnets");
            }
            String patternString = (String)args.get(0);
            String flagString = numArgs > 1 ? (String)args.get(1) : "";
            Pattern pattern = RegexBuiltins.getPattern(patternString, flagString);
            Matcher matcher = pattern.matcher(this.matchString);
            return new RegexMatchModel(matcher, this.matchString);
        }
    }

    static class RegexMatchModel
    implements TemplateBooleanModel,
    TemplateCollectionModel,
    TemplateSequenceModel {
        Matcher matcher;
        String input;
        String matchedString;
        final boolean matches;
        TemplateSequenceModel groups;
        private ArrayList data;

        RegexMatchModel(Matcher matcher, String input) {
            this.matcher = matcher;
            this.input = input;
            this.matches = matcher.matches();
            if (this.matches) {
                this.matchedString = input.substring(matcher.start(), matcher.end());
            }
        }

        public boolean getAsBoolean() {
            return this.matches;
        }

        public TemplateModel get(int i) throws TemplateModelException {
            if (this.data == null) {
                this.initSequence();
            }
            return (TemplateModel)this.data.get(i);
        }

        public int size() throws TemplateModelException {
            if (this.data == null) {
                this.initSequence();
            }
            return this.data.size();
        }

        private void initSequence() throws TemplateModelException {
            this.data = new ArrayList();
            TemplateModelIterator it = this.iterator();
            while (it.hasNext()) {
                this.data.add(it.next());
            }
        }

        public TemplateModel getGroups() {
            if (this.groups == null) {
                this.groups = new TemplateSequenceModel(){

                    public int size() throws TemplateModelException {
                        try {
                            return RegexMatchModel.this.matcher.groupCount() + 1;
                        }
                        catch (Exception e) {
                            throw new TemplateModelException(e);
                        }
                    }

                    public TemplateModel get(int i) throws TemplateModelException {
                        try {
                            return new SimpleScalar(RegexMatchModel.this.matcher.group(i));
                        }
                        catch (Exception e) {
                            throw new TemplateModelException(e);
                        }
                    }
                };
            }
            return this.groups;
        }

        public TemplateModelIterator iterator() {
            this.matcher.reset();
            return new TemplateModelIterator(){
                boolean hasFindInfo;
                {
                    this.hasFindInfo = RegexMatchModel.this.matcher.find();
                }

                public boolean hasNext() {
                    return this.hasFindInfo;
                }

                public TemplateModel next() throws TemplateModelException {
                    if (!this.hasNext()) {
                        throw new TemplateModelException("No more matches");
                    }
                    Match result = new Match();
                    this.hasFindInfo = RegexMatchModel.this.matcher.find();
                    return result;
                }
            };
        }

        class Match
        implements TemplateScalarModel {
            String match;
            SimpleSequence subs = new SimpleSequence();

            Match() {
                this.match = RegexMatchModel.this.input.substring(RegexMatchModel.this.matcher.start(), RegexMatchModel.this.matcher.end());
                for (int i = 0; i < RegexMatchModel.this.matcher.groupCount() + 1; ++i) {
                    this.subs.add(RegexMatchModel.this.matcher.group(i));
                }
            }

            public String getAsString() {
                return this.match;
            }
        }
    }

    static class ReplaceMethod
    implements TemplateMethodModel {
        private String s;

        ReplaceMethod(String s) {
            this.s = s;
        }

        public Object exec(List args) throws TemplateModelException {
            int numArgs = args.size();
            if (numArgs < 2 || numArgs > 3) {
                throw new TemplateModelException("?replace(...) needs 2 or 3 arguments.");
            }
            String first = (String)args.get(0);
            String second = (String)args.get(1);
            String flags = numArgs > 2 ? (String)args.get(2) : "";
            boolean caseInsensitive = flags.indexOf(105) >= 0;
            boolean useRegexp = flags.indexOf(114) >= 0;
            boolean firstOnly = flags.indexOf(102) >= 0;
            String result = null;
            if (!useRegexp) {
                result = StringUtil.replace(this.s, first, second, caseInsensitive, firstOnly);
            } else {
                Pattern pattern = RegexBuiltins.getPattern(first, flags);
                Matcher matcher = pattern.matcher(this.s);
                result = firstOnly ? matcher.replaceFirst(second) : matcher.replaceAll(second);
            }
            return new SimpleScalar(result);
        }
    }

    static class SplitMethod
    implements TemplateMethodModel {
        private String s;

        SplitMethod(String s) {
            this.s = s;
        }

        public Object exec(List args) throws TemplateModelException {
            int numArgs = args.size();
            if (numArgs < 1 || numArgs > 2) {
                throw new TemplateModelException("?replace(...) needs 1 or 2 arguments.");
            }
            String splitString = (String)args.get(0);
            String flags = numArgs > 1 ? (String)args.get(1) : "";
            boolean caseInsensitive = flags.indexOf(105) >= 0;
            boolean useRegexp = flags.indexOf(114) >= 0;
            String[] result = null;
            if (!useRegexp) {
                result = StringUtil.split(this.s, splitString, caseInsensitive);
            } else {
                Pattern pattern = RegexBuiltins.getPattern(splitString, flags);
                result = pattern.split(this.s);
            }
            return ObjectWrapper.DEFAULT_WRAPPER.wrap(result);
        }
    }

    static class groupsBI
    extends BuiltIn {
        groupsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel targetModel = this.target.getAsTemplateModel(env);
            groupsBI.assertNonNull(targetModel, this, env);
            if (targetModel instanceof RegexMatchModel) {
                return ((RegexMatchModel)targetModel).getGroups();
            }
            if (targetModel instanceof RegexMatchModel.Match) {
                return ((RegexMatchModel.Match)targetModel).subs;
            }
            throw groupsBI.invalidTypeException(targetModel, this.target, env, "a regular expression matcher");
        }
    }

    static class matchesBI
    extends BuiltIn {
        matchesBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel targetModel = this.target.getAsTemplateModel(env);
            matchesBI.assertNonNull(targetModel, this, env);
            if (!(targetModel instanceof TemplateScalarModel)) {
                throw matchesBI.invalidTypeException(targetModel, this.target, env, "string");
            }
            return new MatcherBuilder((TemplateScalarModel)targetModel);
        }
    }

    static class replace_reBI
    extends BuiltIn {
        replace_reBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new ReplaceMethod(((TemplateScalarModel)model).getAsString());
            }
            throw replace_reBI.invalidTypeException(model, this.target, env, "string");
        }
    }

    static class split_reBI
    extends BuiltIn {
        split_reBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new SplitMethod(((TemplateScalarModel)model).getAsString());
            }
            throw split_reBI.invalidTypeException(model, this.target, env, "string");
        }
    }
}

