/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.wizards.CompositeComponentVisualPanel;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CompositeComponentWizardPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private CompositeComponentVisualPanel component;
    private String text;
    private TemplateWizard wizard;
    Project project;
    SourceGroup[] folders;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final String RESOURCES_FOLDER = "resources";
    private static final Pattern INVALID_FILENAME_CHARACTERS = Pattern.compile("[`~!@#$%^&*()=+\\|{};:'\",<>/?]");
    private static final Pattern INVALID_FOLDERNAME_CHARACTERS = Pattern.compile("[`~!@#$%^&*()=+|{};:'\",<>?]");
    private static final String FROM_EDITOR_PROP = "fromEditor";

    public CompositeComponentWizardPanel(TemplateWizard wizard, SourceGroup[] folders, String selectedText) {
        this.wizard = wizard;
        this.text = selectedText;
        this.folders = folders;
        this.project = Templates.getProject((WizardDescriptor)wizard);
    }

    public Component getComponent() {
        if (SwingUtilities.isEventDispatchThread()) {
            return this._getComponent();
        }
        final AtomicReference ref = new AtomicReference();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ref.set(CompositeComponentWizardPanel.this._getComponent());
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return (Component)ref.get();
    }

    public Component _getComponent() {
        if (this.component == null) {
            this.component = new CompositeComponentVisualPanel(this.project, this.folders, this.text);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        String folderName;
        String errorMessage = null;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (!(Utilities.isJavaEE6((TemplateWizard)this.wizard) || JSFUtils.isJavaEE5(this.wizard) && JSFUtils.isJSF20Plus(webModule))) {
            errorMessage = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"ERR_Not_JSF20");
        }
        if (this.component == null || this.component.getTargetName() == null || this.component.getTargetGroup() == null) {
            return false;
        }
        if (this.component.getTargetFolder() == null || !this.component.getTargetFolder().startsWith(RESOURCES_FOLDER)) {
            errorMessage = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"ERR_No_resources_folder");
        } else if (this.component.getTargetFolder().equals(RESOURCES_FOLDER) || this.component.getTargetFolder().equals(RESOURCES_FOLDER + File.separatorChar)) {
            errorMessage = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"ERR_No_component_folder");
        }
        String filename = this.component.getTargetName();
        if ("".equals(filename) || INVALID_FILENAME_CHARACTERS.matcher(filename).find()) {
            errorMessage = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"ERR_Wrong_Filename");
        }
        if (INVALID_FOLDERNAME_CHARACTERS.matcher(folderName = this.component.getTargetFolder()).find()) {
            errorMessage = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"ERR_Wrong_Foldername");
        }
        if (webModule != null && webModule.getDocumentBase() != null) {
            String expectedExtension = Templates.getTemplate((WizardDescriptor)this.wizard).getExt();
            expectedExtension = expectedExtension.length() == 0 ? "" : "." + expectedExtension;
            FileObject targetFile = webModule.getDocumentBase().getFileObject(folderName + "/" + filename + expectedExtension);
            if (targetFile != null) {
                errorMessage = filename + expectedExtension + " already exist";
            }
        }
        if (Boolean.TRUE.equals((Boolean)this.wizard.getProperty("incorrectActionContext"))) {
            this.wizard.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"MSG_Invalid_Selection"));
            return true;
        }
        if (Boolean.TRUE.equals((Boolean)this.wizard.getProperty(FROM_EDITOR_PROP))) {
            String prefix = this.component.getPrefix();
            if (prefix.length() == 0) {
                errorMessage = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"MSG_Library_Prefix_Empty");
            } else {
                Map declaredPrefixes = (Map)this.wizard.getProperty("declaredPrefixes");
                String ccLibNamespace = this.component.getCompositeComponentURI();
                if (declaredPrefixes != null && !prefix.equals(declaredPrefixes.get(ccLibNamespace)) && declaredPrefixes.values().contains(prefix)) {
                    this.wizard.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"MSG_Already_Used_Prefix", (Object)this.component.getPrefix()));
                    return true;
                }
            }
        }
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        return errorMessage == null;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void readSettings(Object settings) {
        if (settings instanceof TemplateWizard) {
            Object substitute;
            this.wizard = (TemplateWizard)settings;
            this.project = Templates.getProject((WizardDescriptor)this.wizard);
            if (this.component == null) {
                this.getComponent();
            }
            if (this.component != null) {
                FileObject preselectedTarget = Templates.getTargetFolder((WizardDescriptor)this.wizard);
                if (preselectedTarget == null) {
                    preselectedTarget = this.project.getProjectDirectory();
                }
                String targetName = Templates.getTargetName((WizardDescriptor)this.wizard);
                boolean fromEditor = Boolean.TRUE.equals((Boolean)this.wizard.getProperty(FROM_EDITOR_PROP));
                this.component.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), preselectedTarget, targetName, fromEditor);
            }
            if ((substitute = this.component.getClientProperty("NewFileWizard_Title")) != null) {
                this.wizard.putProperty("NewFileWizard_Title", substitute);
            }
        }
    }

    public void storeSettings(Object settings) {
        if (settings instanceof TemplateWizard) {
            TemplateWizard wiz = (TemplateWizard)settings;
            if (WizardDescriptor.PREVIOUS_OPTION.equals(wiz.getValue())) {
                return;
            }
            if (!wiz.getValue().equals(WizardDescriptor.CANCEL_OPTION) && this.isValid()) {
                FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
                String name = this.component.getTargetName();
                if (name.indexOf(47) > 0) {
                    name = name.substring(name.lastIndexOf(47) + 1);
                }
                Templates.setTargetFolder((WizardDescriptor)wiz, (FileObject)this.getTargetFolderFromGUI());
                Templates.setTargetName((WizardDescriptor)wiz, (String)name);
            }
            wiz.putProperty("NewFileWizard_Title", null);
            wiz.putProperty("selectedPrefix", (Object)this.component.getPrefix());
        }
    }

    private FileObject getTargetFolderFromGUI() {
        FileObject targetFolder;
        FileObject rootFolder = this.component.getTargetGroup().getRootFolder();
        String folderName = this.component.getTargetFolder();
        String newObject = this.component.getTargetName();
        if (newObject.indexOf(47) > 0) {
            String path = newObject.substring(0, newObject.lastIndexOf(47));
            folderName = folderName == null || "".equals(folderName) ? path : folderName + '/' + path;
        }
        if ((targetFolder = folderName == null ? rootFolder : rootFolder.getFileObject(folderName)) == null) {
            try {
                targetFolder = FileUtil.createFolder((FileObject)rootFolder, (String)folderName);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
        return targetFolder;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }
}

