/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.wizards.CompositeComponentWizardPanel;
import org.netbeans.modules.web.wizards.BrowseFolders;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CompositeComponentVisualPanel
extends JPanel
implements ActionListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(CompositeComponentVisualPanel.class.getName());
    private Project project;
    private SourceGroup[] folders;
    private WebModule wm;
    private static final String RESOURCES_FOLDER = "resources";
    private static final String COMPONENT_FOLDER = "ezcomp";
    private String expectedExtension;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final ListCellRenderer CELL_RENDERER = new GroupCellRenderer();
    private final Pattern FOLDER_NAME_PATTERN = Pattern.compile(".*/(.*)");
    private boolean indirectModification;
    private boolean prefixLocked;
    private static final String COMPOSITE_LIBRARY_NS = "http://java.sun.com/jsf/composite";
    private JButton browseButton;
    private JPanel customPanel;
    private JTextField documentNameTextField;
    private JTextField fileTextField;
    private JPanel fillerPanel;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JLabel implSectionLabel;
    private JScrollPane jScrollPane1;
    private JComboBox locationCB;
    private JLabel locationLabel;
    private JLabel nameLabel;
    private JLabel pathLabel;
    private JLabel prefixLabel;
    private JTextField prefixTextField;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JEditorPane selectedTextPane;
    private JSeparator targetSeparator;

    public CompositeComponentVisualPanel(Project project, SourceGroup[] folders, String selectedText) {
        this.project = project;
        this.folders = folders;
        this.initComponents();
        this.locationCB.setRenderer(this.CELL_RENDERER);
        if (selectedText != null) {
            try {
                EditorKit kit = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/xhtml")).lookup(EditorKit.class);
                Document doc = kit.createDefaultDocument();
                doc.insertString(0, selectedText, null);
                this.selectedTextPane.setEditorKit(kit);
                this.selectedTextPane.setDocument(doc);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            this.selectedTextPane.setEnabled(false);
            this.implSectionLabel.setEnabled(false);
        }
        this.initValues(null, null, null, false);
        this.browseButton.addActionListener(this);
        this.locationCB.addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.prefixTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CompositeComponentVisualPanel.this.prefixTextFieldModified();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CompositeComponentVisualPanel.this.prefixTextFieldModified();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CompositeComponentVisualPanel.this.prefixTextFieldModified();
            }
        });
    }

    WebModule getWebModule() {
        return this.wm;
    }

    void initValues(FileObject template, FileObject preselectedFolder, String documentName, boolean fromEditor) {
        assert (this.project != null);
        this.prefixLabel.setEnabled(fromEditor);
        this.prefixTextField.setEnabled(fromEditor);
        this.prefixLocked = !fromEditor;
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        this.locationCB.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup preselectedGroup = this.getPreselectedGroup(this.folders, preselectedFolder);
        if (preselectedGroup != null) {
            this.locationCB.setSelectedItem(preselectedGroup);
            if (preselectedFolder != null && preselectedFolder.getName().equals(RESOURCES_FOLDER)) {
                this.folderTextField.setText(this.getRelativeNativeName(preselectedGroup.getRootFolder(), preselectedFolder) + File.separatorChar + COMPONENT_FOLDER);
            } else {
                this.folderTextField.setText(RESOURCES_FOLDER + File.separatorChar + COMPONENT_FOLDER);
            }
        }
        String ext = template == null ? "" : template.getExt();
        this.expectedExtension = ext.length() == 0 ? "" : "." + ext;
        String displayName = null;
        try {
            if (template != null) {
                DataObject templateDo = DataObject.find((FileObject)template);
                displayName = templateDo.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"LBL_SimpleTargetChooserPanel_Name")});
        if (template != null) {
            String baseName = template.getName();
            if (documentName == null) {
                documentName = baseName;
            }
            if (preselectedFolder != null) {
                FileObject _tmp;
                int index = 0;
                while ((_tmp = preselectedFolder.getFileObject(documentName, template.getExt())) != null) {
                    documentName = baseName + ++index;
                }
            }
            this.documentNameTextField.setText(documentName);
            this.documentNameTextField.selectAll();
        }
    }

    private SourceGroup getPreselectedGroup(SourceGroup[] groups, FileObject folder) {
        for (int i = 0; folder != null && i < groups.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)groups[i].getRootFolder(), (FileObject)folder) && !groups[i].getRootFolder().equals(folder)) continue;
            return groups[i];
        }
        if (groups.length > 0) {
            return groups[0];
        }
        return null;
    }

    private String getRelativeNativeName(FileObject root, FileObject folder) {
        if (root == null) {
            throw new NullPointerException("null root passed to getRelativeNativeName");
        }
        String path = folder == null ? "" : FileUtil.getRelativePath((FileObject)root, (FileObject)folder);
        return path == null ? "" : path.replace('/', File.separatorChar);
    }

    public SourceGroup getTargetGroup() {
        return (SourceGroup)this.locationCB.getSelectedItem();
    }

    public String getCompositeComponentURI() {
        String resfslash;
        String folder = this.getTargetFolder();
        if (folder.startsWith(resfslash = "resources/")) {
            return "http://java.sun.com/jsf/composite/" + folder.substring(resfslash.length());
        }
        return null;
    }

    public String getTargetFolder() {
        String folderName = this.folderTextField.getText().trim();
        if (folderName.length() == 0) {
            return "";
        }
        return folderName.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String text = this.documentNameTextField.getText().trim();
        if (text.length() == 0) {
            return "";
        }
        return text;
    }

    public String getPrefix() {
        try {
            Document doc = this.prefixTextField.getDocument();
            return doc.getText(0, doc.getLength()).trim();
        }
        catch (BadLocationException ex) {
            return "";
        }
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationCB = new JComboBox();
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.pathLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.customPanel = new JPanel();
        this.implSectionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.selectedTextPane = new JEditorPane();
        this.fillerPanel = new JPanel();
        this.prefixLabel = new JLabel();
        this.prefixTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setDisplayedMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_FileName_mnem").charAt(0));
        this.nameLabel.setLabelFor(this.documentNameTextField);
        this.nameLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_JspName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_DESC_FileName"));
        this.projectLabel.setDisplayedMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_Project_mnem").charAt(0));
        this.projectLabel.setLabelFor(this.projectTextField);
        this.projectLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_DESC_Project"));
        this.locationLabel.setDisplayedMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_Location_mnem").charAt(0));
        this.locationLabel.setLabelFor(this.locationCB);
        this.locationLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.locationCB, gridBagConstraints);
        this.locationCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_DESC_Location"));
        this.folderLabel.setDisplayedMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_Folder_mnem").charAt(0));
        this.folderLabel.setLabelFor(this.folderTextField);
        this.folderLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.folderLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_DESC_Folder"));
        this.browseButton.setMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_Browse_Mnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_Browse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"ACSD_Browse"));
        this.pathLabel.setDisplayedMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_CreatedFile_mnem").charAt(0));
        this.pathLabel.setLabelFor(this.fileTextField);
        this.pathLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.pathLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_DESC_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.customPanel.setPreferredSize(new Dimension(400, 180));
        this.customPanel.setLayout(new GridBagLayout());
        this.implSectionLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_IMPLEMENTATION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.customPanel.add((Component)this.implSectionLabel, gridBagConstraints);
        this.selectedTextPane.setEditable(false);
        this.selectedTextPane.setEnabled(false);
        this.selectedTextPane.setPreferredSize(null);
        this.jScrollPane1.setViewportView(this.selectedTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.customPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.customPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.fillerPanel, gridBagConstraints);
        this.prefixLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("A11Y_Prefix_mnem").charAt(0));
        this.prefixLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_Prefix"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.prefixLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.prefixTextField, gridBagConstraints);
        this.prefixTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_Library_Prefix"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.browseButton == e.getSource()) {
            FileObject fo = null;
            SourceGroup group = (SourceGroup)this.locationCB.getSelectedItem();
            if (group == null) {
                return;
            }
            fo = BrowseFolders.showDialog((SourceGroup[])new SourceGroup[]{group}, DataFolder.class, (String)this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fo != null && fo.isFolder()) {
                String relPath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo);
                this.folderTextField.setText(relPath.replace('/', File.separatorChar));
            }
        } else if (this.locationCB == e.getSource()) {
            this.updateCreatedFolder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCreatedFolder() {
        SourceGroup sg = (SourceGroup)this.locationCB.getSelectedItem();
        if (sg == null) {
            return;
        }
        FileObject root = sg.getRootFolder();
        if (root == null) {
            return;
        }
        String folderName = this.folderTextField.getText().trim();
        String documentName = this.documentNameTextField.getText().trim();
        String createdFileName = FileUtil.getFileDisplayName((FileObject)root) + (folderName.startsWith("/") || folderName.startsWith(File.separator) ? "" : "/") + folderName + (folderName.endsWith("/") || folderName.endsWith(File.separator) || folderName.length() == 0 ? "" : "/") + documentName + this.expectedExtension;
        this.fileTextField.setText(createdFileName.replace('/', File.separatorChar));
        try {
            this.indirectModification = false;
            this.updatePrefix();
        }
        finally {
            this.indirectModification = true;
        }
        this.changeSupport.fireChange();
    }

    private void prefixTextFieldModified() {
        if (this.indirectModification) {
            this.prefixLocked = true;
        }
        this.changeSupport.fireChange();
    }

    private void updatePrefix() {
        Matcher matcher;
        if (!this.prefixLocked && (matcher = this.FOLDER_NAME_PATTERN.matcher(this.folderTextField.getText())).matches() && matcher.groupCount() == 1) {
            String lastFolderName;
            this.prefixTextField.setText(lastFolderName.substring(0, (lastFolderName = matcher.group(1)).length() < 2 ? lastFolderName.length() : 2));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateCreatedFolder();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateCreatedFolder();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateCreatedFolder();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public String getCreatedFilePath() {
        return this.fileTextField.getText();
    }

    private class GroupCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public GroupCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof SourceGroup) {
                String groupDisplayName;
                SourceGroup group = (SourceGroup)value;
                String projectDisplayName = ProjectUtils.getInformation((Project)CompositeComponentVisualPanel.this.project).getDisplayName();
                if (projectDisplayName.equals(groupDisplayName = group.getDisplayName())) {
                    this.setText(groupDisplayName);
                } else {
                    this.setText(MessageFormat.format("{1} - {0}", groupDisplayName, projectDisplayName, group.getRootFolder().getName()));
                }
                this.setIcon(group.getIcon(false));
            } else {
                this.setText(value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

