/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.web.jsf.refactoring.DiffElement;
import org.netbeans.modules.web.jsf.refactoring.JSFRefactoringUtils;
import org.netbeans.modules.web.jsf.refactoring.JSFSafeDeletePlugin;
import org.netbeans.modules.web.jsf.refactoring.Modifications;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JSFMoveClassPlugin
implements RefactoringPlugin {
    private Collection<TreePathHandle> treePathHandles;
    private static final Logger LOGGER = Logger.getLogger(JSFMoveClassPlugin.class.getName());
    private final MoveRefactoring refactoring;

    public JSFMoveClassPlugin(MoveRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Collection fileObjects = this.refactoring.getRefactoringSource().lookupAll(FileObject.class);
        Collection treePathHandlesFromLookup = this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class);
        this.treePathHandles = new ArrayList<TreePathHandle>(treePathHandlesFromLookup);
        if (fileObjects != null) {
            for (FileObject fileObject : fileObjects) {
                JavaSource source;
                if (fileObject.isFolder() && (JSFRefactoringUtils.isJavaFile(fileObject) || fileObject.isFolder())) {
                    ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                    FileObject root = classPath.findOwnerRoot(fileObject);
                    String prefix = FileUtil.getRelativePath((FileObject)root, (FileObject)fileObject.getParent()).replace('/', '.');
                    String oldName = prefix.length() == 0 ? fileObject.getName() : prefix + '.' + fileObject.getName();
                    String newPrefix = JSFRefactoringUtils.getPackageName((URL)this.refactoring.getTarget().lookup(URL.class));
                    String newName = newPrefix.length() == 0 ? fileObject.getName() : newPrefix + '.' + fileObject.getName();
                    JSFRefactoringUtils.renamePackage((AbstractRefactoring)this.refactoring, refactoringElements, fileObject, oldName, newName, true);
                    continue;
                }
                if (!JSFRefactoringUtils.isJavaFile(fileObject) || (source = JavaSource.forFileObject((FileObject)fileObject)) == null) continue;
                try {
                    source.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController co) throws Exception {
                            co.toPhase(JavaSource.Phase.RESOLVED);
                            CompilationUnitTree cut = co.getCompilationUnit();
                            List<? extends Tree> typeDecls = cut.getTypeDecls();
                            if (!typeDecls.isEmpty()) {
                                JSFMoveClassPlugin.this.treePathHandles.add(TreePathHandle.create((TreePath)TreePath.getPath(cut, typeDecls.get(0)), (CompilationInfo)co));
                                JSFMoveClassPlugin.this.refactoring.getContext().add((Object)co);
                            }
                        }
                    }, false);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.log(Level.WARNING, "Exception in JSFMoveClassPlugin", ex);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, "Exception in JSFMoveClassPlugin", ex);
                }
            }
        }
        if (this.treePathHandles != null) {
            for (TreePathHandle treePathHandle : this.treePathHandles) {
                List<Occurrences.OccurrenceItem> items;
                String newFQN;
                Element resElement;
                TypeElement type;
                CompilationInfo info;
                Project project;
                if (treePathHandle == null || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePathHandle.getKind()) || (project = FileOwnerQuery.getOwner((FileObject)treePathHandle.getFileObject())) == null || (info = JSFRefactoringUtils.getCompilationInfo((AbstractRefactoring)this.refactoring, treePathHandle.getFileObject())) == null || (type = (TypeElement)(resElement = treePathHandle.resolveElement(info))) == null) continue;
                String oldFQN = type.getQualifiedName().toString();
                String newPackageName = JSFRefactoringUtils.getPackageName((URL)this.refactoring.getTarget().lookup(URL.class));
                String string = newFQN = newPackageName.length() == 0 ? type.getSimpleName().toString() : newPackageName + '.' + type.getSimpleName().toString();
                if (this.isTargetOtherProject(treePathHandle.getFileObject(), this.refactoring)) {
                    items = Occurrences.getAllOccurrences(project, oldFQN, newFQN);
                    for (Occurrences.OccurrenceItem item : items) {
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new JSFSafeDeletePlugin.JSFSafeDeleteClassElement(item));
                    }
                    continue;
                }
                items = Occurrences.getAllOccurrences(project, oldFQN, newFQN);
                Modifications modification = new Modifications();
                for (Occurrences.OccurrenceItem item : items) {
                    Modifications.Difference difference = new Modifications.Difference(Modifications.Difference.Kind.CHANGE, item.getChangePosition().getBegin(), item.getChangePosition().getEnd(), item.getOldValue(), item.getNewValue(), item.getRenamePackageMessage());
                    modification.addDifference(item.getFacesConfig(), difference);
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new DiffElement.ChangeFQCNElement(difference, item, modification));
                }
            }
        }
        return null;
    }

    private boolean isTargetOtherProject(FileObject localFileObject, MoveRefactoring ref) {
        boolean targetOtherProject = false;
        try {
            Project targetProject = FileOwnerQuery.getOwner((URI)((URL)ref.getTarget().lookup(URL.class)).toURI());
            Project srcProject = FileOwnerQuery.getOwner((FileObject)localFileObject);
            targetOtherProject = !targetProject.equals(srcProject);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception in JSFMoveClassPlugin", e);
        }
        return targetOtherProject;
    }
}

