/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.wizard.EntityClosure;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.JpaControllerUtil;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.api.model.ModelUnit;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.api.model.WebBeansModelFactory;
import org.netbeans.modules.web.beans.api.model.support.WebBeansModelSupport;
import org.netbeans.modules.web.jsf.api.editor.JSFBeanCache;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.palette.items.CancellableDialog;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ManagedBeanCustomizer
extends JPanel
implements CancellableDialog {
    private static final RequestProcessor RP = new RequestProcessor();
    public static final String VIEW_TEMPLATE = "/Templates/JSF/JSF_From_Entity_Snippets/view.ftl";
    public static final String EDIT_TEMPLATE = "/Templates/JSF/JSF_From_Entity_Snippets/edit.ftl";
    public static final String TABLE_TEMPLATE = "/Templates/JSF/JSF_From_Entity_Snippets/table.ftl";
    private Project project;
    private boolean collection;
    private boolean dummyBean = false;
    private Dialog dialog;
    private DialogDescriptor dialogDescriptor;
    private boolean cancelled = false;
    private JLabel customizeTemplatesLabel;
    private JComboBox entityBeanCombo;
    private JLabel entityBeanLabel;
    private JLabel hint;
    private JComboBox managedBeanCombo;
    private JLabel managedBeanLabel;
    private JCheckBox readOnlyCheckBox;
    private JLabel scanningLabel;
    private MetadataModel<WebBeansModel> webBeansModel;

    public ManagedBeanCustomizer(Project project, boolean collection, boolean enableReadOnly) {
        this.initComponents();
        this.scanningLabel.setVisible(SourceUtils.isScanInProgress());
        EntityClassScope scope = EntityClassScope.getEntityClassScope((FileObject)project.getProjectDirectory());
        EntityClosure ec = EntityClosure.create((EntityClassScope)scope, (Project)project);
        this.entityBeanCombo.setModel(EntityClosure.getAsComboModel((EntityClosure)ec));
        this.entityBeanCombo.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                ManagedBeanCustomizer.this.setScanningLabelVisible(SourceUtils.isScanInProgress());
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ManagedBeanCustomizer.this.setScanningLabelVisible(SourceUtils.isScanInProgress());
            }
        });
        this.project = project;
        this.collection = collection;
        this.readOnlyCheckBox.setVisible(enableReadOnly);
        this.hint.setVisible(false);
        Component comp = this.managedBeanCombo.getEditor().getEditorComponent();
        if (comp instanceof JTextField) {
            final JTextField field = (JTextField)comp;
            field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent arg0) {
                    ManagedBeanCustomizer.this.updateValidity(field.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                    ManagedBeanCustomizer.this.updateValidity(field.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                    ManagedBeanCustomizer.this.updateValidity(field.getText());
                }
            });
        }
    }

    private void updateValidity(String text) {
        this.dialogDescriptor.setValid(text.length() > 0 && this.entityBeanCombo.getSelectedItem() != null);
    }

    public String getBeanClass() {
        return (String)this.entityBeanCombo.getSelectedItem();
    }

    public String getManagedBeanProperty() {
        return (String)this.managedBeanCombo.getSelectedItem();
    }

    public boolean isReadOnly() {
        return this.readOnlyCheckBox.isSelected();
    }

    private void initComponents() {
        this.entityBeanLabel = new JLabel();
        this.entityBeanCombo = new JComboBox();
        this.managedBeanLabel = new JLabel();
        this.managedBeanCombo = new JComboBox();
        this.readOnlyCheckBox = new JCheckBox();
        this.customizeTemplatesLabel = new JLabel();
        this.hint = new JLabel();
        this.scanningLabel = new JLabel();
        this.entityBeanLabel.setText(NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.entityBeanLabel.text"));
        this.entityBeanCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ManagedBeanCustomizer.this.entityBeanComboItemStateChanged(evt);
            }
        });
        this.managedBeanLabel.setText(NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.managedBeanLabel.text"));
        this.managedBeanCombo.setEditable(true);
        this.managedBeanCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ManagedBeanCustomizer.this.managedBeanComboItemStateChanged(evt);
            }
        });
        this.readOnlyCheckBox.setText(NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.readOnlyCheckBox.text"));
        this.customizeTemplatesLabel.setText(NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.customizeTemplatesLabel.text"));
        this.customizeTemplatesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ManagedBeanCustomizer.this.customizeTemplatesLabelMouseClicked(evt);
            }
        });
        this.hint.setText(NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.hint.text"));
        this.scanningLabel.setFont(new Font("Dialog", 2, 12));
        this.scanningLabel.setForeground(new Color(153, 153, 153));
        this.scanningLabel.setText(NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.scanningLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.entityBeanLabel).addComponent(this.managedBeanLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.entityBeanCombo, 0, -1, Short.MAX_VALUE).addComponent(this.managedBeanCombo, 0, -1, Short.MAX_VALUE).addComponent(this.readOnlyCheckBox).addComponent(this.hint, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scanningLabel).addComponent(this.customizeTemplatesLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.entityBeanLabel).addComponent(this.entityBeanCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.managedBeanLabel).addComponent(this.managedBeanCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hint).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.readOnlyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 67, Short.MAX_VALUE).addComponent(this.customizeTemplatesLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanningLabel).addContainerGap()));
    }

    private void entityBeanComboItemStateChanged(ItemEvent evt) {
        final String entityClass = (String)this.entityBeanCombo.getModel().getSelectedItem();
        if (entityClass != null && entityClass.length() > 0) {
            if (this.collection) {
                this.hint.setText(NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.listHint", (Object)entityClass));
            } else {
                this.hint.setText(NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.instanceHint", (Object)entityClass));
            }
            this.hint.setVisible(true);
            RP.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    final List<String> props = ManagedBeanCustomizer.this.getPropertyNames(ManagedBeanCustomizer.this.project, entityClass, ManagedBeanCustomizer.this.collection);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ManagedBeanCustomizer.this.dummyBean = false;
                            if (props.size() == 0) {
                                props.add("");
                                props.add(NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.notManagedBeanFound"));
                                ManagedBeanCustomizer.this.dummyBean = true;
                            }
                            ManagedBeanCustomizer.this.managedBeanCombo.setModel(new DefaultComboBoxModel<String>(props.toArray(new String[props.size()])));
                        }
                    });
                }
            });
        } else {
            this.managedBeanCombo.setModel(new DefaultComboBoxModel());
            this.hint.setVisible(false);
        }
    }

    private void managedBeanComboItemStateChanged(ItemEvent evt) {
        String entityClass = (String)this.managedBeanCombo.getModel().getSelectedItem();
        if (this.dummyBean && entityClass.equals(NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.notManagedBeanFound"))) {
            this.managedBeanCombo.setSelectedIndex(0);
        }
    }

    private void customizeTemplatesLabelMouseClicked(MouseEvent evt) {
        if (this.collection) {
            new OpenTemplateAction(this, NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.tableTemplate"), TABLE_TEMPLATE).actionPerformed(null);
        } else {
            JPopupMenu menu = new JPopupMenu();
            menu.add(new OpenTemplateAction(this, NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.allTemplates"), VIEW_TEMPLATE, EDIT_TEMPLATE));
            menu.add(new OpenTemplateAction(this, NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.viewTemplate"), VIEW_TEMPLATE));
            menu.add(new OpenTemplateAction(this, NbBundle.getMessage(ManagedBeanCustomizer.class, (String)"ManagedBeanCustomizer.editTemplate"), EDIT_TEMPLATE));
            menu.show(this.customizeTemplatesLabel, evt.getX(), evt.getY());
        }
    }

    void setDialog(Dialog dlg, DialogDescriptor dd) {
        this.dialog = dlg;
        this.dialogDescriptor = dd;
        this.updateValidity("");
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.dialog.setVisible(false);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<String> getPropertyNames(Project project, String entityClass, boolean collection) {
        ArrayList<String> res = new ArrayList<String>();
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        assert (wm != null);
        List<FacesManagedBean> beans = JSFBeanCache.getBeans(project);
        for (FacesManagedBean b : beans) {
            res.addAll(this.getManagedBeanPropertyNames(project, b.getManagedBeanClass(), entityClass, b.getManagedBeanName(), collection));
        }
        List namedElements = WebBeansModelSupport.getNamedBeans(this.getWebBeansModel(wm));
        for (WebBeansModelSupport.WebBean bean : namedElements) {
            String beanName = bean.getName();
            String className = bean.getBeanClassName();
            if (beanName == null) continue;
            res.addAll(this.getManagedBeanPropertyNames(project, className, entityClass, beanName, collection));
        }
        return res;
    }

    public synchronized MetadataModel<WebBeansModel> getWebBeansModel(WebModule wm) {
        if (this.webBeansModel == null) {
            ModelUnit modelUnit = WebBeansModelSupport.getModelUnit((WebModule)wm);
            this.webBeansModel = WebBeansModelFactory.getMetaModel((ModelUnit)modelUnit);
        }
        return this.webBeansModel;
    }

    public List<String> getManagedBeanPropertyNames(Project project, String managedBean, String entityClassName, String managedBeanName, boolean collection) {
        ArrayList<String> res = new ArrayList<String>();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups.length == 0) {
            return res;
        }
        FileObject root = sourceGroups[0].getRootFolder();
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPath.getClassPath((FileObject)root, (String)"classpath/boot")}), (ClassPath)ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPath.getClassPath((FileObject)root, (String)"classpath/compile")}), (ClassPath)ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPath.getClassPath((FileObject)root, (String)"classpath/source")}));
        JavaSource js = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            Future searchingTask = js.runWhenScanFinished((Task)new SearchTask(managedBean, entityClassName, managedBeanName, res, false), true);
            if (searchingTask.isDone()) {
                return res;
            }
            js.runUserActionTask((Task)new SearchTask(managedBean, entityClassName, managedBeanName, res, true), true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return res;
    }

    private void setScanningLabelVisible(final boolean visible) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                ManagedBeanCustomizer.this.scanningLabel.setVisible(visible);
            }
        });
    }

    public static class OpenTemplateAction
    extends AbstractAction {
        private String[] templateFileName;
        private CancellableDialog panel;

        public OpenTemplateAction(CancellableDialog panel, String actionName, String ... templateFileName) {
            this.templateFileName = templateFileName;
            this.panel = panel;
            this.putValue("Name", actionName);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (String template : this.templateFileName) {
                this.openSingle(template);
            }
        }

        private void openSingle(String template) {
            FileObject tableTemplate = FileUtil.getConfigRoot().getFileObject(template);
            try {
                final DataObject dob = DataObject.find((FileObject)tableTemplate);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((EditCookie)dob.getLookup().lookup(EditCookie.class)).edit();
                    }
                });
                this.panel.cancel();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class SearchTask
    implements Task<CompilationController> {
        private final String managedBean;
        private final String entityClassName;
        private final String managedBeanName;
        private final List<String> result;
        private boolean scanning;

        public SearchTask(String managedBean, String entityClassName, String managedBeanName, List<String> result, boolean scanning) {
            this.managedBean = managedBean;
            this.entityClassName = entityClassName;
            this.managedBeanName = managedBeanName;
            this.scanning = scanning;
            this.result = result;
        }

        public void run(CompilationController cc) throws Exception {
            cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement entityClassTypeElement = cc.getElements().getTypeElement(this.entityClassName);
            TypeElement beanTypeElement = cc.getElements().getTypeElement(this.managedBean);
            if (entityClassTypeElement != null && beanTypeElement != null) {
                TypeMirror entityClassType = entityClassTypeElement.asType();
                for (ExecutableElement el : ElementFilter.methodsIn(beanTypeElement.getEnclosedElements())) {
                    TypeMirror returnTypeMirror;
                    DeclaredType declaredReturnType;
                    Element returnElement;
                    if (el.getParameters().size() > 0 || el.getReturnType().getKind() != TypeKind.DECLARED || (returnElement = (declaredReturnType = (DeclaredType)el.getReturnType()).asElement()).getKind() != ElementKind.CLASS && returnElement.getKind() != ElementKind.INTERFACE || !(returnElement instanceof TypeElement)) continue;
                    TypeElement returnTypeElement = (TypeElement)returnElement;
                    TypeElement returnCollectionTypeElement = null;
                    if (declaredReturnType.getTypeArguments().size() > 0) {
                        returnCollectionTypeElement = returnTypeElement;
                        returnTypeMirror = declaredReturnType.getTypeArguments().get(0);
                    } else {
                        returnTypeMirror = returnTypeElement.asType();
                    }
                    if (ManagedBeanCustomizer.this.collection) {
                        if (returnCollectionTypeElement == null || !this.isCollection(returnCollectionTypeElement) || !cc.getTypes().isAssignable(returnTypeMirror, entityClassType)) continue;
                        this.result.add(this.managedBeanName + "." + JpaControllerUtil.getPropNameFromMethod((String)el.getSimpleName().toString()));
                        continue;
                    }
                    if (!((Object)entityClassType).equals(returnTypeMirror)) continue;
                    this.result.add(this.managedBeanName + "." + JpaControllerUtil.getPropNameFromMethod((String)el.getSimpleName().toString()));
                }
            }
            ManagedBeanCustomizer.this.setScanningLabelVisible(SourceUtils.isScanInProgress());
        }

        private boolean isCollection(TypeElement type) {
            String collectionTypeClass = type.getQualifiedName().toString();
            Class<?> collectionTypeAsClass = null;
            try {
                collectionTypeAsClass = Class.forName(collectionTypeClass);
            }
            catch (ClassNotFoundException cfne) {
                // empty catch block
            }
            return collectionTypeAsClass != null && Collection.class.isAssignableFrom(collectionTypeAsClass);
        }
    }
}

