/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.impl.metamodel;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.web.jsf.api.metamodel.SystemEventListener;
import org.netbeans.modules.web.jsf.impl.metamodel.BehaviorImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.ClientBehaviorRendererImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.ComponentImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.ConverterImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.ManagedBeanImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.Refreshable;
import org.netbeans.modules.web.jsf.impl.metamodel.RendererImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.SystemEventListenerAnnotation;
import org.netbeans.modules.web.jsf.impl.metamodel.SystemEventListenerImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.ValidatorImpl;

class ObjectProviders {
    ObjectProviders() {
    }

    static List<SystemEventListener> findApplicationSystemEventListeners(final AnnotationModelHelper helper) {
        final LinkedList<SystemEventListener> result = new LinkedList<SystemEventListener>();
        try {
            helper.getAnnotationScanner().findAnnotations("javax.faces.event.ListenersFor", EnumSet.of(ElementKind.CLASS), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotation) {
                    if (!SystemEventListenerProvider.isApplicationSystemEventListener(typeElement, helper)) {
                        return;
                    }
                    AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
                    parser.expectAnnotationArray("value", helper.resolveType("javax.faces.event.ListenerFor"), (ArrayValueHandler)new ListenerForHandler(helper, typeElement, result), null);
                    parser.parse(annotation);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    private static abstract class AbstractProvider<T extends Refreshable>
    implements ObjectProvider<T> {
        private String myAnnotationName;
        private AnnotationModelHelper myHelper;

        AbstractProvider(AnnotationModelHelper helper, String annotationName) {
            this.myAnnotationName = annotationName;
            this.myHelper = helper;
        }

        public List<T> createInitialObjects() throws InterruptedException {
            final LinkedList result = new LinkedList();
            this.getHelper().getAnnotationScanner().findAnnotations(this.getAnnotationName(), EnumSet.of(ElementKind.CLASS), new AnnotationHandler(){

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    if (AbstractProvider.this.checkType(type)) {
                        result.add(AbstractProvider.this.createObject(AbstractProvider.this.getHelper(), type));
                    }
                }
            });
            return result;
        }

        public List<T> createObjects(TypeElement type) {
            ArrayList<T> result = new ArrayList<T>();
            if (this.getHelper().hasAnnotation(this.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(type), this.getAnnotationName()) && this.checkType(type)) {
                result.add(this.createObject(this.getHelper(), type));
            }
            return result;
        }

        public boolean modifyObjects(TypeElement type, List<T> objects) {
            boolean isModified = false;
            Iterator<T> iterator = objects.iterator();
            while (iterator.hasNext()) {
                Refreshable object = (Refreshable)iterator.next();
                if (object.refresh(type)) continue;
                iterator.remove();
                isModified = true;
            }
            return isModified;
        }

        abstract T createObject(AnnotationModelHelper var1, TypeElement var2);

        protected boolean checkType(TypeElement type) {
            return true;
        }

        protected AnnotationModelHelper getHelper() {
            return this.myHelper;
        }

        private String getAnnotationName() {
            return this.myAnnotationName;
        }
    }

    static final class BehaviorProvider
    extends AbstractProvider<BehaviorImpl> {
        BehaviorProvider(AnnotationModelHelper helper) {
            super(helper, "javax.faces.component.behavior.FacesBehavior");
        }

        @Override
        BehaviorImpl createObject(AnnotationModelHelper helper, TypeElement typeElement) {
            return new BehaviorImpl(helper, typeElement);
        }
    }

    static final class ClientBehaviorProvider
    extends AbstractProvider<ClientBehaviorRendererImpl>
    implements ObjectProvider<ClientBehaviorRendererImpl> {
        ClientBehaviorProvider(AnnotationModelHelper helper) {
            super(helper, "javax.faces.render.FacesBehaviorRenderer");
        }

        @Override
        ClientBehaviorRendererImpl createObject(AnnotationModelHelper helper, TypeElement typeElement) {
            return new ClientBehaviorRendererImpl(helper, typeElement);
        }
    }

    static final class ComponentProvider
    extends AbstractProvider<ComponentImpl>
    implements ObjectProvider<ComponentImpl> {
        ComponentProvider(AnnotationModelHelper helper) {
            super(helper, "javax.faces.component.FacesComponent");
        }

        @Override
        ComponentImpl createObject(AnnotationModelHelper helper, TypeElement typeElement) {
            return new ComponentImpl(helper, typeElement);
        }
    }

    static final class ConverterProvider
    extends AbstractProvider<ConverterImpl>
    implements ObjectProvider<ConverterImpl> {
        ConverterProvider(AnnotationModelHelper helper) {
            super(helper, "javax.faces.convert.FacesConverter");
        }

        @Override
        ConverterImpl createObject(AnnotationModelHelper helper, TypeElement typeElement) {
            return new ConverterImpl(helper, typeElement);
        }
    }

    private static final class ListenerForHandler
    implements ArrayValueHandler {
        private AnnotationModelHelper myHelper;
        private TypeElement myType;
        private List<SystemEventListener> myListeners;

        ListenerForHandler(AnnotationModelHelper helper, TypeElement type, List<SystemEventListener> listeners) {
            this.myHelper = helper;
            this.myType = type;
            this.myListeners = listeners;
        }

        public Object handleArray(List<AnnotationValue> arrayMembers) {
            for (AnnotationValue arrayMember : arrayMembers) {
                Object arrayMemberValue = arrayMember.getValue();
                if (!(arrayMemberValue instanceof AnnotationMirror)) continue;
                AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
                parser.expectClass("systemEventClass", null);
                parser.expectClass("sourceClass", AnnotationParser.defaultValue((Object)Void.class.getCanonicalName()));
                ParseResult parseResult = parser.parse((AnnotationMirror)arrayMemberValue);
                String eventClass = (String)parseResult.get("systemEventClass", String.class);
                String sourceClass = (String)parseResult.get("sourceClass", String.class);
                String clazz = this.myType.getQualifiedName().toString();
                this.myListeners.add(new SystemEventListenerAnnotation(clazz, sourceClass, eventClass));
            }
            return null;
        }

        private AnnotationModelHelper getHelper() {
            return this.myHelper;
        }
    }

    static final class ManagedBeanProvider
    extends AbstractProvider<ManagedBeanImpl>
    implements ObjectProvider<ManagedBeanImpl> {
        ManagedBeanProvider(AnnotationModelHelper helper) {
            super(helper, "javax.faces.bean.ManagedBean");
        }

        @Override
        ManagedBeanImpl createObject(AnnotationModelHelper helper, TypeElement typeElement) {
            return new ManagedBeanImpl(helper, typeElement);
        }
    }

    static final class RendererProvider
    extends AbstractProvider<RendererImpl>
    implements ObjectProvider<RendererImpl> {
        RendererProvider(AnnotationModelHelper helper) {
            super(helper, "javax.faces.render.FacesRenderer");
        }

        @Override
        RendererImpl createObject(AnnotationModelHelper helper, TypeElement typeElement) {
            return new RendererImpl(helper, typeElement);
        }
    }

    static final class SystemEventListenerProvider
    extends AbstractProvider<SystemEventListenerImpl>
    implements ObjectProvider<SystemEventListenerImpl> {
        SystemEventListenerProvider(AnnotationModelHelper helper) {
            super(helper, "javax.faces.event.ListenerFor");
        }

        @Override
        SystemEventListenerImpl createObject(AnnotationModelHelper helper, TypeElement typeElement) {
            return new SystemEventListenerImpl(helper, typeElement);
        }

        @Override
        protected boolean checkType(TypeElement type) {
            return SystemEventListenerProvider.isApplicationSystemEventListener(type, this.getHelper());
        }

        static boolean isApplicationSystemEventListener(TypeElement type, AnnotationModelHelper helper) {
            List<TypeElement> interfaces = SystemEventListenerProvider.getImplementedInterfaces(type, helper);
            boolean isSystemEventListener = false;
            boolean isComponentSystemEventListener = false;
            for (TypeElement typeElement : interfaces) {
                if (typeElement.getQualifiedName().contentEquals("javax.faces.event.SystemEventListener")) {
                    isSystemEventListener = true;
                    continue;
                }
                if (!typeElement.getQualifiedName().contentEquals("javax.faces.event.ComponentSystemEventListener")) continue;
                isComponentSystemEventListener = true;
            }
            return isSystemEventListener && !isComponentSystemEventListener;
        }

        static List<TypeElement> getImplementedInterfaces(TypeElement type, AnnotationModelHelper helper) {
            List<? extends TypeMirror> interfaces = type.getInterfaces();
            ArrayList<TypeElement> result = new ArrayList<TypeElement>(interfaces.size());
            for (TypeMirror typeMirror : interfaces) {
                Element element;
                if (!TypeKind.DECLARED.equals((Object)typeMirror.getKind()) || !ElementKind.INTERFACE.equals((Object)(element = ((DeclaredType)typeMirror).asElement()).getKind())) continue;
                result.add((TypeElement)element);
                List<TypeElement> superInterfaces = SystemEventListenerProvider.getImplementedInterfaces((TypeElement)element, helper);
                result.addAll(superInterfaces);
            }
            List superClasses = helper.getSuperclasses(type);
            for (TypeElement typeElement : superClasses) {
                List<TypeElement> list = SystemEventListenerProvider.getImplementedInterfaces(typeElement, helper);
                result.addAll(list);
            }
            return result;
        }
    }

    static final class ValidatorProvider
    extends AbstractProvider<ValidatorImpl>
    implements ObjectProvider<ValidatorImpl> {
        ValidatorProvider(AnnotationModelHelper helper) {
            super(helper, "javax.faces.validator.FacesValidator");
        }

        @Override
        ValidatorImpl createObject(AnnotationModelHelper helper, TypeElement typeElement) {
            return new ValidatorImpl(helper, typeElement);
        }
    }
}

