/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public class JsfComponentUtils {
    private JsfComponentUtils() {
    }

    public static Library enhanceLibraryWithPomContent(final Library library, final List<URI> poms) throws IOException {
        List mavenContent = library.getContent("maven-pom");
        String name = library.getName();
        if (mavenContent == null || mavenContent.isEmpty()) {
            Runnable call = new Runnable(){

                @Override
                public void run() {
                    String type = library.getType();
                    String name = library.getName();
                    String displayName = library.getDisplayName();
                    String desc = library.getDescription();
                    HashMap<String, List> content = new HashMap<String, List>();
                    content.put("classpath", library.getURIContent("classpath"));
                    content.put("src", library.getURIContent("src"));
                    content.put("javadoc", library.getURIContent("javadoc"));
                    content.put("maven-pom", poms);
                    try {
                        LibraryManager.getDefault().removeLibrary(library);
                        LibraryManager.getDefault().createURILibrary(type, name, displayName, desc, content);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (IllegalArgumentException iae) {
                        Exceptions.printStackTrace((Throwable)iae);
                    }
                }
            };
            Mutex.EVENT.writeAccess(call);
        }
        return LibraryManager.getDefault().getLibrary(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reformat(DataObject dob) {
        try {
            EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return;
            }
            final StyledDocument doc = ec.openDocument();
            final Reformat reformat = Reformat.get((Document)doc);
            reformat.lock();
            try {
                NbDocument.runAtomicAsUser((StyledDocument)doc, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            reformat.reformat(0, doc.getLength());
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                reformat.unlock();
                ec.saveDocument();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enhanceFileBody(DataObject dob, final String find, final String enhanceBy) {
        try {
            EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return;
            }
            final StyledDocument doc = ec.openDocument();
            try {
                NbDocument.runAtomicAsUser((StyledDocument)doc, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int position = doc.getText(0, doc.getLength()).indexOf(find);
                            if (position >= 0) {
                                doc.insertString(position, enhanceBy + "\n", null);
                            }
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                ec.saveDocument();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

