/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.java.editor.codegen.CodeDeleter;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.RemoveSurroundingCodePanel;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RemoveSurroundingCodeAction
extends BaseAction {
    public void actionPerformed(ActionEvent evt, final JTextComponent component) {
        if (component == null || !component.isEditable() || !component.isEnabled()) {
            component.getToolkit().beep();
            return;
        }
        BaseDocument doc = (BaseDocument)component.getDocument();
        final JavaSource js = JavaSource.forDocument((Document)doc);
        if (js != null) {
            final AtomicBoolean cancel = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        js.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController controller) throws Exception {
                                try {
                                    if (cancel.get()) {
                                        return;
                                    }
                                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    if (cancel.get()) {
                                        return;
                                    }
                                    TreeUtilities tu = controller.getTreeUtilities();
                                    final ArrayList<Deleter> codeDeleters = new ArrayList<Deleter>();
                                    final int caretOffset = component.getCaretPosition();
                                    block7: for (TreePath tp = tu.pathFor(caretOffset); tp != null; tp = tp.getParentPath()) {
                                        Tree leaf = tp.getLeaf();
                                        switch (leaf.getKind()) {
                                            case IF: {
                                                if (RemoveSurroundingCodeAction.this.insideElse(controller, (IfTree)leaf, component.getCaretPosition())) {
                                                    codeDeleters.add(new Deleter((CompilationInfo)controller, component, tp, false));
                                                }
                                            }
                                            case FOR_LOOP: 
                                            case ENHANCED_FOR_LOOP: 
                                            case WHILE_LOOP: 
                                            case DO_WHILE_LOOP: 
                                            case SYNCHRONIZED: 
                                            case TRY: {
                                                codeDeleters.add(new Deleter((CompilationInfo)controller, component, tp));
                                                continue block7;
                                            }
                                            case BLOCK: {
                                                if (tp.getParentPath().getLeaf().getKind() != Tree.Kind.BLOCK) continue block7;
                                                codeDeleters.add(new Deleter((CompilationInfo)controller, component, tp));
                                            }
                                        }
                                    }
                                    if (codeDeleters.size() > 0) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                int altHeight = -1;
                                                Point where = null;
                                                try {
                                                    Rectangle carretRectangle = component.modelToView(caretOffset);
                                                    altHeight = carretRectangle.height;
                                                    where = new Point(carretRectangle.x, carretRectangle.y + carretRectangle.height);
                                                    SwingUtilities.convertPointToScreen(where, component);
                                                }
                                                catch (BadLocationException badLocationException) {
                                                    // empty catch block
                                                }
                                                if (where == null) {
                                                    where = new Point(-1, -1);
                                                }
                                                PopupUtil.showPopup(new RemoveSurroundingCodePanel(component, codeDeleters), null, where.x, where.y, true, altHeight);
                                            }
                                        });
                                    } else {
                                        component.getToolkit().beep();
                                    }
                                }
                                catch (IOException ioe) {
                                    component.getToolkit().beep();
                                }
                            }
                        }, true);
                    }
                    catch (IOException ioe) {
                        component.getToolkit().beep();
                    }
                }
            }, (String)this.getShortDescription(), (AtomicBoolean)cancel, (boolean)false);
        }
    }

    private String getShortDescription() {
        String name = (String)this.getValue("Name");
        if (name != null) {
            try {
                return NbBundle.getMessage(RemoveSurroundingCodeAction.class, (String)name);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return name;
    }

    private boolean insideElse(CompilationController controller, IfTree ifTree, int caretPosition) {
        if (ifTree.getElseStatement() == null) {
            return false;
        }
        SourcePositions sp = controller.getTrees().getSourcePositions();
        int end = (int)sp.getEndPosition(controller.getCompilationUnit(), ifTree.getThenStatement());
        return end > 0 && caretPosition > end;
    }

    private static class Deleter
    implements CodeDeleter {
        private static final AttributeSet DELETE_HIGHLIGHT = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, new Color(245, 245, 245), StyleConstants.Foreground, new Color(180, 180, 180)});
        private static final AttributeSet REMAIN_HIGHLIGHT = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, new Color(210, 240, 210)});
        private JTextComponent component;
        private TreePathHandle tpHandle;
        private boolean unwrap;
        private OffsetsBag bag;

        private Deleter(CompilationInfo cInfo, JTextComponent component, TreePath path) throws BadLocationException {
            this(cInfo, component, path, true);
        }

        private Deleter(CompilationInfo cInfo, JTextComponent component, TreePath path, boolean unwrap) throws BadLocationException {
            this.component = component;
            this.tpHandle = TreePathHandle.create((TreePath)path, (CompilationInfo)cInfo);
            this.unwrap = unwrap;
            this.bag = this.createOffsetsBag(component, cInfo.getTrees().getSourcePositions(), path);
        }

        @Override
        public String getDisplayName() {
            switch (this.tpHandle.getKind()) {
                case IF: {
                    return this.unwrap ? "if (...) ..." : "else ...";
                }
                case FOR_LOOP: 
                case ENHANCED_FOR_LOOP: {
                    return "for (...) ...";
                }
                case WHILE_LOOP: {
                    return "while (...) ...";
                }
                case DO_WHILE_LOOP: {
                    return "do ... while(...)";
                }
                case SYNCHRONIZED: {
                    return "synchronized (...) ...";
                }
                case TRY: {
                    return "try ...";
                }
                case BLOCK: {
                    return "{...}";
                }
            }
            throw new IllegalStateException("Unsupported kind: " + (Object)((Object)this.tpHandle.getKind()));
        }

        @Override
        public void invoke() {
            JavaSource js = JavaSource.forDocument((Document)this.component.getDocument());
            if (js != null) {
                try {
                    ModificationResult mr = js.runModificationTask((Task)new Task<WorkingCopy>(){

                        public void run(WorkingCopy copy) throws IOException {
                            copy.toPhase(JavaSource.Phase.PARSED);
                            TreePath tp = Deleter.this.tpHandle.resolve((CompilationInfo)copy);
                            if (tp != null) {
                                TreeMaker tm = copy.getTreeMaker();
                                Tree tree = tp.getLeaf();
                                Tree parent = tp.getParentPath().getLeaf();
                                ArrayList<? extends StatementTree> stats = new ArrayList<StatementTree>();
                                switch (tree.getKind()) {
                                    case IF: {
                                        IfTree it = (IfTree)tree;
                                        if (Deleter.this.unwrap) {
                                            Deleter.this.addStat(it.getThenStatement(), stats);
                                        } else {
                                            Deleter.this.addStat(tm.If(it.getCondition(), it.getThenStatement(), null), stats);
                                        }
                                        Deleter.this.addStat(it.getElseStatement(), stats);
                                        break;
                                    }
                                    case FOR_LOOP: {
                                        ForLoopTree flt = (ForLoopTree)tree;
                                        stats.addAll(flt.getInitializer());
                                        Deleter.this.addStat(flt.getStatement(), stats);
                                        break;
                                    }
                                    case ENHANCED_FOR_LOOP: {
                                        EnhancedForLoopTree eflt = (EnhancedForLoopTree)tree;
                                        VariableTree var = eflt.getVariable();
                                        stats.add(tm.Variable(var.getModifiers(), (CharSequence)var.getName(), var.getType(), (ExpressionTree)tm.Literal(null)));
                                        Deleter.this.addStat(eflt.getStatement(), stats);
                                        break;
                                    }
                                    case WHILE_LOOP: {
                                        WhileLoopTree wlt = (WhileLoopTree)tree;
                                        Deleter.this.addStat(wlt.getStatement(), stats);
                                        break;
                                    }
                                    case DO_WHILE_LOOP: {
                                        DoWhileLoopTree dwlt = (DoWhileLoopTree)tree;
                                        Deleter.this.addStat(dwlt.getStatement(), stats);
                                        break;
                                    }
                                    case SYNCHRONIZED: {
                                        SynchronizedTree st = (SynchronizedTree)tree;
                                        Deleter.this.addStat(st.getBlock(), stats);
                                        break;
                                    }
                                    case TRY: {
                                        TryTree tt = (TryTree)tree;
                                        for (Tree tree2 : tt.getResources()) {
                                            Deleter.this.addStat((StatementTree)tree2, stats);
                                        }
                                        Deleter.this.addStat(tt.getBlock(), stats);
                                        Deleter.this.addStat(tt.getFinallyBlock(), stats);
                                        break;
                                    }
                                    case BLOCK: {
                                        BlockTree bt = (BlockTree)tree;
                                        Deleter.this.addStat(bt, stats);
                                    }
                                }
                                if (parent.getKind() == Tree.Kind.BLOCK) {
                                    int i;
                                    BlockTree block = (BlockTree)parent;
                                    int idx = -1;
                                    List<? extends StatementTree> blockStats = block.getStatements();
                                    for (i = 0; i < blockStats.size(); ++i) {
                                        if (tree != blockStats.get(i)) continue;
                                        idx = i;
                                        break;
                                    }
                                    if (idx >= 0) {
                                        block = tm.removeBlockStatement(block, idx);
                                        for (i = stats.size() - 1; i >= 0; --i) {
                                            block = tm.insertBlockStatement(block, idx, (StatementTree)stats.get(i));
                                        }
                                    }
                                    copy.rewrite(parent, (Tree)block);
                                } else {
                                    BlockTree newTree = stats.size() > 1 ? tm.Block(stats, false) : (stats.size() == 1 ? (StatementTree)stats.get(0) : null);
                                    copy.rewrite(tree, (Tree)newTree);
                                }
                            }
                        }
                    });
                    GeneratorUtils.guardedCommit(this.component, mr);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        @Override
        public OffsetsBag getHighlight() {
            return this.bag;
        }

        private OffsetsBag createOffsetsBag(JTextComponent component, SourcePositions sp, TreePath path) throws BadLocationException {
            Document doc = component.getDocument();
            OffsetsBag offsetsBag = new OffsetsBag(doc, true);
            int start = (int)sp.getStartPosition(path.getCompilationUnit(), path.getLeaf());
            if (start >= 0) {
                ArrayList<int[]> positions = new ArrayList<int[]>();
                Tree tree = path.getLeaf();
                switch (tree.getKind()) {
                    case IF: {
                        IfTree it = (IfTree)tree;
                        if (this.unwrap) {
                            positions.add(this.getStatBounds(sp, path.getCompilationUnit(), it.getThenStatement()));
                        } else {
                            int end;
                            start = (int)sp.getEndPosition(path.getCompilationUnit(), it.getThenStatement());
                            int off = doc.getText(start, (end = (int)sp.getStartPosition(path.getCompilationUnit(), it.getElseStatement())) - start).indexOf("else");
                            if (off > 0) {
                                start += off;
                            }
                        }
                        positions.add(this.getStatBounds(sp, path.getCompilationUnit(), it.getElseStatement()));
                        break;
                    }
                    case FOR_LOOP: {
                        ForLoopTree flt = (ForLoopTree)tree;
                        List<? extends StatementTree> inits = flt.getInitializer();
                        if (inits != null && !inits.isEmpty()) {
                            int[] bounds = new int[]{-1, -1};
                            bounds[0] = (int)sp.getStartPosition(path.getCompilationUnit(), inits.get(0));
                            bounds[1] = (int)sp.getEndPosition(path.getCompilationUnit(), inits.get(inits.size() - 1));
                            positions.add(bounds);
                        }
                        positions.add(this.getStatBounds(sp, path.getCompilationUnit(), flt.getStatement()));
                        break;
                    }
                    case ENHANCED_FOR_LOOP: {
                        EnhancedForLoopTree eflt = (EnhancedForLoopTree)tree;
                        positions.add(this.getStatBounds(sp, path.getCompilationUnit(), eflt.getVariable()));
                        positions.add(this.getStatBounds(sp, path.getCompilationUnit(), eflt.getStatement()));
                        break;
                    }
                    case WHILE_LOOP: {
                        WhileLoopTree wlt = (WhileLoopTree)tree;
                        positions.add(this.getStatBounds(sp, path.getCompilationUnit(), wlt.getStatement()));
                        break;
                    }
                    case DO_WHILE_LOOP: {
                        DoWhileLoopTree dwlt = (DoWhileLoopTree)tree;
                        positions.add(this.getStatBounds(sp, path.getCompilationUnit(), dwlt.getStatement()));
                        break;
                    }
                    case SYNCHRONIZED: {
                        SynchronizedTree st = (SynchronizedTree)tree;
                        positions.add(this.getStatBounds(sp, path.getCompilationUnit(), st.getBlock()));
                        break;
                    }
                    case TRY: {
                        TryTree tt = (TryTree)tree;
                        for (Tree tree2 : tt.getResources()) {
                            positions.add(this.getStatBounds(sp, path.getCompilationUnit(), (StatementTree)tree2));
                        }
                        positions.add(this.getStatBounds(sp, path.getCompilationUnit(), tt.getBlock()));
                        positions.add(this.getStatBounds(sp, path.getCompilationUnit(), tt.getFinallyBlock()));
                        break;
                    }
                    case BLOCK: {
                        BlockTree bt = (BlockTree)tree;
                        positions.add(this.getStatBounds(sp, path.getCompilationUnit(), bt));
                    }
                }
                for (int[] bounds : positions) {
                    if (bounds[0] < 0 || bounds[1] <= bounds[0]) continue;
                    offsetsBag.addHighlight(start, bounds[0], DELETE_HIGHLIGHT);
                    offsetsBag.addHighlight(bounds[0], bounds[1], REMAIN_HIGHLIGHT);
                    start = bounds[1];
                }
                int end = (int)sp.getEndPosition(path.getCompilationUnit(), path.getLeaf());
                if (end > start) {
                    offsetsBag.addHighlight(start, end, DELETE_HIGHLIGHT);
                }
            }
            return offsetsBag;
        }

        private void addStat(StatementTree stat, List<StatementTree> to) {
            if (stat != null) {
                if (stat.getKind() == Tree.Kind.BLOCK) {
                    to.addAll(((BlockTree)stat).getStatements());
                } else {
                    to.add(stat);
                }
            }
        }

        private int[] getStatBounds(SourcePositions sp, CompilationUnitTree cut, StatementTree stat) {
            int[] bounds = new int[]{-1, -1};
            if (stat != null) {
                if (stat.getKind() == Tree.Kind.BLOCK) {
                    List<? extends StatementTree> stats = ((BlockTree)stat).getStatements();
                    if (stats != null && !stats.isEmpty()) {
                        bounds[0] = (int)sp.getStartPosition(cut, stats.get(0));
                        bounds[1] = (int)sp.getEndPosition(cut, stats.get(stats.size() - 1));
                    }
                } else {
                    bounds[0] = (int)sp.getStartPosition(cut, stat);
                    bounds[1] = (int)sp.getEndPosition(cut, stat);
                }
            }
            return bounds;
        }
    }
}

