/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Utilities;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class GeneratorUtils {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(GeneratorUtils.class.getName());
    private static final String ERROR = "<error>";
    public static final int GETTERS_ONLY = 1;
    public static final int SETTERS_ONLY = 2;
    private static final Set<Modifier> NOT_OVERRIDABLE = EnumSet.of(Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL);

    private GeneratorUtils() {
    }

    public static List<? extends ExecutableElement> findUndefs(CompilationInfo info, TypeElement impl) {
        if (ERR.isLoggable(1)) {
            ERR.log(1, "findUndefs(" + info + ", " + impl + ")");
        }
        List undef = info.getElementUtilities().findUnimplementedMethods(impl);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "undef=" + undef);
        }
        return undef;
    }

    public static List<? extends ExecutableElement> findOverridable(CompilationInfo info, TypeElement impl) {
        ArrayList<ExecutableElement> overridable = new ArrayList<ExecutableElement>();
        List<TypeElement> classes = GeneratorUtils.getAllClasses(impl);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "classes=" + classes);
        }
        for (TypeElement te : classes.subList(1, classes.size())) {
            for (ExecutableElement ee : ElementFilter.methodsIn(te.getEnclosedElements())) {
                EnumSet<Modifier> set = EnumSet.copyOf(NOT_OVERRIDABLE);
                set.removeAll(ee.getModifiers());
                if (set.size() != NOT_OVERRIDABLE.size() || ee.getModifiers().contains((Object)Modifier.PRIVATE) || GeneratorUtils.overridesPackagePrivateOutsidePackage(ee, impl)) continue;
                int thisElement = classes.indexOf(te);
                if (ERR.isLoggable(1)) {
                    ERR.log(1, "ee=" + ee);
                    ERR.log(1, "thisElement = " + thisElement);
                    ERR.log(1, "classes.subList(0, thisElement + 1)=" + classes.subList(0, thisElement + 1));
                    ERR.log(1, "isOverriden(info, ee, classes.subList(0, thisElement + 1))=" + GeneratorUtils.isOverriden(info, ee, classes.subList(0, thisElement + 1)));
                }
                if (GeneratorUtils.isOverriden(info, ee, classes.subList(0, thisElement + 1))) continue;
                overridable.add(ee);
            }
        }
        return overridable;
    }

    public static Map<? extends TypeElement, ? extends List<? extends VariableElement>> findAllAccessibleFields(CompilationInfo info, TypeElement clazz) {
        HashMap<TypeElement, List<? extends VariableElement>> result = new HashMap<TypeElement, List<? extends VariableElement>>();
        result.put(clazz, GeneratorUtils.findAllAccessibleFields(info, clazz, clazz));
        for (TypeElement te : GeneratorUtils.getAllParents(clazz)) {
            result.put(te, GeneratorUtils.findAllAccessibleFields(info, clazz, te));
        }
        return result;
    }

    public static void scanForFieldsAndConstructors(CompilationInfo info, TreePath clsPath, final Set<VariableElement> initializedFields, final Set<VariableElement> uninitializedFields, final List<ExecutableElement> constructors) {
        final Trees trees = info.getTrees();
        new TreePathScanner<Void, Boolean>(){

            @Override
            public Void visitVariable(VariableTree node, Boolean p) {
                if (GeneratorUtils.ERROR.contentEquals(node.getName())) {
                    return null;
                }
                Element el = trees.getElement(this.getCurrentPath());
                if (el != null && el.getKind() == ElementKind.FIELD && !el.getModifiers().contains((Object)Modifier.STATIC) && node.getInitializer() == null && !initializedFields.remove(el)) {
                    uninitializedFields.add((VariableElement)el);
                }
                return null;
            }

            @Override
            public Void visitAssignment(AssignmentTree node, Boolean p) {
                Element el = trees.getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                if (el != null && el.getKind() == ElementKind.FIELD && !uninitializedFields.remove(el)) {
                    initializedFields.add((VariableElement)el);
                }
                return null;
            }

            @Override
            public Void visitClass(ClassTree node, Boolean p) {
                return p != false ? (Void)super.visitClass(node, false) : null;
            }

            @Override
            public Void visitMethod(MethodTree node, Boolean p) {
                Element el = trees.getElement(this.getCurrentPath());
                if (el != null && el.getKind() == ElementKind.CONSTRUCTOR) {
                    constructors.add((ExecutableElement)el);
                }
                return null;
            }
        }.scan(clsPath, Boolean.TRUE);
    }

    public static void generateAllAbstractMethodImplementations(WorkingCopy wc, TreePath path) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
            ElementUtilities elemUtils = wc.getElementUtilities();
            clazz = gu.insertClassMembers(clazz, (Iterable)gu.createAbstractMethodImplementations(te, (Iterable)elemUtils.findUnimplementedMethods(te)));
            wc.rewrite(path.getLeaf(), (Tree)clazz);
        }
    }

    public static void generateAbstractMethodImplementations(WorkingCopy wc, TreePath path, List<? extends ExecutableElement> elements, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMembers(wc, clazz, GeneratorUtilities.get((WorkingCopy)wc).createAbstractMethodImplementations(te, elements), offset));
        }
    }

    public static void generateAbstractMethodImplementation(WorkingCopy wc, TreePath path, ExecutableElement element, int index) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree decl = wc.getTreeMaker().insertClassMember((ClassTree)path.getLeaf(), index, (Tree)GeneratorUtilities.get((WorkingCopy)wc).createAbstractMethodImplementation(te, element));
            wc.rewrite(path.getLeaf(), (Tree)decl);
        }
    }

    public static void generateMethodOverrides(WorkingCopy wc, TreePath path, List<? extends ExecutableElement> elements, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMembers(wc, clazz, GeneratorUtilities.get((WorkingCopy)wc).createOverridingMethods(te, elements), offset));
        }
    }

    public static void generateMethodOverride(WorkingCopy wc, TreePath path, ExecutableElement element, int index) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree decl = wc.getTreeMaker().insertClassMember((ClassTree)path.getLeaf(), index, (Tree)GeneratorUtilities.get((WorkingCopy)wc).createOverridingMethod(te, element));
            wc.rewrite(path.getLeaf(), (Tree)decl);
        }
    }

    public static void generateConstructor(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> initFields, ExecutableElement inheritedConstructor, int offset) {
        ClassTree clazz = (ClassTree)path.getLeaf();
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMembers(wc, clazz, Collections.singletonList(GeneratorUtilities.get((WorkingCopy)wc).createConstructor(te, initFields, inheritedConstructor)), offset));
    }

    public static void generateConstructors(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> initFields, List<? extends ExecutableElement> inheritedConstructors, int offset) {
        ClassTree clazz = (ClassTree)path.getLeaf();
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
        ArrayList<MethodTree> members = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : inheritedConstructors) {
            members.add(gu.createConstructor(te, initFields, executableElement));
        }
        wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMembers(wc, clazz, members, offset));
    }

    public static void generateGettersAndSetters(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> fields, int type, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
            ClassTree clazz = (ClassTree)path.getLeaf();
            ArrayList<MethodTree> members = new ArrayList<MethodTree>();
            for (VariableElement variableElement : fields) {
                if (type != 2) {
                    members.add(gu.createGetter(te, variableElement));
                }
                if (type == 1) continue;
                members.add(gu.createSetter(te, variableElement));
            }
            wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMembers(wc, clazz, members, offset));
        }
    }

    public static boolean hasGetter(CompilationInfo info, TypeElement typeElement, VariableElement field, Map<String, List<ExecutableElement>> methods) {
        Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = field.asType();
        StringBuilder sb = GeneratorUtils.getCapitalizedName(name);
        sb.insert(0, type.getKind() == TypeKind.BOOLEAN ? "is" : "get");
        Types types = info.getTypes();
        List<ExecutableElement> candidates = methods.get(sb.toString());
        if (candidates != null) {
            for (ExecutableElement candidate : candidates) {
                if (candidate.getModifiers().contains((Object)Modifier.ABSTRACT) && candidate.getEnclosingElement() != typeElement || !candidate.getParameters().isEmpty() || !types.isSameType(candidate.getReturnType(), type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSetter(CompilationInfo info, TypeElement typeElement, VariableElement field, Map<String, List<ExecutableElement>> methods) {
        Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = field.asType();
        StringBuilder sb = GeneratorUtils.getCapitalizedName(name);
        sb.insert(0, "set");
        Types types = info.getTypes();
        List<ExecutableElement> candidates = methods.get(sb.toString());
        if (candidates != null) {
            for (ExecutableElement candidate : candidates) {
                if (candidate.getModifiers().contains((Object)Modifier.ABSTRACT) && candidate.getEnclosingElement() != typeElement || candidate.getReturnType().getKind() != TypeKind.VOID || candidate.getParameters().size() != 1 || !types.isSameType(candidate.getParameters().get(0).asType(), type)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static ClassTree insertClassMembers(WorkingCopy wc, ClassTree clazz, List<? extends Tree> members, int offset) throws IllegalStateException {
        void var9_12;
        if (offset < 0 || GeneratorUtils.getCodeStyle((CompilationInfo)wc).getClassMemberInsertionPoint() != CodeStyle.InsertionPoint.CARET_LOCATION) {
            return GeneratorUtilities.get((WorkingCopy)wc).insertClassMembers(clazz, members);
        }
        int index = 0;
        SourcePositions sp = wc.getTrees().getSourcePositions();
        GuardedDocument gdoc = null;
        try {
            Document doc = wc.getDocument();
            if (doc != null && doc instanceof GuardedDocument) {
                gdoc = (GuardedDocument)doc;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Tree lastMember = null;
        for (Tree tree : clazz.getMembers()) {
            if ((long)offset <= sp.getStartPosition(wc.getCompilationUnit(), tree)) {
                if (gdoc == null) break;
                int pos = (int)(lastMember != null ? sp.getEndPosition(wc.getCompilationUnit(), lastMember) : sp.getStartPosition(wc.getCompilationUnit(), clazz));
                pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                if ((long)pos <= sp.getStartPosition(wc.getCompilationUnit(), tree)) break;
            }
            ++index;
            lastMember = tree;
        }
        TreeMaker tm = wc.getTreeMaker();
        int n = members.size() - 1;
        while (var9_12 >= 0) {
            clazz = tm.insertClassMember(clazz, index, members.get((int)var9_12));
            --var9_12;
        }
        return clazz;
    }

    private static CodeStyle getCodeStyle(CompilationInfo info) {
        if (info != null) {
            try {
                Document doc = info.getDocument();
                if (doc != null) {
                    CodeStyle cs = (CodeStyle)doc.getProperty(CodeStyle.class);
                    return cs != null ? cs : CodeStyle.getDefault((Document)doc);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            FileObject file = info.getFileObject();
            if (file != null) {
                return CodeStyle.getDefault((FileObject)file);
            }
        }
        return CodeStyle.getDefault((Document)null);
    }

    private static List<? extends VariableElement> findAllAccessibleFields(CompilationInfo info, TypeElement accessibleFrom, TypeElement toScan) {
        ArrayList<VariableElement> result = new ArrayList<VariableElement>();
        for (VariableElement ve : ElementFilter.fieldsIn(toScan.getEnclosedElements())) {
            if (ve.getModifiers().contains((Object)Modifier.PUBLIC)) {
                result.add(ve);
                continue;
            }
            if (ve.getModifiers().contains((Object)Modifier.PRIVATE)) {
                if (accessibleFrom != toScan) continue;
                result.add(ve);
                continue;
            }
            if (!ve.getModifiers().contains((Object)Modifier.PROTECTED) || !GeneratorUtils.getAllParents(accessibleFrom).contains(toScan)) continue;
            result.add(ve);
        }
        return result;
    }

    public static Collection<TypeElement> getAllParents(TypeElement of) {
        TypeElement typeElement;
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (TypeMirror typeMirror : of.getInterfaces()) {
            TypeElement te2 = (TypeElement)((DeclaredType)typeMirror).asElement();
            if (te2 != null) {
                result.add(te2);
                result.addAll(GeneratorUtils.getAllParents(te2));
                continue;
            }
            if (!ERR.isLoggable(1)) continue;
            ERR.log(1, "te=null, t=" + typeMirror);
        }
        TypeMirror sup = of.getSuperclass();
        TypeElement typeElement2 = typeElement = sup.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)sup).asElement() : null;
        if (typeElement != null) {
            result.add(typeElement);
            result.addAll(GeneratorUtils.getAllParents(typeElement));
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "te=null, t=" + of);
        }
        return result;
    }

    public static boolean supportsOverride(@NonNull CompilationInfo info) {
        return SourceVersion.RELEASE_5.compareTo(info.getSourceVersion()) <= 0 && info.getElements().getTypeElement("java.lang.Override") != null;
    }

    private static List<TypeElement> getAllClasses(TypeElement of) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        TypeMirror sup = of.getSuperclass();
        TypeElement te = sup.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)sup).asElement() : null;
        result.add(of);
        if (te != null) {
            result.addAll(GeneratorUtils.getAllClasses(te));
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "te=null, t=" + of);
        }
        return result;
    }

    private static boolean isOverriden(CompilationInfo info, ExecutableElement methodBase, List<TypeElement> classes) {
        if (ERR.isLoggable(1)) {
            ERR.log(1, "isOverriden(" + info + ", " + methodBase + ", " + classes + ")");
        }
        for (TypeElement impl : classes) {
            for (ExecutableElement methodImpl : ElementFilter.methodsIn(impl.getEnclosedElements())) {
                if (ERR.isLoggable(1) && info.getElements().overrides(methodImpl, methodBase, impl)) {
                    ERR.log(1, "overrides:");
                    ERR.log(1, "impl=" + impl);
                    ERR.log(1, "methodImpl=" + methodImpl);
                }
                if (!info.getElements().overrides(methodImpl, methodBase, impl)) continue;
                return true;
            }
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "no overriding methods overrides:");
        }
        return false;
    }

    public static boolean isAccessible(TypeElement from, Element what) {
        TypeElement whatTopLevel;
        if (what.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return true;
        }
        TypeElement fromTopLevel = SourceUtils.getOutermostEnclosingTypeElement((Element)from);
        if (fromTopLevel.equals(whatTopLevel = SourceUtils.getOutermostEnclosingTypeElement((Element)what))) {
            return true;
        }
        if (what.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        if (what.getModifiers().contains((Object)Modifier.PROTECTED) && GeneratorUtils.getAllClasses(fromTopLevel).contains(SourceUtils.getEnclosingTypeElement((Element)what))) {
            return true;
        }
        return ((PackageElement)fromTopLevel.getEnclosingElement()).getQualifiedName().toString().contentEquals(((PackageElement)whatTopLevel.getEnclosingElement()).getQualifiedName());
    }

    static DialogDescriptor createDialogDescriptor(JComponent content, String label) {
        Object[] buttons = new JButton[2];
        buttons[0] = new JButton(NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_generate_button"));
        buttons[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorUtils.class, (String)"A11Y_Generate"));
        buttons[1] = new JButton(NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_cancel_button"));
        return new DialogDescriptor((Object)content, label, true, buttons, (Object)buttons[0], 0, null, null);
    }

    private static boolean overridesPackagePrivateOutsidePackage(ExecutableElement ee, TypeElement impl) {
        String elemPackageName = GeneratorUtils.getPackageName(ee);
        String currentPackageName = GeneratorUtils.getPackageName(impl);
        return !ee.getModifiers().contains((Object)Modifier.PRIVATE) && !ee.getModifiers().contains((Object)Modifier.PUBLIC) && !ee.getModifiers().contains((Object)Modifier.PROTECTED) && !currentPackageName.equals(elemPackageName);
    }

    private static String getPackageName(Element e) {
        while (e.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        return ((PackageElement)e.getEnclosingElement()).getQualifiedName().toString();
    }

    public static StringBuilder getCapitalizedName(CharSequence cs) {
        StringBuilder sb = new StringBuilder(cs);
        while (sb.length() > 1 && sb.charAt(0) == '_') {
            sb.deleteCharAt(0);
        }
        if (sb.length() > 1 && Character.isUpperCase(sb.charAt(1))) {
            return sb;
        }
        if (sb.length() > 0) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb;
    }

    public static void guardedCommit(JTextComponent component, ModificationResult mr) throws IOException {
        block2: {
            try {
                mr.commit();
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof GuardedException)) break block2;
                String message = NbBundle.getMessage(GeneratorUtils.class, (String)"ERR_CannotApplyGuarded");
                Utilities.setStatusBoldText((JTextComponent)component, (String)message);
                Logger.getLogger(GeneratorUtils.class.getName()).log(Level.FINE, null, e);
            }
        }
    }
}

