/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.ReferencesCount;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.editor.javadoc.JavadocImports;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;

public final class Utilities {
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";
    private static final String ERROR = "<error>";
    private static final String UNKNOWN = "<unknown>";
    private static boolean caseSensitive = true;
    private static boolean showDeprecatedMembers = true;
    private static boolean guessMethodArguments = true;
    private static boolean autoPopupOnJavaIdentifierPart = true;
    private static boolean javaCompletionExcluderMethods;
    private static String javaCompletionAutoPopupTriggers;
    private static String javaCompletionSelectors;
    private static String javadocCompletionAutoPopupTriggers;
    private static final AtomicBoolean inited;
    private static Preferences preferences;
    private static final PreferenceChangeListener preferencesTracker;
    private static String cachedPrefix;
    private static Pattern cachedPattern;
    private static final AtomicReference<Collection<String>> excludeRef;
    private static final AtomicReference<Collection<String>> includeRef;

    public static boolean startsWith(String theString, String prefix) {
        if (theString == null || theString.length() == 0 || ERROR.equals(theString)) {
            return false;
        }
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        return Utilities.isCaseSensitive() ? theString.startsWith(prefix) : theString.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
    }

    public static boolean startsWithCamelCase(String theString, String prefix) {
        if (theString == null || theString.length() == 0 || prefix == null || prefix.length() == 0) {
            return false;
        }
        if (!prefix.equals(cachedPrefix) || cachedPattern == null) {
            int index;
            StringBuilder sb = new StringBuilder();
            int lastIndex = 0;
            do {
                String token = prefix.substring(lastIndex, (index = Utilities.findNextUpper(prefix, lastIndex + 1)) == -1 ? prefix.length() : index);
                sb.append(token);
                sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                lastIndex = index;
            } while (index != -1);
            cachedPrefix = prefix;
            cachedPattern = Pattern.compile(sb.toString());
        }
        return cachedPattern.matcher(theString).matches();
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isCaseSensitive() {
        Utilities.lazyInit();
        return caseSensitive;
    }

    public static void setCaseSensitive(boolean b) {
        Utilities.lazyInit();
        caseSensitive = b;
    }

    public static boolean isShowDeprecatedMembers() {
        Utilities.lazyInit();
        return showDeprecatedMembers;
    }

    public static void setShowDeprecatedMembers(boolean b) {
        Utilities.lazyInit();
        showDeprecatedMembers = b;
    }

    public static boolean guessMethodArguments() {
        Utilities.lazyInit();
        return guessMethodArguments;
    }

    public static boolean autoPopupOnJavaIdentifierPart() {
        Utilities.lazyInit();
        return autoPopupOnJavaIdentifierPart;
    }

    public static String getJavaCompletionAutoPopupTriggers() {
        Utilities.lazyInit();
        return javaCompletionAutoPopupTriggers;
    }

    public static String getJavaCompletionSelectors() {
        Utilities.lazyInit();
        return javaCompletionSelectors;
    }

    public static String getJavadocCompletionAutoPopupTriggers() {
        Utilities.lazyInit();
        return javadocCompletionAutoPopupTriggers;
    }

    private static void updateExcluder(AtomicReference<Collection<String>> existing, String updated) {
        String[] entries;
        LinkedList<String> nue = new LinkedList<String>();
        if (updated == null || updated.length() == 0) {
            existing.set(nue);
            return;
        }
        for (String entry : entries = updated.split(",")) {
            if (entry.length() == 0) continue;
            nue.add(entry);
        }
        existing.set(nue);
    }

    public static boolean isExcludeMethods() {
        Utilities.lazyInit();
        return javaCompletionExcluderMethods;
    }

    public static boolean isExcluded(CharSequence fqn) {
        if (fqn == null || fqn.length() == 0) {
            return true;
        }
        Utilities.lazyInit();
        String s = ((Object)fqn).toString();
        Collection<String> include = includeRef.get();
        Collection<String> exclude = excludeRef.get();
        if (include != null && !include.isEmpty()) {
            for (String entry : include) {
                if (!(entry.length() > fqn.length() ? entry.startsWith(s) : s.startsWith(entry))) continue;
                return false;
            }
        }
        if (exclude != null && !exclude.isEmpty()) {
            for (String entry : exclude) {
                if (entry.length() > fqn.length() || !s.startsWith(entry)) continue;
                return true;
            }
        }
        return false;
    }

    private static void lazyInit() {
        if (inited.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)"text/x-java").lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferencesTracker, (Object)preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    public static int getImportanceLevel(ReferencesCount referencesCount, ElementHandle<TypeElement> handle) {
        int typeRefCount = 999 - Math.min(referencesCount.getTypeReferenceCount(handle), 999);
        int pkgRefCount = 999;
        String binaryName = SourceUtils.getJVMSignature(handle)[0];
        int idx = binaryName.lastIndexOf(46);
        if (idx > 0) {
            ElementHandle pkgElement = ElementHandle.createPackageElementHandle((String)binaryName.substring(0, idx));
            pkgRefCount -= Math.min(referencesCount.getPackageReferenceCount(pkgElement), 999);
        }
        return typeRefCount * 100000 + pkgRefCount * 100 + Utilities.getImportanceLevel(binaryName);
    }

    public static int getImportanceLevel(String fqn) {
        int weight = 50;
        if (fqn.startsWith("java.lang") || fqn.startsWith("java.util")) {
            weight -= 10;
        } else if (fqn.startsWith("org.omg") || fqn.startsWith("org.apache")) {
            weight += 10;
        } else if (fqn.startsWith("com.sun") || fqn.startsWith("com.ibm") || fqn.startsWith("com.apple")) {
            weight += 20;
        } else if (fqn.startsWith("sun") || fqn.startsWith("sunw") || fqn.startsWith("netscape")) {
            weight += 30;
        }
        return weight;
    }

    public static boolean hasAccessibleInnerClassConstructor(Element e, Scope scope, Trees trees) {
        DeclaredType dt = (DeclaredType)e.asType();
        for (TypeElement inner : ElementFilter.typesIn(e.getEnclosedElements())) {
            if (!trees.isAccessible(scope, inner, dt)) continue;
            DeclaredType innerType = (DeclaredType)inner.asType();
            for (ExecutableElement ctor : ElementFilter.constructorsIn(inner.getEnclosedElements())) {
                if (!trees.isAccessible(scope, ctor, innerType)) continue;
                return true;
            }
        }
        return false;
    }

    public static TreePath getPathElementOfKind(Tree.Kind kind, TreePath path) {
        return Utilities.getPathElementOfKind(EnumSet.of(kind), path);
    }

    public static TreePath getPathElementOfKind(Set<Tree.Kind> kinds, TreePath path) {
        while (path != null) {
            if (kinds.contains((Object)path.getLeaf().getKind())) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJavaContext(JTextComponent component, int offset, boolean allowInStrings) {
        Document doc = component.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            if (doc.getLength() == 0 && "text/x-dialog-binding".equals(doc.getProperty("mimeType"))) {
                LanguagePath path;
                InputAttributes attributes = (InputAttributes)doc.getProperty(InputAttributes.class);
                Document d = (Document)attributes.getValue(path = LanguagePath.get((Language)((Language)MimeLookup.getLookup((String)"text/x-dialog-binding").lookup(Language.class))), (Object)"dialogBinding.document");
                if (d != null) {
                    boolean bl = "text/x-java".equals(NbEditorUtilities.getMimeType((Document)d));
                    return bl;
                }
                FileObject fo = (FileObject)attributes.getValue(path, (Object)"dialogBinding.fileObject");
                boolean bl = "text/x-java".equals(fo.getMIMEType());
                return bl;
            }
            TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)offset);
            if (ts == null) {
                boolean bl = false;
                return bl;
            }
            if (!ts.moveNext() && !ts.movePrevious()) {
                boolean bl = true;
                return bl;
            }
            if (offset == ts.offset()) {
                boolean bl = true;
                return bl;
            }
            switch ((JavaTokenId)ts.token().id()) {
                case DOUBLE_LITERAL: 
                case FLOAT_LITERAL: 
                case FLOAT_LITERAL_INVALID: {
                    if (ts.token().text().charAt(0) == '.') break;
                }
                case CHAR_LITERAL: 
                case INT_LITERAL: 
                case INVALID_COMMENT_END: 
                case JAVADOC_COMMENT: 
                case LONG_LITERAL: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: {
                    boolean bl = false;
                    return bl;
                }
                case STRING_LITERAL: {
                    boolean bl = allowInStrings;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
    }

    @Deprecated
    public static CharSequence getTypeName(TypeMirror type, boolean fqn) {
        return Utilities.getTypeName(null, type, fqn, false);
    }

    @Deprecated
    public static CharSequence getTypeName(TypeMirror type, boolean fqn, boolean varArg) {
        return Utilities.getTypeName(null, type, fqn, varArg);
    }

    public static CharSequence getTypeName(CompilationInfo info, TypeMirror type, boolean fqn) {
        return Utilities.getTypeName(info, type, fqn, false);
    }

    public static CharSequence getTypeName(CompilationInfo info, TypeMirror type, boolean fqn, boolean varArg) {
        if (type == null) {
            return "";
        }
        return (CharSequence)new TypeNameVisitor(varArg).visit(type, fqn);
    }

    public static CharSequence getElementName(Element el, boolean fqn) {
        if (el == null || el.asType().getKind() == TypeKind.NONE) {
            return "";
        }
        return (CharSequence)new ElementNameVisitor().visit(el, fqn);
    }

    public static Collection<? extends Element> getForwardReferences(TreePath path, int pos, SourcePositions sourcePositions, Trees trees) {
        HashSet<Element> refs = new HashSet<Element>();
        while (path != null) {
            switch (path.getLeaf().getKind()) {
                case BLOCK: 
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return refs;
                }
                case VARIABLE: {
                    refs.add(trees.getElement(path));
                    TreePath parent = path.getParentPath();
                    if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getLeaf().getKind())) {
                        boolean isStatic = ((VariableTree)path.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC);
                        for (Tree tree : ((ClassTree)parent.getLeaf()).getMembers()) {
                            if (tree.getKind() != Tree.Kind.VARIABLE || sourcePositions.getStartPosition(path.getCompilationUnit(), tree) < (long)pos || !isStatic && ((VariableTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC)) continue;
                            refs.add(trees.getElement(new TreePath(parent, tree)));
                        }
                    }
                    return refs;
                }
                case ENHANCED_FOR_LOOP: {
                    EnhancedForLoopTree efl = (EnhancedForLoopTree)path.getLeaf();
                    if (sourcePositions.getEndPosition(path.getCompilationUnit(), efl.getExpression()) < (long)pos) break;
                    refs.add(trees.getElement(new TreePath(path, efl.getVariable())));
                }
            }
            path = path.getParentPath();
        }
        return refs;
    }

    public static List<String> varNamesSuggestions(TypeMirror type, String suggestedName, String prefix, Types types, Elements elements, Iterable<? extends Element> locals, boolean isConst) {
        List<String> vnct;
        ArrayList<String> result = new ArrayList<String>();
        if (type == null && suggestedName == null) {
            return result;
        }
        List<String> list = vnct = suggestedName != null ? Collections.singletonList(suggestedName) : Utilities.varNamesForType(type, types, elements, prefix);
        if (isConst) {
            ArrayList<String> ls = new ArrayList<String>(vnct.size());
            for (String s : vnct) {
                ls.add(Utilities.getConstName(s));
            }
            vnct = ls;
        }
        String p = prefix;
        while (p != null && p.length() > 0) {
            ArrayList<String> l = new ArrayList<String>();
            for (String name : vnct) {
                if (!Utilities.startsWith(name, p)) continue;
                l.add(name);
            }
            if (l.isEmpty()) {
                p = Utilities.nextName(p);
                continue;
            }
            vnct = l;
            prefix = prefix.substring(0, prefix.length() - p.length());
            p = null;
        }
        for (String name : vnct) {
            boolean isPrimitive;
            boolean bl = isPrimitive = type != null && type.getKind().isPrimitive();
            if (prefix != null && prefix.length() > 0) {
                name = isConst ? prefix.toUpperCase(Locale.ENGLISH) + '_' + name : prefix + name.toUpperCase(Locale.ENGLISH).charAt(0) + name.substring(1);
            }
            int cnt = 1;
            String baseName = name;
            while (Utilities.isClashing(name, type, locals)) {
                if (isPrimitive) {
                    char c = name.charAt(0);
                    c = (char)(c + '\u0001');
                    name = Character.toString(c);
                    if (c != 'z') continue;
                    isPrimitive = false;
                    continue;
                }
                name = baseName + cnt++;
            }
            result.add(name);
        }
        return result;
    }

    public static boolean inAnonymousOrLocalClass(TreePath path) {
        if (path == null) {
            return false;
        }
        TreePath parentPath = path.getParentPath();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()) && parentPath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)parentPath.getLeaf().getKind())) {
            return true;
        }
        return Utilities.inAnonymousOrLocalClass(parentPath);
    }

    public static Set<Element> getUsedElements(final CompilationInfo info) {
        final HashSet<Element> ret = new HashSet<Element>();
        final Trees trees = info.getTrees();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                this.addElement(trees.getElement(this.getCurrentPath()));
                return null;
            }

            @Override
            public Void visitClass(ClassTree node, Void p) {
                for (TypeElement element : JavadocImports.computeReferencedElements(info, this.getCurrentPath())) {
                    this.addElement(element);
                }
                return (Void)super.visitClass(node, p);
            }

            @Override
            public Void visitMethod(MethodTree node, Void p) {
                for (TypeElement element : JavadocImports.computeReferencedElements(info, this.getCurrentPath())) {
                    this.addElement(element);
                }
                return (Void)super.visitMethod(node, p);
            }

            @Override
            public Void visitVariable(VariableTree node, Void p) {
                for (TypeElement element : JavadocImports.computeReferencedElements(info, this.getCurrentPath())) {
                    this.addElement(element);
                }
                return (Void)super.visitVariable(node, p);
            }

            @Override
            public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
                this.scan(node.getPackageAnnotations(), p);
                return (Void)this.scan(node.getTypeDecls(), p);
            }

            private void addElement(Element element) {
                if (element != null) {
                    ret.add(element);
                }
            }
        }.scan(info.getCompilationUnit(), null);
        return ret;
    }

    private static List<String> varNamesForType(TypeMirror type, Types types, Elements elements, String prefix) {
        switch (type.getKind()) {
            case ARRAY: {
                TypeElement iterableTE = elements.getTypeElement("java.lang.Iterable");
                DeclaredType iterable = iterableTE != null ? types.getDeclaredType(iterableTE, new TypeMirror[0]) : null;
                TypeMirror ct = ((ArrayType)type).getComponentType();
                if (ct.getKind() == TypeKind.ARRAY && iterable != null && types.isSubtype(ct, iterable)) {
                    return Utilities.varNamesForType(ct, types, elements, prefix);
                }
                ArrayList<String> vnct = new ArrayList<String>();
                for (String name : Utilities.varNamesForType(ct, types, elements, prefix)) {
                    vnct.add(name.endsWith("s") ? name + "es" : name + "s");
                }
                return vnct;
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return Collections.singletonList(((Object)type).toString().substring(0, 1));
            }
            case TYPEVAR: {
                return Collections.singletonList(((Object)type).toString().toLowerCase(Locale.ENGLISH));
            }
            case ERROR: {
                String tn = ((ErrorType)type).asElement().getSimpleName().toString();
                if (tn.toUpperCase(Locale.ENGLISH).contentEquals(tn)) {
                    return Collections.singletonList(tn.toLowerCase(Locale.ENGLISH));
                }
                StringBuilder sb = new StringBuilder();
                ArrayList<String> al = new ArrayList<String>();
                if ("Iterator".equals(tn)) {
                    al.add("it");
                }
                while ((tn = Utilities.nextName(tn)).length() > 0) {
                    al.add(tn);
                    sb.append(tn.charAt(0));
                }
                if (sb.length() > 0) {
                    String s = sb.toString();
                    if (prefix == null || prefix.length() == 0 || s.startsWith(prefix)) {
                        al.add(s);
                    }
                }
                return al;
            }
            case DECLARED: {
                List<? extends TypeMirror> tas;
                TypeElement iterableTE = elements.getTypeElement("java.lang.Iterable");
                DeclaredType iterable = iterableTE != null ? types.getDeclaredType(iterableTE, new TypeMirror[0]) : null;
                String tn = ((DeclaredType)type).asElement().getSimpleName().toString();
                if (tn.toUpperCase(Locale.ENGLISH).contentEquals(tn)) {
                    return Collections.singletonList(tn.toLowerCase(Locale.ENGLISH));
                }
                StringBuilder sb = new StringBuilder();
                ArrayList<String> al = new ArrayList<String>();
                if ("Iterator".equals(tn)) {
                    al.add("it");
                }
                while ((tn = Utilities.nextName(tn)).length() > 0) {
                    al.add(tn);
                    sb.append(tn.charAt(0));
                }
                if (iterable != null && types.isSubtype(type, iterable) && (tas = ((DeclaredType)type).getTypeArguments()).size() > 0) {
                    TypeMirror et = tas.get(0);
                    if (et.getKind() == TypeKind.ARRAY || et.getKind() != TypeKind.WILDCARD && types.isSubtype(et, iterable)) {
                        al.addAll(Utilities.varNamesForType(et, types, elements, prefix));
                    } else {
                        for (String name : Utilities.varNamesForType(et, types, elements, prefix)) {
                            al.add(name.endsWith("s") ? name + "es" : name + "s");
                        }
                    }
                }
                if (sb.length() > 0) {
                    String s = sb.toString();
                    if (prefix == null || prefix.length() == 0 || s.startsWith(prefix)) {
                        al.add(s);
                    }
                }
                return al;
            }
            case WILDCARD: {
                TypeMirror bound = ((WildcardType)type).getExtendsBound();
                if (bound == null) {
                    bound = ((WildcardType)type).getSuperBound();
                }
                if (bound == null) break;
                return Utilities.varNamesForType(bound, types, elements, prefix);
            }
        }
        return Collections.emptyList();
    }

    private static String getConstName(String s) {
        StringBuilder sb = new StringBuilder();
        boolean prevUpper = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!prevUpper) {
                    sb.append('_');
                }
                sb.append(c);
                prevUpper = true;
                continue;
            }
            sb.append(Character.toUpperCase(c));
            prevUpper = false;
        }
        return sb.toString();
    }

    private static String nextName(CharSequence name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            char lc = Character.toLowerCase(c);
            sb.append(lc);
            sb.append(name.subSequence(i + 1, name.length()));
            break;
        }
        return sb.toString();
    }

    private static boolean isClashing(String varName, TypeMirror type, Iterable<? extends Element> locals) {
        if (JavaTokenContext.getKeyword((String)varName) != null) {
            return true;
        }
        if (type != null && type.getKind() == TypeKind.DECLARED && ((DeclaredType)type).asElement().getSimpleName().contentEquals(varName)) {
            return true;
        }
        for (Element element : locals) {
            if (!element.getKind().isField() && element.getKind() != ElementKind.LOCAL_VARIABLE && element.getKind() != ElementKind.RESOURCE_VARIABLE && element.getKind() != ElementKind.PARAMETER && element.getKind() != ElementKind.EXCEPTION_PARAMETER || !varName.contentEquals(element.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    public static TypeMirror resolveCapturedType(CompilationInfo info, TypeMirror tm) {
        TypeMirror type = Utilities.resolveCapturedTypeInt(info, tm);
        if (type.getKind() == TypeKind.WILDCARD) {
            TypeMirror tmirr = ((WildcardType)type).getExtendsBound();
            if (tmirr != null) {
                return tmirr;
            }
            return info.getElements().getTypeElement("java.lang.Object").asType();
        }
        return type;
    }

    private static TypeMirror resolveCapturedTypeInt(CompilationInfo info, TypeMirror tm) {
        WildcardType orig = SourceUtils.resolveCapturedType((TypeMirror)tm);
        if (orig != null) {
            TypeMirror extendsBound;
            WildcardType rct;
            if (orig.getKind() == TypeKind.WILDCARD && (rct = SourceUtils.resolveCapturedType((TypeMirror)((extendsBound = orig.getExtendsBound()) != null ? extendsBound : orig.getSuperBound()))) != null) {
                return rct;
            }
            return orig;
        }
        if (tm.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)tm;
            LinkedList<TypeMirror> typeArguments = new LinkedList<TypeMirror>();
            for (TypeMirror typeMirror : dt.getTypeArguments()) {
                typeArguments.add(Utilities.resolveCapturedTypeInt(info, typeMirror));
            }
            TypeMirror enclosingType = dt.getEnclosingType();
            if (enclosingType.getKind() == TypeKind.DECLARED) {
                return info.getTypes().getDeclaredType((DeclaredType)enclosingType, (TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
            }
            return info.getTypes().getDeclaredType((TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
        }
        if (tm.getKind() == TypeKind.ARRAY) {
            ArrayType at = (ArrayType)tm;
            return info.getTypes().getArrayType(Utilities.resolveCapturedTypeInt(info, at.getComponentType()));
        }
        return tm;
    }

    /*
     * WARNING - void declaration
     */
    public static ExecutableElement fuzzyResolveMethodInvocation(CompilationInfo info, TreePath path, TypeMirror[] proposed, int[] index) {
        assert (path.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION || path.getLeaf().getKind() == Tree.Kind.NEW_CLASS);
        if (path.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION) {
            void var7_13;
            String methodName;
            LinkedList<TypeMirror> actualTypes = new LinkedList<TypeMirror>();
            MethodInvocationTree mit = (MethodInvocationTree)path.getLeaf();
            for (ExpressionTree expressionTree : mit.getArguments()) {
                TreePath tp = new TreePath(path, expressionTree);
                actualTypes.add(info.getTrees().getTypeMirror(tp));
            }
            switch (mit.getMethodSelect().getKind()) {
                case IDENTIFIER: {
                    Scope s = info.getTrees().getScope(path);
                    TypeElement enclosingClass = s.getEnclosingClass();
                    TypeMirror typeMirror = enclosingClass != null ? enclosingClass.asType() : null;
                    methodName = ((IdentifierTree)mit.getMethodSelect()).getName().toString();
                    break;
                }
                case MEMBER_SELECT: {
                    TypeMirror typeMirror = info.getTrees().getTypeMirror(new TreePath(path, ((MemberSelectTree)mit.getMethodSelect()).getExpression()));
                    methodName = ((MemberSelectTree)mit.getMethodSelect()).getIdentifier().toString();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (var7_13 == null || var7_13.getKind() != TypeKind.DECLARED) {
                return null;
            }
            return Utilities.resolveMethod(info, actualTypes, (DeclaredType)var7_13, false, false, methodName, proposed, index);
        }
        if (path.getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
            LinkedList<TypeMirror> actualTypes = new LinkedList<TypeMirror>();
            NewClassTree nct = (NewClassTree)path.getLeaf();
            for (ExpressionTree expressionTree : nct.getArguments()) {
                TreePath tp = new TreePath(path, expressionTree);
                actualTypes.add(info.getTrees().getTypeMirror(tp));
            }
            TypeMirror on = info.getTrees().getTypeMirror(new TreePath(path, nct.getIdentifier()));
            if (on == null || on.getKind() != TypeKind.DECLARED) {
                return null;
            }
            return Utilities.resolveMethod(info, actualTypes, (DeclaredType)on, false, true, null, proposed, index);
        }
        return null;
    }

    private static Iterable<ExecutableElement> execsIn(CompilationInfo info, TypeElement e, boolean constr, String name) {
        if (constr) {
            return ElementFilter.constructorsIn(info.getElements().getAllMembers(e));
        }
        LinkedList<ExecutableElement> result = new LinkedList<ExecutableElement>();
        for (ExecutableElement ee : ElementFilter.methodsIn(info.getElements().getAllMembers(e))) {
            if (!name.equals(ee.getSimpleName().toString())) continue;
            result.add(ee);
        }
        return result;
    }

    private static ExecutableElement resolveMethod(CompilationInfo info, List<TypeMirror> foundTypes, DeclaredType on, boolean statik, boolean constr, String name, TypeMirror[] candidateType, int[] index) {
        ExecutableElement found = null;
        block0: for (ExecutableElement ee : Utilities.execsIn(info, (TypeElement)on.asElement(), constr, name)) {
            TypeMirror currType = ((TypeElement)ee.getEnclosingElement()).asType();
            if (!info.getTypes().isSubtype(on, currType) && !((Object)on.asElement()).equals(((DeclaredType)currType).asElement()) || ee.getParameters().size() != foundTypes.size()) continue;
            TypeMirror innerCandidate = null;
            int innerIndex = -1;
            ExecutableType et = (ExecutableType)info.getTypes().asMemberOf(on, ee);
            Iterator<? extends TypeMirror> formal = et.getParameterTypes().iterator();
            Iterator<TypeMirror> actual = foundTypes.iterator();
            boolean mismatchFound = false;
            int i = 0;
            while (formal.hasNext() && actual.hasNext()) {
                TypeMirror currentFormal = formal.next();
                TypeMirror currentActual = actual.next();
                if (!info.getTypes().isAssignable(currentActual, currentFormal) || currentActual.getKind() == TypeKind.ERROR) {
                    if (mismatchFound) continue block0;
                    mismatchFound = true;
                    innerCandidate = currentFormal;
                    innerIndex = i;
                }
                ++i;
            }
            if (!mismatchFound) continue;
            if (candidateType[0] == null) {
                candidateType[0] = innerCandidate;
                index[0] = innerIndex;
                found = ee;
                continue;
            }
            if (index[0] == innerIndex && info.getTypes().isSameType(candidateType[0], innerCandidate)) continue;
            return null;
        }
        return found;
    }

    private Utilities() {
    }

    static {
        javaCompletionAutoPopupTriggers = null;
        javaCompletionSelectors = null;
        javadocCompletionAutoPopupTriggers = null;
        inited = new AtomicBoolean(false);
        preferencesTracker = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String settingName;
                String string = settingName = evt == null ? null : evt.getKey();
                if (settingName == null || "completion-case-sensitive".equals(settingName)) {
                    caseSensitive = preferences.getBoolean("completion-case-sensitive", false);
                }
                if (settingName == null || "show-deprecated-members".equals(settingName)) {
                    showDeprecatedMembers = preferences.getBoolean("show-deprecated-members", true);
                }
                if (settingName == null || "guessMethodArguments".equals(settingName)) {
                    guessMethodArguments = preferences.getBoolean("guessMethodArguments", true);
                }
                if (settingName == null || "javaAutoPopupOnIdentifierPart".equals(settingName)) {
                    autoPopupOnJavaIdentifierPart = preferences.getBoolean("javaAutoPopupOnIdentifierPart", false);
                }
                if (settingName == null || "javaAutoCompletionTriggers".equals(settingName)) {
                    javaCompletionAutoPopupTriggers = preferences.get("javaAutoCompletionTriggers", ".");
                }
                if (settingName == null || "javaCompletionSelectors".equals(settingName)) {
                    javaCompletionSelectors = preferences.get("javaCompletionSelectors", ".,;:([+-=");
                }
                if (settingName == null || "javadocAutoCompletionTriggers".equals(settingName)) {
                    javadocCompletionAutoPopupTriggers = preferences.get("javadocAutoCompletionTriggers", ".#@");
                }
                if (settingName == null || "javaCompletionBlacklist".equals(settingName)) {
                    String blacklist = preferences.get("javaCompletionBlacklist", "");
                    Utilities.updateExcluder(excludeRef, blacklist);
                }
                if (settingName == null || "javaCompletionWhitelist".equals(settingName)) {
                    String whitelist = preferences.get("javaCompletionWhitelist", "");
                    Utilities.updateExcluder(includeRef, whitelist);
                }
                if (settingName == null || "javaCompletionExcluderMethods".equals(settingName)) {
                    javaCompletionExcluderMethods = preferences.getBoolean("javaCompletionExcluderMethods", false);
                }
            }
        };
        cachedPrefix = null;
        cachedPattern = null;
        excludeRef = new AtomicReference();
        includeRef = new AtomicReference();
    }

    private static class ElementNameVisitor
    extends SimpleElementVisitor6<StringBuilder, Boolean> {
        private ElementNameVisitor() {
            super(new StringBuilder());
        }

        @Override
        public StringBuilder visitPackage(PackageElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }

        @Override
        public StringBuilder visitType(TypeElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }
    }

    private static class TypeNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Boolean> {
        private boolean varArg;
        private boolean insideCapturedWildcard = false;

        private TypeNameVisitor(boolean varArg) {
            super(new StringBuilder());
            this.varArg = varArg;
        }

        @Override
        public StringBuilder defaultAction(TypeMirror t, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(t);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
                Iterator<? extends TypeMirror> it = t.getTypeArguments().iterator();
                if (it.hasNext()) {
                    ((StringBuilder)this.DEFAULT_VALUE).append("<");
                    while (it.hasNext()) {
                        this.visit(it.next(), p);
                        if (!it.hasNext()) continue;
                        ((StringBuilder)this.DEFAULT_VALUE).append(", ");
                    }
                    ((StringBuilder)this.DEFAULT_VALUE).append(">");
                }
                return (StringBuilder)this.DEFAULT_VALUE;
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(Utilities.UNKNOWN);
        }

        @Override
        public StringBuilder visitUnion(UnionType t, Boolean p) {
            Iterator<? extends TypeMirror> it = t.getAlternatives().iterator();
            while (it.hasNext()) {
                this.visit(it.next(), p);
                if (!it.hasNext()) continue;
                ((StringBuilder)this.DEFAULT_VALUE).append(" | ");
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitArray(ArrayType t, Boolean p) {
            boolean isVarArg = this.varArg;
            this.varArg = false;
            this.visit(t.getComponentType(), p);
            return ((StringBuilder)this.DEFAULT_VALUE).append(isVarArg ? "..." : "[]");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable t, Boolean p) {
            String name;
            Element e = t.asElement();
            if (e != null && !Utilities.CAPTURED_WILDCARD.equals(name = e.getSimpleName().toString())) {
                return ((StringBuilder)this.DEFAULT_VALUE).append(name);
            }
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            if (!this.insideCapturedWildcard) {
                this.insideCapturedWildcard = true;
                TypeMirror bound = t.getLowerBound();
                if (bound != null && bound.getKind() != TypeKind.NULL) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                    this.visit(bound, p);
                } else {
                    bound = t.getUpperBound();
                    if (bound != null && bound.getKind() != TypeKind.NULL) {
                        ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                        if (bound.getKind() == TypeKind.TYPEVAR) {
                            bound = ((TypeVariable)bound).getLowerBound();
                        }
                        this.visit(bound, p);
                    }
                }
                this.insideCapturedWildcard = false;
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType t, Boolean p) {
            int len = ((StringBuilder)this.DEFAULT_VALUE).length();
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror bound = t.getSuperBound();
            if (bound == null) {
                bound = t.getExtendsBound();
                if (bound != null) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (bound.getKind() == TypeKind.WILDCARD) {
                        bound = ((WildcardType)bound).getSuperBound();
                    }
                    this.visit(bound, p);
                } else if (!(len != 0 || (bound = SourceUtils.getBound((WildcardType)t)) == null || bound.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)bound).asElement()).getQualifiedName().contentEquals("java.lang.Object"))) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    this.visit(bound, p);
                }
            } else {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(bound, p);
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitError(ErrorType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }
    }
}

