/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ReferencesCount;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.whitelist.WhiteListQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.java.AutoImport;
import org.netbeans.modules.editor.java.JavaCompletionProvider;
import org.netbeans.modules.editor.java.LazySortText;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public abstract class JavaCompletionItem
implements CompletionItem {
    protected static int SMART_TYPE = 1000;
    private static final String GENERATE_TEXT = NbBundle.getMessage(JavaCompletionItem.class, (String)"generate_Lbl");
    private static final Logger LOGGER = Logger.getLogger(JavaCompletionItem.class.getName());
    public static final String COLOR_END = "</font>";
    public static final String STRIKE = "<s>";
    public static final String STRIKE_END = "</s>";
    public static final String BOLD = "<b>";
    public static final String BOLD_END = "</b>";
    protected int substitutionOffset;
    private static final int PUBLIC_LEVEL = 3;
    private static final int PROTECTED_LEVEL = 2;
    private static final int PACKAGE_LEVEL = 1;
    private static final int PRIVATE_LEVEL = 0;

    public static final JavaCompletionItem createKeywordItem(String kwd, String postfix, int substitutionOffset, boolean smartType) {
        return new KeywordItem(kwd, 0, postfix, substitutionOffset, smartType);
    }

    public static final JavaCompletionItem createPackageItem(String pkgFQN, int substitutionOffset, boolean inPackageStatement) {
        return new PackageItem(pkgFQN, substitutionOffset, inPackageStatement);
    }

    public static final JavaCompletionItem createTypeItem(CompilationInfo info, TypeElement elem, DeclaredType type, int substitutionOffset, ReferencesCount referencesCount, boolean isDeprecated, boolean insideNew, boolean addTypeVars, boolean addSimpleName, boolean smartType, boolean autoImport, WhiteListQuery.WhiteList whiteList) {
        switch (elem.getKind()) {
            case CLASS: {
                return new ClassItem(info, elem, type, 0, substitutionOffset, referencesCount, isDeprecated, insideNew, addTypeVars, addSimpleName, smartType, autoImport, whiteList);
            }
            case INTERFACE: {
                return new InterfaceItem(info, elem, type, 0, substitutionOffset, referencesCount, isDeprecated, insideNew, addTypeVars, addSimpleName, smartType, autoImport, whiteList);
            }
            case ENUM: {
                return new EnumItem(info, elem, type, 0, substitutionOffset, referencesCount, isDeprecated, insideNew, addSimpleName, smartType, autoImport, whiteList);
            }
            case ANNOTATION_TYPE: {
                return new AnnotationTypeItem(info, elem, type, 0, substitutionOffset, referencesCount, isDeprecated, insideNew, addSimpleName, smartType, autoImport, whiteList);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)elem.getKind()));
    }

    public static final JavaCompletionItem createArrayItem(CompilationInfo info, ArrayType type, int substitutionOffset, ReferencesCount referencesCount, Elements elements, WhiteListQuery.WhiteList whiteList) {
        int dim = 0;
        TypeMirror tm = type;
        while (tm.getKind() == TypeKind.ARRAY) {
            tm = tm.getComponentType();
            ++dim;
        }
        if (tm.getKind().isPrimitive()) {
            return new KeywordItem(((Object)tm).toString(), dim, null, substitutionOffset, true);
        }
        if (tm.getKind() == TypeKind.DECLARED || tm.getKind() == TypeKind.ERROR) {
            DeclaredType dt = (DeclaredType)tm;
            TypeElement elem = (TypeElement)dt.asElement();
            switch (elem.getKind()) {
                case CLASS: {
                    return new ClassItem(info, elem, dt, dim, substitutionOffset, referencesCount, elements.isDeprecated(elem), false, false, false, true, false, whiteList);
                }
                case INTERFACE: {
                    return new InterfaceItem(info, elem, dt, dim, substitutionOffset, referencesCount, elements.isDeprecated(elem), false, false, false, true, false, whiteList);
                }
                case ENUM: {
                    return new EnumItem(info, elem, dt, dim, substitutionOffset, referencesCount, elements.isDeprecated(elem), false, false, true, false, whiteList);
                }
                case ANNOTATION_TYPE: {
                    return new AnnotationTypeItem(info, elem, dt, dim, substitutionOffset, referencesCount, elements.isDeprecated(elem), false, false, true, false, whiteList);
                }
            }
        }
        throw new IllegalArgumentException("array element kind=" + (Object)((Object)tm.getKind()));
    }

    public static final JavaCompletionItem createTypeParameterItem(TypeParameterElement elem, int substitutionOffset) {
        return new TypeParameterItem(elem, substitutionOffset);
    }

    public static final JavaCompletionItem createVariableItem(CompilationInfo info, VariableElement elem, TypeMirror type, int substitutionOffset, ReferencesCount referencesCount, boolean isInherited, boolean isDeprecated, boolean smartType, int assignToVarPos, WhiteListQuery.WhiteList whiteList) {
        switch (elem.getKind()) {
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: 
            case PARAMETER: 
            case EXCEPTION_PARAMETER: {
                return new VariableItem(info, type, elem.getSimpleName().toString(), substitutionOffset, false, smartType, assignToVarPos);
            }
            case ENUM_CONSTANT: 
            case FIELD: {
                return new FieldItem(info, elem, type, substitutionOffset, referencesCount, isInherited, isDeprecated, smartType, assignToVarPos, whiteList);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)elem.getKind()));
    }

    public static final JavaCompletionItem createVariableItem(CompilationInfo info, String varName, int substitutionOffset, boolean newVarName, boolean smartType) {
        return new VariableItem(info, null, varName, substitutionOffset, newVarName, smartType, -1);
    }

    public static final JavaCompletionItem createExecutableItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, ReferencesCount referencesCount, boolean isInherited, boolean isDeprecated, boolean inImport, boolean addSemicolon, boolean smartType, int assignToVarPos, WhiteListQuery.WhiteList whiteList) {
        switch (elem.getKind()) {
            case METHOD: {
                return new MethodItem(info, elem, type, substitutionOffset, referencesCount, isInherited, isDeprecated, inImport, addSemicolon, smartType, assignToVarPos, whiteList);
            }
            case CONSTRUCTOR: {
                return new ConstructorItem(info, elem, type, substitutionOffset, isDeprecated, smartType, null, whiteList);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)elem.getKind()));
    }

    public static final JavaCompletionItem createThisOrSuperConstructorItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated, String name, WhiteListQuery.WhiteList whiteList) {
        if (elem.getKind() == ElementKind.CONSTRUCTOR) {
            return new ConstructorItem(info, elem, type, substitutionOffset, isDeprecated, false, name, whiteList);
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)elem.getKind()));
    }

    public static final JavaCompletionItem createOverrideMethodItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean implement, WhiteListQuery.WhiteList whiteList) {
        switch (elem.getKind()) {
            case METHOD: {
                return new OverrideMethodItem(info, elem, type, substitutionOffset, implement, whiteList);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)elem.getKind()));
    }

    public static final JavaCompletionItem createGetterSetterMethodItem(CompilationInfo info, VariableElement elem, TypeMirror type, int substitutionOffset, boolean setter) {
        switch (elem.getKind()) {
            case ENUM_CONSTANT: 
            case FIELD: {
                return new GetterSetterMethodItem(info, elem, type, substitutionOffset, setter);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)elem.getKind()));
    }

    public static final JavaCompletionItem createDefaultConstructorItem(TypeElement elem, int substitutionOffset, boolean smartType) {
        return new DefaultConstructorItem(elem, substitutionOffset, smartType);
    }

    public static final JavaCompletionItem createParametersItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated, int activeParamIndex, String name) {
        return new ParametersItem(info, elem, type, substitutionOffset, isDeprecated, activeParamIndex, name);
    }

    public static final JavaCompletionItem createAnnotationItem(CompilationInfo info, TypeElement elem, DeclaredType type, int substitutionOffset, ReferencesCount referencesCount, boolean isDeprecated, WhiteListQuery.WhiteList whiteList) {
        return new AnnotationItem(info, elem, type, substitutionOffset, referencesCount, isDeprecated, true, whiteList);
    }

    public static final JavaCompletionItem createAttributeItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated) {
        return new AttributeItem(info, elem, type, substitutionOffset, isDeprecated);
    }

    public static final JavaCompletionItem createAttributeValueItem(CompilationInfo info, String value, String documentation, TypeElement element, int substitutionOffset, ReferencesCount referencesCount, WhiteListQuery.WhiteList whiteList) {
        return new AttributeValueItem(info, value, documentation, element, substitutionOffset, referencesCount, whiteList);
    }

    public static final JavaCompletionItem createStaticMemberItem(CompilationInfo info, DeclaredType type, Element memberElem, TypeMirror memberType, int substitutionOffset, boolean isDeprecated, WhiteListQuery.WhiteList whiteList) {
        switch (memberElem.getKind()) {
            case ENUM_CONSTANT: 
            case FIELD: 
            case METHOD: {
                return new StaticMemberItem(info, type, memberElem, memberType, substitutionOffset, isDeprecated, whiteList);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)memberElem.getKind()));
    }

    public static final JavaCompletionItem createInitializeAllConstructorItem(CompilationInfo info, Iterable<? extends VariableElement> fields, ExecutableElement superConstructor, TypeElement parent, int substitutionOffset) {
        return new InitializeAllConstructorItem(info, fields, superConstructor, parent, substitutionOffset);
    }

    protected JavaCompletionItem(int substitutionOffset) {
        this.substitutionOffset = substitutionOffset;
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, null, false);
        }
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 400) {
            if (!(Utilities.autoPopupOnJavaIdentifierPart() && this instanceof VariableItem && ((VariableItem)this).newVarName || Utilities.getJavaCompletionSelectors().indexOf(evt.getKeyChar()) < 0 || ' ' == evt.getKeyChar() && (evt.getModifiers() & 2) != 0)) {
                if (!(evt.getKeyChar() != '(' || this instanceof AnnotationItem || this instanceof ConstructorItem || this instanceof DefaultConstructorItem || this instanceof MethodItem || this instanceof GetterSetterMethodItem || this instanceof InitializeAllConstructorItem || this instanceof OverrideMethodItem || this instanceof StaticMemberItem)) {
                    return;
                }
                Completion.get().hideDocumentation();
                if (Utilities.getJavaCompletionAutoPopupTriggers().indexOf(evt.getKeyChar()) < 0) {
                    Completion.get().hideCompletion();
                }
                JTextComponent component = (JTextComponent)evt.getSource();
                int caretOffset = component.getSelectionEnd();
                this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, Character.toString(evt.getKeyChar()), false);
                evt.consume();
            }
        } else if (evt.getID() == 401 && evt.getKeyCode() == 10 && (evt.getModifiers() & 2) > 0) {
            JTextComponent component = (JTextComponent)evt.getSource();
            int caretOffset = component.getSelectionEnd();
            Document doc = component.getDocument();
            TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)caretOffset);
            if (ts != null && (ts.moveNext() || ts.movePrevious()) && (ts.token().id() == JavaTokenId.IDENTIFIER || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("keyword") || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("string"))) {
                try {
                    doc.remove(caretOffset, ts.offset() + ts.token().length() - caretOffset);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else if (evt.getID() == 401 && evt.getKeyCode() == 10 && (evt.getModifiers() & 8) > 0) {
            JTextComponent component = (JTextComponent)evt.getSource();
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, null, true);
            evt.consume();
        }
    }

    public boolean instantSubstitution(JTextComponent component) {
        if (component != null) {
            try {
                int caretOffset = component.getSelectionEnd();
                if (caretOffset > this.substitutionOffset) {
                    String text = component.getDocument().getText(this.substitutionOffset, caretOffset - this.substitutionOffset);
                    if (!((Object)this.getInsertPrefix()).toString().startsWith(text)) {
                        return false;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.defaultAction(component);
        return true;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    protected ImageIcon getIcon() {
        return null;
    }

    protected String getLeftHtmlText() {
        return null;
    }

    protected String getRightHtmlText() {
        return null;
    }

    protected void substituteText(final JTextComponent c, final int offset, int len, String toAdd, boolean assignToVar) {
        int semiPos;
        final BaseDocument doc = (BaseDocument)c.getDocument();
        CharSequence prefix = this.getInsertPrefix();
        if (prefix == null) {
            return;
        }
        final StringBuilder text = new StringBuilder(prefix);
        int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
        if (semiPos > -2) {
            String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
        }
        if (toAdd != null && !toAdd.equals("\n")) {
            TokenSequence sequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)(offset + len));
            if (sequence == null || !sequence.moveNext() && !sequence.movePrevious()) {
                text.append(toAdd);
                toAdd = null;
            }
            boolean added = false;
            while (toAdd != null && toAdd.length() > 0) {
                String tokenText = ((Object)sequence.token().text()).toString();
                if (tokenText.startsWith(toAdd)) {
                    len = sequence.offset() - offset + toAdd.length();
                    text.append(toAdd);
                    toAdd = null;
                    continue;
                }
                if (toAdd.startsWith(tokenText)) {
                    sequence.moveNext();
                    len = sequence.offset() - offset;
                    text.append(toAdd.substring(0, tokenText.length()));
                    toAdd = toAdd.substring(tokenText.length());
                    added = true;
                    continue;
                }
                if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                    if (sequence.moveNext()) continue;
                    text.append(toAdd);
                    toAdd = null;
                    continue;
                }
                if (!added) {
                    text.append(toAdd);
                }
                toAdd = null;
            }
        }
        final int length = len;
        doc.runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    String textToReplace = doc.getText(offset, length);
                    Position position = doc.createPosition(offset);
                    if (textToReplace.contentEquals(text)) {
                        if (semiPos > -1) {
                            doc.insertString(semiPos, ";", null);
                        } else {
                            c.setCaretPosition(offset + length);
                        }
                        return;
                    }
                    Position semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                    doc.remove(position.getOffset(), length);
                    doc.insertString(position.getOffset(), text.toString(), null);
                    if (semiPosition != null) {
                        doc.insertString(semiPosition.getOffset(), ";", null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private static int getProtectionLevel(Set<Modifier> modifiers) {
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return 3;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return 2;
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return 0;
        }
        return 1;
    }

    private static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private static int findPositionForSemicolon(JTextComponent c) {
        final int[] ret = new int[]{-2};
        final int offset = c.getSelectionEnd();
        final Source s = Source.create((Document)c.getDocument());
        final AtomicBoolean cancel = new AtomicBoolean();
        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ParserManager.parse(Collections.singletonList(s), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            TreePath tp;
                            if (cancel.get()) {
                                return;
                            }
                            CompilationController controller = CompilationController.get((Parser.Result)resultIterator.getParserResult(offset));
                            controller.toPhase(JavaSource.Phase.PARSED);
                            if (cancel.get()) {
                                return;
                            }
                            int embeddedOffset = controller.getSnapshot().getEmbeddedOffset(offset);
                            Tree t = null;
                            block5: for (tp = controller.getTreeUtilities().pathFor(embeddedOffset); t == null && tp != null; tp = tp.getParentPath()) {
                                switch (tp.getLeaf().getKind()) {
                                    case EXPRESSION_STATEMENT: 
                                    case IMPORT: {
                                        t = tp.getLeaf();
                                        continue block5;
                                    }
                                    case RETURN: {
                                        t = ((ReturnTree)tp.getLeaf()).getExpression();
                                        continue block5;
                                    }
                                    case THROW: {
                                        t = ((ThrowTree)tp.getLeaf()).getExpression();
                                    }
                                }
                            }
                            if (t != null) {
                                SourcePositions sp = controller.getTrees().getSourcePositions();
                                int endPos = (int)sp.getEndPosition(tp.getCompilationUnit(), t);
                                TokenSequence ts = JavaCompletionItem.findLastNonWhitespaceToken((CompilationInfo)controller, embeddedOffset, endPos);
                                if (ts != null) {
                                    ret[0] = ts.token().id() == JavaTokenId.SEMICOLON ? -1 : (ts.moveNext() ? (ts.token().id() == JavaTokenId.LINE_COMMENT || ts.token().id() == JavaTokenId.WHITESPACE && ((Object)ts.token().text()).toString().contains("\n") ? ts.offset() : offset) : ts.offset() + ts.token().length());
                                }
                            } else {
                                TokenSequence ts = controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                                ts.move(embeddedOffset);
                                if (ts.moveNext() && ts.token().id() == JavaTokenId.SEMICOLON) {
                                    ret[0] = -1;
                                }
                            }
                        }
                    });
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }, (String)NbBundle.getMessage(JavaCompletionItem.class, (String)"JCI-find_semicolon_pos"), (AtomicBoolean)cancel, (boolean)false);
        return ret[0];
    }

    private static TokenSequence<JavaTokenId> findLastNonWhitespaceToken(CompilationInfo info, int startPos, int endPos) {
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(endPos);
        block3: while (ts.movePrevious()) {
            int offset = ts.offset();
            if (offset < startPos) {
                return null;
            }
            switch ((JavaTokenId)ts.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    continue block3;
                }
            }
            return ts;
        }
        return null;
    }

    private static String getAssignToVarText(CompilationInfo info, TypeMirror type, String name) {
        name = JavaCompletionItem.adjustName(name);
        StringBuilder sb = new StringBuilder();
        sb.append("${TYPE type=\"");
        sb.append(Utilities.getTypeName(info, type, true));
        sb.append("\" default=\"");
        sb.append(Utilities.getTypeName(info, type, false));
        sb.append("\" editable=false}");
        sb.append(" ${NAME newVarName=\"");
        sb.append(name);
        sb.append("\" default=\"");
        sb.append(name);
        sb.append("\"} = ");
        return sb.toString();
    }

    private static String adjustName(String name) {
        if (name == null) {
            return null;
        }
        String shortName = null;
        if (name.startsWith("get") && name.length() > 3) {
            shortName = name.substring(3);
        }
        if (name.startsWith("is") && name.length() > 2) {
            shortName = name.substring(2);
        }
        if (shortName != null) {
            return JavaCompletionItem.firstToLower(shortName);
        }
        if (SourceVersion.isKeyword(name)) {
            return "a" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    private static String firstToLower(String name) {
        if (name.length() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean toLower = true;
        char last = Character.toLowerCase(name.charAt(0));
        for (int i = 1; i < name.length(); ++i) {
            if (toLower && Character.isUpperCase(name.charAt(i))) {
                result.append(Character.toLowerCase(last));
            } else {
                result.append(last);
                toLower = false;
            }
            last = name.charAt(i);
        }
        result.append(last);
        if (SourceVersion.isKeyword(result)) {
            return "a" + name;
        }
        return result.toString();
    }

    static class AnnotationItem
    extends AnnotationTypeItem {
        private AnnotationItem(CompilationInfo info, TypeElement elem, DeclaredType type, int substitutionOffset, ReferencesCount referencesCount, boolean isDeprecated, boolean smartType, WhiteListQuery.WhiteList whiteList) {
            super(info, elem, type, 0, substitutionOffset, referencesCount, isDeprecated, false, false, smartType, false, whiteList);
        }

        @Override
        public CharSequence getInsertPrefix() {
            return "@" + super.getInsertPrefix();
        }

        protected void substituteText(JTextComponent c, final int offset, int len, String toAdd) {
            int semiPos;
            final BaseDocument doc = (BaseDocument)c.getDocument();
            final StringBuilder text = new StringBuilder();
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if (toAdd != null && !toAdd.equals("\n")) {
                TokenSequence sequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)(offset + len));
                if (sequence == null || !sequence.moveNext() && !sequence.movePrevious()) {
                    text.append(toAdd);
                    toAdd = null;
                }
                boolean added = false;
                while (toAdd != null && toAdd.length() > 0) {
                    String tokenText = ((Object)sequence.token().text()).toString();
                    if (tokenText.startsWith(toAdd)) {
                        len = sequence.offset() - offset + toAdd.length();
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (toAdd.startsWith(tokenText)) {
                        sequence.moveNext();
                        len = sequence.offset() - offset;
                        text.append(toAdd.substring(0, tokenText.length()));
                        toAdd = toAdd.substring(tokenText.length());
                        added = true;
                        continue;
                    }
                    if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                        if (sequence.moveNext()) continue;
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (!added) {
                        text.append(toAdd);
                    }
                    toAdd = null;
                }
            }
            final int finalLen = len;
            final Source s = Source.create((Document)doc);
            final AtomicBoolean cancel = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ParserManager.parse(Collections.singletonList(s), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                if (cancel.get()) {
                                    return;
                                }
                                final CompilationController controller = CompilationController.get((Parser.Result)resultIterator.getParserResult(offset));
                                controller.toPhase(JavaSource.Phase.RESOLVED);
                                if (cancel.get()) {
                                    return;
                                }
                                final int embeddedOffset = controller.getSnapshot().getEmbeddedOffset(offset);
                                final DeclaredType type = (DeclaredType)AnnotationItem.this.typeHandle.resolve((CompilationInfo)controller);
                                doc.runAtomic(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            Position semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                                            TreePath tp = controller.getTreeUtilities().pathFor(embeddedOffset);
                                            text.insert(0, "@" + AutoImport.resolveImport((CompilationInfo)controller, tp, type));
                                            String textToReplace = doc.getText(offset, finalLen);
                                            if (textToReplace.contentEquals(text)) {
                                                return;
                                            }
                                            Position pos = doc.createPosition(offset);
                                            doc.remove(pos.getOffset(), finalLen);
                                            doc.insertString(pos.getOffset(), text.toString(), null);
                                            if (semiPosition != null) {
                                                doc.insertString(semiPosition.getOffset(), ";", null);
                                            }
                                        }
                                        catch (BadLocationException badLocationException) {
                                            // empty catch block
                                        }
                                    }
                                });
                            }
                        });
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }, (String)NbBundle.getMessage(JavaCompletionItem.class, (String)"JCI-import_resolve"), (AtomicBoolean)cancel, (boolean)false);
        }
    }

    static class AnnotationTypeItem
    extends ClassItem {
        private static final String ANNOTATION = "org/netbeans/modules/editor/resources/completion/annotation_type.png";
        private static ImageIcon icon;

        private AnnotationTypeItem(CompilationInfo info, TypeElement elem, DeclaredType type, int dim, int substitutionOffset, ReferencesCount referencesCount, boolean isDeprecated, boolean insideNew, boolean addSimpleName, boolean smartType, boolean autoImport, WhiteListQuery.WhiteList whiteList) {
            super(info, elem, type, dim, substitutionOffset, referencesCount, isDeprecated, insideNew, false, addSimpleName, smartType, autoImport, whiteList);
        }

        @Override
        protected ImageIcon getBaseIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)ANNOTATION, (boolean)false);
            }
            return icon;
        }
    }

    static class AttributeItem
    extends JavaCompletionItem {
        private static final String ATTRIBUTE = "org/netbeans/modules/java/editor/resources/attribute_16.png";
        private static final String ATTRIBUTE_COLOR = "<font color=#404040>";
        private static ImageIcon icon;
        private ElementHandle<ExecutableElement> elementHandle;
        private boolean isDeprecated;
        private String simpleName;
        private String typeName;
        private String defaultValue;
        private String leftText;
        private String rightText;

        private AttributeItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated) {
            super(substitutionOffset);
            this.elementHandle = ElementHandle.create((Element)elem);
            this.isDeprecated = isDeprecated;
            this.simpleName = elem.getSimpleName().toString();
            this.typeName = ((Object)Utilities.getTypeName(info, type.getReturnType(), false)).toString();
            AnnotationValue value = elem.getDefaultValue();
            this.defaultValue = value != null ? ((Object)value).toString() : null;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.simpleName;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)ATTRIBUTE, (boolean)false);
            }
            return icon;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(ATTRIBUTE_COLOR);
                if (this.defaultValue == null) {
                    sb.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    sb.append(JavaCompletionItem.STRIKE);
                }
                sb.append(this.simpleName);
                if (this.isDeprecated) {
                    sb.append(JavaCompletionItem.STRIKE_END);
                }
                if (this.defaultValue == null) {
                    sb.append(JavaCompletionItem.BOLD_END);
                } else {
                    sb.append(" = ");
                    sb.append(this.defaultValue);
                }
                sb.append(JavaCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        @Override
        protected void substituteText(JTextComponent c, int offset, int len, String toAdd, boolean assignToVar) {
            super.substituteText(c, offset, len, toAdd != null ? toAdd : "=", assignToVar);
        }

        public String toString() {
            return this.simpleName;
        }
    }

    static class AttributeValueItem
    extends WhiteListJavaCompletionItem<TypeElement> {
        private static final String ATTRIBUTE_VALUE = "org/netbeans/modules/java/editor/resources/attribute_value_16.png";
        private static final String ATTRIBUTE_VALUE_COLOR = "<font color=#404040>";
        private static ImageIcon icon;
        private JavaCompletionItem delegate;
        private String value;
        private boolean quoteAdded;
        private String documentation;
        private String leftText;

        private AttributeValueItem(CompilationInfo info, String value, String documentation, TypeElement element, int substitutionOffset, ReferencesCount referencesCount, WhiteListQuery.WhiteList whiteList) {
            super(substitutionOffset, element != null ? ElementHandle.create((Element)element) : null, whiteList);
            if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) != '\"') {
                value = value + '\"';
                this.quoteAdded = true;
            } else {
                this.quoteAdded = false;
            }
            this.value = value;
            this.documentation = documentation;
            if (element != null) {
                this.delegate = AttributeValueItem.createTypeItem(info, element, (DeclaredType)element.asType(), substitutionOffset, referencesCount, false, false, false, false, false, false, this.getWhiteList());
            }
        }

        public int getSortPriority() {
            return -SMART_TYPE;
        }

        public CharSequence getSortText() {
            return this.delegate != null ? this.delegate.getSortText() : this.value;
        }

        public CharSequence getInsertPrefix() {
            return this.delegate != null ? this.delegate.getInsertPrefix() : this.value;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return this.documentation == null ? null : new CompletionTask(){
                private CompletionDocumentation cd = new CompletionDocumentation(){

                    public String getText() {
                        return AttributeValueItem.this.documentation;
                    }

                    public URL getURL() {
                        return null;
                    }

                    public CompletionDocumentation resolveLink(String link) {
                        return null;
                    }

                    public Action getGotoSourceAction() {
                        return null;
                    }
                };

                public void query(CompletionResultSet resultSet) {
                    resultSet.setDocumentation(this.cd);
                    resultSet.finish();
                }

                public void refresh(CompletionResultSet resultSet) {
                    resultSet.setDocumentation(this.cd);
                    resultSet.finish();
                }

                public void cancel() {
                }
            };
        }

        @Override
        protected ImageIcon getBaseIcon() {
            if (this.delegate != null) {
                return this.delegate.getIcon();
            }
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)ATTRIBUTE_VALUE, (boolean)false);
            }
            return icon;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                if (this.delegate != null) {
                    this.leftText = this.delegate.getLeftHtmlText();
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append(ATTRIBUTE_VALUE_COLOR);
                    sb.append(this.value);
                    sb.append(JavaCompletionItem.COLOR_END);
                    this.leftText = sb.toString();
                }
            }
            return this.leftText;
        }

        @Override
        protected void substituteText(JTextComponent c, int offset, int len, String toAdd, boolean assignToVar) {
            if (this.delegate != null) {
                toAdd = toAdd == null || ".".equals(toAdd) ? ".class" : ".class" + toAdd;
                this.delegate.substituteText(c, offset, len, toAdd, assignToVar);
            } else {
                TokenSequence sequence;
                if (toAdd == null && this.value.charAt(this.value.length() - 1) == '\"' && (sequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)c.getDocument()), (int)(offset + len))) != null && sequence.moveNext() && sequence.token().id() == JavaTokenId.STRING_LITERAL && sequence.token().length() == len + 1) {
                    ++len;
                }
                super.substituteText(c, offset, len, toAdd, assignToVar);
                if (toAdd == null && this.quoteAdded) {
                    c.setCaretPosition(c.getCaretPosition() - 1);
                }
            }
        }

        public String toString() {
            return this.value;
        }
    }

    static class ClassItem
    extends WhiteListJavaCompletionItem<TypeElement> {
        private static final String CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png";
        private static final String CLASS_COLOR = "<font color=#560000>";
        private static final String PKG_COLOR = "<font color=#808080>";
        private static ImageIcon icon;
        protected TypeMirrorHandle<DeclaredType> typeHandle;
        private int dim;
        private boolean isDeprecated;
        private boolean insideNew;
        private boolean addTypeVars;
        private boolean addSimpleName;
        private boolean smartType;
        private String simpleName;
        private String typeName;
        private String enclName;
        private CharSequence sortText;
        private String leftText;
        private boolean autoImport;

        private ClassItem(CompilationInfo info, TypeElement elem, DeclaredType type, int dim, int substitutionOffset, ReferencesCount referencesCount, boolean isDeprecated, boolean insideNew, boolean addTypeVars, boolean addSimpleName, boolean smartType, boolean autoImport, WhiteListQuery.WhiteList whiteList) {
            super(substitutionOffset, ElementHandle.create((Element)elem), whiteList);
            this.typeHandle = TypeMirrorHandle.create((TypeMirror)type);
            this.dim = dim;
            this.isDeprecated = isDeprecated;
            this.insideNew = insideNew;
            this.addTypeVars = addTypeVars;
            this.addSimpleName = addSimpleName;
            this.smartType = smartType;
            this.simpleName = elem.getSimpleName().toString();
            this.typeName = ((Object)Utilities.getTypeName(info, type, false)).toString();
            if (referencesCount != null) {
                this.enclName = ((Object)Utilities.getElementName(elem.getEnclosingElement(), true)).toString();
                this.sortText = new LazySortText(this.simpleName, this.enclName, this.getElementHandle(), referencesCount);
            } else {
                this.enclName = null;
                this.sortText = this.simpleName;
            }
            this.autoImport = autoImport;
        }

        public int getSortPriority() {
            return this.smartType ? 800 - SMART_TYPE : 800;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return this.typeHandle.getKind() == TypeKind.DECLARED ? JavaCompletionProvider.createDocTask(ElementHandle.from(this.typeHandle)) : null;
        }

        @Override
        protected ImageIcon getBaseIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)CLASS, (boolean)false);
            }
            return icon;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getColor());
                if (this.isDeprecated || this.isBlackListed()) {
                    sb.append(JavaCompletionItem.STRIKE);
                }
                sb.append(JavaCompletionItem.escape(this.typeName));
                for (int i = 0; i < this.dim; ++i) {
                    sb.append("[]");
                }
                if (this.isDeprecated || this.isBlackListed()) {
                    sb.append(JavaCompletionItem.STRIKE_END);
                }
                if (this.enclName != null && this.enclName.length() > 0) {
                    sb.append(JavaCompletionItem.COLOR_END);
                    sb.append(PKG_COLOR);
                    sb.append(" (");
                    sb.append(this.enclName);
                    sb.append(")");
                }
                sb.append(JavaCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        protected String getColor() {
            return CLASS_COLOR;
        }

        @Override
        protected void substituteText(final JTextComponent c, final int offset, int len, String toAdd, final boolean assignToVar) {
            int semiPos;
            final BaseDocument doc = (BaseDocument)c.getDocument();
            final StringBuilder text = new StringBuilder();
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if (toAdd != null && !toAdd.equals("\n")) {
                TokenSequence sequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)(offset + len));
                if (sequence == null || !sequence.moveNext() && !sequence.movePrevious()) {
                    text.append(toAdd);
                    toAdd = null;
                }
                boolean added = false;
                while (toAdd != null && toAdd.length() > 0) {
                    String tokenText = ((Object)sequence.token().text()).toString();
                    if (tokenText.startsWith(toAdd)) {
                        len = sequence.offset() - offset + toAdd.length();
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (toAdd.startsWith(tokenText)) {
                        sequence.moveNext();
                        len = sequence.offset() - offset;
                        text.append(toAdd.substring(0, tokenText.length()));
                        toAdd = toAdd.substring(tokenText.length());
                        added = true;
                        continue;
                    }
                    if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                        if (sequence.moveNext()) continue;
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (!added) {
                        text.append(toAdd);
                    }
                    toAdd = null;
                }
            }
            final int finalLen = len;
            final Source s = Source.create((Document)doc);
            final AtomicBoolean cancel = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        CodeTemplateManager ctm;
                        final StringBuilder template = new StringBuilder();
                        ParserManager.parse(Collections.singletonList(s), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                if (cancel.get()) {
                                    return;
                                }
                                final CompilationController controller = CompilationController.get((Parser.Result)resultIterator.getParserResult(offset));
                                controller.toPhase(JavaSource.Phase.RESOLVED);
                                if (cancel.get()) {
                                    return;
                                }
                                final int embeddedOffset = controller.getSnapshot().getEmbeddedOffset(offset);
                                DeclaredType type = (DeclaredType)ClassItem.this.typeHandle.resolve((CompilationInfo)controller);
                                final TypeElement elem = type != null ? (TypeElement)type.asElement() : null;
                                boolean asTemplate = false;
                                StringBuilder sb = new StringBuilder();
                                if (elem != null) {
                                    Iterator<? extends TypeMirror> tas;
                                    int cnt = 1;
                                    if (ClassItem.this.addSimpleName) {
                                        sb.append(elem.getSimpleName());
                                    } else {
                                        sb.append("${PAR");
                                        sb.append(cnt++);
                                        if ((type == null || type.getKind() != TypeKind.ERROR) && EnumSet.range(ElementKind.PACKAGE, ElementKind.INTERFACE).contains((Object)elem.getEnclosingElement().getKind())) {
                                            sb.append(" type=\"");
                                            sb.append(elem.getQualifiedName());
                                            sb.append("\" default=\"");
                                            sb.append(elem.getSimpleName());
                                        } else {
                                            sb.append(" default=\"");
                                            sb.append(elem.getQualifiedName());
                                        }
                                        sb.append("\" editable=false}");
                                    }
                                    Iterator<? extends TypeMirror> iterator = tas = type != null ? type.getTypeArguments().iterator() : null;
                                    if (tas != null && tas.hasNext()) {
                                        sb.append('<');
                                        if (!ClassItem.this.insideNew || elem.getModifiers().contains((Object)Modifier.ABSTRACT) || controller.getSourceVersion().compareTo(SourceVersion.RELEASE_7) < 0) {
                                            while (tas.hasNext()) {
                                                TypeMirror ta = tas.next();
                                                sb.append("${PAR");
                                                sb.append(cnt++);
                                                if (ta.getKind() == TypeKind.TYPEVAR) {
                                                    TypeVariable tv = (TypeVariable)ta;
                                                    if (ClassItem.this.smartType || elem != tv.asElement().getEnclosingElement()) {
                                                        sb.append(" editable=false default=\"");
                                                        sb.append(Utilities.getTypeName((CompilationInfo)controller, ta, true));
                                                        asTemplate = true;
                                                    } else {
                                                        sb.append(" typeVar=\"");
                                                        sb.append(tv.asElement().getSimpleName());
                                                        sb.append("\" type=\"");
                                                        ta = tv.getUpperBound();
                                                        sb.append(Utilities.getTypeName((CompilationInfo)controller, ta, true));
                                                        sb.append("\" default=\"");
                                                        sb.append(Utilities.getTypeName((CompilationInfo)controller, ta, false));
                                                        if (ClassItem.this.addTypeVars && SourceVersion.RELEASE_5.compareTo(controller.getSourceVersion()) <= 0) {
                                                            asTemplate = true;
                                                        }
                                                    }
                                                    sb.append("\"}");
                                                } else if (ta.getKind() == TypeKind.WILDCARD) {
                                                    sb.append(" type=\"");
                                                    TypeMirror bound = ((WildcardType)ta).getExtendsBound();
                                                    if (bound == null) {
                                                        bound = ((WildcardType)ta).getSuperBound();
                                                    }
                                                    sb.append(bound != null ? Utilities.getTypeName((CompilationInfo)controller, bound, true) : "Object");
                                                    sb.append("\" default=\"");
                                                    sb.append(bound != null ? Utilities.getTypeName((CompilationInfo)controller, bound, false) : "Object");
                                                    sb.append("\"}");
                                                    asTemplate = true;
                                                } else if (ta.getKind() == TypeKind.ERROR) {
                                                    sb.append(" default=\"");
                                                    sb.append(((ErrorType)ta).asElement().getSimpleName());
                                                    sb.append("\"}");
                                                    asTemplate = true;
                                                } else {
                                                    sb.append(" type=\"");
                                                    sb.append(Utilities.getTypeName((CompilationInfo)controller, ta, true));
                                                    sb.append("\" default=\"");
                                                    sb.append(Utilities.getTypeName((CompilationInfo)controller, ta, false));
                                                    sb.append("\" editable=false}");
                                                    asTemplate = true;
                                                }
                                                if (!tas.hasNext()) continue;
                                                sb.append(", ");
                                            }
                                        } else {
                                            asTemplate = true;
                                        }
                                        sb.append('>');
                                    }
                                    for (int i = 0; i < ClassItem.this.dim; ++i) {
                                        sb.append("[${PAR");
                                        sb.append(cnt++);
                                        sb.append(" instanceof=\"int\" default=\"\"}]");
                                        asTemplate = true;
                                    }
                                }
                                if (asTemplate) {
                                    if (ClassItem.this.insideNew) {
                                        sb.append("${cursor completionInvoke}");
                                    }
                                    if (finalLen > 0) {
                                        doc.runAtomic(new Runnable(){

                                            @Override
                                            public void run() {
                                                try {
                                                    doc.remove(offset, finalLen);
                                                }
                                                catch (BadLocationException badLocationException) {
                                                    // empty catch block
                                                }
                                            }
                                        });
                                    }
                                    if (ClassItem.this.autoImport && elem != null) {
                                        AutoImport.resolveImport((CompilationInfo)controller, controller.getTreeUtilities().pathFor(embeddedOffset), elem.getEnclosingElement().asType());
                                    }
                                    sb.append((CharSequence)text);
                                    template.append((CharSequence)sb);
                                } else {
                                    doc.runAtomic(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                CharSequence cs;
                                                Position semiPosition = semiPos > -1 && !ClassItem.this.insideNew ? doc.createPosition(semiPos) : null;
                                                TreePath tp = controller.getTreeUtilities().pathFor(embeddedOffset);
                                                CharSequence charSequence = ClassItem.this.enclName == null ? (elem != null ? elem.getSimpleName() : ClassItem.this.simpleName) : (cs = AutoImport.resolveImport((CompilationInfo)controller, tp, controller.getTypes().getDeclaredType(elem, new TypeMirror[0])));
                                                if (!ClassItem.this.insideNew) {
                                                    cs = text.insert(0, cs);
                                                }
                                                String textToReplace = doc.getText(offset, finalLen);
                                                Position pos = doc.createPosition(offset);
                                                if (textToReplace.contentEquals(cs)) {
                                                    return;
                                                }
                                                doc.remove(offset, finalLen);
                                                doc.insertString(pos.getOffset(), ((Object)cs).toString(), null);
                                                if (semiPosition != null) {
                                                    doc.insertString(semiPosition.getOffset(), ";", null);
                                                }
                                            }
                                            catch (BadLocationException badLocationException) {
                                                // empty catch block
                                            }
                                        }
                                    });
                                    if (ClassItem.this.autoImport && elem != null) {
                                        AutoImport.resolveImport((CompilationInfo)controller, controller.getTreeUtilities().pathFor(embeddedOffset), elem.getEnclosingElement().asType());
                                    }
                                    if (ClassItem.this.insideNew && type != null && type.getKind() == TypeKind.DECLARED) {
                                        ExecutableElement ctor = null;
                                        Trees trees = controller.getTrees();
                                        Scope scope = controller.getTreeUtilities().scopeFor(embeddedOffset);
                                        int val = 0;
                                        for (ExecutableElement ee : ElementFilter.constructorsIn(elem.getEnclosedElements())) {
                                            if (trees.isAccessible(scope, ee, type)) {
                                                if (ctor != null) {
                                                    val = 2;
                                                    break;
                                                }
                                                ctor = ee;
                                            }
                                            val = 1;
                                        }
                                        if (val != 1 || ctor != null) {
                                            final JavaCompletionItem item = val == 0 ? JavaCompletionItem.createDefaultConstructorItem(elem, offset, true) : (val == 2 || Utilities.hasAccessibleInnerClassConstructor(elem, scope, trees) ? null : JavaCompletionItem.createExecutableItem((CompilationInfo)controller, ctor, (ExecutableType)controller.getTypes().asMemberOf(type, ctor), offset, null, false, false, false, false, true, -1, ClassItem.this.getWhiteList()));
                                            try {
                                                final Position offPosition = doc.createPosition(offset);
                                                SwingUtilities.invokeLater(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        if (item != null) {
                                                            item.substituteText(c, offPosition.getOffset(), c.getSelectionEnd() - offPosition.getOffset(), text.toString(), assignToVar);
                                                        } else {
                                                            SwingUtilities.invokeLater(new Runnable(){

                                                                @Override
                                                                public void run() {
                                                                    Completion.get().showCompletion();
                                                                }
                                                            });
                                                        }
                                                    }
                                                });
                                            }
                                            catch (BadLocationException e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                }
                            }
                        });
                        CodeTemplateManager codeTemplateManager = ctm = template.length() > 0 ? CodeTemplateManager.get((Document)doc) : null;
                        if (ctm != null) {
                            ctm.createTemporary(template.toString()).insert(c);
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }, (String)NbBundle.getMessage(JavaCompletionItem.class, (String)"JCI-import_resolve"), (AtomicBoolean)cancel, (boolean)false);
        }

        public String toString() {
            return this.simpleName;
        }
    }

    static class ConstructorItem
    extends WhiteListJavaCompletionItem<ExecutableElement> {
        private static final String CONSTRUCTOR_PUBLIC = "org/netbeans/modules/editor/resources/completion/constructor_16.png";
        private static final String CONSTRUCTOR_PROTECTED = "org/netbeans/modules/editor/resources/completion/constructor_protected_16.png";
        private static final String CONSTRUCTOR_PACKAGE = "org/netbeans/modules/editor/resources/completion/constructor_package_private_16.png";
        private static final String CONSTRUCTOR_PRIVATE = "org/netbeans/modules/editor/resources/completion/constructor_private_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon[] icon = new ImageIcon[4];
        private boolean isDeprecated;
        private boolean smartType;
        private String simpleName;
        protected Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private boolean isAbstract;
        private boolean insertName;
        private String sortText;
        private String leftText;

        private ConstructorItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated, boolean smartType, String name, WhiteListQuery.WhiteList whiteList) {
            super(substitutionOffset, ElementHandle.create((Element)elem), whiteList);
            TypeMirror tm;
            this.isDeprecated = isDeprecated;
            this.smartType = smartType;
            this.simpleName = name != null ? name : elem.getEnclosingElement().getSimpleName().toString();
            this.insertName = name != null;
            this.modifiers = elem.getModifiers();
            this.params = new ArrayList<ParamDesc>();
            Iterator<? extends VariableElement> it = elem.getParameters().iterator();
            Iterator<? extends TypeMirror> tIt = type.getParameterTypes().iterator();
            while (it.hasNext() && tIt.hasNext() && (tm = tIt.next()) != null) {
                this.params.add(new ParamDesc(((Object)tm).toString(), ((Object)Utilities.getTypeName(info, tm, false, elem.isVarArgs() && !tIt.hasNext())).toString(), it.next().getSimpleName().toString()));
            }
            this.isAbstract = !this.insertName && elem.getEnclosingElement().getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        public int getSortPriority() {
            return this.insertName ? 550 : (this.smartType ? 650 - SMART_TYPE : 650);
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder sortParams = new StringBuilder();
                sortParams.append('(');
                int cnt = 0;
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    sortParams.append(paramDesc.typeName);
                    if (it.hasNext()) {
                        sortParams.append(',');
                    }
                    ++cnt;
                }
                sortParams.append(')');
                this.sortText = this.simpleName + "#" + (cnt < 10 ? "0" : "") + cnt + "#" + sortParams.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder lText = new StringBuilder();
                lText.append(CONSTRUCTOR_COLOR);
                lText.append(JavaCompletionItem.BOLD);
                if (this.isDeprecated || this.isBlackListed()) {
                    lText.append(JavaCompletionItem.STRIKE);
                }
                lText.append(this.simpleName);
                if (this.isDeprecated || this.isBlackListed()) {
                    lText.append(JavaCompletionItem.STRIKE_END);
                }
                lText.append(JavaCompletionItem.BOLD_END);
                lText.append(JavaCompletionItem.COLOR_END);
                lText.append('(');
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    lText.append(JavaCompletionItem.escape(paramDesc.typeName));
                    lText.append(' ');
                    lText.append(PARAMETER_NAME_COLOR);
                    lText.append(paramDesc.name);
                    lText.append(JavaCompletionItem.COLOR_END);
                    if (!it.hasNext()) continue;
                    lText.append(", ");
                }
                lText.append(')');
                this.leftText = lText.toString();
            }
            return this.leftText;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.getElementHandle());
        }

        @Override
        protected ImageIcon getBaseIcon() {
            ImageIcon newIcon;
            int level = JavaCompletionItem.getProtectionLevel(this.modifiers);
            ImageIcon cachedIcon = icon[level];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            String iconPath = CONSTRUCTOR_PUBLIC;
            switch (level) {
                case 0: {
                    iconPath = CONSTRUCTOR_PRIVATE;
                    break;
                }
                case 1: {
                    iconPath = CONSTRUCTOR_PACKAGE;
                    break;
                }
                case 2: {
                    iconPath = CONSTRUCTOR_PROTECTED;
                    break;
                }
                case 3: {
                    iconPath = CONSTRUCTOR_PUBLIC;
                }
            }
            ConstructorItem.icon[level] = newIcon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
            return newIcon;
        }

        @Override
        protected void substituteText(final JTextComponent c, int offset, int len, String toAdd, boolean assignToVar) {
            CodeTemplateManager ctm;
            String text;
            String add;
            BaseDocument doc;
            TokenSequence sequence;
            int semiPos;
            if (!this.insertName) {
                offset += len;
                len = 0;
            }
            final boolean lpar = "(".equals(toAdd);
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if ((sequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)(doc = (BaseDocument)c.getDocument())), (int)offset)) == null || !sequence.moveNext() && !sequence.movePrevious()) {
                sequence.movePrevious();
                if (sequence.token().id() == JavaTokenId.THIS || sequence.token().id() == JavaTokenId.SUPER) {
                    this.isAbstract = false;
                    if (toAdd == null) {
                        toAdd = ";";
                    }
                }
                sequence.moveNext();
            }
            String string = add = this.isAbstract ? "() {}" : "()";
            if (toAdd != null && !add.startsWith(toAdd)) {
                add = add + toAdd;
            } else {
                toAdd = null;
            }
            String string2 = text = CodeStyle.getDefault((Document)doc).spaceBeforeMethodCallParen() ? " " : "";
            if (sequence == null) {
                text = text + add;
                add = null;
            }
            boolean added = false;
            while (add != null && add.length() > 0) {
                String tokenText = ((Object)sequence.token().text()).toString();
                if (tokenText.startsWith(add)) {
                    len = sequence.offset() - offset + add.length();
                    text = text + add;
                    add = null;
                    continue;
                }
                if (add.startsWith(tokenText)) {
                    sequence.moveNext();
                    len = sequence.offset() - offset;
                    text = text + add.substring(0, tokenText.length());
                    add = add.substring(tokenText.length());
                    added = true;
                    continue;
                }
                if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                    if (sequence.moveNext()) continue;
                    text = text + add;
                    add = null;
                    continue;
                }
                if (!added) {
                    text = text + add;
                }
                add = null;
            }
            final String text2 = text;
            final int length = len;
            final int offset2 = offset;
            final Position[] position = new Position[1];
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        String newText;
                        Position semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                        String textToReplace = doc.getText(offset2, length);
                        String string = newText = ConstructorItem.this.insertName ? ConstructorItem.this.simpleName + text2 : text2;
                        if (!textToReplace.contentEquals(newText)) {
                            doc.remove(offset2, length);
                            doc.insertString(offset2, newText, null);
                        }
                        c.setCaretPosition(offset2 + newText.length());
                        position[0] = doc.createPosition(offset2 + newText.indexOf(40));
                        if (semiPosition != null) {
                            doc.insertString(semiPosition.getOffset(), ";", null);
                        } else if (!ConstructorItem.this.isAbstract && ConstructorItem.this.params.isEmpty() && lpar) {
                            c.setCaretPosition(c.getCaretPosition() - 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            if (this.isAbstract && text.length() > 3) {
                try {
                    final int off = offset + text.indexOf(123) + 1;
                    ModificationResult mr = ModificationResult.runModificationTask(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                            copy.toPhase(JavaSource.Phase.RESOLVED);
                            int embeddedOffset = copy.getSnapshot().getEmbeddedOffset(off);
                            TreePath path = copy.getTreeUtilities().pathFor(embeddedOffset);
                            while (path.getLeaf() != path.getCompilationUnit()) {
                                Tree tree = path.getLeaf();
                                Tree parentTree = path.getParentPath().getLeaf();
                                if (parentTree.getKind() == Tree.Kind.NEW_CLASS && TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
                                    GeneratorUtils.generateAllAbstractMethodImplementations(copy, path);
                                    break;
                                }
                                path = path.getParentPath();
                            }
                        }
                    });
                    GeneratorUtils.guardedCommit(c, mr);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
            }
            text = text.trim();
            if (!this.params.isEmpty() && text.length() > 1 && (ctm = CodeTemplateManager.get((Document)doc)) != null) {
                if (position[0] != null) {
                    offset = position[0].getOffset();
                }
                if (toAdd == null) {
                    toAdd = "";
                }
                if (text.startsWith("()" + toAdd)) {
                    c.select(offset, offset + toAdd.length() + 2);
                } else if (text.startsWith("()")) {
                    c.select(offset, offset + 2);
                } else {
                    c.setCaretPosition(offset);
                }
                StringBuilder sb = new StringBuilder();
                boolean guessArgs = Utilities.guessMethodArguments();
                sb.append("(");
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    sb.append("${");
                    sb.append(paramDesc.name);
                    if (guessArgs) {
                        sb.append(" named instanceof=");
                        sb.append(paramDesc.fullTypeName);
                    }
                    sb.append("}");
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(")");
                sb.append(toAdd);
                ctm.createTemporary(sb.toString()).insert(c);
                Completion.get().showToolTip();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : this.modifiers) {
                sb.append(mod.toString());
                sb.append(' ');
            }
            sb.append(this.simpleName);
            sb.append('(');
            Iterator<ParamDesc> it = this.params.iterator();
            while (it.hasNext()) {
                ParamDesc paramDesc = it.next();
                sb.append(paramDesc.typeName);
                sb.append(' ');
                sb.append(paramDesc.name);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(')');
            return sb.toString();
        }
    }

    static class DefaultConstructorItem
    extends JavaCompletionItem {
        private static final String CONSTRUCTOR = "org/netbeans/modules/java/editor/resources/new_constructor_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static ImageIcon icon;
        private boolean smartType;
        private String simpleName;
        private boolean isAbstract;
        private String sortText;
        private String leftText;

        private DefaultConstructorItem(TypeElement elem, int substitutionOffset, boolean smartType) {
            super(substitutionOffset);
            this.smartType = smartType;
            this.simpleName = elem.getSimpleName().toString();
            this.isAbstract = elem.getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public int getSortPriority() {
            return this.smartType ? 650 - SMART_TYPE : 650;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                this.sortText = this.simpleName + "#0#";
            }
            return this.sortText;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = CONSTRUCTOR_COLOR + this.simpleName + "()" + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)CONSTRUCTOR, (boolean)false);
            }
            return icon;
        }

        @Override
        protected void substituteText(final JTextComponent c, int offset, int len, String toAdd, boolean assignToVar) {
            String text;
            String add;
            BaseDocument doc;
            TokenSequence sequence;
            int semiPos;
            final boolean lpar = "(".equals(toAdd);
            final int[] offset2 = new int[]{offset + len};
            len = 0;
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if ((sequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)(doc = (BaseDocument)c.getDocument())), (int)offset2[0])) == null || !sequence.moveNext() && !sequence.movePrevious()) {
                sequence.movePrevious();
                if (sequence.token().id() == JavaTokenId.THIS || sequence.token().id() == JavaTokenId.SUPER) {
                    this.isAbstract = false;
                    if (toAdd == null) {
                        toAdd = ";";
                    }
                }
                sequence.moveNext();
            }
            String string = add = this.isAbstract ? "() {}" : "()";
            if (toAdd != null && !add.startsWith(toAdd)) {
                add = add + toAdd;
            }
            String string2 = text = CodeStyle.getDefault((Document)doc).spaceBeforeMethodCallParen() ? " " : "";
            if (sequence == null) {
                text = text + add;
                add = null;
            }
            boolean added = false;
            while (add != null && add.length() > 0) {
                String tokenText = ((Object)sequence.token().text()).toString();
                if (tokenText.startsWith(add)) {
                    len = sequence.offset() - offset2[0] + add.length();
                    text = text + add;
                    add = null;
                    continue;
                }
                if (add.startsWith(tokenText)) {
                    sequence.moveNext();
                    len = sequence.offset() - offset2[0];
                    text = text + add.substring(0, tokenText.length());
                    add = add.substring(tokenText.length());
                    added = true;
                    continue;
                }
                if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                    if (sequence.moveNext()) continue;
                    text = text + add;
                    add = null;
                    continue;
                }
                if (!added) {
                    text = text + add;
                }
                add = null;
            }
            final Position[] position = new Position[1];
            final String text2 = text;
            final int length = len;
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        position[0] = doc.createPosition(offset2[0]);
                        Position semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                        doc.remove(offset2[0], length);
                        offset2[0] = position[0].getOffset();
                        doc.insertString(offset2[0], text2, null);
                        position[0] = doc.createPosition(offset2[0]);
                        if (semiPosition != null) {
                            doc.insertString(semiPosition.getOffset(), ";", null);
                        } else if (!DefaultConstructorItem.this.isAbstract && lpar) {
                            c.setCaretPosition(c.getCaretPosition() - 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            if (this.isAbstract && text.trim().length() > 3) {
                try {
                    if (position[0] != null) {
                        offset2[0] = position[0].getOffset();
                    }
                    final int off = offset2[0] + text.indexOf(123) + 1;
                    ModificationResult mr = ModificationResult.runModificationTask(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                            copy.toPhase(JavaSource.Phase.RESOLVED);
                            int embeddedOffset = copy.getSnapshot().getEmbeddedOffset(off);
                            TreePath path = copy.getTreeUtilities().pathFor(embeddedOffset);
                            while (path.getLeaf() != path.getCompilationUnit()) {
                                Tree tree = path.getLeaf();
                                Tree parentTree = path.getParentPath().getLeaf();
                                if (parentTree.getKind() == Tree.Kind.NEW_CLASS && TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
                                    GeneratorUtils.generateAllAbstractMethodImplementations(copy, path);
                                    break;
                                }
                                path = path.getParentPath();
                            }
                        }
                    });
                    GeneratorUtils.guardedCommit(c, mr);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
            }
        }

        public String toString() {
            return this.simpleName + "()";
        }
    }

    static class EnumItem
    extends ClassItem {
        private static final String ENUM = "org/netbeans/modules/editor/resources/completion/enum.png";
        private static ImageIcon icon;

        private EnumItem(CompilationInfo info, TypeElement elem, DeclaredType type, int dim, int substitutionOffset, ReferencesCount referencesCount, boolean isDeprecated, boolean insideNew, boolean addSimpleName, boolean smartType, boolean autoImport, WhiteListQuery.WhiteList whiteList) {
            super(info, elem, type, dim, substitutionOffset, referencesCount, isDeprecated, insideNew, false, addSimpleName, smartType, autoImport, whiteList);
        }

        @Override
        protected ImageIcon getBaseIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)ENUM, (boolean)false);
            }
            return icon;
        }
    }

    static class FieldItem
    extends WhiteListJavaCompletionItem<VariableElement> {
        private static final String FIELD_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_16.png";
        private static final String FIELD_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_protected_16.png";
        private static final String FIELD_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_package_private_16.png";
        private static final String FIELD_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_private_16.png";
        private static final String FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png";
        private static final String FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png";
        private static final String FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png";
        private static final String FIELD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_static_private_16.png";
        private static final String FIELD_COLOR = "<font color=#008618>";
        private static ImageIcon[][] icon = new ImageIcon[2][4];
        private boolean isInherited;
        private boolean isDeprecated;
        private boolean smartType;
        private String simpleName;
        private Set<Modifier> modifiers;
        private String typeName;
        private String leftText;
        private String rightText;
        private boolean autoImport;
        private CharSequence enclSortText;
        private int assignToVarPos;
        private String assignToVarText;

        private FieldItem(CompilationInfo info, VariableElement elem, TypeMirror type, int substitutionOffset, ReferencesCount referencesCount, boolean isInherited, boolean isDeprecated, boolean smartType, int assignToVarPos, WhiteListQuery.WhiteList whiteList) {
            super(substitutionOffset, ElementHandle.create((Element)elem), whiteList);
            this.isInherited = isInherited;
            this.isDeprecated = isDeprecated;
            this.smartType = smartType;
            this.simpleName = elem.getSimpleName().toString();
            this.modifiers = elem.getModifiers();
            this.typeName = ((Object)Utilities.getTypeName(info, type, false)).toString();
            this.autoImport = referencesCount != null;
            this.enclSortText = this.autoImport ? new LazySortText(elem.getEnclosingElement().getSimpleName().toString(), null, (ElementHandle<TypeElement>)ElementHandle.create((Element)((TypeElement)elem.getEnclosingElement())), referencesCount) : "";
            this.assignToVarPos = assignToVarPos;
            this.assignToVarText = assignToVarPos < 0 ? null : JavaCompletionItem.getAssignToVarText(info, type, this.simpleName);
        }

        public int getSortPriority() {
            return this.smartType ? 300 - SMART_TYPE : 300;
        }

        public CharSequence getSortText() {
            return this.simpleName + "#" + this.enclSortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.getElementHandle());
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(FIELD_COLOR);
                if (!this.isInherited) {
                    sb.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated || this.isBlackListed()) {
                    sb.append(JavaCompletionItem.STRIKE);
                }
                sb.append(this.simpleName);
                if (this.isDeprecated || this.isBlackListed()) {
                    sb.append(JavaCompletionItem.STRIKE_END);
                }
                if (!this.isInherited) {
                    sb.append(JavaCompletionItem.BOLD_END);
                }
                sb.append(JavaCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        @Override
        protected ImageIcon getBaseIcon() {
            int level = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean isStatic = this.modifiers.contains((Object)Modifier.STATIC);
            ImageIcon cachedIcon = icon[isStatic ? 1 : 0][level];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            String iconPath = FIELD_PUBLIC;
            if (isStatic) {
                switch (level) {
                    case 0: {
                        iconPath = FIELD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = FIELD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = FIELD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = FIELD_ST_PUBLIC;
                    }
                }
            } else {
                switch (level) {
                    case 0: {
                        iconPath = FIELD_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = FIELD_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = FIELD_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = FIELD_PUBLIC;
                    }
                }
            }
            ImageIcon newIcon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
            FieldItem.icon[isStatic ? 1 : 0][level] = newIcon;
            return newIcon;
        }

        @Override
        protected void substituteText(JTextComponent c, final int offset, int len, String toAdd, boolean assignToVar) {
            try {
                CodeTemplateManager ctm;
                Position endPos;
                final BaseDocument doc = (BaseDocument)c.getDocument();
                final Position startPos = this.assignToVarPos < 0 ? null : doc.createPosition(this.assignToVarPos, Position.Bias.Backward);
                Position position = endPos = this.assignToVarText == null ? null : doc.createPosition(offset);
                super.substituteText(c, offset, len, toAdd != null ? toAdd : (assignToVar && this.assignToVarText != null ? ";" : null), assignToVar);
                if (this.autoImport) {
                    final Source s = Source.create((Document)c.getDocument());
                    final AtomicBoolean cancel = new AtomicBoolean();
                    ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ParserManager.parse(Collections.singletonList(s), (UserTask)new UserTask(){

                                    public void run(ResultIterator resultIterator) throws Exception {
                                        if (cancel.get()) {
                                            return;
                                        }
                                        CompilationController controller = CompilationController.get((Parser.Result)resultIterator.getParserResult(offset));
                                        controller.toPhase(JavaSource.Phase.RESOLVED);
                                        if (cancel.get()) {
                                            return;
                                        }
                                        int embeddedOffset = controller.getSnapshot().getEmbeddedOffset(offset);
                                        VariableElement ve = (VariableElement)FieldItem.this.getElementHandle().resolve((CompilationInfo)controller);
                                        if (ve != null) {
                                            AutoImport.resolveImport((CompilationInfo)controller, controller.getTreeUtilities().pathFor(embeddedOffset), ve.getEnclosingElement().asType());
                                        }
                                    }
                                });
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                    }, (String)NbBundle.getMessage(JavaCompletionItem.class, (String)"JCI-import_resolve"), (AtomicBoolean)cancel, (boolean)false);
                }
                if (assignToVar && this.assignToVarText != null && (ctm = CodeTemplateManager.get((Document)doc)) != null) {
                    final String[] docText = new String[1];
                    doc.runAtomic(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                docText[0] = doc.getText(startPos.getOffset(), endPos.getOffset() - startPos.getOffset());
                                doc.remove(startPos.getOffset(), endPos.getOffset() - startPos.getOffset());
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                    CodeTemplate tmp = ctm.createTemporary(this.assignToVarText + docText[0]);
                    c.setCaretPosition(startPos.getOffset());
                    tmp.insert(c);
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : this.modifiers) {
                sb.append(mod.toString());
                sb.append(' ');
            }
            sb.append(this.typeName);
            sb.append(' ');
            sb.append(this.simpleName);
            return sb.toString();
        }
    }

    static class GetterSetterMethodItem
    extends JavaCompletionItem {
        private static final String METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png";
        private static final String GETTER_BADGE_PATH = "org/netbeans/modules/java/editor/resources/getter_badge.png";
        private static final String SETTER_BADGE_PATH = "org/netbeans/modules/java/editor/resources/setter_badge.png";
        private static final String METHOD_COLOR = "<font color=#000000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon superIcon;
        private static ImageIcon[] merged_icons;
        protected ElementHandle<VariableElement> elementHandle;
        private boolean setter;
        private String simpleName;
        private String name;
        private String typeName;
        private String sortText;
        private String leftText;
        private String rightText;

        private GetterSetterMethodItem(CompilationInfo info, VariableElement elem, TypeMirror type, int substitutionOffset, boolean setter) {
            super(substitutionOffset);
            this.elementHandle = ElementHandle.create((Element)elem);
            this.setter = setter;
            this.simpleName = elem.getSimpleName().toString();
            this.name = setter ? "set" + GeneratorUtils.getCapitalizedName(this.simpleName) : (elem.asType().getKind() == TypeKind.BOOLEAN ? "is" : "get") + GeneratorUtils.getCapitalizedName(this.simpleName);
            this.typeName = ((Object)Utilities.getTypeName(info, type, false)).toString();
        }

        public int getSortPriority() {
            return 500;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder sortParams = new StringBuilder();
                sortParams.append('(');
                if (this.setter) {
                    sortParams.append(this.typeName);
                }
                sortParams.append(')');
                this.sortText = this.name + "#" + (this.setter ? "01" : "00") + "#" + sortParams.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.name;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder lText = new StringBuilder();
                lText.append(METHOD_COLOR);
                lText.append(JavaCompletionItem.BOLD);
                lText.append(this.name);
                lText.append(JavaCompletionItem.BOLD_END);
                lText.append(JavaCompletionItem.COLOR_END);
                lText.append('(');
                if (this.setter) {
                    lText.append(JavaCompletionItem.escape(this.typeName));
                    lText.append(' ');
                    lText.append(PARAMETER_NAME_COLOR);
                    lText.append(this.simpleName);
                    lText.append(JavaCompletionItem.COLOR_END);
                }
                lText.append(") - ");
                lText.append(GENERATE_TEXT);
                this.leftText = lText.toString();
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = this.setter ? "void" : JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        @Override
        protected ImageIcon getIcon() {
            if (merged_icons[this.setter ? 1 : 0] == null) {
                if (superIcon == null) {
                    superIcon = ImageUtilities.loadImageIcon((String)METHOD_PUBLIC, (boolean)false);
                }
                if (this.setter) {
                    ImageIcon setterBadge = ImageUtilities.loadImageIcon((String)SETTER_BADGE_PATH, (boolean)false);
                    GetterSetterMethodItem.merged_icons[1] = new ImageIcon(ImageUtilities.mergeImages((Image)superIcon.getImage(), (Image)setterBadge.getImage(), (int)8, (int)8));
                } else {
                    ImageIcon getterBadge = ImageUtilities.loadImageIcon((String)GETTER_BADGE_PATH, (boolean)false);
                    GetterSetterMethodItem.merged_icons[0] = new ImageIcon(ImageUtilities.mergeImages((Image)superIcon.getImage(), (Image)getterBadge.getImage(), (int)8, (int)8));
                }
            }
            return merged_icons[this.setter ? 1 : 0];
        }

        @Override
        protected void substituteText(JTextComponent c, final int offset, final int len, String toAdd, boolean assignToVar) {
            Position pos;
            final BaseDocument doc = (BaseDocument)c.getDocument();
            try {
                pos = doc.createPosition(offset);
            }
            catch (BadLocationException e) {
                return;
            }
            if (len > 0) {
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            doc.remove(offset, len);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
            try {
                ModificationResult mr = ModificationResult.runModificationTask(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        VariableElement ve = (VariableElement)GetterSetterMethodItem.this.elementHandle.resolve((CompilationInfo)copy);
                        if (ve == null) {
                            return;
                        }
                        int embeddedOffset = copy.getSnapshot().getEmbeddedOffset(pos.getOffset());
                        TreePath tp = copy.getTreeUtilities().pathFor(embeddedOffset);
                        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
                            TypeElement te;
                            if (Utilities.inAnonymousOrLocalClass(tp)) {
                                copy.toPhase(JavaSource.Phase.RESOLVED);
                            }
                            int idx = 0;
                            for (Tree tree : ((ClassTree)tp.getLeaf()).getMembers()) {
                                if (copy.getTrees().getSourcePositions().getStartPosition(tp.getCompilationUnit(), tree) >= (long)embeddedOffset) break;
                                ++idx;
                            }
                            if ((te = (TypeElement)copy.getTrees().getElement(tp)) != null) {
                                GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)copy);
                                MethodTree method = GetterSetterMethodItem.this.setter ? generatorUtilities.createSetter(te, ve) : generatorUtilities.createGetter(te, ve);
                                ClassTree decl = copy.getTreeMaker().insertClassMember((ClassTree)tp.getLeaf(), idx, (Tree)method);
                                copy.rewrite(tp.getLeaf(), (Tree)decl);
                            }
                        }
                    }
                });
                GeneratorUtils.guardedCommit(c, mr);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("public ");
            sb.append(this.setter ? "void" : this.typeName);
            sb.append(' ');
            sb.append(this.name);
            sb.append('(');
            if (this.setter) {
                sb.append(this.typeName);
                sb.append(' ');
                sb.append(this.simpleName);
            }
            sb.append(") - ");
            sb.append(GENERATE_TEXT);
            return sb.toString();
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        static {
            merged_icons = new ImageIcon[2];
        }
    }

    static class InitializeAllConstructorItem
    extends JavaCompletionItem {
        private static final String CONSTRUCTOR_PUBLIC = "org/netbeans/modules/java/editor/resources/new_constructor_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#b200b2>";
        private static ImageIcon icon;
        private List<ElementHandle<VariableElement>> fieldHandles = new ArrayList<ElementHandle<VariableElement>>();
        private ElementHandle<TypeElement> parentHandle;
        private ElementHandle<ExecutableElement> superConstructorHandle;
        private String simpleName;
        private List<ParamDesc> params;
        private String sortText;
        private String leftText;

        private InitializeAllConstructorItem(CompilationInfo info, Iterable<? extends VariableElement> fields, ExecutableElement superConstructor, TypeElement parent, int substitutionOffset) {
            super(substitutionOffset);
            this.parentHandle = ElementHandle.create((Element)parent);
            this.params = new ArrayList<ParamDesc>();
            for (VariableElement variableElement : fields) {
                this.fieldHandles.add((ElementHandle<VariableElement>)ElementHandle.create((Element)variableElement));
                this.params.add(new ParamDesc(null, ((Object)Utilities.getTypeName(info, variableElement.asType(), false)).toString(), variableElement.getSimpleName().toString()));
            }
            if (superConstructor != null) {
                this.superConstructorHandle = ElementHandle.create((Element)superConstructor);
                for (VariableElement variableElement : superConstructor.getParameters()) {
                    this.params.add(new ParamDesc(null, ((Object)Utilities.getTypeName(info, variableElement.asType(), false)).toString(), variableElement.getSimpleName().toString()));
                }
            } else {
                this.superConstructorHandle = null;
            }
            this.simpleName = parent.getSimpleName().toString();
        }

        public int getSortPriority() {
            return 400;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder sortParams = new StringBuilder();
                sortParams.append('(');
                int cnt = 0;
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    sortParams.append(paramDesc.typeName);
                    if (it.hasNext()) {
                        sortParams.append(',');
                    }
                    ++cnt;
                }
                sortParams.append(')');
                this.sortText = this.simpleName + "#" + (cnt < 10 ? "0" : "") + cnt + "#" + sortParams.toString();
            }
            return this.sortText;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder lText = new StringBuilder();
                lText.append(CONSTRUCTOR_COLOR);
                lText.append(this.simpleName);
                lText.append(JavaCompletionItem.COLOR_END);
                lText.append('(');
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    lText.append(JavaCompletionItem.escape(paramDesc.typeName));
                    lText.append(' ');
                    lText.append(PARAMETER_NAME_COLOR);
                    lText.append(paramDesc.name);
                    lText.append(JavaCompletionItem.COLOR_END);
                    if (!it.hasNext()) continue;
                    lText.append(", ");
                }
                lText.append(") - ");
                lText.append(GENERATE_TEXT);
                this.leftText = lText.toString();
            }
            return this.leftText;
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)CONSTRUCTOR_PUBLIC, (boolean)false);
            }
            return icon;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        protected void substituteText(JTextComponent c, final int offset, final int len, String toAdd, boolean assignToVar) {
            final BaseDocument doc = (BaseDocument)c.getDocument();
            if (len > 0) {
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            doc.remove(offset, len);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
            try {
                ModificationResult mr = ModificationResult.runModificationTask(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        int embeddedOffset = copy.getSnapshot().getEmbeddedOffset(offset);
                        TreePath tp = copy.getTreeUtilities().pathFor(embeddedOffset);
                        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
                            TypeElement parent = (TypeElement)InitializeAllConstructorItem.this.parentHandle.resolve((CompilationInfo)copy);
                            ArrayList<VariableElement> fieldElements = new ArrayList<VariableElement>();
                            for (ElementHandle handle : InitializeAllConstructorItem.this.fieldHandles) {
                                fieldElements.add((VariableElement)handle.resolve((CompilationInfo)copy));
                            }
                            int idx = 0;
                            for (Tree tree : ((ClassTree)tp.getLeaf()).getMembers()) {
                                if (copy.getTrees().getSourcePositions().getStartPosition(tp.getCompilationUnit(), tree) >= (long)embeddedOffset) break;
                                ++idx;
                            }
                            ExecutableElement superConstructor = InitializeAllConstructorItem.this.superConstructorHandle != null ? (ExecutableElement)InitializeAllConstructorItem.this.superConstructorHandle.resolve((CompilationInfo)copy) : null;
                            TreeMaker treeMaker = copy.getTreeMaker();
                            ClassTree clazz = (ClassTree)tp.getLeaf();
                            GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)copy);
                            ClassTree decl = treeMaker.insertClassMember(clazz, idx, (Tree)gu.createConstructor(parent, fieldElements, superConstructor));
                            copy.rewrite((Tree)clazz, (Tree)decl);
                        }
                    }
                });
                GeneratorUtils.guardedCommit(c, mr);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("public ");
            sb.append(this.simpleName);
            sb.append('(');
            Iterator<ParamDesc> it = this.params.iterator();
            while (it.hasNext()) {
                ParamDesc paramDesc = it.next();
                sb.append(paramDesc.typeName);
                sb.append(' ');
                sb.append(paramDesc.name);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(") - ");
            sb.append(GENERATE_TEXT);
            return sb.toString();
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }
    }

    static class InterfaceItem
    extends ClassItem {
        private static final String INTERFACE = "org/netbeans/modules/editor/resources/completion/interface.png";
        private static final String INTERFACE_COLOR = "<font color=#404040>";
        private static ImageIcon icon;

        private InterfaceItem(CompilationInfo info, TypeElement elem, DeclaredType type, int dim, int substitutionOffset, ReferencesCount referencesCount, boolean isDeprecated, boolean insideNew, boolean addTypeVars, boolean addSimpleName, boolean smartType, boolean autoImport, WhiteListQuery.WhiteList whiteList) {
            super(info, elem, type, dim, substitutionOffset, referencesCount, isDeprecated, insideNew, addTypeVars, addSimpleName, smartType, autoImport, whiteList);
        }

        @Override
        protected ImageIcon getBaseIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)INTERFACE, (boolean)false);
            }
            return icon;
        }

        @Override
        protected String getColor() {
            return INTERFACE_COLOR;
        }
    }

    static class KeywordItem
    extends JavaCompletionItem {
        private static final String JAVA_KEYWORD = "org/netbeans/modules/java/editor/resources/javakw_16.png";
        private static final String KEYWORD_COLOR = "<font color=#000099>";
        private static ImageIcon icon;
        private String kwd;
        private int dim;
        private String postfix;
        private boolean smartType;
        private String leftText;

        private KeywordItem(String kwd, int dim, String postfix, int substitutionOffset, boolean smartType) {
            super(substitutionOffset);
            this.kwd = kwd;
            this.dim = dim;
            this.postfix = postfix;
            this.smartType = smartType;
        }

        public int getSortPriority() {
            return this.smartType ? 600 - SMART_TYPE : 600;
        }

        public CharSequence getSortText() {
            return this.kwd;
        }

        public CharSequence getInsertPrefix() {
            return this.kwd;
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)JAVA_KEYWORD, (boolean)false);
            }
            return icon;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(KEYWORD_COLOR);
                sb.append(JavaCompletionItem.BOLD);
                sb.append(this.kwd);
                for (int i = 0; i < this.dim; ++i) {
                    sb.append("[]");
                }
                sb.append(JavaCompletionItem.BOLD_END);
                sb.append(JavaCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        protected void substituteText(JTextComponent c, final int offset, int len, String toAdd, boolean assignToVar) {
            int semiPos;
            if (this.dim == 0) {
                super.substituteText(c, offset, len, toAdd != null ? toAdd : this.postfix, assignToVar);
                return;
            }
            final BaseDocument doc = (BaseDocument)c.getDocument();
            StringBuilder text = new StringBuilder();
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if (toAdd != null && !toAdd.equals("\n")) {
                TokenSequence sequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)(offset + len));
                if (sequence == null || !sequence.moveNext() && !sequence.movePrevious()) {
                    text.append(toAdd);
                    toAdd = null;
                }
                boolean added = false;
                while (toAdd != null && toAdd.length() > 0) {
                    String tokenText = ((Object)sequence.token().text()).toString();
                    if (tokenText.startsWith(toAdd)) {
                        len = sequence.offset() - offset + toAdd.length();
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (toAdd.startsWith(tokenText)) {
                        sequence.moveNext();
                        len = sequence.offset() - offset;
                        text.append(toAdd.substring(0, tokenText.length()));
                        toAdd = toAdd.substring(tokenText.length());
                        added = true;
                        continue;
                    }
                    if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                        if (sequence.moveNext()) continue;
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (!added) {
                        text.append(toAdd);
                    }
                    toAdd = null;
                }
            }
            StringBuilder sb = new StringBuilder();
            int cnt = 1;
            sb.append(this.kwd);
            for (int i = 0; i < this.dim; ++i) {
                sb.append("[${PAR");
                sb.append(cnt++);
                sb.append(" instanceof=\"int\" default=\"\"}]");
            }
            final int length = len;
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        Position semiPosition;
                        Position position = semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                        if (length > 0) {
                            doc.remove(offset, length);
                        }
                        if (semiPosition != null) {
                            doc.insertString(semiPosition.getOffset(), ";", null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            CodeTemplateManager ctm = CodeTemplateManager.get((Document)doc);
            if (ctm != null) {
                ctm.createTemporary(sb.append((CharSequence)text).toString()).insert(c);
            }
        }

        public String toString() {
            return this.kwd;
        }
    }

    static class MethodItem
    extends WhiteListJavaCompletionItem<ExecutableElement> {
        private static final String METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png";
        private static final String METHOD_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_protected_16.png";
        private static final String METHOD_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_package_private_16.png";
        private static final String METHOD_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_private_16.png";
        private static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
        private static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
        private static final String METHOD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_static_private_16.png";
        private static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
        private static final String METHOD_COLOR = "<font color=#000000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon[][] icon = new ImageIcon[2][4];
        private boolean isInherited;
        private boolean isDeprecated;
        private boolean inImport;
        private boolean smartType;
        private String simpleName;
        protected Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private String typeName;
        private boolean addSemicolon;
        private String sortText;
        private String leftText;
        private String rightText;
        private boolean autoImport;
        private CharSequence enclSortText;
        private int assignToVarPos;
        private String assignToVarText;

        private MethodItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, ReferencesCount referencesCount, boolean isInherited, boolean isDeprecated, boolean inImport, boolean addSemicolon, boolean smartType, int assignToVarPos, WhiteListQuery.WhiteList whiteList) {
            super(substitutionOffset, ElementHandle.create((Element)elem), whiteList);
            TypeMirror tm;
            this.isInherited = isInherited;
            this.isDeprecated = isDeprecated;
            this.inImport = inImport;
            this.smartType = smartType;
            this.simpleName = elem.getSimpleName().toString();
            this.modifiers = elem.getModifiers();
            this.params = new ArrayList<ParamDesc>();
            Iterator<? extends VariableElement> it = elem.getParameters().iterator();
            Iterator<? extends TypeMirror> tIt = type.getParameterTypes().iterator();
            while (it.hasNext() && tIt.hasNext() && (tm = tIt.next()) != null) {
                this.params.add(new ParamDesc(((Object)tm).toString(), ((Object)Utilities.getTypeName(info, tm, false, elem.isVarArgs() && !tIt.hasNext())).toString(), it.next().getSimpleName().toString()));
            }
            TypeMirror retType = type.getReturnType();
            this.typeName = ((Object)Utilities.getTypeName(info, retType, false)).toString();
            this.addSemicolon = addSemicolon && (retType.getKind().isPrimitive() || retType.getKind() == TypeKind.VOID);
            this.autoImport = referencesCount != null;
            this.enclSortText = this.autoImport ? new LazySortText(elem.getEnclosingElement().getSimpleName().toString(), null, (ElementHandle<TypeElement>)ElementHandle.create((Element)((TypeElement)elem.getEnclosingElement())), referencesCount) : "";
            this.assignToVarPos = type.getReturnType().getKind() == TypeKind.VOID ? -1 : assignToVarPos;
            this.assignToVarText = this.assignToVarPos < 0 ? null : JavaCompletionItem.getAssignToVarText(info, type.getReturnType(), this.simpleName);
        }

        public int getSortPriority() {
            return this.smartType ? 500 - SMART_TYPE : 500;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder sortParams = new StringBuilder();
                sortParams.append('(');
                int cnt = 0;
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc param = it.next();
                    sortParams.append(param.typeName);
                    if (it.hasNext()) {
                        sortParams.append(',');
                    }
                    ++cnt;
                }
                sortParams.append(')');
                this.sortText = this.simpleName + "#" + this.enclSortText + "#" + (cnt < 10 ? "0" : "") + cnt + "#" + sortParams.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder lText = new StringBuilder();
                lText.append(METHOD_COLOR);
                if (!this.isInherited) {
                    lText.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated || this.isBlackListed()) {
                    lText.append(JavaCompletionItem.STRIKE);
                }
                lText.append(this.simpleName);
                if (this.isDeprecated || this.isBlackListed()) {
                    lText.append(JavaCompletionItem.STRIKE_END);
                }
                if (!this.isInherited) {
                    lText.append(JavaCompletionItem.BOLD_END);
                }
                lText.append(JavaCompletionItem.COLOR_END);
                lText.append('(');
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    lText.append(JavaCompletionItem.escape(paramDesc.typeName));
                    lText.append(' ');
                    lText.append(PARAMETER_NAME_COLOR);
                    lText.append(paramDesc.name);
                    lText.append(JavaCompletionItem.COLOR_END);
                    if (!it.hasNext()) continue;
                    lText.append(", ");
                }
                lText.append(')');
                return lText.toString();
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.getElementHandle());
        }

        @Override
        protected ImageIcon getBaseIcon() {
            int level = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean isStatic = this.modifiers.contains((Object)Modifier.STATIC);
            ImageIcon cachedIcon = icon[isStatic ? 1 : 0][level];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            String iconPath = METHOD_PUBLIC;
            if (isStatic) {
                switch (level) {
                    case 0: {
                        iconPath = METHOD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = METHOD_ST_PUBLIC;
                    }
                }
            } else {
                switch (level) {
                    case 0: {
                        iconPath = METHOD_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = METHOD_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = METHOD_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = METHOD_PUBLIC;
                    }
                }
            }
            ImageIcon newIcon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
            MethodItem.icon[isStatic ? 1 : 0][level] = newIcon;
            return newIcon;
        }

        @Override
        protected void substituteText(final JTextComponent c, final int offset, int len, String toAdd, boolean assignToVar) {
            try {
                Position endPos;
                if (toAdd == null && (this.addSemicolon || assignToVar && this.assignToVarText != null)) {
                    toAdd = ";";
                }
                final BaseDocument doc = (BaseDocument)c.getDocument();
                final Position startPos = this.assignToVarPos < 0 ? null : doc.createPosition(this.assignToVarPos, Position.Bias.Backward);
                Position position = endPos = this.assignToVarText == null ? null : doc.createPosition(offset);
                if (this.inImport || this.params.isEmpty()) {
                    CodeTemplateManager ctm;
                    String add;
                    String string = this.inImport ? ";" : (add = CodeStyle.getDefault((Document)c.getDocument()).spaceBeforeMethodCallParen() ? " ()" : "()");
                    if (toAdd != null && !add.startsWith(toAdd)) {
                        add = add + toAdd;
                    }
                    super.substituteText(c, offset, len, add, assignToVar);
                    if ("(".equals(toAdd)) {
                        c.setCaretPosition(c.getCaretPosition() - 1);
                    }
                    if (this.autoImport) {
                        final Source s = Source.create((Document)doc);
                        final AtomicBoolean cancel = new AtomicBoolean();
                        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ParserManager.parse(Collections.singletonList(s), (UserTask)new UserTask(){

                                        public void run(ResultIterator resultIterator) throws Exception {
                                            if (cancel.get()) {
                                                return;
                                            }
                                            CompilationController controller = CompilationController.get((Parser.Result)resultIterator.getParserResult(offset));
                                            controller.toPhase(JavaSource.Phase.RESOLVED);
                                            if (cancel.get()) {
                                                return;
                                            }
                                            int embeddedOffset = controller.getSnapshot().getEmbeddedOffset(offset);
                                            ExecutableElement ee = (ExecutableElement)MethodItem.this.getElementHandle().resolve((CompilationInfo)controller);
                                            if (ee != null) {
                                                AutoImport.resolveImport((CompilationInfo)controller, controller.getTreeUtilities().pathFor(embeddedOffset), ee.getEnclosingElement().asType());
                                            }
                                        }
                                    });
                                }
                                catch (ParseException parseException) {
                                    // empty catch block
                                }
                            }
                        }, (String)NbBundle.getMessage(JavaCompletionItem.class, (String)"JCI-import_resolve"), (AtomicBoolean)cancel, (boolean)false);
                    }
                    if (assignToVar && this.assignToVarText != null && (ctm = CodeTemplateManager.get((Document)doc)) != null) {
                        final String[] docText = new String[1];
                        doc.runAtomic(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    docText[0] = doc.getText(startPos.getOffset(), endPos.getOffset() - startPos.getOffset());
                                    doc.remove(startPos.getOffset(), endPos.getOffset() - startPos.getOffset());
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        });
                        CodeTemplate tmp = ctm.createTemporary(this.assignToVarText + docText[0]);
                        c.setCaretPosition(startPos.getOffset());
                        tmp.insert(c);
                    }
                } else {
                    CodeTemplateManager ctm;
                    TokenSequence sequence;
                    int semiPos;
                    String add = "()";
                    if (toAdd != null && !add.startsWith(toAdd)) {
                        add = add + toAdd;
                    }
                    String text = "";
                    int n = semiPos = add.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
                    if (semiPos > -2) {
                        String string = add = add.length() > 1 ? add.substring(0, add.length() - 1) : null;
                    }
                    if ((sequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)(offset + len))) == null || !sequence.moveNext() && !sequence.movePrevious()) {
                        text = text + add;
                        add = null;
                    }
                    boolean added = false;
                    while (add != null && add.length() > 0) {
                        String tokenText = ((Object)sequence.token().text()).toString();
                        if (tokenText.startsWith(add)) {
                            len = sequence.offset() - offset + add.length();
                            text = text + add;
                            add = null;
                            continue;
                        }
                        if (add.startsWith(tokenText)) {
                            sequence.moveNext();
                            len = sequence.offset() - offset;
                            text = text + add.substring(0, tokenText.length());
                            add = add.substring(tokenText.length());
                            added = true;
                            continue;
                        }
                        if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                            if (sequence.moveNext()) continue;
                            text = text + add;
                            add = null;
                            continue;
                        }
                        if (!added) {
                            text = text + add;
                        }
                        add = null;
                    }
                    final int length = len;
                    final StringBuilder sb = new StringBuilder();
                    if (CodeStyle.getDefault((Document)doc).spaceBeforeMethodCallParen()) {
                        sb.append(' ');
                    }
                    sb.append('(');
                    doc.runAtomic(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Position pos = doc.createPosition(offset);
                                Position semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                                String textToReplace = doc.getText(pos.getOffset(), length);
                                if (textToReplace.contentEquals(MethodItem.this.getInsertPrefix() + sb.toString())) {
                                    c.setCaretPosition(c.getCaretPosition() + sb.length());
                                    sb.delete(0, sb.length());
                                } else {
                                    if (length > 0) {
                                        doc.remove(pos.getOffset(), length);
                                    }
                                    doc.insertString(pos.getOffset(), ((Object)MethodItem.this.getInsertPrefix()).toString(), null);
                                }
                                int caretPos = pos.getOffset();
                                if (semiPosition != null) {
                                    doc.insertString(semiPosition.getOffset(), ";", null);
                                    c.setCaretPosition(caretPos);
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                    if (this.autoImport) {
                        final Source s = Source.create((Document)doc);
                        final AtomicBoolean cancel = new AtomicBoolean();
                        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ParserManager.parse(Collections.singletonList(s), (UserTask)new UserTask(){

                                        public void run(ResultIterator resultIterator) throws Exception {
                                            if (cancel.get()) {
                                                return;
                                            }
                                            CompilationController controller = CompilationController.get((Parser.Result)resultIterator.getParserResult(offset));
                                            controller.toPhase(JavaSource.Phase.RESOLVED);
                                            if (cancel.get()) {
                                                return;
                                            }
                                            int embeddedOffset = controller.getSnapshot().getEmbeddedOffset(offset);
                                            ExecutableElement ee = (ExecutableElement)MethodItem.this.getElementHandle().resolve((CompilationInfo)controller);
                                            if (ee != null) {
                                                AutoImport.resolveImport((CompilationInfo)controller, controller.getTreeUtilities().pathFor(embeddedOffset), ee.getEnclosingElement().asType());
                                            }
                                        }
                                    });
                                }
                                catch (ParseException parseException) {
                                    // empty catch block
                                }
                            }
                        }, (String)NbBundle.getMessage(JavaCompletionItem.class, (String)"JCI-import_resolve"), (AtomicBoolean)cancel, (boolean)false);
                    }
                    if ((ctm = CodeTemplateManager.get((Document)doc)) != null) {
                        if (text.length() > 1) {
                            boolean guessArgs = Utilities.guessMethodArguments();
                            Iterator<ParamDesc> it = this.params.iterator();
                            while (it.hasNext()) {
                                ParamDesc paramDesc = it.next();
                                sb.append("${");
                                sb.append(paramDesc.name);
                                if (guessArgs) {
                                    sb.append(" named instanceof=");
                                    sb.append(paramDesc.fullTypeName);
                                }
                                sb.append('}');
                                if (!it.hasNext()) continue;
                                sb.append(", ");
                            }
                            sb.append(')');
                            if (text.length() > 2) {
                                sb.append(text.substring(2));
                            }
                        }
                        if (assignToVar && this.assignToVarText != null) {
                            doc.runAtomic(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        sb.insert(0, doc.getText(startPos.getOffset(), endPos.getOffset() - startPos.getOffset()));
                                        doc.remove(startPos.getOffset(), endPos.getOffset() - startPos.getOffset());
                                    }
                                    catch (BadLocationException badLocationException) {
                                        // empty catch block
                                    }
                                }
                            });
                            sb.insert(0, this.assignToVarText);
                            c.setCaretPosition(startPos.getOffset());
                        }
                        if (sb.length() > 0) {
                            ctm.createTemporary(sb.toString()).insert(c);
                        }
                        Completion.get().showToolTip();
                    }
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : this.modifiers) {
                sb.append(mod.toString());
                sb.append(' ');
            }
            sb.append(this.typeName);
            sb.append(' ');
            sb.append(this.simpleName);
            sb.append('(');
            Iterator<ParamDesc> it = this.params.iterator();
            while (it.hasNext()) {
                ParamDesc paramDesc = it.next();
                sb.append(paramDesc.typeName);
                sb.append(' ');
                sb.append(paramDesc.name);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(')');
            return sb.toString();
        }
    }

    static class OverrideMethodItem
    extends MethodItem {
        private static final String IMPL_BADGE_PATH = "org/netbeans/modules/java/editor/resources/implement_badge.png";
        private static final String OVRD_BADGE_PATH = "org/netbeans/modules/java/editor/resources/override_badge.png";
        private static final String OVERRIDE_TEXT = NbBundle.getMessage(JavaCompletionItem.class, (String)"override_Lbl");
        private static final String IMPLEMENT_TEXT = NbBundle.getMessage(JavaCompletionItem.class, (String)"implement_Lbl");
        private static ImageIcon implementBadge = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/editor/resources/implement_badge.png", (boolean)false);
        private static ImageIcon overrideBadge = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/editor/resources/override_badge.png", (boolean)false);
        private static ImageIcon[][] merged_icon = new ImageIcon[2][4];
        private boolean implement;
        private String leftText;

        private OverrideMethodItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean implement, WhiteListQuery.WhiteList whiteList) {
            super(info, elem, type, substitutionOffset, null, false, false, false, false, false, -1, whiteList);
            this.implement = implement;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = super.getLeftHtmlText() + " - ";
                this.leftText = this.leftText + (this.implement ? IMPLEMENT_TEXT : OVERRIDE_TEXT);
            }
            return this.leftText;
        }

        @Override
        protected ImageIcon getBaseIcon() {
            int level;
            ImageIcon merged = merged_icon[this.implement ? 0 : 1][level = JavaCompletionItem.getProtectionLevel(this.modifiers)];
            if (merged != null) {
                return merged;
            }
            ImageIcon superIcon = super.getBaseIcon();
            merged = new ImageIcon(ImageUtilities.mergeImages((Image)superIcon.getImage(), (Image)(this.implement ? implementBadge.getImage() : overrideBadge.getImage()), (int)8, (int)8));
            OverrideMethodItem.merged_icon[this.implement ? 0 : 1][level] = merged;
            return merged;
        }

        @Override
        protected void substituteText(JTextComponent c, final int offset, final int len, String toAdd, boolean assignToVar) {
            Position pos;
            final BaseDocument doc = (BaseDocument)c.getDocument();
            try {
                pos = doc.createPosition(offset);
            }
            catch (BadLocationException e) {
                return;
            }
            if (len > 0) {
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            doc.remove(offset, len);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
            try {
                ModificationResult mr = ModificationResult.runModificationTask(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ExecutableElement ee = (ExecutableElement)OverrideMethodItem.this.getElementHandle().resolve((CompilationInfo)copy);
                        if (ee == null) {
                            return;
                        }
                        int embeddedOffset = copy.getSnapshot().getEmbeddedOffset(pos.getOffset());
                        TreePath tp = copy.getTreeUtilities().pathFor(embeddedOffset);
                        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
                            if (Utilities.inAnonymousOrLocalClass(tp)) {
                                copy.toPhase(JavaSource.Phase.RESOLVED);
                            }
                            int idx = 0;
                            for (Tree tree : ((ClassTree)tp.getLeaf()).getMembers()) {
                                if (copy.getTrees().getSourcePositions().getStartPosition(tp.getCompilationUnit(), tree) >= (long)embeddedOffset) break;
                                ++idx;
                            }
                            if (OverrideMethodItem.this.implement) {
                                GeneratorUtils.generateAbstractMethodImplementation(copy, tp, ee, idx);
                            } else {
                                GeneratorUtils.generateMethodOverride(copy, tp, ee, idx);
                            }
                        }
                    }
                });
                GeneratorUtils.guardedCommit(c, mr);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" - ");
            sb.append(this.implement ? IMPLEMENT_TEXT : OVERRIDE_TEXT);
            return sb.toString();
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }
    }

    static class PackageItem
    extends JavaCompletionItem {
        private static final String PACKAGE = "org/netbeans/modules/java/editor/resources/package.gif";
        private static final String PACKAGE_COLOR = "<font color=#005600>";
        private static ImageIcon icon;
        private boolean inPackageStatement;
        private String simpleName;
        private String sortText;
        private String leftText;

        private PackageItem(String pkgFQN, int substitutionOffset, boolean inPackageStatement) {
            super(substitutionOffset);
            this.inPackageStatement = inPackageStatement;
            int idx = pkgFQN.lastIndexOf(46);
            this.simpleName = idx < 0 ? pkgFQN : pkgFQN.substring(idx + 1);
            this.sortText = this.simpleName + "#" + pkgFQN;
        }

        public int getSortPriority() {
            return 900;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)PACKAGE, (boolean)false);
            }
            return icon;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(PACKAGE_COLOR);
                sb.append(this.simpleName);
                sb.append(JavaCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        public void defaultAction(JTextComponent component) {
            if (component != null) {
                Completion.get().hideDocumentation();
                if (this.inPackageStatement || Utilities.getJavaCompletionAutoPopupTriggers().indexOf(46) < 0) {
                    Completion.get().hideCompletion();
                }
                int caretOffset = component.getSelectionEnd();
                this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, null, false);
            }
        }

        @Override
        protected void substituteText(JTextComponent c, int offset, int len, String toAdd, boolean assingToVar) {
            super.substituteText(c, offset, len, this.inPackageStatement || toAdd != null ? toAdd : ".", assingToVar);
        }

        public String toString() {
            return this.simpleName;
        }
    }

    static class ParamDesc {
        private String fullTypeName;
        private String typeName;
        private String name;

        public ParamDesc(String fullTypeName, String typeName, String name) {
            this.fullTypeName = fullTypeName;
            this.typeName = typeName;
            this.name = name;
        }
    }

    static class ParametersItem
    extends JavaCompletionItem {
        private static final String PARAMETERS_COLOR = "<font color=#808080>";
        private static final String ACTIVE_PARAMETER_COLOR = "<font color=#000000>";
        protected ElementHandle<ExecutableElement> elementHandle;
        private boolean isDeprecated;
        private int activeParamsIndex;
        private String simpleName;
        private ArrayList<ParamDesc> params;
        private String typeName;
        private String sortText;
        private String leftText;
        private String rightText;

        private ParametersItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated, int activeParamsIndex, String name) {
            super(substitutionOffset);
            TypeMirror tm;
            this.elementHandle = ElementHandle.create((Element)elem);
            this.isDeprecated = isDeprecated;
            this.activeParamsIndex = activeParamsIndex;
            this.simpleName = name != null ? name : (elem.getKind() == ElementKind.CONSTRUCTOR ? elem.getEnclosingElement().getSimpleName().toString() : elem.getSimpleName().toString());
            this.params = new ArrayList();
            Iterator<? extends VariableElement> it = elem.getParameters().iterator();
            Iterator<? extends TypeMirror> tIt = type.getParameterTypes().iterator();
            while (it.hasNext() && tIt.hasNext() && (tm = tIt.next()) != null) {
                this.params.add(new ParamDesc(((Object)tm).toString(), ((Object)Utilities.getTypeName(info, tm, false, elem.isVarArgs() && !tIt.hasNext())).toString(), it.next().getSimpleName().toString()));
            }
            TypeMirror retType = type.getReturnType();
            this.typeName = ((Object)Utilities.getTypeName(info, retType, false)).toString();
        }

        public int getSortPriority() {
            return 100 - SMART_TYPE;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder sortParams = new StringBuilder();
                sortParams.append('(');
                int cnt = 0;
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc param = it.next();
                    sortParams.append(param.typeName);
                    if (it.hasNext()) {
                        sortParams.append(',');
                    }
                    ++cnt;
                }
                sortParams.append(')');
                this.sortText = "#" + (cnt < 10 ? "0" : "") + cnt + "#" + sortParams.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return "";
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder lText = new StringBuilder();
                lText.append(PARAMETERS_COLOR);
                if (this.isDeprecated) {
                    lText.append(JavaCompletionItem.STRIKE);
                }
                lText.append(this.simpleName);
                if (this.isDeprecated) {
                    lText.append(JavaCompletionItem.STRIKE_END);
                }
                lText.append('(');
                for (int i = 0; i < this.params.size(); ++i) {
                    ParamDesc paramDesc = this.params.get(i);
                    if (i == this.activeParamsIndex) {
                        lText.append(JavaCompletionItem.COLOR_END).append(ACTIVE_PARAMETER_COLOR).append(JavaCompletionItem.BOLD);
                    }
                    lText.append(JavaCompletionItem.escape(paramDesc.typeName));
                    lText.append(' ');
                    lText.append(paramDesc.name);
                    if (i < this.params.size() - 1) {
                        lText.append(", ");
                        continue;
                    }
                    lText.append(JavaCompletionItem.BOLD_END).append(JavaCompletionItem.COLOR_END).append(PARAMETERS_COLOR);
                }
                lText.append(')');
                lText.append(JavaCompletionItem.COLOR_END);
                return lText.toString();
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = PARAMETERS_COLOR + JavaCompletionItem.escape(this.typeName) + JavaCompletionItem.COLOR_END;
            }
            return this.rightText;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        @Override
        protected void substituteText(JTextComponent c, final int offset, int len, String toAdd, boolean assignToVar) {
            String add = ")";
            if (toAdd != null && !add.startsWith(toAdd)) {
                add = add + toAdd;
            }
            if (this.params.isEmpty()) {
                super.substituteText(c, offset, len, add, assignToVar);
            } else {
                TokenSequence sequence;
                int semiPos;
                final BaseDocument doc = (BaseDocument)c.getDocument();
                String text = "";
                int n = semiPos = add.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
                if (semiPos > -2) {
                    String string = add = add.length() > 1 ? add.substring(0, add.length() - 1) : null;
                }
                if ((sequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)(offset + len))) == null || !sequence.moveNext() && !sequence.movePrevious()) {
                    text = text + add;
                    add = null;
                }
                boolean added = false;
                while (add != null && add.length() > 0) {
                    String tokenText = ((Object)sequence.token().text()).toString();
                    if (tokenText.startsWith(add)) {
                        len = sequence.offset() - offset + add.length();
                        text = text + add;
                        add = null;
                        continue;
                    }
                    if (add.startsWith(tokenText)) {
                        sequence.moveNext();
                        len = sequence.offset() - offset;
                        text = text + add.substring(0, tokenText.length());
                        add = add.substring(tokenText.length());
                        added = true;
                        continue;
                    }
                    if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                        if (sequence.moveNext()) continue;
                        text = text + add;
                        add = null;
                        continue;
                    }
                    if (!added) {
                        text = text + add;
                    }
                    add = null;
                }
                final int length = len;
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Position semiPosition;
                            Position position = semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                            if (length > 0) {
                                doc.remove(offset, length);
                            }
                            if (semiPosition != null) {
                                doc.insertString(semiPosition.getOffset(), ";", null);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
                CodeTemplateManager ctm = CodeTemplateManager.get((Document)doc);
                if (ctm != null) {
                    StringBuilder sb = new StringBuilder();
                    boolean guessArgs = Utilities.guessMethodArguments();
                    for (int i = this.activeParamsIndex; i < this.params.size(); ++i) {
                        ParamDesc paramDesc = this.params.get(i);
                        sb.append("${");
                        sb.append(paramDesc.name);
                        if (guessArgs) {
                            sb.append(" named instanceof=");
                            sb.append(paramDesc.fullTypeName);
                        }
                        sb.append("}");
                        if (i >= this.params.size() - 1) continue;
                        sb.append(", ");
                    }
                    if (text.length() > 0) {
                        sb.append(text);
                    }
                    ctm.createTemporary(sb.toString()).insert(c);
                    Completion.get().showToolTip();
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.typeName);
            sb.append(' ');
            sb.append(this.simpleName);
            sb.append('(');
            Iterator<ParamDesc> it = this.params.iterator();
            while (it.hasNext()) {
                ParamDesc paramDesc = it.next();
                sb.append(paramDesc.typeName);
                sb.append(' ');
                sb.append(paramDesc.name);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(") - parameters");
            return sb.toString();
        }
    }

    static class StaticMemberItem
    extends WhiteListJavaCompletionItem<Element> {
        private static final String FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png";
        private static final String FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png";
        private static final String FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png";
        private static final String FIELD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_static_private_16.png";
        private static final String FIELD_COLOR = "<font color=#0000b2>";
        private static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
        private static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
        private static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
        private static final String METHOD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_static_private_16.png";
        private static final String METHOD_COLOR = "<font color=#7c0000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#b200b2>";
        private static ImageIcon[][] icon = new ImageIcon[2][4];
        private TypeMirrorHandle<DeclaredType> typeHandle;
        private boolean isDeprecated;
        private String typeName;
        private String memberName;
        private String memberTypeName;
        private Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private String sortText;
        private String leftText;
        private String rightText;

        private StaticMemberItem(CompilationInfo info, DeclaredType type, Element memberElem, TypeMirror memberType, int substitutionOffset, boolean isDeprecated, WhiteListQuery.WhiteList whiteList) {
            super(substitutionOffset, ElementHandle.create((Element)memberElem), whiteList);
            type = (DeclaredType)info.getTypes().erasure(type);
            this.typeHandle = TypeMirrorHandle.create((TypeMirror)type);
            this.isDeprecated = isDeprecated;
            this.typeName = ((Object)Utilities.getTypeName(info, type, false)).toString();
            this.memberName = memberElem.getSimpleName().toString();
            this.memberTypeName = ((Object)Utilities.getTypeName(info, memberElem.getKind().isField() ? memberType : ((ExecutableType)memberType).getReturnType(), false)).toString();
            this.modifiers = memberElem.getModifiers();
            if (!memberElem.getKind().isField()) {
                this.params = new ArrayList<ParamDesc>();
                Iterator<? extends VariableElement> it = ((ExecutableElement)memberElem).getParameters().iterator();
                Iterator<? extends TypeMirror> tIt = ((ExecutableType)memberType).getParameterTypes().iterator();
                while (it.hasNext() && tIt.hasNext()) {
                    TypeMirror tm = tIt.next();
                    this.params.add(new ParamDesc(((Object)tm).toString(), ((Object)Utilities.getTypeName(info, tm, false, ((ExecutableElement)memberElem).isVarArgs() && !tIt.hasNext())).toString(), it.next().getSimpleName().toString()));
                }
            }
        }

        public int getSortPriority() {
            return (this.params == null ? 700 : 750) - SMART_TYPE;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                if (this.params == null) {
                    this.sortText = this.memberName + "#" + this.typeName;
                } else {
                    StringBuilder sortParams = new StringBuilder();
                    sortParams.append('(');
                    int cnt = 0;
                    Iterator<ParamDesc> it = this.params.iterator();
                    while (it.hasNext()) {
                        ParamDesc paramDesc = it.next();
                        sortParams.append(paramDesc.typeName);
                        if (it.hasNext()) {
                            sortParams.append(',');
                        }
                        ++cnt;
                    }
                    sortParams.append(')');
                    this.sortText = this.memberName + "#" + (cnt < 10 ? "0" : "") + cnt + "#" + sortParams.toString() + "#" + this.typeName;
                }
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.typeName + "." + this.memberName;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.getElementHandle());
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder lText = new StringBuilder();
                lText.append(this.getElementHandle().getKind().isField() ? FIELD_COLOR : METHOD_COLOR);
                lText.append(JavaCompletionItem.escape(this.typeName));
                lText.append('.');
                if (this.isDeprecated || this.isBlackListed()) {
                    lText.append(JavaCompletionItem.STRIKE);
                }
                lText.append(this.memberName);
                if (this.isDeprecated || this.isBlackListed()) {
                    lText.append(JavaCompletionItem.STRIKE_END);
                }
                lText.append(JavaCompletionItem.COLOR_END);
                if (this.params != null) {
                    lText.append('(');
                    Iterator<ParamDesc> it = this.params.iterator();
                    while (it.hasNext()) {
                        ParamDesc paramDesc = it.next();
                        lText.append(JavaCompletionItem.escape(paramDesc.typeName));
                        lText.append(' ');
                        lText.append(PARAMETER_NAME_COLOR);
                        lText.append(paramDesc.name);
                        lText.append(JavaCompletionItem.COLOR_END);
                        if (!it.hasNext()) continue;
                        lText.append(", ");
                    }
                    lText.append(')');
                }
                this.leftText = lText.toString();
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.memberTypeName);
            }
            return this.rightText;
        }

        @Override
        protected ImageIcon getBaseIcon() {
            int level = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean isField = this.getElementHandle().getKind().isField();
            ImageIcon cachedIcon = icon[isField ? 0 : 1][level];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            String iconPath = null;
            if (isField) {
                switch (level) {
                    case 0: {
                        iconPath = FIELD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = FIELD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = FIELD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = FIELD_ST_PUBLIC;
                    }
                }
            } else {
                switch (level) {
                    case 0: {
                        iconPath = METHOD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = METHOD_ST_PUBLIC;
                    }
                }
            }
            if (iconPath == null) {
                return null;
            }
            ImageIcon newIcon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
            StaticMemberItem.icon[isField ? 0 : 1][level] = newIcon;
            return newIcon;
        }

        @Override
        protected void substituteText(final JTextComponent c, final int offset, int len, String toAdd, boolean assignToVar) {
            int semiPos;
            final BaseDocument doc = (BaseDocument)c.getDocument();
            final StringBuilder text = new StringBuilder();
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if (toAdd != null && !toAdd.equals("\n")) {
                TokenSequence sequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)(offset + len));
                if (sequence == null || !sequence.moveNext() && !sequence.movePrevious()) {
                    text.append(toAdd);
                    toAdd = null;
                }
                boolean added = false;
                while (toAdd != null && toAdd.length() > 0) {
                    String tokenText = ((Object)sequence.token().text()).toString();
                    if (tokenText.startsWith(toAdd)) {
                        len = sequence.offset() - offset + toAdd.length();
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (toAdd.startsWith(tokenText)) {
                        sequence.moveNext();
                        len = sequence.offset() - offset;
                        text.append(toAdd.substring(0, tokenText.length()));
                        toAdd = toAdd.substring(tokenText.length());
                        added = true;
                        continue;
                    }
                    if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                        if (sequence.moveNext()) continue;
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (!added) {
                        text.append(toAdd);
                    }
                    toAdd = null;
                }
            }
            final int finalLen = len;
            final StringBuilder template = new StringBuilder();
            final Source s = Source.create((Document)doc);
            final AtomicBoolean cancel = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CodeTemplateManager ctm;
                    try {
                        ParserManager.parse(Collections.singletonList(s), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                if (cancel.get()) {
                                    return;
                                }
                                CompilationController controller = CompilationController.get((Parser.Result)resultIterator.getParserResult(offset));
                                controller.toPhase(JavaSource.Phase.RESOLVED);
                                if (cancel.get()) {
                                    return;
                                }
                                DeclaredType type = (DeclaredType)StaticMemberItem.this.typeHandle.resolve((CompilationInfo)controller);
                                int cnt = 1;
                                template.append("${PAR#");
                                template.append(cnt++);
                                template.append(" type=\"");
                                template.append(((TypeElement)type.asElement()).getQualifiedName());
                                template.append("\" default=\"");
                                template.append(((TypeElement)type.asElement()).getSimpleName());
                                template.append("\" editable=false}");
                                Iterator<? extends TypeMirror> tas = type.getTypeArguments().iterator();
                                if (tas.hasNext()) {
                                    template.append('<');
                                    while (tas.hasNext()) {
                                        TypeMirror ta = tas.next();
                                        template.append("${PAR#");
                                        template.append(cnt++);
                                        if (ta.getKind() == TypeKind.TYPEVAR) {
                                            template.append(" type=\"");
                                            ta = ((TypeVariable)ta).getUpperBound();
                                            template.append(Utilities.getTypeName((CompilationInfo)controller, ta, true));
                                            template.append("\" default=\"");
                                            template.append(Utilities.getTypeName((CompilationInfo)controller, ta, false));
                                            template.append("\"}");
                                        } else if (ta.getKind() == TypeKind.WILDCARD) {
                                            template.append(" type=\"");
                                            TypeMirror bound = ((WildcardType)ta).getExtendsBound();
                                            if (bound == null) {
                                                bound = ((WildcardType)ta).getSuperBound();
                                            }
                                            template.append(bound != null ? Utilities.getTypeName((CompilationInfo)controller, bound, true) : "Object");
                                            template.append("\" default=\"");
                                            template.append(bound != null ? Utilities.getTypeName((CompilationInfo)controller, bound, false) : "Object");
                                            template.append("\"}");
                                        } else if (ta.getKind() == TypeKind.ERROR) {
                                            template.append(" default=\"");
                                            template.append(((ErrorType)ta).asElement().getSimpleName());
                                            template.append("\"}");
                                        } else {
                                            template.append(" type=\"");
                                            template.append(Utilities.getTypeName((CompilationInfo)controller, ta, true));
                                            template.append("\" default=\"");
                                            template.append(Utilities.getTypeName((CompilationInfo)controller, ta, false));
                                            template.append("\" editable=false}");
                                        }
                                        if (!tas.hasNext()) continue;
                                        template.append(", ");
                                    }
                                    template.append('>');
                                }
                                template.append('.');
                                template.append(StaticMemberItem.this.memberName);
                                if (StaticMemberItem.this.params != null) {
                                    boolean guessArgs = Utilities.guessMethodArguments();
                                    template.append("(");
                                    Iterator it = StaticMemberItem.this.params.iterator();
                                    while (it.hasNext()) {
                                        ParamDesc paramDesc = (ParamDesc)it.next();
                                        template.append("${");
                                        template.append(paramDesc.name);
                                        if (guessArgs) {
                                            template.append(" named instanceof=");
                                            template.append(paramDesc.fullTypeName);
                                        }
                                        template.append("}");
                                        if (!it.hasNext()) continue;
                                        template.append(", ");
                                    }
                                    template.append(")");
                                }
                                template.append((CharSequence)text);
                                doc.runAtomic(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            Position semiPosition;
                                            Position position = semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                                            if (finalLen > 0) {
                                                doc.remove(offset, finalLen);
                                            }
                                            if (semiPosition != null) {
                                                doc.insertString(semiPosition.getOffset(), ";", null);
                                            }
                                        }
                                        catch (BadLocationException badLocationException) {
                                            // empty catch block
                                        }
                                    }
                                });
                            }
                        });
                    }
                    catch (ParseException pe) {
                        // empty catch block
                    }
                    CodeTemplateManager codeTemplateManager = ctm = template.length() > 0 ? CodeTemplateManager.get((Document)doc) : null;
                    if (ctm != null) {
                        ctm.createTemporary(template.toString()).insert(c);
                    }
                }
            }, (String)NbBundle.getMessage(JavaCompletionItem.class, (String)"JCI-import_resolve"), (AtomicBoolean)cancel, (boolean)false);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : this.modifiers) {
                sb.append(mod.toString());
                sb.append(' ');
            }
            sb.append(this.memberTypeName);
            sb.append(' ');
            sb.append(this.typeName);
            sb.append('.');
            sb.append(this.memberName);
            if (this.params != null) {
                sb.append('(');
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    sb.append(paramDesc.typeName);
                    sb.append(' ');
                    sb.append(paramDesc.name);
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(')');
            }
            return sb.toString();
        }
    }

    static class TypeParameterItem
    extends JavaCompletionItem {
        private static final String TYPE_PARAMETER_COLOR = "<font color=#000000>";
        private String simpleName;
        private String leftText;

        private TypeParameterItem(TypeParameterElement elem, int substitutionOffset) {
            super(substitutionOffset);
            this.simpleName = elem.getSimpleName().toString();
        }

        public int getSortPriority() {
            return 700;
        }

        public CharSequence getSortText() {
            return this.simpleName;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = TYPE_PARAMETER_COLOR + this.simpleName + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        public String toString() {
            return this.simpleName;
        }
    }

    static class VariableItem
    extends JavaCompletionItem {
        private static final String LOCAL_VARIABLE = "org/netbeans/modules/editor/resources/completion/localVariable.gif";
        private static final String PARAMETER_COLOR = "<font color=#00007c>";
        private static ImageIcon icon;
        private String varName;
        private boolean newVarName;
        private boolean smartType;
        private String typeName;
        private String leftText;
        private String rightText;
        private int assignToVarPos;
        private String assignToVarText;

        private VariableItem(CompilationInfo info, TypeMirror type, String varName, int substitutionOffset, boolean newVarName, boolean smartType, int assignToVarPos) {
            super(substitutionOffset);
            this.varName = varName;
            this.newVarName = newVarName;
            this.smartType = smartType;
            this.typeName = type != null ? ((Object)Utilities.getTypeName(info, type, false)).toString() : null;
            this.assignToVarPos = assignToVarPos;
            this.assignToVarText = assignToVarPos < 0 ? null : JavaCompletionItem.getAssignToVarText(info, type, varName);
        }

        public int getSortPriority() {
            return this.smartType ? 200 - SMART_TYPE : 200;
        }

        public CharSequence getSortText() {
            return this.varName;
        }

        public CharSequence getInsertPrefix() {
            return this.varName;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = "<font color=#00007c><b>" + this.varName + JavaCompletionItem.BOLD_END + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)LOCAL_VARIABLE, (boolean)false);
            }
            return icon;
        }

        @Override
        protected void substituteText(JTextComponent c, int offset, int len, String toAdd, boolean assignToVar) {
            try {
                CodeTemplateManager ctm;
                Position endPos;
                final BaseDocument doc = (BaseDocument)c.getDocument();
                final Position startPos = this.assignToVarPos < 0 ? null : doc.createPosition(this.assignToVarPos, Position.Bias.Backward);
                Position position = endPos = this.assignToVarText == null ? null : doc.createPosition(offset);
                super.substituteText(c, offset, len, toAdd != null ? toAdd : (assignToVar && this.assignToVarText != null ? ";" : null), assignToVar);
                if (assignToVar && this.assignToVarText != null && (ctm = CodeTemplateManager.get((Document)doc)) != null) {
                    final String[] docText = new String[1];
                    doc.runAtomic(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                docText[0] = doc.getText(startPos.getOffset(), endPos.getOffset() - startPos.getOffset());
                                doc.remove(startPos.getOffset(), endPos.getOffset() - startPos.getOffset());
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                    CodeTemplate tmp = ctm.createTemporary(this.assignToVarText + docText[0]);
                    c.setCaretPosition(startPos.getOffset());
                    tmp.insert(c);
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }

        public String toString() {
            return (this.typeName != null ? this.typeName + " " : "") + this.varName;
        }
    }

    static abstract class WhiteListJavaCompletionItem<T extends Element>
    extends JavaCompletionItem {
        private static final String WARNING = "org/netbeans/modules/java/editor/resources/warning_badge.gif";
        private static ImageIcon warningIcon;
        private final WhiteListQuery.WhiteList whiteList;
        private final ElementHandle<T> handle;
        private Boolean isBlackListed;

        protected WhiteListJavaCompletionItem(int substitutionOffset, ElementHandle<T> handle, WhiteListQuery.WhiteList whiteList) {
            super(substitutionOffset);
            this.handle = handle;
            this.whiteList = whiteList;
        }

        protected final WhiteListQuery.WhiteList getWhiteList() {
            return this.whiteList;
        }

        protected final ElementHandle<T> getElementHandle() {
            return this.handle;
        }

        protected final boolean isBlackListed() {
            if (this.isBlackListed == null) {
                this.isBlackListed = this.whiteList == null ? false : !this.whiteList.check(this.handle, WhiteListQuery.Operation.USAGE).isAllowed();
            }
            return this.isBlackListed;
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return this.isBlackListed() ? false : super.instantSubstitution(component);
        }

        @Override
        public final ImageIcon getIcon() {
            ImageIcon base = this.getBaseIcon();
            if (base == null || !this.isBlackListed()) {
                return base;
            }
            if (warningIcon == null) {
                warningIcon = ImageUtilities.loadImageIcon((String)WARNING, (boolean)false);
            }
            assert (warningIcon != null);
            return new ImageIcon(ImageUtilities.mergeImages((Image)base.getImage(), (Image)warningIcon.getImage(), (int)8, (int)8));
        }

        protected ImageIcon getBaseIcon() {
            return super.getIcon();
        }
    }
}

