/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.editor.java.JavaCodeTemplateProcessor;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaCodeTemplateFilter
implements CodeTemplateFilter {
    private static final Logger LOG = Logger.getLogger(JavaCodeTemplateFilter.class.getName());
    private int startOffset;
    private int endOffset;
    private Tree.Kind ctx = null;

    private JavaCodeTemplateFilter(JTextComponent component, int offset) {
        if (Utilities.isJavaContext(component, offset, false)) {
            this.startOffset = offset;
            this.endOffset = component.getSelectionStart() == offset ? component.getSelectionEnd() : -1;
            final Source source = Source.create((Document)component.getDocument());
            if (source != null) {
                final AtomicBoolean cancel = new AtomicBoolean();
                ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    CompilationController controller;
                                    if (cancel.get()) {
                                        return;
                                    }
                                    Parser.Result result = resultIterator.getParserResult(JavaCodeTemplateFilter.this.startOffset);
                                    CompilationController compilationController = controller = result != null ? CompilationController.get((Parser.Result)result) : null;
                                    if (controller != null) {
                                        controller.toPhase(JavaSource.Phase.PARSED);
                                        Tree tree = controller.getTreeUtilities().pathFor(JavaCodeTemplateFilter.this.startOffset).getLeaf();
                                        if (JavaCodeTemplateFilter.this.endOffset >= 0 && JavaCodeTemplateFilter.this.startOffset != JavaCodeTemplateFilter.this.endOffset && controller.getTreeUtilities().pathFor(JavaCodeTemplateFilter.this.endOffset).getLeaf() != tree) {
                                            return;
                                        }
                                        JavaCodeTemplateFilter.this.ctx = tree.getKind();
                                    }
                                }
                            });
                        }
                        catch (ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }, (String)NbBundle.getMessage(JavaCodeTemplateProcessor.class, (String)"JCT-init"), (AtomicBoolean)cancel, (boolean)false);
            }
        }
    }

    public synchronized boolean accept(CodeTemplate template) {
        if (this.ctx == null) {
            return false;
        }
        EnumSet<Tree.Kind> contexts = this.getTemplateContexts(template);
        return contexts.size() == 0 || contexts.contains((Object)this.ctx);
    }

    private EnumSet<Tree.Kind> getTemplateContexts(CodeTemplate template) {
        List contexts = template.getContexts();
        ArrayList<Tree.Kind> kinds = new ArrayList<Tree.Kind>();
        if (contexts != null) {
            for (String ctx : contexts) {
                Tree.Kind kind = Tree.Kind.valueOf(ctx);
                if (kind != null) {
                    kinds.add(kind);
                    continue;
                }
                LOG.warning("Invalid code template context '" + ctx + "', ignoring.");
            }
        }
        if (kinds.size() > 0) {
            return EnumSet.copyOf(kinds);
        }
        return EnumSet.noneOf(Tree.Kind.class);
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent component, int offset) {
            return new JavaCodeTemplateFilter(component, offset);
        }
    }
}

