/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring.rename;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.jpa.refactoring.JPARefactoring;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class RelationshipMappingRename
implements JPARefactoring {
    private final RenameRefactoring rename;

    public RelationshipMappingRename(RenameRefactoring rename) {
        this.rename = rename;
    }

    @Override
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Problem result = null;
        TreePathHandle handle = (TreePathHandle)this.rename.getRefactoringSource().lookup(TreePathHandle.class);
        if (handle == null) {
            return null;
        }
        if (handle.getKind() == Tree.Kind.VARIABLE) {
            TypeElement mainEnt;
            Element resElement = handle.resolveElement(RefactoringUtil.getCompilationInfo(handle, (AbstractRefactoring)this.rename));
            VariableElement var = (VariableElement)resElement;
            Element mainEntTmp = var.getEnclosingElement();
            TypeElement typeElement = mainEnt = mainEntTmp instanceof TypeElement ? (TypeElement)mainEntTmp : null;
            if (mainEnt == null) {
                return null;
            }
            List<? extends AnnotationMirror> ans = var.getAnnotationMirrors();
            boolean checkFoMappedBy = false;
            for (AnnotationMirror annotationMirror : ans) {
                String tp = annotationMirror.getAnnotationType().toString();
                if (!"javax.persistence.ManyToOne".equals(tp) && !"javax.persistence.ManyToMany".equals(tp)) continue;
                checkFoMappedBy = true;
                break;
            }
            if (checkFoMappedBy) {
                TypeMirror tm = var.asType();
                TypeElement typeElement2 = RefactoringUtil.getCompilationInfo(handle, (AbstractRefactoring)this.rename).getElements().getTypeElement(((Object)tm).toString());
                for (VariableElement field : ElementFilter.fieldsIn(typeElement2.getEnclosedElements())) {
                    String fqn = ((Object)field.asType()).toString();
                    if (!fqn.endsWith("<" + mainEnt + ">") || !fqn.startsWith("java.util.")) continue;
                    ans = field.getAnnotationMirrors();
                    for (AnnotationMirror annotationMirror : ans) {
                        String tp = annotationMirror.getAnnotationType().toString();
                        if (!"javax.persistence.OneToMany".equals(tp) && !"javax.persistence.ManyToMany".equals(tp)) continue;
                        for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                            if (!executableElement.getSimpleName().toString().equals("mappedBy") || !annotationMirror.getElementValues().get(executableElement).getValue().toString().equals(var.getSimpleName().toString())) continue;
                            FileObject fo = null;
                            try {
                                fo = RefactoringUtil.getTreePathHandle(field.getSimpleName().toString(), typeElement2.toString(), handle.getFileObject()).getFileObject();
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            TreePathHandle ph = null;
                            try {
                                ph = RefactoringUtil.getTreePathHandle(field.getSimpleName().toString(), typeElement2.toString(), handle.getFileObject());
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            CompilationInfo ci = RefactoringUtil.getCompilationInfo(ph, (AbstractRefactoring)this.rename);
                            TreePath tree = ph.resolve(ci);
                            CompilationUnitTree unit = tree.getCompilationUnit();
                            Tree t = tree.getLeaf();
                            List<? extends AnnotationTree> aList = ((VariableTree)t).getModifiers().getAnnotations();
                            AnnotationTree at0 = null;
                            block8: for (AnnotationTree annotationTree : aList) {
                                for (ExpressionTree expressionTree : annotationTree.getArguments()) {
                                    AssignmentTree ast;
                                    if (!(expressionTree instanceof AssignmentTree) || !(ast = (AssignmentTree)expressionTree).toString().startsWith("mappedBy")) continue;
                                    t = ast.getExpression();
                                    at0 = annotationTree;
                                    continue block8;
                                }
                            }
                            SourcePositions sp = ci.getTrees().getSourcePositions();
                            sp.getStartPosition(unit, t);
                            if (fo == null) continue;
                            refactoringElementsBag.add((AbstractRefactoring)this.rename, (RefactoringElementImplementation)new RelationshipAnnotationRenameRefactoringElement(fo, typeElement2, field, at0, t, annotationMirror, var.getSimpleName().toString(), (int)sp.getStartPosition(unit, t), (int)sp.getEndPosition(unit, t)));
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public Problem preCheck() {
        return null;
    }

    private class RelationshipAnnotationRenameRefactoringElement
    extends SimpleRefactoringElementImplementation {
        private final AnnotationMirror annotation;
        private final String attrValue;
        private final FileObject fo;
        private final TypeElement oppEntEl;
        private final Tree tree;
        private final VariableElement var;
        private final AnnotationTree at;
        private int[] loc;

        RelationshipAnnotationRenameRefactoringElement(FileObject fo, TypeElement oppEntEl, VariableElement var, AnnotationTree at, Tree valueTree, AnnotationMirror annotation, String attrValue, int start, int end) {
            this.fo = fo;
            this.annotation = annotation;
            this.attrValue = attrValue;
            if (end - start > attrValue.length()) {
                // empty if block
            }
            this.loc = new int[]{++start, --end};
            this.oppEntEl = oppEntEl;
            this.tree = valueTree;
            this.at = at;
            this.var = var;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return this.annotation.toString().replace("\"" + this.attrValue + "\"", "\"<b>" + this.attrValue + "</b>\"");
        }

        public void performChange() {
            try {
                JavaSource source = JavaSource.forFileObject((FileObject)this.fo);
                source.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws Exception {
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement element = RelationshipAnnotationRenameRefactoringElement.this.oppEntEl;
                        for (AnnotationMirror annotationMirror : RelationshipAnnotationRenameRefactoringElement.this.var.getAnnotationMirrors()) {
                            TreeMaker make = workingCopy.getTreeMaker();
                            AnnotationTree oldAt = RelationshipAnnotationRenameRefactoringElement.this.at;
                            List<? extends ExpressionTree> arguments = oldAt.getArguments();
                            ArrayList<ExpressionTree> newArguments = new ArrayList<ExpressionTree>();
                            Iterator<? extends ExpressionTree> i$ = arguments.iterator();
                            while (i$.hasNext()) {
                                ExpressionTree argument;
                                ExpressionTree tmp = argument = i$.next();
                                if (argument instanceof AssignmentTree) {
                                    AssignmentTree assignment = (AssignmentTree)argument;
                                    ExpressionTree expression = assignment.getExpression();
                                    ExpressionTree variable = assignment.getVariable();
                                    if (variable.toString().equals("mappedBy") && expression instanceof LiteralTree) {
                                        LiteralTree literal = (LiteralTree)expression;
                                        String value = literal.getValue().toString();
                                        if (RelationshipAnnotationRenameRefactoringElement.this.attrValue.equals(value)) {
                                            tmp = make.Assignment(variable, (ExpressionTree)make.Literal((Object)RelationshipMappingRename.this.rename.getNewName()));
                                        }
                                    }
                                }
                                newArguments.add(tmp);
                            }
                            TypeElement typeElement = workingCopy.getElements().getTypeElement(annotationMirror.getAnnotationType().toString());
                            AnnotationTree newAt = make.Annotation((Tree)make.QualIdent((Element)typeElement), newArguments);
                            workingCopy.rewrite((Tree)oldAt, (Tree)newAt);
                        }
                    }
                }).commit();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.fo);
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            try {
                EditorCookie.Observable obs;
                DataObject dobj = DataObject.find((FileObject)this.getParentFile());
                if (dobj != null && (obs = (EditorCookie.Observable)dobj.getCookie(EditorCookie.Observable.class)) != null && obs instanceof CloneableEditorSupport) {
                    CloneableEditorSupport supp = (CloneableEditorSupport)obs;
                    PositionBounds bounds = new PositionBounds(supp.createPositionRef(this.loc[0], Position.Bias.Forward), supp.createPositionRef(Math.max(this.loc[0], this.loc[1]), Position.Bias.Forward));
                    return bounds;
                }
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            return null;
        }
    }
}

