/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.projects.maven;

import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.HashMap;
import java.util.Map;
import org.nbheaven.sqe.core.maven.api.MavenPluginConfiguration;
import org.nbheaven.sqe.core.maven.utils.MavenUtilities;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.settings.FindBugsSettings;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.settings.FindBugsSettingsProvider;
import org.netbeans.api.project.Project;

public class MavenFindBugsSettingsProvider
extends FindBugsSettingsProvider {
    private static final Map<String, String> THRESHOLDS = new HashMap<String, String>();
    private static final Map<String, String> EFFORTS = new HashMap<String, String>();
    private final Project p;

    public MavenFindBugsSettingsProvider(Project prj) {
        this.p = prj;
    }

    public UserPreferences getFindBugsSettings() {
        MavenPluginConfiguration pluginConfiguration = MavenUtilities.getReportPluginConfiguration((Project)this.p, (String)"org.codehaus.mojo", (String)"findbugs-maven-plugin");
        if (pluginConfiguration.isDefinedInProject()) {
            String effort;
            UserPreferences prefs = UserPreferences.createDefaultUserPreferences();
            ProjectFilterSettings pfs = ProjectFilterSettings.createDefault();
            prefs.setProjectFilterSettings(pfs);
            String threshold = THRESHOLDS.get(pluginConfiguration.getValue("threshold"));
            if (threshold != null) {
                pfs.setMinPriority(threshold);
            }
            if ((effort = EFFORTS.get(pluginConfiguration.getValue("effort"))) != null) {
                prefs.setEffort(effort);
            }
            return prefs;
        }
        UserPreferences globalDefaultPreferences = FindBugsSettings.getUserPreferences();
        this.presetPreferences(globalDefaultPreferences);
        return globalDefaultPreferences;
    }

    public void setFindBugsSettings(UserPreferences userPreferences) {
    }

    static {
        THRESHOLDS.put("High", "High");
        THRESHOLDS.put("high", "High");
        THRESHOLDS.put("Low", "Low");
        THRESHOLDS.put("Exp", "Experimental");
        EFFORTS.put("Min", "min");
        EFFORTS.put("Max", "max");
    }
}

