/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.internal;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.common.CoordinatorIF;
import com.sun.xml.ws.tx.at.common.WSATVersion;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContext;
import com.sun.xml.ws.tx.at.internal.WSATGatewayRM;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.dev.WSATRuntimeConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignRecoveryContextManager {
    private static final int REPLAY_TIMER_INTERVAL_MS = new Integer(System.getProperty("com.sun.xml.ws.tx.at.internal.indoubt.timeout.interval", "10000"));
    private static final int INDOUBT_TIMEOUT = new Integer(System.getProperty("com.sun.xml.ws.tx.at.internal.indoubt.timeout", "90000"));
    private static ForeignRecoveryContextManager singleton = new ForeignRecoveryContextManager();
    volatile int counter;
    private static final Logger LOGGER_ContextRunnable = Logger.getLogger(ContextRunnable.class);
    private static final Logger LOGGER_RecoveryContextWorker = Logger.getLogger(RecoveryContextWorker.class);
    private Map<Xid, RecoveryContextWorker> recoveredContexts = new HashMap<Xid, RecoveryContextWorker>();

    private ForeignRecoveryContextManager() {
    }

    public static ForeignRecoveryContextManager getInstance() {
        return singleton;
    }

    public synchronized ForeignRecoveryContext addAndGetForeignRecoveryContextForTidByteArray(Xid xid) {
        RecoveryContextWorker rc = this.recoveredContexts.get(xid);
        if (rc != null) {
            return rc.context;
        }
        ForeignRecoveryContext frc = new ForeignRecoveryContext(xid);
        this.add(frc, false);
        return frc;
    }

    void start() {
        new Thread(new ContextRunnable()).start();
    }

    synchronized void add(ForeignRecoveryContext context) {
        this.add(context, true);
    }

    synchronized void add(ForeignRecoveryContext context, boolean isRecovery) {
        if (context == null) {
            return;
        }
        this.recoveredContexts.put(context.getXid(), new RecoveryContextWorker(context, isRecovery ? -1 : 0));
    }

    synchronized void persist(Xid xid) {
        if (WSATRuntimeConfig.getInstance().isWSATRecoveryEnabled()) {
            ForeignRecoveryContext contextWorker = this.recoveredContexts.get(xid).getContext();
            try {
                String logLocation = WSATGatewayRM.txlogdirInbound + File.separator + System.currentTimeMillis() + "-" + this.counter++;
                contextWorker.setTxLogLocation(logLocation);
                FileOutputStream fos = new FileOutputStream(logLocation);
                ObjectOutputStream out = new ObjectOutputStream(fos);
                out.writeObject(contextWorker);
                out.close();
                fos.flush();
            }
            catch (Throwable e) {
                throw new WebServiceException("Unable to persist log for inbound transaction Xid:" + xid, e);
            }
        }
    }

    public void delete(XidImpl xid) {
        if (WSATRuntimeConfig.getInstance().isWSATRecoveryEnabled()) {
            ForeignRecoveryContext contextWorker = this.recoveredContexts.get(xid).getContext();
            String logLocation = contextWorker.getTxLogLocation();
            try {
                new File(logLocation).delete();
            }
            catch (Throwable e) {
                LOGGER_RecoveryContextWorker.warning("Unable to delete WS-AT log file:" + logLocation);
            }
        }
    }

    Map<Xid, RecoveryContextWorker> getRecoveredContexts() {
        return this.recoveredContexts;
    }

    public ForeignRecoveryContext getForeignRecoveryContext(Xid xid) {
        RecoveryContextWorker recoveryContextWorker = this.recoveredContexts.get(xid);
        return recoveryContextWorker == null ? null : recoveryContextWorker.getContext();
    }

    synchronized void remove(Xid fxid) {
        this.recoveredContexts.remove(fxid);
    }

    private class ContextRunnable
    implements Runnable {
        private ContextRunnable() {
        }

        public void run() {
            while (true) {
                this.doRun();
                try {
                    Thread.sleep(300000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() {
            ArrayList<RecoveryContextWorker> replayList = new ArrayList<RecoveryContextWorker>();
            ForeignRecoveryContextManager foreignRecoveryContextManager = ForeignRecoveryContextManager.this;
            synchronized (foreignRecoveryContextManager) {
                for (RecoveryContextWorker rc : ForeignRecoveryContextManager.this.recoveredContexts.values()) {
                    long lastReplay = rc.getLastReplayMillis();
                    if (lastReplay == -1L) {
                        replayList.add(rc);
                        continue;
                    }
                    try {
                        Transaction transaction = rc.context.getTransaction();
                        if (!this.isEligibleForBottomUpQuery(rc, transaction)) continue;
                        if (lastReplay == 0L) {
                            rc.setLastReplayMillis(System.currentTimeMillis());
                        }
                        replayList.add(rc);
                    }
                    catch (Throwable e) {
                        this.debug("ForeignRecoveryContextManager$ContextTimerListener.timerExpired error scheduling work for recovery context:" + rc.context + " Exception getting transaction status, transaction may be null:" + e);
                    }
                }
            }
            if (!replayList.isEmpty()) {
                this.debug("ForeignRecoveryContextManager$ContextTimerListener.timerExpired replayList.size():" + replayList.size());
            }
            for (RecoveryContextWorker rc : replayList) {
                boolean isScheduled = rc.isScheduled();
                if (isScheduled || System.currentTimeMillis() - rc.getLastReplayMillis() <= (long)(INDOUBT_TIMEOUT * rc.getRetryCount())) continue;
                rc.setScheduled(true);
                rc.incrementRetryCount();
                new Thread(rc).start();
            }
        }

        boolean isEligibleForBottomUpQuery(RecoveryContextWorker rc, Transaction transaction) throws SystemException {
            return rc.context.isRecovered() || transaction != null && transaction.getStatus() == 2;
        }

        private void debug(String message) {
            LOGGER_ContextRunnable.info(message);
        }
    }

    private class RecoveryContextWorker
    implements Runnable {
        ForeignRecoveryContext context;
        long lastReplayMillis;
        boolean scheduled;
        private int retryCount = 1;

        RecoveryContextWorker(ForeignRecoveryContext context, int lastReplay) {
            this.context = context;
            this.lastReplayMillis = lastReplay;
        }

        synchronized long getLastReplayMillis() {
            return this.lastReplayMillis;
        }

        synchronized void setLastReplayMillis(long lastReplayMillis) {
            this.lastReplayMillis = lastReplayMillis;
        }

        synchronized boolean isScheduled() {
            return this.scheduled;
        }

        synchronized void setScheduled(boolean b) {
            this.scheduled = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Xid xid = this.context.getXid();
                if (xid == null) {
                    this.debug("no Xid mapping for recovered context " + this.context);
                    return;
                }
                this.debug("about to send Prepared recovery call for " + this.context);
                CoordinatorIF coordinatorPort = WSATHelper.getInstance(this.context.getVersion()).getCoordinatorPort(this.context.getEndpointReference(), xid);
                this.debug("About to send Prepared recovery call for " + this.context + " with coordinatorPort:" + coordinatorPort);
                Object notification = WSATVersion.getInstance(this.context.getVersion()).newNotificationBuilder().build();
                Transaction transaction = this.context.getTransaction();
                if (this.isEligibleForBottomUpQuery(this, transaction)) {
                    coordinatorPort.preparedOperation(notification);
                }
                this.debug("Prepared recovery call for " + this.context + " returned successfully");
            }
            catch (Throwable e) {
                this.debug("Prepared recovery call error for " + this.context + " exception:" + e);
            }
            finally {
                RecoveryContextWorker recoveryContextWorker = this;
                synchronized (recoveryContextWorker) {
                    this.scheduled = false;
                    this.lastReplayMillis = System.currentTimeMillis();
                }
            }
        }

        boolean isEligibleForBottomUpQuery(RecoveryContextWorker rc, Transaction transaction) throws SystemException {
            return rc.context.isRecovered() || transaction != null && transaction.getStatus() == 2;
        }

        void incrementRetryCount() {
            if (this.retryCount * 2 * INDOUBT_TIMEOUT < 0x2AAAAAAA) {
                this.retryCount *= 2;
            }
            this.debug("Next recovery call for " + this.context + " in:" + this.retryCount * INDOUBT_TIMEOUT + "ms");
        }

        int getRetryCount() {
            return this.retryCount;
        }

        ForeignRecoveryContext getContext() {
            return this.context;
        }

        private void debug(String message) {
            LOGGER_RecoveryContextWorker.info(message);
        }
    }
}

