/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.glassfish;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.glassfish.RegistrationUtil;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.SystemInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.PostStartup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="PingService")
public class PingService
implements PostStartup,
PostConstruct {
    @Inject
    Logger logger;
    @Inject
    Version version;
    private static final long ONE_WEEK = 604800000L;
    private static final String JVM_OPTION = "com.sun.enterprise.registration.PING_TIMER_INTERVAL";
    private static final long TIMER_INTERVAL = Long.getLong("com.sun.enterprise.registration.PING_TIMER_INTERVAL", 10080L) * 60L * 1000L;
    private static final String UC_PING_TIME_STAMP_FILE = ".ping";
    private static final String CONTEXT = "ping";

    public void postConstruct() {
        if (TIMER_INTERVAL <= 0L) {
            this.logger.fine("Domain Ping disabled : com.sun.enterprise.registration.PING_TIMER_INTERVAL <= 0");
            return;
        }
        SystemInfo.UpdateCheckFrequency frequency = SystemInfo.getUpdateCheckFrequency();
        if (frequency.equals((Object)SystemInfo.UpdateCheckFrequency.NEVER)) {
            this.logger.fine("Domain Ping disabled by Update Center option");
            return;
        }
        try {
            RegistrationUtil.synchUUID();
        }
        catch (RegistrationException ex) {
            this.logger.fine("Domain Ping disabled due to UUID exception.");
            this.logger.fine(ex.getMessage());
            return;
        }
        Timer pingTimer = new Timer("PingService", true);
        TimerTask pingTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Image img = null;
                try {
                    HashMap<String, String> map = new HashMap<String, String>();
                    PingService pingService = PingService.this;
                    map.put("product", pingService.version.getProductName().replace(";", ":"));
                    map.put("version", PingService.this.getVersionNumber());
                    map.put("context", PingService.CONTEXT);
                    img = RegistrationUtil.getUpdateCenterImage();
                    img.setMetaData(map);
                    img.refreshCatalog(img.getPreferredAuthorityName());
                    PingService.this.logger.log(Level.INFO, "Domain Pinged: {0}", img.getPreferredAuthorityName());
                    if (PingService.this.logger.isLoggable(Level.FINE)) {
                        PingService.this.logger.fine("X-JPkg-Metadata: product: " + (String)map.get("product"));
                        PingService.this.logger.fine("X-JPkg-Metadata: version: " + (String)map.get("version"));
                        PingService.this.logger.fine("X-JPkg-Metadata: context: " + (String)map.get("context"));
                    }
                }
                catch (Exception e) {
                    if (img != null) {
                        PingService.this.logger.log(Level.FINE, "Domain Ping: Unable to refresh catalog: {0}", img.getPreferredAuthorityName());
                    } else {
                        PingService.this.logger.log(Level.FINE, "Domain Ping: Unable to refresh catalog.  Null image.");
                    }
                    PingService.this.logger.fine(e.getMessage());
                }
                finally {
                    try {
                        PingService.this.setTimeStamp();
                    }
                    catch (Exception ex) {
                        PingService.this.logger.fine(ex.getMessage());
                    }
                }
            }
        };
        long nextPing = 120000L;
        try {
            long current = System.currentTimeMillis();
            long lastPing = this.getTimeStamp();
            if (current - lastPing <= 604800000L) {
                nextPing = lastPing - current + 604800000L;
            }
            if (nextPing < 0L) {
                nextPing = 120000L;
            }
        }
        catch (Exception ex) {
            this.logger.fine("Domain Ping: exception computing next ping time.");
            this.logger.fine(ex.getMessage());
            nextPing = 120000L;
        }
        this.logger.fine("Domain Ping: next ping in " + nextPing / 60000L + " minutes");
        pingTimer.schedule(pingTask, nextPing, TIMER_INTERVAL);
    }

    private void setTimeStamp() throws Exception {
        File f = new File(RegistrationUtil.getRegistrationHome(), UC_PING_TIME_STAMP_FILE);
        if (!f.createNewFile()) {
            f.setLastModified(System.currentTimeMillis());
        }
    }

    private long getTimeStamp() throws Exception {
        File f = new File(RegistrationUtil.getRegistrationHome(), UC_PING_TIME_STAMP_FILE);
        if (!f.exists()) {
            return 0L;
        }
        return f.lastModified();
    }

    private String getVersionNumber() {
        StringBuilder versionNumber = new StringBuilder();
        PingService pingService = this;
        if (pingService.version.getMajorVersion() != null) {
            PingService pingService2 = this;
            versionNumber.append(pingService2.version.getMajorVersion()).append(".");
        } else {
            versionNumber.append("0.");
        }
        PingService pingService3 = this;
        if (pingService3.version.getMinorVersion() != null) {
            PingService pingService4 = this;
            versionNumber.append(pingService4.version.getMinorVersion()).append(".");
        } else {
            versionNumber.append("0.");
        }
        PingService pingService5 = this;
        if (pingService5.version.getUpdateVersion() != null) {
            PingService pingService6 = this;
            versionNumber.append(pingService6.version.getUpdateVersion()).append("-");
        } else {
            versionNumber.append("0-");
        }
        PingService pingService7 = this;
        if (pingService7.version.getBuildVersion() != null) {
            PingService pingService8 = this;
            versionNumber.append(pingService8.version.getBuildVersion());
        } else {
            versionNumber.append("0");
        }
        return versionNumber.toString();
    }
}

