/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.spi;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WildcardTree;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.javaee.specs.support.api.JaxRsStackSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.model.api.RestApplicationModel;
import org.netbeans.modules.websvc.rest.model.api.RestApplications;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.spi.ApplicationConfigPanel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class WebRestSupport
extends RestSupport {
    private static final String GET_REST_RESOURCE_CLASSES = "getRestResourceClasses";
    private static final String GET_CLASSES = "getClasses";
    public static final String PROP_REST_RESOURCES_PATH = "rest.resources.path";
    public static final String PROP_REST_CONFIG_TYPE = "rest.config.type";
    public static final String PROP_REST_JERSEY = "rest.jersey.type";
    public static final String CONFIG_TYPE_IDE = "ide";
    public static final String CONFIG_TYPE_USER = "user";
    public static final String CONFIG_TYPE_DD = "dd";
    public static final String JERSEY_CONFIG_IDE = "ide";
    public static final String JERSEY_CONFIG_SERVER = "server";
    public static final String REST_CONFIG_TARGET = "generate-rest-config";
    protected static final String JERSEY_SPRING_JAR_PATTERN = "jersey-spring.*\\.jar";
    protected static final String JERSEY_PROP_PACKAGES = "com.sun.jersey.config.property.packages";
    protected static final String JERSEY_PROP_PACKAGES_DESC = "Multiple packages, separated by semicolon(;), can be specified in param-value";
    private volatile PropertyChangeListener restModelListener;
    private RequestProcessor REST_APP_MODIFICATION_RP = new RequestProcessor(WebRestSupport.class);

    public WebRestSupport(Project project) {
        super(project);
    }

    @Override
    public boolean isRestSupportOn() {
        if (this.getAntProjectHelper() == null) {
            return false;
        }
        return this.getProjectProperty(PROP_REST_CONFIG_TYPE) != null;
    }

    public void enableRestSupport(RestConfig restConfig) {
        String string = null;
        switch (restConfig) {
            case IDE: {
                string = "ide";
                break;
            }
            case DD: {
                string = CONFIG_TYPE_DD;
            }
        }
        if (string != null) {
            this.setProjectProperty(PROP_REST_CONFIG_TYPE, string);
        }
    }

    @Override
    public FileObject getPersistenceXml() {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.getProject().getProjectDirectory());
        if (persistenceScope != null) {
            return persistenceScope.getPersistenceXml();
        }
        return null;
    }

    public WebApp getWebApp() throws IOException {
        FileObject fileObject = this.getWebXml();
        if (fileObject != null) {
            return DDProvider.getDefault().getDDRoot(fileObject);
        }
        return null;
    }

    protected WebApp findWebApp() throws IOException {
        FileObject fileObject;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null && (fileObject = webModule.getDeploymentDescriptor()) != null) {
            return DDProvider.getDefault().getDDRoot(fileObject);
        }
        return null;
    }

    public String getApplicationPathFromDD() throws IOException {
        ServletMapping servletMapping;
        WebApp webApp = this.findWebApp();
        if (webApp != null && (servletMapping = this.getRestServletMapping(webApp)) != null) {
            String string = null;
            if (servletMapping instanceof ServletMapping25) {
                String[] stringArray = ((ServletMapping25)servletMapping).getUrlPatterns();
                if (stringArray.length > 0) {
                    string = stringArray[0];
                }
            } else {
                string = servletMapping.getUrlPattern();
            }
            if (string != null) {
                if (string.endsWith("*")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                return string;
            }
        }
        return null;
    }

    @Override
    public void upgrade() {
        if (!this.isRestSupportOn()) {
            return;
        }
        try {
            FileObject fileObject = this.getDeploymentDescriptor();
            if (fileObject == null) {
                return;
            }
            WebApp webApp = this.findWebApp();
            if (webApp == null) {
                return;
            }
            Servlet servlet = this.getRestServletAdaptorByName(webApp, "ServletAdaptor");
            if (servlet != null && "com.sun.ws.rest.impl.container.servlet.ServletAdaptor".equals(servlet.getServletClass())) {
                boolean bl = this.hasSpringSupport();
                if (bl) {
                    servlet.setServletClass("com.sun.jersey.spi.spring.container.servlet.SpringServlet");
                    InitParam initParam = (InitParam)servlet.findBeanByName("InitParam", "ParamName", JERSEY_PROP_PACKAGES);
                    if (initParam == null) {
                        try {
                            initParam = (InitParam)servlet.createBean("InitParam");
                            initParam.setParamName(JERSEY_PROP_PACKAGES);
                            initParam.setParamValue(".");
                            initParam.setDescription(JERSEY_PROP_PACKAGES_DESC);
                            servlet.addInitParam(initParam);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                } else {
                    servlet.setServletClass("com.sun.jersey.spi.container.servlet.ServletContainer");
                }
                webApp.write(fileObject);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public FileObject getDeploymentDescriptor() {
        WebModuleProvider webModuleProvider = (WebModuleProvider)this.project.getLookup().lookup(WebModuleProvider.class);
        if (webModuleProvider != null) {
            return webModuleProvider.findWebModule(this.project.getProjectDirectory()).getDeploymentDescriptor();
        }
        return null;
    }

    public FileObject getWebXml() throws IOException {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            FileObject fileObject = webModule.getDeploymentDescriptor();
            if (fileObject == null) {
                FileObject fileObject2;
                FileObject fileObject3 = webModule.getWebInf();
                if (fileObject3 == null && (fileObject2 = webModule.getDocumentBase()) != null) {
                    fileObject3 = fileObject2.createFolder("WEB-INF");
                }
                if (fileObject3 != null) {
                    fileObject = DDHelper.createWebXml((Profile)webModule.getJ2eeProfile(), (FileObject)fileObject3);
                }
            }
            return fileObject;
        }
        return null;
    }

    public ServletMapping getRestServletMapping(WebApp webApp) {
        String string = null;
        for (Servlet servlet : webApp.getServlet()) {
            String string2 = servlet.getServletClass();
            if (!"com.sun.jersey.spi.container.servlet.ServletContainer".equals(string2) && !"com.sun.jersey.spi.spring.container.servlet.SpringServlet".equals(string2)) continue;
            string = servlet.getServletName();
            break;
        }
        if (string != null) {
            for (Servlet servlet : webApp.getServletMapping()) {
                if (!string.equals(servlet.getServletName())) continue;
                return servlet;
            }
        }
        return null;
    }

    protected boolean hasRestServletAdaptor() {
        try {
            return this.getRestServletAdaptor(this.getWebApp()) != null;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    public boolean hasServerJerseyLibrary() {
        return this.getJaxRsStackSupport() != null;
    }

    public JaxRsStackSupport getJaxRsStackSupport() {
        return JaxRsStackSupport.getInstance((Project)this.project);
    }

    protected Servlet getRestServletAdaptor(WebApp webApp) {
        if (webApp != null) {
            for (Servlet servlet : webApp.getServlet()) {
                String string = servlet.getServletClass();
                if (!"com.sun.jersey.spi.container.servlet.ServletContainer".equals(string) && !"com.sun.jersey.spi.spring.container.servlet.SpringServlet".equals(string) && !"com.sun.ws.rest.impl.container.servlet.ServletAdaptor".equals(string)) continue;
                return servlet;
            }
        }
        return null;
    }

    protected Servlet getRestServletAdaptorByName(WebApp webApp, String string) {
        if (webApp != null) {
            for (Servlet servlet : webApp.getServlet()) {
                if (!string.equals(servlet.getServletName())) continue;
                return servlet;
            }
        }
        return null;
    }

    @Override
    public void configure(String ... stringArray) throws IOException {
        RestApplicationModel restApplicationModel;
        String string = this.getProjectProperty(PROP_REST_CONFIG_TYPE);
        if (CONFIG_TYPE_DD.equals(string)) {
            this.configRestPackages(stringArray);
        } else if ("ide".equals(string) && (restApplicationModel = this.getRestApplicationsModel()) != null) {
            try {
                restApplicationModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<RestApplications, Void>(){

                    public Void run(RestApplications restApplications) throws IOException {
                        List<RestApplication> list = restApplications.getRestApplications();
                        if (list != null && !list.isEmpty()) {
                            RestApplication restApplication = list.get(0);
                            String string = restApplication.getApplicationClass();
                            WebRestSupport.this.reconfigApplicationClass(string);
                        }
                        return null;
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                Logger.getLogger(WebRestSupport.class.getName()).log(Level.INFO, metadataModelException.getLocalizedMessage(), metadataModelException);
            }
        }
    }

    public void addResourceConfigToWebApp(String string) throws IOException {
        FileObject fileObject = this.getWebXml();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        if (webApp.getStatus() == 2) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebRestSupport.class, (String)"MSG_InvalidDD", (Object)webApp.getError()), 0));
            return;
        }
        boolean bl = false;
        try {
            ServletMapping servletMapping;
            Servlet servlet = this.getRestServletAdaptor(webApp);
            if (servlet == null) {
                servlet = (Servlet)webApp.createBean("Servlet");
                servlet.setServletName("ServletAdaptor");
                boolean bl2 = this.hasSpringSupport();
                if (bl2) {
                    servlet.setServletClass("com.sun.jersey.spi.spring.container.servlet.SpringServlet");
                    servletMapping = (InitParam)servlet.createBean("InitParam");
                    servletMapping.setParamName(JERSEY_PROP_PACKAGES);
                    servletMapping.setParamValue(".");
                    servletMapping.setDescription(JERSEY_PROP_PACKAGES_DESC);
                    servlet.addInitParam((InitParam)servletMapping);
                } else {
                    servlet.setServletClass("com.sun.jersey.spi.container.servlet.ServletContainer");
                }
                servlet.setLoadOnStartup(BigInteger.valueOf(1L));
                webApp.addServlet(servlet);
                bl = true;
            }
            String string2 = string;
            if (!string.startsWith("/")) {
                string2 = "/" + string;
            }
            if (string2.endsWith("/")) {
                string2 = string2 + "*";
            } else if (!string2.endsWith("*")) {
                string2 = string2 + "/*";
            }
            servletMapping = this.getRestServletMapping(webApp);
            if (servletMapping == null) {
                servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                servletMapping.setServletName(servlet.getServletName());
                if (servletMapping instanceof ServletMapping25) {
                    ((ServletMapping25)servletMapping).addUrlPattern(string2);
                } else {
                    servletMapping.setUrlPattern(string2);
                }
                webApp.addServletMapping(servletMapping);
                bl = true;
            } else {
                String[] stringArray;
                boolean bl3 = false;
                if (servletMapping instanceof ServletMapping25) {
                    stringArray = ((ServletMapping25)servletMapping).getUrlPatterns();
                    if (stringArray.length == 0 || !string2.equals(stringArray[0])) {
                        bl3 = true;
                    }
                } else if (!string2.equals(servletMapping.getUrlPattern())) {
                    bl3 = true;
                }
                if (bl3) {
                    if (servletMapping instanceof ServletMapping25) {
                        stringArray = ((ServletMapping25)servletMapping).getUrlPatterns();
                        if (stringArray.length > 0) {
                            ((ServletMapping25)servletMapping).setUrlPattern(0, string2);
                        } else {
                            ((ServletMapping25)servletMapping).addUrlPattern(string2);
                        }
                    } else {
                        servletMapping.setUrlPattern(string2);
                    }
                    bl = true;
                }
            }
            if (bl) {
                webApp.write(fileObject);
                this.logResourceCreation(this.project);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException);
        }
    }

    @Override
    public String getApplicationPath() throws IOException {
        String string = this.getApplicationPathFromDD();
        String string2 = this.getApplicationPathFromAnnotations(string);
        return string2 == null ? super.getApplicationPath() : string2;
    }

    protected String getApplicationPathFromAnnotations(String string) {
        List<RestApplication> list = this.getRestApplications();
        if (string == null) {
            if (list.size() == 0) {
                return null;
            }
            return list.get(0).getApplicationPath();
        }
        if (list.size() == 0) {
            return string;
        }
        for (RestApplication restApplication : list) {
            if (!string.equals(restApplication.getApplicationPath())) continue;
            return string;
        }
        return list.get(0).getApplicationPath();
    }

    protected void removeResourceConfigFromWebApp() throws IOException {
        FileObject fileObject = this.getWebXml();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        boolean bl = false;
        Servlet servlet = this.getRestServletAdaptorByName(webApp, "ServletAdaptor");
        if (servlet != null) {
            webApp.removeServlet(servlet);
            bl = true;
        }
        for (ServletMapping servletMapping : webApp.getServletMapping()) {
            if (!"ServletAdaptor".equals(servletMapping.getServletName())) continue;
            webApp.removeServletMapping(servletMapping);
            bl = true;
            break;
        }
        if (bl) {
            webApp.write(fileObject);
        }
    }

    protected void logResourceCreation(Project project) {
    }

    public List<RestApplication> getRestApplications() {
        RestApplicationModel restApplicationModel = this.getRestApplicationsModel();
        if (restApplicationModel != null) {
            try {
                Future future = restApplicationModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<RestApplications, List<RestApplication>>(){

                    public List<RestApplication> run(RestApplications restApplications) throws IOException {
                        return restApplications.getRestApplications();
                    }
                });
                return (List)future.get();
            }
            catch (IOException iOException) {
                return Collections.emptyList();
            }
            catch (InterruptedException interruptedException) {
                return Collections.emptyList();
            }
            catch (ExecutionException executionException) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    protected RestConfig setApplicationConfigProperty(boolean bl) {
        ApplicationConfigPanel applicationConfigPanel = new ApplicationConfigPanel(bl, this.hasServerJerseyLibrary());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)applicationConfigPanel, NbBundle.getMessage(WebRestSupport.class, (String)"TTL_ApplicationConfigPanel"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            String string = applicationConfigPanel.getConfigType();
            this.setProjectProperty(PROP_REST_CONFIG_TYPE, string);
            RestConfig restConfig = null;
            if ("ide".equals(string)) {
                String string2 = applicationConfigPanel.getApplicationPath();
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                this.setProjectProperty(PROP_REST_RESOURCES_PATH, string2);
                restConfig = RestConfig.IDE;
                restConfig.setResourcePath(string2);
            } else if (CONFIG_TYPE_DD.equals(string)) {
                restConfig = RestConfig.DD;
                restConfig.setResourcePath(applicationConfigPanel.getApplicationPath());
            }
            if (restConfig != null) {
                restConfig.setJerseyLibSelected(applicationConfigPanel.isJerseyLibSelected());
                restConfig.setServerJerseyLibSelected(applicationConfigPanel.isServerJerseyLibSelected());
                if (applicationConfigPanel.isServerJerseyLibSelected()) {
                    this.setProjectProperty(PROP_REST_JERSEY, JERSEY_CONFIG_SERVER);
                } else if (applicationConfigPanel.isJerseyLibSelected()) {
                    this.setProjectProperty(PROP_REST_JERSEY, "ide");
                }
                return restConfig;
            }
        } else {
            this.setProjectProperty(PROP_REST_CONFIG_TYPE, CONFIG_TYPE_USER);
            RestConfig restConfig = RestConfig.USER;
            restConfig.setJerseyLibSelected(false);
            restConfig.setServerJerseyLibSelected(false);
            return restConfig;
        }
        return RestConfig.USER;
    }

    protected void addJerseySpringJar() throws IOException {
        File[] fileArray;
        File file;
        ClassPath classPath;
        FileObject fileObject = this.findSourceRoot();
        if (fileObject != null && (classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile")).findResource("com/sun/jersey/api/spring/Autowire.class") == null && (file = InstalledFileLocator.getDefault().locate("modules/ext/rest", null, false)) != null && file.isDirectory() && (fileArray = file.listFiles(new RestSupport.JerseyFilter(JERSEY_SPRING_JAR_PATTERN))) != null && fileArray.length > 0) {
            URL uRL = FileUtil.getArchiveRoot((URL)fileArray[0].toURI().toURL());
            ProjectClassPathModifier.addRoots((URL[])new URL[]{uRL}, (FileObject)fileObject, (String)"classpath/compile");
        }
    }

    @Override
    public int getProjectType() {
        return 1;
    }

    private String getPackagesList(Iterable<String> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : iterable) {
            stringBuilder.append(string);
            stringBuilder.append(';');
        }
        String string = stringBuilder.length() > 0 ? stringBuilder.substring(0, stringBuilder.length() - 1) : stringBuilder.toString();
        return string;
    }

    private String getPackagesList(String[] stringArray) {
        return this.getPackagesList(Arrays.asList(stringArray));
    }

    private InitParam createJerseyPackagesInitParam(Servlet servlet, String ... stringArray) throws ClassNotFoundException {
        InitParam initParam = (InitParam)servlet.createBean("InitParam");
        initParam.setParamName(JERSEY_PROP_PACKAGES);
        initParam.setParamValue(this.getPackagesList(stringArray));
        initParam.setDescription(JERSEY_PROP_PACKAGES_DESC);
        return initParam;
    }

    protected void reconfigApplicationClass(final String string) {
        if (this.restModelListener == null) {
            this.scheduleReconfigAppClass(string);
            this.restModelListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    WebRestSupport.this.scheduleReconfigAppClass(string);
                }
            };
            this.addModelListener(this.restModelListener);
        }
    }

    private void scheduleReconfigAppClass(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    WebRestSupport.this.doReconfigApplicationClass(string);
                }
                catch (IOException iOException) {
                    Logger.getLogger(WebRestSupport.class.getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                }
            }
        };
        this.REST_APP_MODIFICATION_RP.post(runnable);
    }

    protected void doReconfigApplicationClass(String string) throws IOException {
        JavaSource javaSource = this.getJavaSourceFromClassName(string);
        if (javaSource == null) {
            return;
        }
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                for (Tree tree : compilationUnitTree.getTypeDecls()) {
                    if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                    MethodTree methodTree = null;
                    MethodTree methodTree2 = null;
                    ClassTree classTree = (ClassTree)tree;
                    List<? extends Tree> list = classTree.getMembers();
                    for (Tree tree2 : list) {
                        if (!tree2.getKind().equals((Object)Tree.Kind.METHOD)) continue;
                        MethodTree methodTree3 = (MethodTree)tree2;
                        String string = methodTree3.getName().toString();
                        if (string.equals(WebRestSupport.GET_CLASSES)) {
                            methodTree = methodTree3;
                            continue;
                        }
                        if (!string.equals(WebRestSupport.GET_REST_RESOURCE_CLASSES)) continue;
                        methodTree2 = methodTree3;
                    }
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    ClassTree tree22 = classTree;
                    tree22 = WebRestSupport.this.removeResourcesMethod(methodTree2, treeMaker, tree22);
                    tree22 = WebRestSupport.this.createMethods(methodTree, treeMaker, tree22, methodTree2 == null);
                    workingCopy.rewrite((Tree)classTree, (Tree)tree22);
                }
            }
        }).commit();
    }

    protected FileObject getFileObjectFromClassName(String string) throws IOException {
        FileObject fileObject = this.findSourceRoot();
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)fileObject);
        ClassIndex classIndex = classpathInfo.getClassIndex();
        int n = string.lastIndexOf(46) + 1;
        String string2 = string.substring(n);
        Set set = classIndex.getDeclaredTypes(string2, ClassIndex.NameKind.SIMPLE_NAME, Collections.singleton(ClassIndex.SearchScope.SOURCE));
        for (ElementHandle elementHandle : set) {
            if (!string.equals(elementHandle.getQualifiedName())) continue;
            return SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)classpathInfo);
        }
        return null;
    }

    protected JavaSource getJavaSourceFromClassName(String string) throws IOException {
        FileObject fileObject = this.getFileObjectFromClassName(string);
        if (fileObject != null) {
            return JavaSource.forFileObject((FileObject)fileObject);
        }
        return null;
    }

    private void configRestPackages(String ... stringArray) throws IOException {
        try {
            this.addResourceConfigToWebApp("/webresources/*");
            FileObject fileObject = this.getWebXml();
            WebApp webApp = this.getWebApp();
            if (webApp == null) {
                return;
            }
            if (webApp.getStatus() == 2) {
                return;
            }
            boolean bl = false;
            Servlet servlet = this.getRestServletAdaptor(webApp);
            if (servlet == null) {
                return;
            }
            InitParam initParam = servlet.getInitParam();
            boolean bl2 = false;
            for (InitParam initParam2 : initParam) {
                if (!initParam2.getParamName().equals(JERSEY_PROP_PACKAGES)) continue;
                bl2 = true;
                String string = initParam2.getParamValue();
                string = string != null ? string.trim() : "";
                if (string.length() == 0 || string.equals(".")) {
                    initParam2.setParamValue(this.getPackagesList(stringArray));
                    bl = true;
                    continue;
                }
                String[] stringArray2 = string.split(";");
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                linkedHashSet.addAll(Arrays.asList(stringArray2));
                linkedHashSet.addAll(Arrays.asList(stringArray));
                initParam2.setParamValue(this.getPackagesList(linkedHashSet));
                bl = stringArray2.length != linkedHashSet.size();
            }
            if (!bl2) {
                InitParam initParam3 = this.createJerseyPackagesInitParam(servlet, stringArray);
                servlet.addInitParam(initParam3);
                bl = true;
            }
            if (bl) {
                webApp.write(fileObject);
                this.logResourceCreation(this.project);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException);
        }
    }

    private ClassTree removeResourcesMethod(MethodTree methodTree, TreeMaker treeMaker, ClassTree classTree) {
        return treeMaker.removeClassMember(classTree, (Tree)methodTree);
    }

    private ClassTree createMethods(MethodTree methodTree, TreeMaker treeMaker, ClassTree classTree, boolean bl) throws IOException {
        Tree tree;
        Object object;
        WildcardTree wildcardTree = treeMaker.Wildcard(Tree.Kind.UNBOUNDED_WILDCARD, null);
        ParameterizedTypeTree parameterizedTypeTree = treeMaker.ParameterizedType((Tree)treeMaker.QualIdent(Class.class.getCanonicalName()), Collections.singletonList(wildcardTree));
        ParameterizedTypeTree parameterizedTypeTree2 = treeMaker.ParameterizedType((Tree)treeMaker.QualIdent(Set.class.getCanonicalName()), Collections.singletonList(parameterizedTypeTree));
        if (methodTree == null) {
            object = treeMaker.Modifiers(EnumSet.of(Modifier.PUBLIC));
            tree = treeMaker.Method((ModifiersTree)object, (CharSequence)GET_CLASSES, (Tree)parameterizedTypeTree2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{return getRestResourceClasses();}", null);
            classTree = treeMaker.addClassMember(classTree, tree);
        }
        object = new StringBuilder();
        this.collectRestResources((StringBuilder)object);
        tree = treeMaker.Modifiers(EnumSet.of(Modifier.PRIVATE));
        MethodTree methodTree2 = treeMaker.Method(tree, (CharSequence)GET_REST_RESOURCE_CLASSES, (Tree)parameterizedTypeTree2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), ((StringBuilder)object).toString(), null);
        if (bl) {
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)"Do not modify this method. It is automatically generated by NetBeans REST support.");
            treeMaker.addComment((Tree)methodTree2, comment, true);
        }
        classTree = treeMaker.addClassMember(classTree, (Tree)methodTree2);
        return classTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectRestResources(final StringBuilder stringBuilder) throws IOException {
        stringBuilder.append('{');
        stringBuilder.append("Set<Class<?>> resources = new java.util.HashSet<Class<?>>();");
        RestServicesModel restServicesModel = this.getRestServicesModel();
        try {
            restServicesModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                public Void run(RestServicesMetadata restServicesMetadata) throws Exception {
                    RestServiceDescription[] restServiceDescriptionArray;
                    RestServices restServices = restServicesMetadata.getRoot();
                    for (RestServiceDescription restServiceDescription : restServiceDescriptionArray = restServices.getRestServiceDescription()) {
                        String string = restServiceDescription.getClassName();
                        stringBuilder.append("resources.add(");
                        stringBuilder.append(string);
                        stringBuilder.append(".class);");
                    }
                    return null;
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            Logger.getLogger(WebRestSupport.class.getName()).log(Level.INFO, metadataModelException.getLocalizedMessage(), metadataModelException);
        }
        finally {
            stringBuilder.append("return resources;");
            stringBuilder.append('}');
        }
    }

    public static enum RestConfig {
        IDE,
        USER,
        DD;

        private String resourcePath;
        private boolean jerseyLibSelected;
        private boolean serverJerseyLibSelected;

        public boolean isJerseyLibSelected() {
            return this.jerseyLibSelected;
        }

        public void setJerseyLibSelected(boolean bl) {
            this.jerseyLibSelected = bl;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public void setResourcePath(String string) {
            this.resourcePath = string;
        }

        public void setServerJerseyLibSelected(boolean bl) {
            this.serverJerseyLibSelected = bl;
        }

        public boolean isServerJerseyLibSelected() {
            return this.serverJerseyLibSelected;
        }
    }
}

