/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.validator;

import com.sun.faces.util.MessageFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;

public class DateTimeRangeValidator
implements Validator,
StateHolder {
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MINIMUM";
    private String _globalDateFormat = "yyyy/MM/dd HH:mm:ss";
    private static final String DATE_ATTR_TODAY = "today";
    private static final String DATE_ATTR_TOMORROW = "tomorrow";
    private static final String DATE_ATTR_YESTERDAY = "yesterday";
    private static final String TIME_ATTR_NOW = "now";
    private Date minimum = null;
    private Date maximum = null;
    private boolean minimumSet = false;
    private boolean maximumSet = false;
    private boolean transientValue = false;

    public DateTimeRangeValidator() {
    }

    public DateTimeRangeValidator(Date date) {
        this.setMaximum(date);
    }

    public DateTimeRangeValidator(Date date, Date date2) {
        this.setMaximum(date);
        this.setMinimum(date2);
    }

    public Date getMaximum() {
        return this.isMaximumSet() ? this.maximum : null;
    }

    public void setMaximum(Date date) {
        this.maximum = date;
        this.maximumSet = true;
    }

    public boolean isMaximumSet() {
        return this.maximumSet;
    }

    public Date getMinimum() {
        return this.isMinimumSet() ? this.minimum : null;
    }

    public void setMinimum(Date date) {
        this.minimum = date;
        this.minimumSet = true;
    }

    public boolean isMinimumSet() {
        return this.minimumSet;
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) throws FacesException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        Date date = null;
        if (object != null) {
            if (object instanceof Date) {
                date = (Date)object;
            } else if (object instanceof Long) {
                date = new Date((Long)object);
            } else {
                throw new FacesException("Validation Error: Specified attribute cannot be converted to proper type.");
            }
            this.calculateTimeAndPrintErrors(date, facesContext, (UIInput)uIComponent);
        }
    }

    protected FacesMessage getMessage(FacesContext facesContext, String string) {
        return MessageFactory.getMessage((FacesContext)facesContext, (String)string);
    }

    protected FacesMessage getMessage(FacesContext facesContext, String string, Object[] objectArray) {
        return MessageFactory.getMessage((FacesContext)facesContext, (String)string, (Object[])objectArray);
    }

    protected String stringValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    protected void calculateTimeAndPrintErrors(Date date, FacesContext facesContext, UIInput uIInput) {
        String string;
        FacesMessage facesMessage = null;
        Date date2 = null;
        Date date3 = null;
        if (this.isMinimumSet()) {
            date2 = this.getMinimum();
        }
        if (this.isMaximumSet()) {
            date3 = this.getMaximum();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (date2 != null && date.before(date2)) {
            string = simpleDateFormat.format(date2);
            facesMessage = this.getMessage(facesContext, MINIMUM_MESSAGE_ID, new Object[]{string});
            facesContext.addMessage(uIInput.getClientId(facesContext), facesMessage);
            uIInput.setValid(false);
        }
        if (date3 != null && date.after(date3)) {
            string = simpleDateFormat.format(date3);
            facesMessage = this.getMessage(facesContext, MAXIMUM_MESSAGE_ID, new Object[]{string});
            facesContext.addMessage(uIInput.getClientId(facesContext), facesMessage);
            uIInput.setValid(false);
        }
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{this.maximum, this.maximumSet ? Boolean.TRUE : Boolean.FALSE, this.minimum, this.minimumSet ? Boolean.TRUE : Boolean.FALSE};
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.maximum = (Date)objectArray[0];
        this.maximumSet = (Boolean)objectArray[1];
        this.minimum = (Date)objectArray[2];
        this.minimumSet = (Boolean)objectArray[3];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean bl) {
        this.transientValue = bl;
    }
}

