/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.validator;

import com.ibm.faces.ResourceHandler;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class ConstraintValidator
implements Validator,
StateHolder {
    private String regex;
    private ResourceBundle rb;
    private boolean transientFlag = false;

    public ConstraintValidator() {
    }

    public ConstraintValidator(String string) {
        this.setRegex(string);
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) throws ValidatorException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(ResourceHandler.getString(this.rb, "ConstraintValidator.FacesContext_or_UIComponent_is_null._5"));
        }
        this.rb = ResourceHandler.getBundle(facesContext);
        String string = "";
        if (object != null) {
            string = object instanceof String ? (String)object : object.toString();
            if (this.regex.equals("AlphabetOnly")) {
                this.validateAlphabetOnly(string, facesContext, (UIInput)uIComponent);
            } else if (this.regex.equals("DigitOnly")) {
                this.validateDigitOnly(string, facesContext, (UIInput)uIComponent);
            } else if (this.regex.equals("AlnumOnly")) {
                this.validateAlnumOnly(string, facesContext, (UIInput)uIComponent);
            } else {
                this.validateRegEx(string, facesContext, (UIInput)uIComponent);
            }
        }
    }

    protected void validateAlphabetOnly(String string, FacesContext facesContext, UIInput uIInput) {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            boolean bl2 = Character.isLetter(cArray[i]);
            if (bl2) continue;
            bl = false;
            break;
        }
        if (!bl) {
            FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ConstraintValidator.Validation_Error._8"), ResourceHandler.getString(this.rb, "ConstraintValidator.This_field_may_only_contain_alphabetic_characters_between_A_to_Z._1"));
            facesContext.addMessage(uIInput.getClientId(facesContext), facesMessage);
            uIInput.setValid(false);
        }
    }

    protected void validateDigitOnly(String string, FacesContext facesContext, UIInput uIInput) {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            boolean bl2 = Character.isDigit(cArray[i]);
            if (bl2) continue;
            bl = false;
            break;
        }
        if (!bl) {
            FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ConstraintValidator.Validation_Error._9"), ResourceHandler.getString(this.rb, "ConstraintValidator.This_field_may_only_contain_digits_between_0_to_9._2"));
            facesContext.addMessage(uIInput.getClientId(facesContext), facesMessage);
            uIInput.setValid(false);
        }
    }

    protected void validateAlnumOnly(String string, FacesContext facesContext, UIInput uIInput) {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            boolean bl2 = Character.isLetterOrDigit(cArray[i]);
            if (bl2) continue;
            bl = false;
            break;
        }
        if (!bl) {
            FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ConstraintValidator.Validation_Error._10"), ResourceHandler.getString(this.rb, "ConstraintValidator.This_field_may_contain_alphabetic_characters_and_digits._3"));
            facesContext.addMessage(uIInput.getClientId(facesContext), facesMessage);
            uIInput.setValid(false);
        }
    }

    protected void validateRegEx(String string, FacesContext facesContext, UIInput uIInput) {
        try {
            if (!string.matches(this.regex)) {
                FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ConstraintValidator.Validation_Error._10"), ResourceHandler.getString(this.rb, "ConstraintValidator.MatchRegExp"));
                facesContext.addMessage(uIInput.getClientId(facesContext), facesMessage);
                uIInput.setValid(false);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ConstraintValidator.Validation_Error._10"), ResourceHandler.getString(this.rb, "ConstraintValidator.InvalidRegExp"));
            facesContext.addMessage(uIInput.getClientId(facesContext), facesMessage);
            uIInput.setValid(false);
        }
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{this.regex};
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.regex = (String)objectArray[0];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean bl) {
        this.transientFlag = bl;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String string) {
        this.regex = string;
    }
}

