/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.util;

import com.ibm.faces.util.LifecycleUtil;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class JavaScriptUtil {
    public static final String JS_NEWLINE = "\n";
    private static final String VAR_NAME_PREFIX = "hx_";
    private static String[] javascriptReservedWords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "imports", "in", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "var", "void", "while", "with"};
    private static String RESOURCE_ROOT_DIR = LifecycleUtil.getJSResourceURLPattern(FacesContext.getCurrentInstance().getExternalContext().getInitParameter("com.ibm.faces.JS_RESOURCE_SERVLET_URL_PATTERN")) + "/";
    private static String IMG_SUB_DIR = "img/";
    private static String CSS_SUB_DIR = "css/";
    private static String DLG_SUB_DIR = "dlg/";
    private static String ODC_PRJ_DIR = "odc/";
    private static String ODC_RTE_DIR = "rte/";
    private static String ODC_RTE_IMG_DIR = "images/";
    private static Map _keyTable = null;

    public static boolean isJavaScriptReservedWord(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = javascriptReservedWords.length;
        int n3 = 0;
        while (n <= n2) {
            n3 = (n + n2) / 2;
            int n4 = string.compareTo(javascriptReservedWords[n3]);
            if (n4 == 0) {
                bl = true;
                break;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return bl;
    }

    public static String makeVariableName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        n2 = stringBuffer.length();
        for (n = 0; n < n2; ++n) {
            char c = stringBuffer.charAt(n);
            if (Character.isLetterOrDigit(c)) continue;
            stringBuffer.replace(n, n + 1, "_");
        }
        return VAR_NAME_PREFIX + stringBuffer.toString();
    }

    public static String getStartTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<script type=\"text/JavaScript\" language=\"JavaScript\"");
        if (string != null) {
            stringBuffer.append(" src=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static String getStartTag() {
        return JavaScriptUtil.getStartTag(null);
    }

    public static String getEndTag() {
        return "</script>";
    }

    public static boolean isValidWidth(String string) {
        boolean bl = true;
        if (string == null || string == "") {
            bl = false;
        } else {
            int n = string.length();
            if (string.endsWith("%")) {
                --n;
            }
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean isValidHeight(String string) {
        return JavaScriptUtil.isValidWidth(string);
    }

    public static String getResourcePath(FacesContext facesContext, String string) {
        String string2 = null;
        if (facesContext != null) {
            string2 = facesContext.getExternalContext().getRequestContextPath();
        }
        if (string2 != null && string2 != "") {
            string2 = string2 + "/";
        }
        return string2 + RESOURCE_ROOT_DIR + string;
    }

    public static String getImagePath(FacesContext facesContext) {
        return JavaScriptUtil.getResourcePath(facesContext, IMG_SUB_DIR);
    }

    public static String getCSSPath(FacesContext facesContext) {
        return JavaScriptUtil.getResourcePath(facesContext, CSS_SUB_DIR);
    }

    public static String getDlgPath(FacesContext facesContext) {
        return JavaScriptUtil.getResourcePath(facesContext, DLG_SUB_DIR);
    }

    public static String getJavaScriptPath(FacesContext facesContext) {
        return RESOURCE_ROOT_DIR;
    }

    public static String getOdysseyPath(FacesContext facesContext) {
        return JavaScriptUtil.getResourcePath(facesContext, ODC_PRJ_DIR);
    }

    public static String getOdysseyEditorPath(FacesContext facesContext) {
        return JavaScriptUtil.getResourcePath(facesContext, ODC_PRJ_DIR + ODC_RTE_DIR);
    }

    public static String getOdysseyEditorImagesPath(FacesContext facesContext) {
        return JavaScriptUtil.getResourcePath(facesContext, ODC_PRJ_DIR + ODC_RTE_DIR + ODC_RTE_IMG_DIR);
    }

    public static String getKeyCode(String string) {
        if (_keyTable == null) {
            JavaScriptUtil._createKeyTable();
        }
        return (String)_keyTable.get(string.toLowerCase());
    }

    private static void _createKeyTable() {
        _keyTable = new HashMap();
        _keyTable.put("tab", "9");
        _keyTable.put("enter", "13");
        _keyTable.put("space", "32");
        _keyTable.put("f1", "112");
        _keyTable.put("f2", "113");
        _keyTable.put("f3", "114");
        _keyTable.put("f4", "115");
        _keyTable.put("f5", "116");
        _keyTable.put("f6", "117");
        _keyTable.put("f7", "118");
        _keyTable.put("f8", "119");
        _keyTable.put("f9", "120");
        _keyTable.put("f10", "121");
        _keyTable.put("f11", "122");
        _keyTable.put("f12", "123");
        _keyTable.put("a", "65");
        _keyTable.put("b", "66");
        _keyTable.put("c", "67");
        _keyTable.put("d", "68");
        _keyTable.put("e", "69");
        _keyTable.put("f", "70");
        _keyTable.put("g", "71");
        _keyTable.put("h", "72");
        _keyTable.put("i", "73");
        _keyTable.put("j", "74");
        _keyTable.put("k", "75");
        _keyTable.put("l", "76");
        _keyTable.put("m", "77");
        _keyTable.put("n", "78");
        _keyTable.put("o", "79");
        _keyTable.put("p", "80");
        _keyTable.put("q", "81");
        _keyTable.put("r", "82");
        _keyTable.put("s", "83");
        _keyTable.put("t", "84");
        _keyTable.put("u", "85");
        _keyTable.put("v", "86");
        _keyTable.put("w", "87");
        _keyTable.put("x", "88");
        _keyTable.put("y", "89");
        _keyTable.put("z", "90");
        _keyTable.put("arrow_up", "38");
        _keyTable.put("arrow_down", "40");
        _keyTable.put("arrow_left", "37");
        _keyTable.put("arrow_right", "39");
    }

    public static String convertEL2JavaScript(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("#{")) {
            string = string.substring(2);
        }
        if (string.endsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.replaceAll(" eq ", " == ");
        string = string.replaceAll(" ne ", " != ");
        string = string.replaceAll(" lt ", " < ");
        string = string.replaceAll(" gt ", " > ");
        string = string.replaceAll(" le ", " <= ");
        string = string.replaceAll(" ge ", " >= ");
        string = string.replaceAll(" and ", " && ");
        string = string.replaceAll(" or ", " || ");
        string = string.replaceAll(" not ", " ! ");
        string = string.replaceAll(" mod ", " % ");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuffer stringBuffer2 = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl && c != '\"') {
                stringBuffer.append(c);
                continue;
            }
            if (bl2 && c != '\'') {
                stringBuffer.append(c);
                continue;
            }
            if (bl3) {
                if (Character.isJavaIdentifierPart(c) || c == '.' || c == '[' || c == ']') {
                    stringBuffer2.append(c);
                    continue;
                }
                bl3 = false;
                stringBuffer.append(JavaScriptUtil.evaluateIdentifier(stringBuffer2.toString()));
            }
            if (c == '\"') {
                bl = !bl;
                stringBuffer.append(c);
                continue;
            }
            if (c == '\'') {
                bl2 = !bl2;
                stringBuffer.append(c);
                continue;
            }
            if (Character.isJavaIdentifierStart(c)) {
                bl3 = true;
                stringBuffer2 = new StringBuffer();
                stringBuffer2.append(c);
                continue;
            }
            stringBuffer.append(c);
            if (c != '\\' || i == string.length() - 1) continue;
            stringBuffer.append(string.charAt(++i));
        }
        if (bl3) {
            stringBuffer.append(JavaScriptUtil.evaluateIdentifier(stringBuffer2.toString()));
        }
        String string2 = stringBuffer.toString();
        string2 = string2.replaceAll("\\\"", "'");
        return string2;
    }

    private static String evaluateIdentifier(String string) {
        if (string.equals("value") || string.startsWith("value.")) {
            String string2 = string.replaceFirst("value", "@testValue");
            return string2;
        }
        String string3 = "#{" + string + "}";
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ValueBinding valueBinding = facesContext.getApplication().createValueBinding(string3);
            Object object = valueBinding.getValue(facesContext);
            if (object instanceof String) {
                return "'" + object + "'";
            }
            return object.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }
}

