/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.api;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class SQEManager
implements Lookup.Provider {
    public static final String PROP_ACTIVE_PROJECT = "PropActiveProject";
    public static final String PROP_CURRENT_PROJECT = "PropCurrentProject";
    private static SQEManager sqeManager;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final ActionGlobalContextListner actionGlobalContextListner;
    private final InstanceContent instanceContent = new InstanceContent();
    private final Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private Project activeProject;
    private Node activeProjectNode;
    private Project currentProject;

    public SQEManager() {
        this.actionGlobalContextListner = new ActionGlobalContextListner(this);
        this.actionGlobalContextListner.setEnable(true);
    }

    public static synchronized SQEManager getDefault() {
        if (null == sqeManager) {
            sqeManager = new SQEManager();
        }
        return sqeManager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public boolean getFollowActionGlobalContext() {
        return this.actionGlobalContextListner.isEnable();
    }

    public void setFollowActionGlobalContext(boolean followActionGlobalContext) {
        this.actionGlobalContextListner.setEnable(followActionGlobalContext);
    }

    public Project getActiveProject() {
        return this.activeProject;
    }

    public Project getCurrentProject() {
        return this.currentProject;
    }

    public void setActiveProject(Project project) {
        if (this.activeProject == project) {
            return;
        }
        if (null != this.activeProject) {
            this.instanceContent.remove((Object)this.activeProject);
            this.instanceContent.remove((Object)this.activeProjectNode);
        }
        Project oldProject = this.activeProject;
        this.activeProject = project;
        this.activeProjectNode = null;
        if (null != this.activeProject) {
            this.activeProjectNode = new AbstractNode(Children.LEAF, Lookups.singleton((Object)this.activeProject));
            this.instanceContent.add((Object)this.activeProjectNode);
            this.instanceContent.add((Object)this.activeProject);
        }
        this.firePropertyChange(PROP_ACTIVE_PROJECT, oldProject, this.activeProject);
    }

    public void setCurrentProject(Project currentProject) {
        Project oldProject = this.currentProject;
        this.currentProject = currentProject;
        this.firePropertyChange(PROP_CURRENT_PROJECT, oldProject, this.currentProject);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    protected final void firePropertyChange(final String propertyName, final Object oldValue, final Object newValue) {
        if (EventQueue.isDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SQEManager.this.firePropertyChange(propertyName, oldValue, newValue);
                }
            });
            return;
        }
        this.support.firePropertyChange(propertyName, oldValue, newValue);
    }

    private static class ActionGlobalContextListner
    implements LookupListener {
        private final SQEManager manager;
        private Lookup.Result<Project> activeGlobalProject;
        private Lookup.Result<DataObject> activeGlobalDataObject;

        public ActionGlobalContextListner(SQEManager manager) {
            this.manager = manager;
        }

        public boolean isEnable() {
            return null != this.activeGlobalProject;
        }

        public synchronized void setEnable(boolean enable) {
            if (enable && null == this.activeGlobalProject) {
                this.activeGlobalProject = Utilities.actionsGlobalContext().lookupResult(Project.class);
                this.activeGlobalProject.addLookupListener((LookupListener)this);
                this.activeGlobalDataObject = Utilities.actionsGlobalContext().lookupResult(DataObject.class);
                this.activeGlobalDataObject.addLookupListener((LookupListener)this);
            } else if (!enable && null != this.activeGlobalProject) {
                this.activeGlobalProject.removeLookupListener((LookupListener)this);
                this.activeGlobalDataObject.removeLookupListener((LookupListener)this);
                this.activeGlobalProject = null;
            }
        }

        public void resultChanged(LookupEvent arg0) {
            Collection allDataObjects;
            Project project = null;
            Collection allProjectInstances = this.activeGlobalProject.allInstances();
            if (allProjectInstances.size() == 1) {
                project = (Project)allProjectInstances.iterator().next();
            }
            if (null == project && (allDataObjects = this.activeGlobalDataObject.allInstances()).size() == 1) {
                project = FileOwnerQuery.getOwner((FileObject)((DataObject)allDataObjects.iterator().next()).getPrimaryFile());
            }
            this.manager.setActiveProject(project);
        }
    }
}

