/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.utilities;

import org.nbheaven.sqe.core.java.utils.ProjectUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public class SQEProjectSupport {
    private SQEProjectSupport() {
    }

    public static Project findProject(Node node) {
        if (null == node) {
            return null;
        }
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (null == project) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            project = SQEProjectSupport.findProject(dataObject);
        }
        return project;
    }

    public static Project findProject(DataObject dataObject) {
        if (null == dataObject) {
            return null;
        }
        return SQEProjectSupport.findProject(dataObject.getPrimaryFile());
    }

    public static Project findProject(FileObject fileObject) {
        if (null == fileObject) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    public static boolean isProjectPackage(String packageName, Project project) {
        SourceGroup[] sgs;
        String folderName = packageName;
        folderName = folderName.replaceAll("\\.", "/");
        for (SourceGroup sg : sgs = ProjectUtilities.getJavaSourceGroups((Project)project)) {
            FileObject mayBeFileObject = sg.getRootFolder().getFileObject(folderName);
            if (null == mayBeFileObject || !mayBeFileObject.isValid()) continue;
            return true;
        }
        return false;
    }

    public static boolean isProjectClass(String className, Project project) {
        SourceGroup[] sgs;
        String javaFileName = className;
        if (-1 != javaFileName.indexOf(36)) {
            javaFileName = javaFileName.substring(0, javaFileName.indexOf(36));
        }
        javaFileName = javaFileName.replaceAll("\\.", "/") + ".java";
        for (SourceGroup sg : sgs = ProjectUtilities.getJavaSourceGroups((Project)project)) {
            FileObject mayBeFileObject = sg.getRootFolder().getFileObject(javaFileName);
            if (null == mayBeFileObject || !mayBeFileObject.isValid()) continue;
            return true;
        }
        return false;
    }
}

