/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.db;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.glassfish.eecommon.api.DomainEditor;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ResourcesHelper {
    private static RequestProcessor RP = new RequestProcessor("Sample Datasource work");

    public static void addSampleDatasource(final J2eeModule module, final DeploymentManager dmParam) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                File f = module.getResourceDirectory();
                if (null != f && f.exists()) {
                    f = f.getParentFile();
                }
                if (null != f) {
                    Project p = FileOwnerQuery.getOwner((URI)f.toURI());
                    if (null != p) {
                        GlassfishModule commonSupport;
                        String gfdir;
                        DeploymentManager dm;
                        J2eeModuleProvider jmp = ResourcesHelper.getProvider(p);
                        if (null != jmp && (dm = dmParam) instanceof Hk2DeploymentManager && null != (gfdir = (String)(commonSupport = ((Hk2DeploymentManager)dm).getCommonServerSupport()).getInstanceProperties().get("domainsfolder"))) {
                            String domain = (String)commonSupport.getInstanceProperties().get("domainname");
                            if (commonSupport.getServerState() != GlassfishModule.ServerState.RUNNING) {
                                DomainEditor de = new DomainEditor(gfdir, domain, false);
                                de.createSampleDatasource();
                            } else {
                                ResourcesHelper.registerSampleResource(commonSupport);
                            }
                        }
                    } else {
                        Logger.getLogger("glassfish-javaee").finer("Could not find project for J2eeModule");
                    }
                } else {
                    Logger.getLogger("glassfish-javaee").finer("Could not find project root directory for J2eeModule");
                }
            }
        });
    }

    private static J2eeModuleProvider getProvider(Project project) {
        J2eeModuleProvider provider = null;
        if (project != null) {
            Lookup lookup = project.getLookup();
            provider = (J2eeModuleProvider)lookup.lookup(J2eeModuleProvider.class);
        }
        return provider;
    }

    private static void registerSampleResource(GlassfishModule commonSupport) {
        String sample_poolname = "SamplePool";
        String sample_jdbc = "jdbc/sample";
        String sample_classname = "org.apache.derby.jdbc.ClientDataSource";
        String sample_restype = "javax.sql.DataSource";
        String sample_props = "DatabaseName=sample:User=app:Password=app:PortNumber=1527:serverName=localhost:URL=jdbc\\:derby\\://localhost\\:1527/sample";
        Map jdbcsMap = commonSupport.getResourcesMap("jdbc-resource");
        if (!jdbcsMap.containsKey(sample_jdbc)) {
            CreateJDBCConnectionPoolCommand poolCmd = new CreateJDBCConnectionPoolCommand(sample_poolname, sample_classname, sample_restype, sample_props);
            Future poolResult = commonSupport.execute((ServerCommand)poolCmd);
            try {
                if (poolResult.get(60L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                    CreateJDBCResourceCommand jdbcCmd = new CreateJDBCResourceCommand(sample_jdbc, sample_poolname);
                    commonSupport.execute((ServerCommand)jdbcCmd);
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger("glassfish-javaee").log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger("glassfish-javaee").log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
            catch (TimeoutException ex) {
                Logger.getLogger("glassfish-javaee").log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
        }
    }

    public static final class CreateAdminObjectCommand
    extends ServerCommand {
        public CreateAdminObjectCommand(String name, String raname, String restype, String properties) {
            super("create-admin-object");
            StringBuilder cmd = new StringBuilder(128);
            if (name != null && name.length() > 0 && restype != null && restype.length() > 0 && raname != null && raname.length() > 0) {
                cmd.append("enabled=true");
                cmd.append('&').append("restype=").append(restype);
                cmd.append('&').append("raname=").append(restype);
                cmd.append('&').append("property=").append(raname);
                cmd.append('&').append("jndi_name=");
                cmd.append(name);
                this.query = cmd.toString();
            }
        }
    }

    public static final class CreateConnectorCommand
    extends ServerCommand {
        public CreateConnectorCommand(String name, String poolname, String properties) {
            super("create-connector-resource");
            StringBuilder cmd = new StringBuilder(128);
            if (name != null && name.length() > 0 && poolname != null && poolname.length() > 0) {
                cmd.append("enabled=true");
                cmd.append('&').append("poolname=").append(poolname);
                cmd.append('&').append("property=").append(properties);
                cmd.append('&').append("jndi_name=");
                cmd.append(name);
                this.query = cmd.toString();
            }
        }
    }

    public static final class CreateConnectorConnectionPoolCommand
    extends ServerCommand {
        public CreateConnectorConnectionPoolCommand(String name, String raname, String conndefnname, String poolname, String properties) {
            super("create-connector-connection-pool");
            StringBuilder cmd = new StringBuilder(128);
            if (name != null && name.length() > 0 && raname != null && raname.length() > 0 && conndefnname != null && conndefnname.length() > 0) {
                cmd.append("raname=").append(raname);
                cmd.append('&').append("connectiondefinition=").append(conndefnname);
                cmd.append('&').append("property=").append(properties);
                cmd.append('&').append("poolname=");
                cmd.append(name);
                this.query = cmd.toString();
            }
        }
    }

    public static final class CreateJDBCConnectionPoolCommand
    extends ServerCommand {
        public CreateJDBCConnectionPoolCommand(String name, String classname, String restype, String properties) {
            super("create-jdbc-connection-pool");
            StringBuilder cmd = new StringBuilder(128);
            if (classname != null && classname.length() > 0 && restype != null && restype.length() > 0 && name != null && name.length() > 0) {
                cmd.append("datasourceclassname=").append(classname);
                cmd.append('&').append("restype=").append(restype);
                cmd.append('&').append("property=").append(properties);
                cmd.append('&').append("jdbc_connection_pool_id=");
                cmd.append(name);
                this.query = cmd.toString();
            }
        }
    }

    public static final class CreateJDBCResourceCommand
    extends ServerCommand {
        public CreateJDBCResourceCommand(String name, String poolname) {
            super("create-jdbc-resource");
            StringBuilder cmd = new StringBuilder(128);
            cmd.append("connectionpoolid=").append(poolname);
            cmd.append('&').append("jndi_name=");
            cmd.append(name);
            this.query = cmd.toString();
        }
    }
}

