/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.eecommon.api.Utils;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.ide.Hk2DeploymentStatus;
import org.netbeans.modules.glassfish.javaee.ide.Hk2PluginProperties;
import org.netbeans.modules.glassfish.javaee.ui.DebugPortQuery;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModule3;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class Hk2StartServer
extends StartServer
implements ProgressObject {
    private DeploymentStatus deploymentStatus;
    private Hk2DeploymentManager dm;
    private String serverName;
    private List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private InstanceProperties ip;
    private ProgressEvent lastEvent = null;

    public Hk2StartServer(DeploymentManager jdm) {
        if (!(jdm instanceof Hk2DeploymentManager)) {
            throw new IllegalArgumentException("Only GlassFish v3 is supported");
        }
        this.dm = (Hk2DeploymentManager)jdm;
        this.ip = this.dm.getInstanceProperties();
        if (null != this.ip) {
            this.serverName = this.ip.getProperty("displayName");
        }
    }

    public InstanceProperties getInstanceProperties() {
        return this.ip;
    }

    private GlassfishModule getCommonServerSupport() {
        ServerInstance si = this.dm.getServerInstance();
        return (GlassfishModule)si.getBasicNode().getLookup().lookup(GlassfishModule.class);
    }

    public boolean supportsStartDeploymentManager() {
        boolean local;
        GlassfishModule commonSupport = this.getCommonServerSupport();
        assert (commonSupport != null) : "commonSupport is null??";
        if (null == commonSupport) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "commonSupport is null??");
            return false;
        }
        boolean bl = local = !commonSupport.isRemote();
        return local ? local : this.isRunning() || GlassfishModule.ServerState.STARTING.equals((Object)commonSupport.getServerState());
    }

    public ProgressObject startDeploymentManager() {
        if (ProfilerSupport.getState() == 2) {
            this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.FAILED, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_SERVER_PROFILING_IN_PROGRESS", (Object)this.serverName)));
        } else {
            this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.RUNNING, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)this.serverName)));
            GlassfishModule commonSupport = this.getCommonServerSupport();
            if (commonSupport != null && !commonSupport.isRemote()) {
                commonSupport.setEnvironmentProperty("jvmMode", "normalMode", true);
                commonSupport.startServer(new OperationStateListener(){

                    public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                        Hk2StartServer.this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, Hk2StartServer.translateState(newState), ActionType.EXECUTE, message));
                    }
                }, GlassfishModule.ServerState.RUNNING);
            } else if (commonSupport != null) {
                commonSupport.setEnvironmentProperty("jvmMode", "normalMode", true);
                commonSupport.restartServer(new OperationStateListener(){

                    public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                        Hk2StartServer.this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, Hk2StartServer.translateState(newState), ActionType.EXECUTE, message));
                    }
                });
            }
        }
        return this;
    }

    public ProgressObject stopDeploymentManager() {
        this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.STOP, StateType.RUNNING, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)this.serverName)));
        GlassfishModule commonSupport = this.getCommonServerSupport();
        if (commonSupport != null && !commonSupport.isRemote()) {
            commonSupport.stopServer(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                    Hk2StartServer.this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.STOP, Hk2StartServer.translateState(newState), ActionType.EXECUTE, message));
                }
            });
        } else if (null != commonSupport) {
            this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.STOP, StateType.COMPLETED, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_SERVER_STOPPED", (Object)this.serverName)));
        }
        return this;
    }

    private static StateType translateState(GlassfishModule.OperationState commonState) {
        switch (commonState) {
            case RUNNING: {
                return StateType.RUNNING;
            }
            case COMPLETED: {
                return StateType.COMPLETED;
            }
            case FAILED: {
                return StateType.FAILED;
            }
        }
        return StateType.FAILED;
    }

    public boolean supportsStartDebugging(Target target) {
        GlassfishModule commonSupport = this.getCommonServerSupport();
        assert (null != commonSupport) : "commonSupport is null?";
        if (null == commonSupport) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "commonSupport is null??");
            return false;
        }
        boolean retVal = this.supportsStartDeploymentManager() && !this.isClusterOrInstance(commonSupport);
        return retVal;
    }

    public ProgressObject startDebugging(Target target) {
        if (ProfilerSupport.getState() == 2) {
            this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.FAILED, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_SERVER_PROFILING_IN_PROGRESS", (Object)this.serverName)));
        } else {
            this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.RUNNING, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)this.serverName)));
            final GlassfishModule commonSupport = this.getCommonServerSupport();
            if (commonSupport != null && !commonSupport.isRemote()) {
                commonSupport.setEnvironmentProperty("jvmMode", "debugMode", true);
                commonSupport.startServer(new OperationStateListener(){

                    public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                        Hk2StartServer.this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, Hk2StartServer.translateState(newState), ActionType.EXECUTE, message));
                    }
                }, GlassfishModule.ServerState.RUNNING);
            } else if (null != commonSupport) {
                commonSupport.setEnvironmentProperty("jvmMode", "debugMode", true);
                commonSupport.restartServer(new OperationStateListener(){

                    public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                        if (GlassfishModule.OperationState.COMPLETED.equals((Object)newState)) {
                            try {
                                Thread.sleep(1000L);
                                while (GlassfishModule.ServerState.STARTING.equals((Object)commonSupport.getServerState())) {
                                    Thread.sleep(500L);
                                }
                            }
                            catch (InterruptedException ie) {
                                Logger.getLogger("glassfish-javaee").log(Level.INFO, "", ie);
                            }
                        }
                        Hk2StartServer.this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, Hk2StartServer.translateState(newState), ActionType.EXECUTE, message));
                    }
                });
            }
        }
        return this;
    }

    public boolean isDebuggable(Target target) {
        GlassfishModule commonSupport = this.getCommonServerSupport();
        if (!this.isRunning()) {
            return false;
        }
        if (commonSupport != null) {
            return "debugMode".equals(commonSupport.getInstanceProperties().get("jvmMode"));
        }
        return false;
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        GlassfishModule commonSupport = this.getCommonServerSupport();
        String debugPort = (String)commonSupport.getInstanceProperties().get("debugPort");
        ServerDebugInfo retVal = null;
        if (Utils.strEmpty((String)debugPort) && commonSupport.isRemote()) {
            debugPort = this.queryDebugPort();
        }
        if (Utils.notEmpty((String)debugPort)) {
            retVal = new ServerDebugInfo(this.ip.getProperty("host"), Integer.parseInt(debugPort));
        }
        return retVal;
    }

    private String queryDebugPort() {
        String debugPort = null;
        String name = (String)this.getCommonServerSupport().getInstanceProperties().get("displayName");
        DebugPortQuery debugPortQuery = new DebugPortQuery();
        DialogDescriptor desc = new DialogDescriptor((Object)debugPortQuery, NbBundle.getMessage(Hk2StartServer.class, (String)"TITLE_QueryDebugPort", (Object)name));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)desc) == NotifyDescriptor.OK_OPTION) {
            debugPort = debugPortQuery.getDebugPort();
            if (debugPortQuery.shouldPersist()) {
                this.getCommonServerSupport().setEnvironmentProperty("debugPort", debugPort, true);
            }
        }
        return debugPort;
    }

    public boolean needsRestart(Target target) {
        return false;
    }

    public boolean needsStartForTargetList() {
        return false;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForAdminConfig() {
        return false;
    }

    public boolean isRunning() {
        GlassfishModule commonSupport = this.getCommonServerSupport();
        if (commonSupport != null) {
            GlassfishModule.ServerState s = commonSupport.getServerState();
            return GlassfishModule.ServerState.RUNNING.equals((Object)s) || GlassfishModule.ServerState.RUNNING_JVM_DEBUG.equals((Object)s) || GlassfishModule.ServerState.RUNNING_JVM_PROFILER.equals((Object)s);
        }
        return Hk2PluginProperties.isRunning(this.ip.getProperty("host"), this.ip.getProperty("httpportnumber"));
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[0];
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        assert (false) : "client called cancel() even though isCancelSupported() returned FALSE.";
        throw new UnsupportedOperationException();
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        assert (false) : "client called stop() even though isStopSupported() returned FALSE.";
        throw new UnsupportedOperationException();
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
        if (null != this.lastEvent) {
            progressListener.handleProgressEvent(this.lastEvent);
        }
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.listeners.remove(progressListener);
    }

    public void fireHandleProgressEvent(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        this.lastEvent = new ProgressEvent((Object)this, targetModuleID, deploymentStatus);
        this.deploymentStatus = deploymentStatus;
        Iterator<ProgressListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().handleProgressEvent(this.lastEvent);
        }
    }

    public boolean supportsStartProfiling(Target target) {
        GlassfishModule commonSupport = this.getCommonServerSupport();
        assert (null != commonSupport) : "commonSupport is null?";
        if (null == commonSupport) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "commonSupport is null??");
            return false;
        }
        boolean retVal = !commonSupport.isRemote() && !this.isClusterOrInstance(commonSupport);
        return retVal;
    }

    public boolean isProfiling(Target target) {
        return this.isRunning();
    }

    public ProgressObject startProfiling(Target target) {
        if (ProfilerSupport.getState() == 2) {
            this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.RUNNING, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_SERVER_PROFILING_IN_PROGRESS", (Object)this.serverName)));
            return this;
        }
        final GlassfishModule commonSupport = this.getCommonServerSupport();
        if (commonSupport != null) {
            if (this.isClusterOrInstance(commonSupport)) {
                this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.FAILED, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_SERVER_PROFILING_CLUSTER_NOT_SUPPORTED", (Object)this.serverName)));
                return this;
            }
            this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.RUNNING, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)this.serverName)));
            commonSupport.setEnvironmentProperty("jvmMode", "profileMode", true);
            commonSupport.startServer(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                    if (newState == GlassfishModule.OperationState.RUNNING) {
                        int t = 0;
                        Logger.getLogger("glassfish-javaee").log(Level.FINE, "t == {0}", t);
                        try {
                            while (ProfilerSupport.getState() != 2 && t < 30000) {
                                Thread.sleep(1000L);
                                Logger.getLogger("glassfish-javaee").log(Level.FINE, "t.1 == {0}", t += 1000);
                            }
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    Hk2StartServer.this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, Hk2StartServer.translateState(newState), ActionType.EXECUTE, message));
                    final ScheduledExecutorService statusUpdater = Executors.newSingleThreadScheduledExecutor();
                    statusUpdater.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            if (ProfilerSupport.getState() == 0) {
                                statusUpdater.shutdownNow();
                                if (commonSupport instanceof GlassfishModule3) {
                                    ((GlassfishModule3)commonSupport).refresh();
                                }
                            }
                        }
                    }, 50L, 100L, TimeUnit.MILLISECONDS);
                }
            }, GlassfishModule.ServerState.STOPPED_JVM_PROFILER);
        }
        return this;
    }

    private boolean isClusterOrInstance(GlassfishModule commonSupport) {
        String uri = (String)commonSupport.getInstanceProperties().get("url");
        if (null == uri) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "{0} has a null URI??", commonSupport.getInstanceProperties().get("displayName"));
            return true;
        }
        String target = Hk2DeploymentManager.getTargetFromUri(uri);
        return null == target ? false : !"server".equals(target);
    }
}

