/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.Hk2JavaEEPlatformFactory;
import org.netbeans.modules.glassfish.javaee.Hk2JaxRpcStack;
import org.netbeans.modules.glassfish.javaee.Hk2JaxWsStack;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.j2ee.deployment.common.api.J2eeLibraryTypeProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.support.LookupProviderSupport;
import org.netbeans.modules.javaee.specs.support.api.JaxRpc;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.javaee.specs.support.spi.JaxRsStackSupportImplementation;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Hk2JavaEEPlatformImpl
extends J2eePlatformImpl2 {
    private Hk2DeploymentManager dm;
    private final LibraryImplementation lib = new J2eeLibraryTypeProvider().createLibrary();
    private final LibraryImplementation[] libraries = new LibraryImplementation[]{this.lib};
    private Hk2JavaEEPlatformFactory pf;
    private FileChangeListener fcl;
    private volatile Lookup lkp;
    private static final String PERSISTENCE_PROV_ECLIPSELINK = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static final String TOOL_WSCOMPILE = "wscompile";
    private static final String TOOL_JSR109 = "jsr109";
    private static final String TOOL_WSIMPORT = "wsimport";
    private static final String TOOL_WSGEN = "wsgen";
    private static final String TOOL_KEYSTORE = "keystore";
    private static final String TOOL_KEYSTORECLIENT = "keystoreClient";
    private static final String TOOL_TRUSTSTORE = "truststore";
    private static final String TOOL_TRUSTSTORECLIENT = "truststoreClient";
    private static final String TOOL_WSIT = "wsit";
    private static final String TOOL_JAXWSTESTER = "jaxws-tester";
    private static final String TOOL_APPCLIENTRUNTIME = "appClientRuntime";
    private static final String KEYSTORE_LOCATION = "config/keystore.jks";
    private static final String TRUSTSTORE_LOCATION = "config/cacerts.jks";
    private static final String EMBEDDED_EJB_CONTAINER_PATH = "lib/embedded/glassfish-embedded-static-shell.jar";
    private static RequestProcessor libInitThread = new RequestProcessor("init libs -- Hk2JavaEEPlatformImpl");

    public Hk2JavaEEPlatformImpl(Hk2DeploymentManager dm, Hk2JavaEEPlatformFactory pf) {
        this.dm = dm;
        this.pf = pf;
        this.addFcl();
        this.initLibraries();
    }

    private void addFcl() {
        if (null == this.fcl) {
            String path = (String)this.dm.getCommonServerSupport().getInstanceProperties().get("homefolder");
            File f = new File(path, "modules");
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
            if (null == fo) {
                Logger.getLogger("glassfish-javaee").log(Level.WARNING, "{0} did not exist but should", f.getAbsolutePath());
                return;
            }
            this.fcl = new FileChangeListener(){

                public void fileFolderCreated(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileDataCreated(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileChanged(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileDeleted(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileRenamed(FileRenameEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileAttributeChanged(FileAttributeEvent fe) {
                }
            };
            fo.addFileChangeListener(this.fcl);
        }
    }

    public boolean isToolSupported(String toolName) {
        if (PERSISTENCE_PROV_ECLIPSELINK.equals(toolName)) {
            return true;
        }
        if ("org.hibernate.ejb.HibernatePersistence".equals(toolName) || "oracle.toplink.essentials.PersistenceProvider".equals(toolName) || "kodo.persistence.PersistenceProviderImpl".equals(toolName) || "org.apache.openjpa.persistence.PersistenceProviderImpl".equals(toolName)) {
            return true;
        }
        if ("defaultPersistenceProviderJavaEE5".equals(toolName)) {
            return true;
        }
        if ("eclipseLinkPersistenceProviderIsDefault".equals(toolName)) {
            return true;
        }
        String gfRootStr = this.dm.getProperties().getGlassfishRoot();
        if ("embeddableejb".equals(toolName)) {
            File jar = new File(gfRootStr, EMBEDDED_EJB_CONTAINER_PATH);
            return jar.exists() && jar.isFile() && jar.canRead();
        }
        File wsLib = null;
        if (gfRootStr != null) {
            wsLib = ServerUtilities.getJarName((String)gfRootStr, (String)"webservices(|-osgi).jar");
        }
        if (wsLib != null && wsLib.exists()) {
            if (TOOL_WSGEN.equals(toolName)) {
                return true;
            }
            if (TOOL_WSIMPORT.equals(toolName)) {
                return true;
            }
            if (TOOL_WSIT.equals(toolName)) {
                return true;
            }
            if (TOOL_JAXWSTESTER.equals(toolName)) {
                return true;
            }
            if (TOOL_JSR109.equals(toolName)) {
                return true;
            }
            if (TOOL_KEYSTORE.equals(toolName)) {
                return true;
            }
            if (TOOL_KEYSTORECLIENT.equals(toolName)) {
                return true;
            }
            if (TOOL_TRUSTSTORE.equals(toolName)) {
                return true;
            }
            if (TOOL_TRUSTSTORECLIENT.equals(toolName)) {
                return true;
            }
            if (TOOL_WSCOMPILE.equals(toolName)) {
                return true;
            }
            if (TOOL_APPCLIENTRUNTIME.equals(toolName)) {
                return true;
            }
        }
        return false;
    }

    public File[] getToolClasspathEntries(String toolName) {
        String gfRootStr = this.dm.getProperties().getGlassfishRoot();
        if (null != gfRootStr) {
            String domainDirName;
            if ("embeddableejb".equals(toolName)) {
                return new File[]{new File(gfRootStr, EMBEDDED_EJB_CONTAINER_PATH)};
            }
            if (TOOL_WSGEN.equals(toolName) || TOOL_WSIMPORT.equals(toolName)) {
                String[] entries = new String[]{"webservices(|-osgi).jar", "webservices-api(|-osgi).jar", "jaxb(|-osgi).jar", "jaxb-api(|-osgi).jar", "javax.activation.jar"};
                ArrayList<File> cPath = new ArrayList<File>();
                for (String entry : entries) {
                    File f = ServerUtilities.getWsJarName((String)gfRootStr, (String)entry);
                    if (f == null || !f.exists()) continue;
                    cPath.add(f);
                }
                return cPath.toArray(new File[cPath.size()]);
            }
            if (TOOL_WSCOMPILE.equals(toolName)) {
                String[] entries = new String[]{"webservices(|-osgi).jar"};
                ArrayList<File> cPath = new ArrayList<File>();
                for (String entry : entries) {
                    File f = ServerUtilities.getWsJarName((String)gfRootStr, (String)entry);
                    if (f == null || !f.exists()) continue;
                    cPath.add(f);
                }
                return cPath.toArray(new File[cPath.size()]);
            }
            File domainDir = null;
            File gfRoot = new File(gfRootStr);
            if (gfRoot != null && gfRoot.exists() && (domainDirName = this.dm.getProperties().getDomainDir()) != null) {
                domainDir = new File(domainDirName);
                if (TOOL_KEYSTORE.equals(toolName) || TOOL_KEYSTORECLIENT.equals(toolName)) {
                    return new File[]{new File(domainDir, KEYSTORE_LOCATION)};
                }
                if (TOOL_TRUSTSTORE.equals(toolName) || TOOL_TRUSTSTORECLIENT.equals(toolName)) {
                    return new File[]{new File(domainDir, TRUSTSTORE_LOCATION)};
                }
            }
        } else {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, "dm has no root???", new Exception());
        }
        return new File[0];
    }

    public Set<Profile> getSupportedProfiles() {
        return this.getCorrectedProfileSet();
    }

    public Set<Profile> getSupportedProfiles(J2eeModule.Type type) {
        return this.getCorrectedProfileSet();
    }

    private Set<Profile> getCorrectedProfileSet() {
        Set<Profile> retVal = this.pf.getSupportedProfiles();
        String gfRootStr = this.dm.getProperties().getGlassfishRoot();
        File descriminator = new File(gfRootStr, "modules/appclient-server-core.jar");
        if (!descriminator.exists()) {
            retVal.remove(Profile.JAVA_EE_6_FULL);
        }
        return retVal;
    }

    public Set<J2eeModule.Type> getSupportedTypes() {
        Set<J2eeModule.Type> retVal = this.pf.getSupportedTypes();
        Set<Profile> ps = this.getCorrectedProfileSet();
        if (ps.contains(Profile.JAVA_EE_6_WEB) && !ps.contains(Profile.JAVA_EE_6_FULL)) {
            retVal.remove(J2eeModule.Type.CAR);
            retVal.remove(J2eeModule.Type.EAR);
            retVal.remove(J2eeModule.Type.EJB);
            retVal.remove(J2eeModule.Type.RAR);
        }
        return retVal;
    }

    public File[] getPlatformRoots() {
        File server = this.getServerHome();
        if (server != null) {
            return new File[]{server};
        }
        return new File[0];
    }

    public File getServerHome() {
        return this.getExistingFolder(this.dm.getProperties().getGlassfishRoot());
    }

    public File getDomainHome() {
        return this.getExistingFolder(this.dm.getProperties().getDomainDir());
    }

    public File getMiddlewareHome() {
        return this.getExistingFolder(this.dm.getProperties().getInstallRoot());
    }

    public LibraryImplementation[] getLibraries() {
        this.addFcl();
        return (LibraryImplementation[])this.libraries.clone();
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/hk2/resources/server.gif");
    }

    public String getDisplayName() {
        return this.pf.getDisplayName();
    }

    public Set getSupportedJavaPlatformVersions() {
        return this.pf.getSupportedJavaPlatforms();
    }

    public JavaPlatform getJavaPlatform() {
        return this.pf.getJavaPlatform();
    }

    public void notifyLibrariesChanged() {
        this.initLibraries();
    }

    private void initLibraries() {
        libInitThread.post(new Runnable(){

            @Override
            public void run() {
                Hk2JavaEEPlatformImpl.this.lib.setName(Hk2JavaEEPlatformImpl.this.pf.getLibraryName());
                Hk2JavaEEPlatformImpl.this.lib.setContent("classpath", Hk2JavaEEPlatformImpl.this.dm.getProperties().getClasses());
                Hk2JavaEEPlatformImpl.this.lib.setContent("javadoc", Hk2JavaEEPlatformImpl.this.dm.getProperties().getJavadocs());
                Hk2JavaEEPlatformImpl.this.firePropertyChange("libraries", null, Hk2JavaEEPlatformImpl.this.libraries.clone());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        if (this.lkp != null) {
            return this.lkp;
        }
        Hk2JavaEEPlatformImpl hk2JavaEEPlatformImpl = this;
        synchronized (hk2JavaEEPlatformImpl) {
            if (this.lkp == null) {
                String gfRootStr = this.dm.getProperties().getGlassfishRoot();
                WSStack wsStack = WSStackFactory.createWSStack(JaxWs.class, (WSStackImplementation)new Hk2JaxWsStack(gfRootStr, this), (WSStack.Source)WSStack.Source.SERVER);
                WSStack rpcStack = WSStackFactory.createWSStack(JaxRpc.class, (WSStackImplementation)new Hk2JaxRpcStack(gfRootStr), (WSStack.Source)WSStack.Source.SERVER);
                Lookup baseLookup = Lookups.fixed((Object[])new Object[]{gfRootStr, new JaxRsStackSupportImpl(), wsStack, rpcStack});
                this.lkp = LookupProviderSupport.createCompositeLookup((Lookup)baseLookup, (String)this.pf.getLookupKey());
            }
        }
        return this.lkp;
    }

    private File getExistingFolder(String path) {
        File returnedElement;
        if (path != null && (returnedElement = new File(path)).exists()) {
            return returnedElement;
        }
        return null;
    }

    private String quotedString(String s) {
        return "\"" + s + "\"";
    }

    public String getToolProperty(String toolName, String propertyName) {
        if (TOOL_APPCLIENTRUNTIME.equals(toolName)) {
            File root = new File(this.dm.getProperties().getGlassfishRoot());
            String domainPath = this.dm.getProperties().getDomainDir();
            if ("main.class".equals(propertyName)) {
                return "org.glassfish.appclient.client.AppClientFacade";
            }
            if ("main.class.args".equals(propertyName)) {
                return "${j2ee.appclient.tool.args}";
            }
            if ("jvm.opts".equals(propertyName)) {
                if (domainPath != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("-Djava.endorsed.dirs=");
                    sb.append(this.quotedString(new File(root, "lib/endorsed").getAbsolutePath()));
                    sb.append(File.pathSeparator);
                    sb.append(this.quotedString(new File(root, "modules/endorsed").getAbsolutePath()));
                    sb.append(" -javaagent:");
                    String url = (String)this.dm.getCommonServerSupport().getInstanceProperties().get("url");
                    File f = new File(root, "lib/gf-client.jar");
                    if (f.exists()) {
                        sb.append(this.quotedString(f.getAbsolutePath()));
                    } else {
                        sb.append(this.quotedString(new File(root, "modules/gf-client.jar").getAbsolutePath()));
                    }
                    sb.append("=mode=acscript,arg=-configxml,arg=");
                    sb.append(this.quotedString(new File(domainPath, "config/sun-acc.xml").getAbsolutePath()));
                    sb.append(",client=jar=");
                    return sb.toString();
                }
                return null;
            }
            if ("client.jar.location".equals(propertyName)) {
                if (domainPath != null) {
                    FileObject location = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(domainPath)));
                    if (location == null) {
                        return null;
                    }
                    return FileUtil.toFile((FileObject)location).getAbsolutePath() + File.separator + "generated" + File.separator + "xml";
                }
                return null;
            }
            if ("j2ee.appclient.args".equals(propertyName)) {
                return null;
            }
        }
        return null;
    }

    private class JaxRsStackSupportImpl
    implements JaxRsStackSupportImplementation {
        private static final String VERSION_30X = "v3";
        private static final String VERSION_31X = "3.1";

        private JaxRsStackSupportImpl() {
        }

        public boolean addJsr311Api(Project project) {
            String version = this.getGFVersion();
            try {
                if (version == null) {
                    return false;
                }
                if (version.startsWith(VERSION_30X)) {
                    File jsr311 = ServerUtilities.getJarName((String)Hk2JavaEEPlatformImpl.this.dm.getProperties().getGlassfishRoot(), (String)"jsr311-api.jar");
                    if (jsr311 == null || !jsr311.exists()) {
                        return false;
                    }
                    return this.addJars(project, Collections.singletonList(jsr311.toURI().toURL()));
                }
                if (version.startsWith(VERSION_31X)) {
                    File jerseyCore = ServerUtilities.getJarName((String)Hk2JavaEEPlatformImpl.this.dm.getProperties().getGlassfishRoot(), (String)"jersey-core.jar");
                    if (jerseyCore == null || !jerseyCore.exists()) {
                        return false;
                    }
                    return this.addJars(project, Collections.singletonList(jerseyCore.toURI().toURL()));
                }
            }
            catch (MalformedURLException ex) {
                return false;
            }
            return false;
        }

        public boolean extendsJerseyProjectClasspath(Project project) {
            if (this.hasJee6Profile()) {
                return true;
            }
            List<URL> urls = this.getJerseyLibraryURLs();
            if (urls.size() > 0) {
                return this.addJars(project, urls);
            }
            return false;
        }

        public void removeJaxRsLibraries(Project project) {
            List<URL> urls = this.getJerseyLibraryURLs();
            if (urls.size() > 0) {
                String[] classPathTypes;
                SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
                if (sourceGroups == null || sourceGroups.length < 1) {
                    return;
                }
                FileObject sourceRoot = sourceGroups[0].getRootFolder();
                for (String type : classPathTypes = new String[]{"classpath/compile", "classpath/execute"}) {
                    try {
                        ProjectClassPathModifier.removeRoots((URL[])urls.toArray(new URL[urls.size()]), (FileObject)sourceRoot, (String)type);
                    }
                    catch (UnsupportedOperationException ex) {
                        Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, ex);
                    }
                    catch (IOException e) {
                        Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, e);
                    }
                }
            }
        }

        public void configureCustomJersey(Project project) {
        }

        private boolean hasJee6Profile() {
            Set<Profile> profiles = Hk2JavaEEPlatformImpl.this.getSupportedProfiles();
            return profiles.contains(Profile.JAVA_EE_6_FULL) || profiles.contains(Profile.JAVA_EE_6_WEB);
        }

        private List<URL> getJerseyLibraryURLs() {
            String version = this.getGFVersion();
            String gfRoot = Hk2JavaEEPlatformImpl.this.dm.getProperties().getGlassfishRoot();
            LinkedList<URL> urls = new LinkedList<URL>();
            if (version == null) {
                return Collections.emptyList();
            }
            if (version.startsWith(VERSION_30X)) {
                File jackson = ServerUtilities.getJarName((String)gfRoot, (String)"jackson(|-core-asl).jar");
                this.addURL(urls, jackson);
                File jerseyBundle = ServerUtilities.getJarName((String)gfRoot, (String)"jersey-gf-bundle.jar");
                this.addURL(urls, jerseyBundle);
                File jettison = ServerUtilities.getJarName((String)gfRoot, (String)"jettison.jar");
                this.addURL(urls, jettison);
                File jsr311 = ServerUtilities.getJarName((String)gfRoot, (String)"jsr311-api.jar");
                this.addURL(urls, jsr311);
                File miltipart = ServerUtilities.getJarName((String)gfRoot, (String)"jersey-multipart.jar");
                this.addURL(urls, miltipart);
                File mimepull = ServerUtilities.getJarName((String)gfRoot, (String)"mimepull.jar");
                this.addURL(urls, mimepull);
                File asm = ServerUtilities.getJarName((String)gfRoot, (String)"asm-all-repackaged.jar");
                this.addURL(urls, asm);
            } else if (version.startsWith(VERSION_31X)) {
                File jackson = ServerUtilities.getJarName((String)gfRoot, (String)"jackson(-core-asl).jar");
                this.addURL(urls, jackson);
                File jacksonJaxRs = ServerUtilities.getJarName((String)gfRoot, (String)"jackson-jaxrs.jar");
                this.addURL(urls, jacksonJaxRs);
                File jacksonMapper = ServerUtilities.getJarName((String)gfRoot, (String)"jackson-mapper(-asl).jar");
                this.addURL(urls, jacksonMapper);
                File jerseyServer = ServerUtilities.getJarName((String)gfRoot, (String)"jersey-gf-server.jar");
                this.addURL(urls, jerseyServer);
                File jettison = ServerUtilities.getJarName((String)gfRoot, (String)"jettison.jar");
                this.addURL(urls, jettison);
                File miltipart = ServerUtilities.getJarName((String)gfRoot, (String)"jersey-multipart.jar");
                this.addURL(urls, miltipart);
                File mimepull = ServerUtilities.getJarName((String)gfRoot, (String)"mimepull.jar");
                this.addURL(urls, mimepull);
                File jerseyClient = ServerUtilities.getJarName((String)gfRoot, (String)"jersey-client");
                this.addURL(urls, jerseyClient);
                File jerseyCore = ServerUtilities.getJarName((String)gfRoot, (String)"jersey-core");
                this.addURL(urls, jerseyCore);
                File jerseyJson = ServerUtilities.getJarName((String)gfRoot, (String)"jersey-json");
                this.addURL(urls, jerseyJson);
                File asm = ServerUtilities.getJarName((String)gfRoot, (String)"asm-all-repackaged.jar");
                this.addURL(urls, asm);
            }
            return urls;
        }

        private void addURL(Collection<URL> urls, File file) {
            if (file == null || !file.exists()) {
                return;
            }
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        private boolean addJars(Project project, Collection<URL> jars) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (URL url : jars) {
                if (!FileUtil.isArchiveFile((URL)url)) continue;
                urls.add(FileUtil.getArchiveRoot((URL)url));
            }
            SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            if (sourceGroups == null || sourceGroups.length < 1) {
                return false;
            }
            FileObject sourceRoot = sourceGroups[0].getRootFolder();
            try {
                ProjectClassPathModifier.addRoots((URL[])urls.toArray(new URL[urls.size()]), (FileObject)sourceRoot, (String)"classpath/compile");
            }
            catch (UnsupportedOperationException ex) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }

        private String getGFVersion() {
            String gfRootStr = Hk2JavaEEPlatformImpl.this.dm.getProperties().getGlassfishRoot();
            File serviceTag = new File(gfRootStr, "lib/registration/servicetag-registry.xml");
            if (!serviceTag.exists()) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.WARNING, "Couldn't recognize GF version", new Exception());
                return null;
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = factory.newSAXParser();
                RegistrationHandler handler = new RegistrationHandler();
                saxParser.parse(serviceTag, (DefaultHandler)handler);
                return handler.getVersion();
            }
            catch (ParserConfigurationException e) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, e);
            }
            catch (SAXException e) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, e);
            }
            catch (IOException e) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, e);
            }
            return "";
        }
    }

    private static class RegistrationHandler
    extends DefaultHandler {
        private static final String VERSION_TAG = "product_version";
        private boolean versionTag;
        private StringBuilder version = new StringBuilder();

        private RegistrationHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (VERSION_TAG.equals(localName) || VERSION_TAG.equals(qName)) {
                this.versionTag = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (VERSION_TAG.equals(localName) || VERSION_TAG.equals(qName)) {
                this.versionTag = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            if (this.versionTag) {
                this.version.append(ch, start, length);
            }
        }

        String getVersion() {
            return this.version.toString();
        }
    }
}

